/*
 * combiner.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "combiner.h"

// this file has the code for combining two (or more hypothetically) RTP
// streams into one stream whose frames are the glued images of both the
// incoming streams. Then it gives the output to a Real encoding engine

// Constructor for our list node...
CombinerSourceNode::CombinerSourceNode(char* s, int p): pos(p),width(0),height(0),next(0) {
  strcpy(source,s);
}

// =======================

// Wrapper for the OTcl object...
static class CombinerSourceClass : public TclClass {
public:
  CombinerSourceClass() : TclClass ("CombinerSource") {};
  TclObject* create(int argc, const char*const* argv) {
    return (new CombinerSource((Combiner*)TclObject::lookup(argv[4]),argv[5],atoi(argv[6])));
  };
} combiner_source;

CombinerSource::CombinerSource(Combiner* destination, const char* s, int c): dest(destination),colorModel(c) {
  strcpy(src, s);
}

// this is the whole reason we need this class, so that it can tell the
// combiner which source the image came from.
void CombinerSource::recv(Buffer* b) {
  dest->recv(b, src, colorModel);
}

// ==========================

// Wrapper for the OTcl object...
static class CombinerClass : public TclClass {
public:
  CombinerClass() : TclClass ("Combiner") {};
  TclObject* create(int argc, const char*const* argv) {
    return (new Combiner());
  };
} combiner;


Combiner::Combiner(): destination(0),width(0),height(0),sources(0),frame_(0),frame_data_(0) {
}

Combiner::~Combiner() {
};

// this does all the work of gluing the two images together and handing it off.
void Combiner::recv(Buffer* b, char* source, int colorModel) {
  YuvFrame* in_frame_ = (YuvFrame*)b;
  u_int8_t* dest;
  u_int8_t* src;
  int rownum;
  CombinerSourceNode* temp;
  
  if (frame_ == 0) {
    // search the list to see if dimensions were entered yet...
    for (temp=sources; temp != 0; temp=temp->next) {
      if (strcmp(temp->source, source) == 0) {
	temp->width = in_frame_->width_;
	temp->height = in_frame_->height_;
	break;
      }
    }
    // wait until we have at least two sources...
    if (sources !=0 && sources->next != 0) {
      // sort them so that they are in the right left to right order (currently only works for 2 sources)
      if (sources->pos == 2) {
	temp = sources;
	sources = sources->next;
	temp->next = 0;
	sources->next = temp;
      }

      if ((sources->width != 0) && (sources->next->width != 0)) {
	// gather the total size of the output frame
	for(temp=sources; temp != 0; temp=temp->next) {
	  width += temp->width;
	  if (height < temp->height)
	    height = temp->height;
	}
	// FIXME -- should check to make sure the size is a multiple of 8.
	// allocate the data structure to store the frame data...
	frame_data_ = new u_int8_t[(width*height*3)/2];
	frame_ = new YuvFrame(0,frame_data_,0,width,height, 0);
      } else
	return;
    } else
      return;
  }

  // check to see if it is a frame we are going to use...
  if ((strcmp(sources->source,source) != 0) && (strcmp(sources->next->source,source) != 0))
    return;
  
  dest = frame_data_;
  src = in_frame_->bp_;
  // determine if this is the second source and then put the
  // dest (destination) pointer to the appropriate offset in the frame.
  if (strcmp(source,sources->source) != 0)
    dest = &(dest[sources->width]);

  // copy the Luninescence
  for(rownum=0;rownum<in_frame_->height_;rownum++)
    memcpy(&(dest[(rownum*width)]),&(src[rownum*(in_frame_->width_)]),in_frame_->width_);

  dest = &(frame_data_[width*height]);
  src = &((in_frame_->bp_)[in_frame_->width_*in_frame_->height_]);
  // once again, determine the proper destination in the frame (like above)
  if (strcmp(source,sources->source) != 0)
    dest = &(dest[(sources->width)/2]);

  // copy the chrominence (the U component)
  if (colorModel == 422) {
    for(rownum=0;rownum<((in_frame_->height_)/2);rownum++)
      memcpy(&(dest[(rownum*width)/2]),&(src[rownum*in_frame_->width_]),(in_frame_->width_)/2);
  } else {
    for(rownum=0;rownum<((in_frame_->height_)/2);rownum++)
      memcpy(&(dest[(rownum*width)/2]),&(src[(rownum*(in_frame_->width_))/2]),(in_frame_->width_)/2);
  }

  dest = &(frame_data_[(width*height*5)/4]);
  if (colorModel == 422)
    src = &((in_frame_->bp_)[(in_frame_->width_*in_frame_->height_*3)/2]);
  else
    src = &((in_frame_->bp_)[(in_frame_->width_*in_frame_->height_*5)/4]);
  // once again, determine the proper destination in the frame (like above)
  if (strcmp(source,sources->source) != 0)
    dest = &(dest[(sources->width)/2]);

  // copy the chrominence (the V component)
  if (colorModel == 422) {
    for(rownum=0;rownum<((in_frame_->height_)/2);rownum++)
      memcpy(&(dest[(rownum*width)/2]),&(src[rownum*in_frame_->width_]),(in_frame_->width_)/2);
  } else {
    for(rownum=0;rownum<((in_frame_->height_)/2);rownum++)
      memcpy(&(dest[(rownum*width)/2]),&(src[(rownum*(in_frame_->width_))/2]),(in_frame_->width_)/2);
  }

  // hand it off to the Real Encoder.
  if (destination != 0)
    destination->recv(frame_, 0, 0);
}

// For Tcl commands to call from Tcl space...
int Combiner::command(int argc, const char*const* argv) {
  Tcl& tcl = Tcl::instance();
  if (argc == 2) {
    if (strcmp(argv[1], "unlinkEncoder") == 0) {
      destination = 0;
      return (TCL_OK);
    } else if (strcmp(argv[1], "ready") == 0) {
      if ((sources != 0) && (sources->next != 0))
	tcl.resultf("yes");
      else
	tcl.resultf("no");
      return (TCL_OK);
    }
  } else if (argc == 3) {
    if (strcmp(argv[1], "linkEncoder") == 0) {
      destination = (Renderer*)TclObject::lookup(argv[2]);
      return (TCL_OK);
    }
  } else if (argc == 4) {
    if (strcmp(argv[1], "setSide") == 0) {
      // check to see if the source is already there...
      for (CombinerSourceNode* temp=sources; temp != 0; temp=temp->next) {
	if (strcmp(temp->source, argv[3]) == 0) {
	  temp->pos = atoi(argv[2]);
	  return (TCL_OK);
	}
      }
      CombinerSourceNode* head = sources;
      sources = new CombinerSourceNode((char*)(argv[3]),atoi(argv[2]));
      sources->next = head;
      return (TCL_OK);
    }
  }
  
  return (TclObject::command(argc, argv));
}
