/*
 * pipe_rend.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _PIPE_REND_H
#define _PIPE_REND_H
#include <string.h>
#include "tclcl.h"
#include "renderer.h"
#include "../codec/crdef.h"
#ifndef WIN32
#   include <sys/time.h>
#endif
#include "BidderHouse.h"

class BidderHouse;

class PipeRenderer : public Renderer, public ConditionalReplenisher {
public:
  PipeRenderer();
  ~PipeRenderer();
  int command(int argc, const char*const* argv);
  void setcolor(int /* x */) {};
  void recv(Buffer* b, int, int) {recv(b);};
  void recv(Buffer* b);
  void giveToEncoder(int);
  void bandwidthUsage(int);
  //  FILE* fd;
protected:
  EncoderModule* encoder_;
  YuvFrame* frame_;
  u_int8_t* frame_data_;
  u_char* crvec_to_send_;
  u_char* crvec_not_sent_;
  int avg_diff_size_; // this is in Bytes, not bits.
  BidderHouse* bidder_house_;
  char bandwidthObj[40];
  int diff_threshold;
  int diffs_want_to_send;
};

#endif
