;;; -*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

;;; level-0;ppc;ppc-misc.lisp


;(in-package "CCL")

(eval-when (:execute :compile-toplevel)
  (defppclapmacro get-arg (dest arg)
    `(lwz ,dest ,arg vsp))

  (defppclapmacro bignum-ref (dest src index)
    `(lwz ,dest (+ arch::misc-data-offset (ash ,index 2)) ,src))

  (defppclapmacro get-hv (h v pt)
    (let ((lbl-got (gensym)))
      `(progn
         ;(eq-if-fixnum 0 ,h ,pt)
         (clrlwi. ,h ,pt (- arch::nbits-in-word arch::nlisptagbits))
         (unbox-fixnum ,h ,pt)
         (beq+ cr0 ,lbl-got)
         ; Should probably branch around a uuo_interr arch::error-object-not-signed-byte-32
         (trap-unless-typecode= ,pt arch::subtag-bignum ,h)
         (bignum-ref ,h ,pt 0)
         ,lbl-got                       ; now "h" has (signed-byte 32): vvvvhhhh
         (srawi ,v ,h 16)
         (extsh ,h ,h))))

  (defppclapmacro munge-points (pt1 pt2 oper)
    `(let ((h1 imm0)
           (v1 imm1)
           (h2 imm2)
           (v2 imm3))
       (get-hv h1 v1 ,pt1)
       (get-hv h2 v2 ,pt2)
       (,oper h1 h1 h2)
       (,oper v1 v1 v2)
       (insrwi h1 v1 16 0)    ;         ; insert the "rightmost" 16 bits of v1 
                                        ; into the "leftmost" 16 bits of h1

       ;(s32->integer arg_z h1 0 imm2)  ; return fixnum or bignum
       (mcrxr 0)
       (addo imm2 h1 h1)
       (addo. arg_z imm2 imm2)
       (bns+ @done)
       (uuo_box_signed arg_z h1)
       @done
       
       (blr)
       ))
  )


; Copy N bytes from pointer src, starting at byte offset src-offset,
; to ivector dest, starting at offset dest-offset.
; It's fine to leave this in lap.
; Depending on alignment, it might make sense to move more than
; a byte at a time.
; Does no arg checking of any kind.  Really.

(defppclapfunction %copy-ptr-to-ivector ((src 4) 
                                         (src-byte-offset 0) 
                                         (dest arg_x)
                                         (dest-byte-offset arg_y)
                                         (nbytes arg_z))
  (let ((src-reg imm0)
        (src-byteptr imm1)
        (src-node-reg temp0)
        (dest-byteptr imm2)
        (val imm3)
        (node-temp temp1))
    (cmpwi cr0 nbytes 0)
    (get-arg src-node-reg src)
    (lwz src-reg arch::macptr.address src-node-reg)
    (get-arg src-byteptr src-byte-offset)
    (unbox-fixnum src-byteptr src-byteptr)
    (unbox-fixnum dest-byteptr dest-byte-offset)
    (la dest-byteptr arch::misc-data-offset dest-byteptr)
    (b @test)
    @loop
    (subi nbytes nbytes '1)
    (cmpwi cr0 nbytes '0)
    (lbzx val src-reg src-byteptr)
    (la src-byteptr 1 src-byteptr)
    (stbx val dest dest-byteptr)
    (la dest-byteptr 1 dest-byteptr)
    @test
    (bne cr0 @loop)
    (mr arg_z dest)
    (la vsp 8 vsp)
    (blr)))

; %copy-ivector-to-ptr - from hello.lisp:
(defppclapfunction %copy-ivector-to-ptr ((src 4) 
                                         (src-byte-offset 0) 
                                         (dest arg_x)
                                         (dest-byte-offset arg_y)
                                         (nbytes arg_z))
  (lwz temp0 src vsp)
  (cmpwi cr0 nbytes 0)
  (lwz imm0 src-byte-offset vsp)
  (unbox-fixnum imm0 imm0)
  (la imm0 arch::misc-data-offset imm0)
  (unbox-fixnum imm2 dest-byte-offset)
  (lwz imm1 arch::macptr.address dest)
  (b @test)
  @loop
  (subi nbytes nbytes '1)
  (cmpwi cr0 nbytes 0)
  (lbzx imm3 temp0 imm0)
  (addi imm0 imm0 1)
  (stbx imm3 imm1 imm2)
  (addi imm2 imm2 1)
  @test
  (bne cr0 @loop)
  (mr arg_z dest)
  (la vsp 8 vsp)
  (blr))

(defppclapfunction %copy-ivector-to-ivector ((src 4) 
                                             (src-byte-offset 0) 
                                             (dest arg_x)
                                             (dest-byte-offset arg_y)
                                             (nbytes arg_z))
  (lwz temp0 src vsp)
  (cmpwi cr0 nbytes 0)
  (cmpw cr2 temp0 dest)   ; source and dest same?
  (rlwinm imm3 nbytes 0 (- 30 arch::fixnum-shift) 31)  
  (lwz imm0 src-byte-offset vsp)
  (rlwinm imm1 imm0 0 (- 30 arch::fixnum-shift) 31)
  (or imm3 imm3 imm1)
  (unbox-fixnum imm0 imm0)
  (la imm0 arch::misc-data-offset imm0)
  (unbox-fixnum imm2 dest-byte-offset)
  (rlwimi imm1 imm2 0 30 31)
  (or imm3 imm3 imm1)
  (cmpwi cr1 imm3 0)  ; is everybody multiple of 4?
  (la imm2 arch::misc-data-offset imm2)
  (beq cr2 @SisD)   ; source and dest same
  @fwd
  (beq :cr1 @wtest)
  (b @test)

  @loop
  (subi nbytes nbytes '1)
  (cmpwi cr0 nbytes 0)
  (lbzx imm3 temp0 imm0)
  (addi imm0 imm0 1)
  (stbx imm3 dest imm2)
  (addi imm2 imm2 1)
  @test
  (bne cr0 @loop)
  (mr arg_z dest)
  (la vsp 8 vsp)
  (blr)

  @words      ; source and dest different - words 
  (subi nbytes nbytes '4)  
  (cmpwi cr0 nbytes 0)
  (lwzx imm3 temp0 imm0)
  (addi imm0 imm0 4)
  (stwx imm3 dest imm2)
  (addi imm2 imm2 4)
  @wtest
  (bgt cr0 @words)
  @done
  (mr arg_z dest)
  (la vsp 8 vsp)
  (blr)

  @SisD
  (cmpw cr2 imm0 imm2) ; cmp src and dest
  (bgt cr2 @fwd)
  ;(B @bwd) 
  

  ; Copy backwards when src & dest are the same and we're sliding down
  @bwd ; ok
  (unbox-fixnum imm3 nbytes)
  (add imm0 imm0 imm3)
  (add imm2 imm2 imm3)
  (b @test2)
  @loop2
  (subi nbytes nbytes '1)
  (cmpwi cr0 nbytes 0)
  (subi imm0 imm0 1)
  (lbzx imm3 temp0 imm0)
  (subi imm2 imm2 1)
  (stbx imm3 dest imm2)
  @test2
  (bne cr0 @loop2)
  (b @done))



; value will be in save7 = r24
(defppclapfunction %dbg ((arg arg_z))    ; (&optional arg)
  (twlgti nargs 4)                      ; optional
  (save-lisp-context)
  (vpush save7)
  (cmpw cr0 nargs rzero)
  (if (:cr0 :eq)
    (mr arg_z rnil))
  (mr save7 arg)
  (set-nargs 0)
  (call-symbol Debugger)               ; can't (easily) call "traps" inline
  (vpop save7)
  (restore-full-lisp-context)
  (blr))

(defvar *debugger-slep* nil)

(eval-when (:compile-toplevel :execute)
  (declaim (type t *debugger-slep*)))





(defppclapfunction %heap-bytes-allocated ()
  (ref-global imm0 heap-start)
  (sub imm0 freeptr imm0)
  (box-fixnum arg_z imm0)
  (blr))








; P is a macptr pointing to a record of type :unsignedwide.
; Return its value as an integer.
(defppclapfunction unsignedwide->integer ((uwidep arg_z))
  (lwz imm1 arch::macptr.address arg_z)
  (lwz imm0 0 imm1)
  (cmpwi cr0 imm0 0)
  (lwz imm1 4 imm1)
  (cmpwi cr1 imm1 0)
  (li imm2 (arch::make-vheader 3 arch::subtag-bignum))
  (beq cr0 @1word)
  (bgt cr0 @2words)
; Need a 3-digit bignum:
  @make2or3
  (stwu rzero 16 freeptr)
  (la arg_z arch::fulltag-misc initptr)
  (mr initptr freeptr)
  (stw imm2 arch::misc-header-offset arg_z)
  (stw imm1 arch::misc-data-offset arg_z)
  (stw imm0 (+ 4 arch::misc-data-offset) arg_z)
  (blr)
  @2words
  (li imm2 (arch::make-vheader 2 arch::subtag-bignum))
  (b @make2or3)
  @1word
  (blt cr1 @2words)
  (clrrwi. imm2 imm1 (- arch::least-significant-bit arch::nfixnumtagbits))
  (box-fixnum arg_z imm1)
  (beqlr+ cr0)
  (li imm2 (arch::make-vheader 1 arch::subtag-bignum))
  (stwu rzero 8 freeptr)
  (la arg_z arch::fulltag-misc initptr)
  (mr initptr freeptr)
  (stw imm2 arch::misc-header-offset arg_z)
  (stw imm1 arch::misc-data-offset arg_z)
  (blr))





(defppclapfunction values ()
  (vpush-argregs)
  (add temp0 nargs vsp)
  (ba .SPvalues))

;; It would be nice if (%setf-macptr macptr (ash (the fixnum value) ash::fixnumshift))
;; would do this inline.
#+ppc-target
(defppclapfunction %setf-macptr-to-object ((macptr arg_y) (object arg_z))
  (twnei nargs (* 2 4))
  (trap-unless-typecode= arg_y arch::subtag-macptr)
  (stw arg_z arch::macptr.address arg_y)
  (blr))

(defppclapfunction %fixnum-from-macptr ((macptr arg_z))
  (check-nargs 1)
  (trap-unless-typecode= arg_z arch::subtag-macptr)
  (lwz imm0 arch::macptr.address arg_z)
  (trap-unless-lisptag= imm0 arch::tag-fixnum imm1)
  (mr arg_z imm0)
  (blr))

(defppclapfunction %%get-unsigned-longlong ((ptr arg_y) (offset arg_z))
  (trap-unless-typecode= ptr arch::subtag-macptr)
  (macptr-ptr imm1 ptr)
  (unbox-fixnum imm2 offset)
  (add imm2 imm2 imm1)
  (lwz imm0 0 imm2)
  (lwz imm1 4 imm2)
  (ba .SPmakeu64))

(defppclapfunction %%get-signed-longlong ((ptr arg_y) (offset arg_z))
  (trap-unless-typecode= ptr arch::subtag-macptr)
  (macptr-ptr imm1 ptr)
  (unbox-fixnum imm2 offset)
  (add imm2 imm2 imm1)
  (lwz imm0 0 imm2)
  (lwz imm1 4 imm2)
  (ba .SPmakes64))

(defppclapfunction %%set-unsigned-longlong ((ptr arg_x)
					      (offset arg_y)
					      (val arg_z))
  (save-lisp-context)
  (trap-unless-typecode= ptr arch::subtag-macptr)
  (bla .SPgetu64)
  (macptr-ptr imm2 ptr)
  (unbox-fixnum imm3 offset)
  (add imm2 imm3 imm2)
  (stw imm0 0 imm2)
  (stw imm1 4 imm2)
  (ba .SPpopj))

(defppclapfunction %%set-signed-longlong ((ptr arg_x)
					    (offset arg_y)
					    (val arg_z))
  (save-lisp-context)
  (trap-unless-typecode= ptr arch::subtag-macptr)
  (bla .SPgets64)
  (macptr-ptr imm2 ptr)
  (unbox-fixnum imm3 offset)
  (add imm2 imm3 imm2)
  (stw imm0 0 imm2)
  (stw imm1 4 imm2)
  (ba .SPpopj))

; end of ppc-misc.lisp
