;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html


(eval-when (:compile-toplevel :execute)
  (require "PPC-ARCH" "ccl:compiler;ppc;ppc-arch")
  (require "PPC-LAPMACROS" "ccl:compiler;ppc;ppc-lapmacros"))

; This assumes that macros & special-operators
; have something that's not FUNCTIONP in their
; function-cells.
(defppclapfunction %function ((sym arg_z))
  (check-nargs 1)
  (cmpw cr1 sym rnil)
  (let ((symptr temp0)
        (symbol temp1)
        (def arg_z))
    (la symptr arch::nilsym-offset rnil)
    (mr symbol sym)
    (if (:cr1 :ne)
      (progn
        (trap-unless-typecode= sym arch::subtag-symbol)
        (mr symptr sym)))
    (lwz def arch::symbol.fcell symptr)
    (extract-typecode imm0 def)
    (cmpwi cr0 imm0 arch::subtag-function)
    (beqlr+)
    (uuo_interr arch::error-udf symbol)))



; Traps unless sym is NIL or some other symbol.
(defppclapfunction %symbol->symptr ((sym arg_z))
  (cmpw cr0 arg_z rnil)
  (if (:cr0 :eq)
    (progn
      (la arg_z arch::nilsym-offset rnil)
      (blr)))
  (trap-unless-typecode= arg_z arch::subtag-symbol)
  (blr))

; Traps unless symptr is a symbol; returns NIL if symptr is NILSYM.
(defppclapfunction %symptr->symbol ((symptr arg_z))
  (la imm1 arch::nilsym-offset rnil)
  (cmpw cr0 imm1 symptr)
  (if (:cr0 :eq)
    (progn 
      (mr arg_z rnil)
      (blr)))
  (trap-unless-typecode= symptr arch::subtag-symbol imm0)
  (blr))



    




