;;; -*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html


;;; Do an FF-CALL to MakeDataExecutable so that the data cache gets flushed.
;;; This needs to be called inside a WITHOUT-INTERRUPTS.
(defsparclapfunction %make-code-executable ((codev %arg_z))
  (save-lisp-context)
  (getvheader codev %imm2)
  (header-length %imm2 %imm1)
  (add codev arch::misc-data-offset %imm0)
  (sub %sp (+ sparc::c-frame.minsiz sparc::lisp-frame.size) %sp)
  (st %imm0 (%sp sparc::c-frame.param0))
  (st %imm1 (%sp sparc::c-frame.param1))
  (ref-global %imm3 kernel-imports)
  (call-subprim .SPeabi-ff-call)
    (ld (%imm3 arch::kernel-import-MakeDataExecutable) %arg_z)
  (restore-full-lisp-context)
  (retl)
    (mov %rnil %arg_z))

; end of ppc-def.lisp
