;;; -*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

;;; level-0;SPARC;sparc-misc.lisp


;(in-package "CCL")

(eval-when (:execute :compile-toplevel)
  (defsparclapmacro get-arg (arg dest)
    `(ld (%vsp ,arg) ,dest))

  )


; Copy N bytes from pointer src, starting at byte offset src-offset,
; to ivector dest, starting at offset dest-offset.
; It's fine to leave this in lap.
; Depending on alignment, it might make sense to move more than
; a byte at a time.
; Does no arg checking of any kind.  Really.

(defsparclapfunction %copy-ptr-to-ivector ((src 4) 
                                         (src-byte-offset 0) 
                                         (dest %arg_x)
                                         (dest-byte-offset %arg_y)
                                         (nbytes %arg_z))
  (let ((src-reg %imm0)
        (src-byteptr %imm1)
        (src-node-reg %temp0)
        (dest-byteptr %imm2)
        (val %imm3)
        (node-temp %temp1))
    (tst nbytes)
    (get-arg src src-node-reg)
    (ld (src-node-reg arch::macptr.address) src-reg)
    (get-arg src-byte-offset src-byteptr)
    (unbox-fixnum src-byteptr src-byteptr)
    (unbox-fixnum dest-byte-offset dest-byteptr)
    (b @test)
      (inc (1- arch::misc-data-offset) dest-byteptr) ; for inc in delay below
    @loop
    (deccc '1 nbytes)
    (ldub (src-reg src-byteptr) val)
    (inc src-byteptr)
    (stb val (dest dest-byteptr))
    @test
    (bne @loop)
      (inc dest-byteptr)
    (mov dest %arg_z)
    (retl)
      (inc '2 %vsp)))


; %copy-ivector-to-ptr
(defsparclapfunction %copy-ivector-to-ptr ((src 4) 
                                         (src-byte-offset 0) 
                                         (dest %arg_x)
                                         (dest-byte-offset %arg_y)
                                         (nbytes %arg_z))
  (ld (%vsp src) %temp0)
  (tst nbytes)
  (ld (%vsp src-byte-offset) %imm0)
  (unbox-fixnum %imm0 %imm0)
  (inc (1- arch::misc-data-offset) %imm0)
  (unbox-fixnum dest-byte-offset %imm2)
  (b @test)
    (ld (dest arch::macptr.address) %imm1)
  @loop
  (deccc '1  nbytes)
  (ldub (%temp0 %imm0) %imm3)
  (stb %imm3 (%imm1 %imm2))
  (inc %imm2)
  @test
  (bne  @loop)
    (inc %imm0)
  (mov dest %arg_z)
  (retl)
    (inc '2 %vsp))


(defsparclapfunction %copy-ivector-to-ivector ((src 4) 
					       (src-byte-offset 0) 
					       (dest %arg_x)
					       (dest-byte-offset %arg_y)
					       (nbytes %arg_z))
  (ld (%vsp src) %temp0)
  (cmp %temp0 dest)   ; source and dest same?
  (and nbytes '3 %imm3)
  (ld (%vsp src-byte-offset) %imm0)
  (and %imm0 '3 %imm1)
  (or %imm1 %imm3 %imm3)
  (unbox-fixnum %imm0 %imm0)
  (inc arch::misc-data-offset %imm0)
  (unbox-fixnum dest-byte-offset %imm2)
  (and dest-byte-offset '3 %imm1)
  (or %imm1 %imm3 %imm3)
  (inc arch::misc-data-offset %imm2)
  (be @SisD)				; Source and dest same
    (tst %imm3)				; zero -> word-aligned, word count
  @fwd
  (be @wtest)
    (tst nbytes)
  (b @test)
    (dec %imm2)
  @loop
  (deccc '1 nbytes)
  (ldub (%temp0 %imm0) %imm3)
  (inc %imm0)
  (stb %imm3 (dest %imm2))
  @test
  (bne @loop)
    (inc %imm2)
  (mov dest %arg_z)
  (retl)
    (inc '2 %vsp)


  @words      ; source and dest different - words 
  (ld (%temp0 %imm0) %imm3)
  (inc 4 %imm0)
  (st %imm3 (dest %imm2))
  (inc 4 %imm2)
  @wtest
  (bg @words)
    (deccc '4 nbytes)
  @done
  (mov dest %arg_z)
  (retl)
    (inc '2 %vsp)

  @SisD
  (cmp %imm0 %imm2) ; cmp src and dest
  (bg @fwd)
    (tst %imm3)
  ;(B @bwd) 
  

  ; Copy backwards when src & dest are the same and we're sliding down
  @bwd ; ok
  (unbox-fixnum nbytes %imm3)
  (inc %imm3 %imm0)
  (tst nbytes)
  (b @test2)
    (inc %imm3 %imm2)
  @loop2
  (dec %imm0)
  (ldub (%temp0 %imm0) %imm3)
  (dec %imm2)
  (stb %imm3 (dest %imm2))
  @test2
  (bne @loop2)
    (deccc '1 nbytes)
  (b @done)
   (nop))



(defsparclapfunction %heap-bytes-allocated ()
  (ref-global %imm0 heap-start)
  (sub %freeptr %imm0 %imm0)
  (retl)
    (box-fixnum %imm0 %arg_z))



; P is a macptr pointing to a record of type :unsignedwide.
; Return its value as an integer.
(defsparclapfunction unsignedwide->integer ((uwidep %arg_z))
  (mov (arch::make-vheader 3 arch::subtag-bignum) %imm2)
  (ld (uwidep arch::macptr.address) %imm1)
  (ld (%imm1 0) %imm0)
  (tst %imm0)
  (be @1word)
    (ld (%imm1 4) %imm1)
  (bg @2words)
    (nop)
; Need a 3-digit bignum:
  @make2or3
  (phys-alloc 16 arch::fulltag-misc)
  (sub %freeptr 16 %arg_z)
  (st %imm2 (%arg_z arch::misc-header-offset))
  (untag-freeptr)
  (st %imm1 (%arg_z arch::misc-data-offset))
  (retl)  
    (st %imm0 (%arg_z (+ 4 arch::misc-data-offset)))
  @2words
  (b @make2or3)
    (mov (arch::make-vheader 2 arch::subtag-bignum) %imm2)
  @1word
  (tst %imm1)
  (bl @2words)
  (sethi (ash #xc0000000 -10) %imm2)
  (andcc %imm1 %imm2 %rzero)
  (be @done)
    (box-fixnum %imm1 %arg_z)
  (mov (arch::make-vheader 1 arch::subtag-bignum) %imm2)
  (phys-alloc 8 arch::fulltag-misc)
  (sub %freeptr 8 %arg_z)
  (st %imm2 (%arg_z arch::misc-header-offset))
  (untag-freeptr)
  (st %imm1 (%arg_z arch::misc-data-offset))
  @done
  (retl)
    (nop))


(defsparclapfunction values ()
  (vpush-argregs)
  (jump-subprim .SPvalues)
   (add %nargs %vsp %temp0))




