;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html



;(in-package "CCL")

;(push (cons 'number-case 1) *fred-special-indent-alist*) do later



(defsparclapfunction %fixnum-signum ((number %arg_z))
  (tst number)
  (bg.a @done)
    (mov '1 %arg_z)
  (bl.a @done)
    (mov '-1 %arg_z)
  @done
  (retl)
    (nop))

; see %logcount (ppc-bignum.lisp)
(defsparclapfunction %ilogcount ((number %arg_z))
  (let ((arg %imm0)
        (shift %imm1)
        (temp %imm2))
    (unbox-fixnum number arg)
    (movcc arg shift)
    (be @done)
      (clr %arg_z)
    @loop
    (sub shift 1 temp)
    (andcc shift temp shift)
    (bne @loop)
      (inc '1 %arg_z)
    @done
    (retl)
      (nop)))

(defsparclapfunction %iash ((number %arg_y) (count %arg_z))
  (unbox-fixnum count %imm1)
  (subcc %rzero %imm1 %imm2)
  (unbox-fixnum number %imm0)
  (bl @left)
    (sra %imm0 %imm2 %imm0)
  (retl)
    (box-fixnum %imm0 %arg_z)

  @left
  (retl)
    (sll number %imm1 %arg_z))

(defparameter *double-float-zero* 0.0d0)
(defparameter *short-float-zero* 0.0s0)

(defsparclapfunction %short-float-plusp ((number %arg_z))
  (get-single-float number %f2)
  (fcmpes %f2 %fp-zero)
  (clr %imm0)			;need to wait a cycle before fb<cc>
  (fbg.a @done)
    (mov arch::t-offset %imm0)
  @done
  (retl)
    (add %rnil %imm0 %arg_z))

(defsparclapfunction %double-float-plusp ((number %arg_z))
  (get-double-float number %fp-zero)
  (fcmped %f2 %fp-zero)
  (fbg.a @done)
    (mov arch::t-offset %imm0)
  @done
  (retl)
    (add %rnil %imm0 %arg_z))


(defsparclapfunction %sfloat-hwords ((sfloat %arg_z))
  (ld (sfloat arch::single-float.value) %imm0)
  (digit-h %imm0 %temp0)
  (digit-l %imm0 %temp1)
  (vpush %temp0)
  (vpush %temp1)
  (add %vsp '2 %temp0)
  (jump-subprim .SPvalues)
    (set-nargs 2))

; used by fasl-dump-dfloat
(defsparclapfunction %dfloat-hwords ((dfloat %arg_z))
  (ld (dfloat arch::double-float.value) %imm0)
  (ld (dfloat arch::double-float.val-low) %imm1)
  (digit-h %imm0 %temp0)
  (digit-l %imm0 %temp1)
  (digit-h %imm1 %temp2)
  (digit-l %imm1 %temp3)
  (vpush %temp0)
  (vpush %temp1)
  (vpush %temp2)
  (vpush %temp3)
  (add %vsp '4 %temp0)
  (jump-subprim .SPvalues)
    (set-nargs 4))


(defsparclapfunction %fixnum-intlen ((number %arg_z))
  (let ((shift %imm0))
    (mov number shift)
    (tst shift)
    (unbox-fixnum shift shift)
    (bge @test)
      (clr %arg_z)
    (b @test)
      (not shift)
    @loop
    (inc '1 %arg_z)
    @test
    (tst shift)
    (bne @loop)
      (srl shift 1 shift)
    (retl)
      (nop)))



(defsparclapfunction %double-float-negate! ((src %arg_y) (res %arg_z))
  (get-double-float src %f2)
  (fnegs %f2 %f2)			; this is supposed to be correct
  (retl)
    (put-double-float %f2 res))

(defsparclapfunction %short-float-negate! ((src %arg_y) (res %arg_z))
  (get-single-float src %f2)
  (fnegs %f2 %f2)			; this is supposed to be correct
  (retl)
    (put-single-float %f2 res))


; Caller guarantees that result fits in a fixnum.
(defsparclapfunction %truncate-double-float->fixnum ((arg %arg_z))
  (get-double-float arg %f2)
  (fdtoi %f2 %f4)
  (dec 16 %sp)
  (stf %f4 (%sp 64))
  (ld (%sp 64) %imm0)
  (inc 16 %sp)
  (retl)
    (box-fixnum %imm0 %arg_z))

(defsparclapfunction %truncate-short-float->fixnum ((arg %arg_z))
  (get-single-float arg %f2)
  (fstoi %f2 %f4)
  (dec 16 %sp)
  (stf %f4 (%sp 64))
  (ld (%sp 64) %imm0)
  (inc 16 %sp)
  (retl)
    (box-fixnum %imm0 %arg_z))

; DOES round to even
(defsparclapfunction %round-nearest-double-float->fixnum ((arg %arg_z))
  (get-double-float arg %f2)
  (faddd %f2 %fp-zero %f2)		; round
  (fdtoi %f2 %f4)
  (dec 16 %sp)
  (stf %f4 (%sp 64))
  (ld (%sp 64) %imm0)
  (inc 16 %sp)
  (retl)
    (box-fixnum %imm0 %arg_z))

(defsparclapfunction %round-nearest-short-float->fixnum ((arg %arg_z))
  (get-single-float arg %f2)
  (fadds %f2 %fp-zero %f2)		; round
  (fstoi %f2 %f4)
  (dec 16 %sp)
  (stf %f4 (%sp 64))
  (ld (%sp 64) %imm0)
  (inc 16 %sp)
  (retl)
    (box-fixnum %imm0 %arg_z))


; return fixnum if product fits else nil
(defsparclapfunction %%fixnum-*-2 ((y %arg_y) (z %arg_z))
  (unbox-fixnum z %imm0)
  (smul y %imm0 %imm1)			;upper 32 bits in y reg
  (sra %imm1 31 %imm2)
  (mov %imm1 %arg_z)
  (nop)					; Wait 3 cycles between writing Y
  (rdy %imm3)				; and reading it.
  (cmp %imm2 %imm3)			; (eq %y (sign-bit result-low)) ?
  (bne.a @done)
    (mov %rnil %arg_z)			; if not, overflow
  @done
  (retl)
    (nop))

;; maybe this could be smarter but frankly scarlett I dont give a damn
(defsparclapfunction %fixnum-truncate ((dividend %arg_y) (divisor %arg_z))
  (let ((unboxed-quotient %imm0)
        (unboxed-dividend %imm1)
        (unboxed-divisor %imm2)
        (unboxed-product %imm3)
        (product %temp0)
        (boxed-quotient %temp1)
        (remainder %temp2))
    (unbox-fixnum dividend unboxed-dividend)
    (sra unboxed-dividend 31 %imm4)
    (wry %rzero %imm4)
    (unbox-fixnum divisor unboxed-divisor)
    (tst unboxed-divisor)
    (be @div0)
      (nop)
    (sdiv unboxed-dividend unboxed-divisor unboxed-quotient)    
    (box-fixnum unboxed-quotient boxed-quotient)
    (nop)
    (nop)
    (smul unboxed-quotient unboxed-divisor unboxed-product)
    (unbox-fixnum boxed-quotient %imm2)  ; bashing unboxed divisor
    (cmp %imm2 unboxed-quotient)
    (bne.a @ok)
      (uuo_box_signed boxed-quotient unboxed-quotient)
    @ok
    (sub unboxed-dividend unboxed-product %imm0)
    (vpush boxed-quotient)
    (box-fixnum %imm0 remainder)
    (vpush remainder)
    (set-nargs 2)
    (jump-subprim .SPvalues)
      (add %vsp '2 %temp0)
    @div0
    (save-lisp-context)
    (ld (%fn 'truncate) %arg_x)
    (call-symbol divide-by-zero-error)
      (set-nargs 3)

    ))


(defsparclapfunction called-for-mv-p ()
  (ref-global %imm0 ret1valaddr)
  (ld (%lsp sparc::lisp-frame.savelr) %imm1)
  (cmp %imm0 %imm1)
  (mov 0 %imm0)
  (be.a @done)
    (mov arch::t-offset %imm0)
  @done
  (retl)
    (add %rnil %imm0 %arg_z))
  



#|
Date: Mon, 3 Feb 1997 10:04:08 -0500
To: info-mcl@digitool.com, wineberg@franz.scs.carleton.ca
From: dds@flavors.com (Duncan Smith)
Subject: Re: More info on the random number generator
Sender: owner-info-mcl@digitool.com
Precedence: bulk

The generator is a Linear Congruential Generator:

   X[n+1] = (aX[n] + c) mod m

where: a = 16807  (Park&Miller recommend 48271)
       c = 0
       m = 2^31 - 1

See: Knuth, Seminumerical Algorithms (Volume 2), Chapter 3.

The period is: 2^31 - 2  (zero is excluded).

What makes this generator so simple is that multiplication and addition mod
2^n-1 is easy.  See Knuth Ch. 4.3.2 (2nd Ed. p 272).

    ab mod m = ...

If         m = 2^n-1
           u = ab mod 2^n
           v = floor( ab / 2^n )

    ab mod m = u + v                   :  u+v < 2^n
    ab mod m = ((u + v) mod 2^n) + 1   :  u+v >= 2^n

What we do is use 2b and 2n so we can do arithemetic mod 2^32 instead of
2^31.  This reduces the whole generator to 5 instructions on the 680x0 or
80x86, and 8 on the 60x.

-Duncan

|#
; Use the two fixnums in state to generate a random fixnum >= 0 and < 65536
; Scramble those fixnums up a bit.
(defsparclapfunction %next-random-seed ((state %arg_z))
  (let ((seed0 %imm0)
        (seed1 %imm1)
        (temp %imm2))
    (check-nargs 1)             ; check
    (lduh (state (+ ppc::misc-data-offset 4)) seed1) 

    (set #.(* 2 48271) temp)      ; 48271 * 2
    (lduh (state (+ ppc::misc-data-offset 8)) seed0)
    (sll seed1 16 seed1)		;a fixnum
    (or seed1 seed0 seed0)		; combine into 32 bits, x
    (umul seed0 temp seed1)		; seed1 = (x * 48271), lo, * 2
    (add temp temp temp)		; 48271 * 2 * 2
    (smul temp seed0 temp)
    (nop)
    (nop)
    (nop)
    (rdy seed0)			; seed0 = (x * 48271), hi, * 2
    (addcc  seed0 seed1 seed0)		; do mod 2^31-1
    (srl seed0 1 seed0)
    (addxcc %rzero seed0 seed0)
    (sll seed0 16 %imm4)
    (srl %imm4 16 %imm4)
    (srl seed1 16 seed1)
    (sll seed1 16 seed1)
    (or %imm4 seed1 seed1)
    (sth seed1 (state (+ ppc::misc-data-offset 8)))
    (srl seed0 16 %imm4)
    (sll seed0 16 seed0)
    (or %imm4 seed0 seed0)
    (be.a @storehigh)
      (inc seed0)
    @storehigh
    (sth seed0 (state (+ ppc::misc-data-offset 4)))
    (sll seed1 16 temp)
    (retl)
      (srl temp (- 16 arch::fixnumshift) %arg_z)))


; n1 and n2 must be positive (esp non zero)
(defsparclapfunction %fixnum-gcd ((n1 %arg_y)(n2 %arg_z))
  (let ((k %imm0)
        (n1u %imm1)
        (n2u %imm2)
        (temp %imm3))
    (clr k)
    (unbox-fixnum n1 n1u)
    (unbox-fixnum n2 n2u)
    @loop1   
    (or n1u n2u %imm4)
    (btst 1 %imm4)
    (bne @oddior)
      (nop)
    (sra n1u 1 n1u)
    (sra n2u 1 n2u)
    (b @loop1)
      (inc k)
    @oddior
    (btst 1 n1u)
    (bne @n1odd)
      (nop)
    (b @loop2start)
      (sra n1u 1 temp)
    @n1odd
    (neg n2u temp)
    @loop2start
    (btst 1 temp)
    (be @agn2)
      (tst temp)
    (ble @tempminus)
      (nop)
    (b @agn)
      (mov temp n1u)      

    @tempminus
    (neg temp n2u)
    @agn
    (subcc n1u n2u temp)
    (bne @agn2)
      (nop)
    (sll n1u k n1u)
    (retl)
      (box-fixnum n1u %arg_z)
    @agn2
    (b @loop2start)
      (sra temp 1 temp)))

; End of ppc-numbers.lisp
