;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html


; l1-boot-lds.lisp

(in-package :ccl)





(defun command-line-arguments ()
  *command-line-argument-list*)

(defun startup-ccl (&optional init-file)
  (with-simple-restart (abort "Abort startup.")
    (when init-file
      (with-simple-restart (continue "Skip loading init file.")
	(load init-file :if-does-not-exist nil :verbose nil)))
    (flet ((eval-string (s)
	     (with-simple-restart (continue "Skip evaluation of ~a" s)
	       (eval (read-from-string s))))
	   (load-file (name)
	     (with-simple-restart (continue "Skip loading ~s" name)
	       (load name))))
      (dolist (p *lisp-startup-parameters*)
	(let* ((param (cdr p)))
	  (case (car p)
	    (:gc-threshold
	     (multiple-value-bind (n last) (parse-integer param :junk-allowed t)
	       (when n
		 (if (< last (length param))
		   (case (schar param last)
		     ((#\k #\K) (setq n (ash n 10)))
		     ((#\m #\M) (setq n (ash n 20)))))
		 (set-lisp-heap-gc-threshold n)
		 (use-lisp-heap-gc-threshold))))
	    (:eval (eval-string param))
	    (:load (load param))))))))

(defparameter *listener-process-stackseg-size* (ash 1 17))

(defun make-mcl-listener-process (procname input-stream output-stream cleanup-function)
  (let ((p (make-process procname 
                         :stack-size (truncate (* 4/3 *listener-process-stackseg-size*))
                         :vstack-size *listener-process-stackseg-size*
                         :tstack-size (ceiling *listener-process-stackseg-size* 3))))
                         
    (process-preset p #'(lambda ()
                          (let ((*listener-p* t)
				(*terminal-io*
				 (make-echoing-two-way-stream
				  input-stream output-stream)))
			    (unwind-protect
				 (progn
				   (unless *inhibit-greeting* 
				     (format t "~&Welcome to ~A ~A!~%"
					     (lisp-implementation-type)
					     (lisp-implementation-version)))
				   (toplevel-loop))
			     (funcall cleanup-function)
			     (close input-stream)
			     (close output-stream)))))
    (process-enable p)
    p))


; End of l1-boot-lds.lisp
