;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

;;; ppc-callback-support.lisp
;;;
;;; Support for PPC callbacks

;;;sp-callback (sp-eabi-callback for eabi) receives NIL in r11 and a
;;;callback index in r12; the latter is an index into the
;;;%pascal-functions% vector (so called because, under 68K MacOS, most
;;;interesting foreign functions were defined in Pascal and followed
;;;Pascal calling conventions.)  Then it funcalls #'%pascal-functions%
;;;with two args, the %pascal-functions% index and a pointer to the
;;;stack frame containing the arguments (tagged as a fixnum).
;;; %pascal-functions% puts the return value in param0 in the stack frame
;;; (which is where its argument pointer was pointing.)





; Return as a fixnum the address of the subprim at the given offset
#+ppc-target
(defppclapfunction %get-subprim ((subprim-offset arg_z))
  (ref-global imm0 subprims-base)
  (unbox-fixnum arg_z arg_z)
  (add arg_z imm0 arg_z)
  (blr))


#+ppc-target
(defppclapfunction %get-object ((macptr arg_y) (offset arg_z))
  (twnei nargs (* 2 4))
  (trap-unless-typecode= arg_y arch::subtag-macptr)
  (macptr-ptr imm0 arg_y)
  (trap-unless-lisptag= arg_z arch::tag-fixnum imm1)
  (unbox-fixnum arg_z arg_z)
  (lwzx arg_z arg_z imm0)
  (blr))

;; It would be awfully nice if (setf (%get-long macptr offset)
;;                                   (ash (the fixnum value) ppc::fixnumshift))
;; would do this inline.
#+ppc-target
(defppclapfunction %set-object ((macptr arg_x) (offset arg_y) (value arg_z))
  (twnei nargs (* 3 4))
  (trap-unless-typecode= arg_x arch::subtag-macptr)
  (macptr-ptr imm0 arg_x)
  (trap-unless-lisptag= arg_y arch::tag-fixnum imm1)
  (unbox-fixnum arg_y arg_y)
  (stwx arg_z arg_y imm0)
  (blr))


;; This is machine-dependent (it conses up a piece of "trampoline" code
;; which calls a subprim in the lisp kernel.)
(defun make-callback-trampoline (index)
  (macrolet ((ppc-lap-word (instruction-form)
               (uvref (uvref (compile nil `(lambda (&lap 0) (ppc-lap-function () ((?? 0)) ,instruction-form))) 0) 0)))
    (let* ((nil-address (%address-of nil))
           (p (malloc 28)))
      (setf (%get-long p 0) (logior (ash nil-address -16) 
                                    (ppc-lap-word (lis 12 ??)))   ; high half of nil address
            (%get-long p 4) (logior (ppc-lap-word (ori 12 12 ??))
                                    (logand #xffff nil-address))        ; low half of nil address
            (%get-long p 8) (ppc-lap-word (lis 11 (ash (subprim-name->offset #+eabi-target '.SPeabi-callback #-eabi-target '.SPcallback) -16)))
	    (%get-long p 12) (ppc-lap-word (ori 11 11 (logand #xffff (subprim-name->offset #+eabi-target '.SPeabi-callback #-eabi-target '.SPcallback))))
            (%get-long p 16) (ppc-lap-word (mtctr 11))
            (%get-long p 20) (logior index (ppc-lap-word (li 11 ??)))   ; unboxed index
            (%get-long p 24) (ppc-lap-word (bctr)))
      (ff-call (%kernel-import #.arch::kernel-import-makedataexecutable) 
               :address p 
               :unsigned-fullword 24 
               :void)
      p)))










; This is called by .SPcallback



; moved to "lib;dumplisp" as restore-pascal-functions

