;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of OpenMCL.  
;;;
;;;   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with OpenMCL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with OpenMCL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   OpenMCL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html


;(setq *save-local-symbols* t)

#+ppc-target
(progn
(breaker)
(format t "~&Initializing Macintosh Common Lisp ...")
(setq *load-verbose* t)
(setq *warn-if-redefine* nil)
(setq *.fasl-pathname* (pathname ".pfsl")) ; leave it?
(setq *.pfsl-pathname* (pathname ".pfsl"))
(setq *fasl-target* :ppc)
(setq *save-exit-functions* nil)

(require 'compile-ccl)
(ppc-load-ccl)

(setq *warn-if-redefine* t)
(setq *load-verbose* nil)
(format t "~&Macintosh Common Lisp Loaded")

(defun save-mcl-libraries (&optional (suffix ""))
  (save-library (concatenate 'string "ccl:ccl;pmcl-compiler" suffix)
                "pmcl-compiler" *nx-start* *nx-end*)
  ; More here ?
  ; Pick up the leftovers ...
  (save-library (concatenate 'string "ccl:ccl;pmcl-library" suffix)
                "pmcl-library" nil nil))

(defun save-it (&optional (suffix ""))
  (save-mcl-libraries (and suffix (concatenate 'string "-" suffix)))
  (let ((prefix "ccl:ccl;PPCCL"))
    (save-application (if suffix
                        (concatenate 'string prefix " " suffix)
                        prefix))))

;(save-application "ccl;CCL")
)
; End of init-ccl.lisp
