/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/

	
/* sp_builtin.s - builtin functions support */



	include(lisp.s)
	_beginfile

define([jump_builtin],[
	ref_nrs_value(fname,builtin_functions)
	set_nargs($2)
	vref32(fname,fname,$1)
	jump_fname()
])

	
_spentry(builtin_plus)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(bne- cr0,1f)
	__(mcrxr cr0)
	__(addo. arg_z,arg_y,arg_z)
	__(bnslr+)
	__(uuo_fixnum_overflow(arg_z,arg_z))
	__(blr)
1:
	__(jump_builtin(_builtin_plus,2))

_spentry(builtin_minus)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(bne- cr0,1f)
	__(mcrxr cr0)
	__(subo. arg_z,arg_y,arg_z)
	__(bnslr+)
	__(uuo_fixnum_overflow(arg_z,arg_z))
	__(blr)
1:
	__(jump_builtin(_builtin_minus,2))

_spentry(builtin_times)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(unbox_fixnum(imm2,arg_y))
	__(bne 1f)
	__(mcrxr cr0)
	__(mullwo. imm3,arg_z,imm2)
	__(bso 2f)		/*  SO set if result would overflow a fixnum */
	__(mr arg_z,imm3)
	__(blr)
	/* Args are fixnums; result can't be */
2:	__(unbox_fixnum(imm3,arg_z))
	__(mullw imm1,imm3,imm2) /* imm1 = low  32 bits */
	__(mulhw imm0,imm3,imm2) /* imm0 = high 32 bits */
	__(srawi imm2,imm1,31)
	__(cmpw cr1,imm2,imm0)
	__(li imm2,one_digit_bignum_header)
	__(bne cr1,3f)
	__(stwu rzero,8(freeptr))
	__(stw imm2,0(initptr))
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(stw imm1,misc_data_offset(arg_z))
	__(blr)
3:	__(li imm2,two_digit_bignum_header)
	__(stwu rzero,16(freeptr))
	__(stw imm2,0(initptr))
	__(la arg_z,fulltag_misc(initptr))
	__(mr initptr,freeptr)
	__(stw imm1,misc_data_offset(arg_z))
	__(stw imm0,misc_data_offset+4(arg_z))
	__(blr)

1:	__(jump_builtin(_builtin_times,2))

_spentry(builtin_div)
	__(jump_builtin(_builtin_div,2))

_spentry(builtin_eq)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(cmpw cr1,arg_y,arg_z)
	__(bne- cr0,1f)
	__(mr arg_z,rnil)
	__(bnelr cr1)
	__(la arg_z,t_offset(rnil))
	__(blr)
1:
	__(jump_builtin(_builtin_eq,2))

_spentry(builtin_ne)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(cmpw cr1,arg_y,arg_z)
	__(bne- cr0,1f)
	__(mr arg_z,rnil)
	__(beqlr cr1)
	__(la arg_z,t_offset(rnil))
	__(blr)
1:
	__(jump_builtin(_builtin_ne,2))

_spentry(builtin_gt)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(cmpw cr1,arg_y,arg_z)
	__(bne- cr0,1f)
	__(mr arg_z,rnil)
	__(bnglr cr1)
	__(la arg_z,t_offset(rnil))
	__(blr)
1:
	__(jump_builtin(_builtin_gt,2))

_spentry(builtin_ge)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(cmpw cr1,arg_y,arg_z)
	__(bne- cr0,1f)
	__(mr arg_z,rnil)
	__(bltlr cr1)
	__(la arg_z,t_offset(rnil))
	__(blr)
1:
	__(jump_builtin(_builtin_ge,2))

_spentry(builtin_lt)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(cmpw cr1,arg_y,arg_z)
	__(bne- cr0,1f)
	__(mr arg_z,rnil)
	__(bnllr cr1)
	__(la arg_z,t_offset(rnil))
	__(blr)
1:
	__(jump_builtin(_builtin_lt,2))

_spentry(builtin_le)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(cmpw cr1,arg_y,arg_z)
	__(bne- cr0,1f)
	__(mr arg_z,rnil)
	__(bgtlr cr1)
	__(la arg_z,t_offset(rnil))
	__(blr)
1:
	__(jump_builtin(_builtin_le,2))


_spentry(builtin_eql)
	__(cmpw cr0,arg_y,arg_z)
	__(extract_lisptag(imm0,arg_y))
	__(extract_lisptag(imm1,arg_z))
	__(cmpw cr1,imm0,imm1)
	__(beq cr0,1f)
	__(cmpwi cr0,imm0,tag_misc)
	__(bne cr1,2f)
	__(bne cr0,2f)
	__(jump_builtin(_builtin_eql,2))
1:	__(la arg_z,t_offset(rnil))
	__(blr)
2:	__(mr arg_z,rnil)
	__(blr)

_spentry(builtin_length)
	__(cmpw cr1,arg_z,rnil)
	__(extract_typecode(imm0,arg_z))
	__(cmpwi cr0,imm0,min_vector_subtag)
	__(beq cr1,1f)
	__(beq- cr0,2f)
	__(blt- cr0,3f)
	/* (simple-array * (*)) */
	__(vector_length(arg_z,arg_z,imm0))
	__(blr)
2:
	__(lwz arg_z,vectorH.logsize(arg_z))
	__(blr)
1:
	__(li arg_z,0)
	__(blr)
3:
	__(jump_builtin(_builtin_length,1))

_spentry(builtin_seqtype)
	__(extract_typecode(imm0,arg_z))
	__(cmpwi cr0,imm0,tag_list)
	__(cmpwi cr1,imm1,min_vector_subtag)
	__(beq cr0,1f)
	__(blt- cr1,2f)
	__(mr arg_z,rnil)
	__(blr)
1:	__(la arg_z,t_offset(rnil))
	__(blr)
2:
	__(jump_builtin(_builtin_seqtype,1))

_spentry(builtin_assq)
	__(jump_builtin(_builtin_assq,2))

_spentry(builtin_memq)
	__(jump_builtin(_builtin_memq,2))

_spentry(builtin_logbitp)
	/* Call out unless both fixnums,0 <=  arg_y < 30 */
	__(cmplwi cr1,arg_y,30<<fixnum_shift)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(unbox_fixnum(imm0,arg_y))
	__(subfic imm0,imm0,30)
	__(rlwnm imm0,arg_z,imm0,31,31)
	__(rlwimi imm0,imm0,4,27,27)
	__(bnl cr1,1f)
	__(bne cr0,1f)
	__(add arg_z,rnil,imm0)
	__(blr)
1:
	__(jump_builtin(_builtin_logbitp,2))

_spentry(builtin_logior)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(bne- cr0,1f)
	__(or arg_z,arg_y,arg_z)
	__(blr)
1:
	__(jump_builtin(_builtin_logior,2))

_spentry(builtin_logand)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(bne- cr0,1f)
	__(and arg_z,arg_y,arg_z)
	__(blr)
1:
	__(jump_builtin(_builtin_logand,2))

_spentry(builtin_ash)
	__(jump_builtin(_builtin_ash,2))

_spentry(builtin_negate)
	__(extract_lisptag_(imm0,arg_z))
	__(bne- cr0,1f)
	__(mcrxr cr0)
	__(nego. arg_z,arg_z)
	__(bnslr+)
	__(uuo_fixnum_overflow(arg_z,arg_z))
	__(blr)
1:
	__(jump_builtin(_builtin_negate,1))

_spentry(builtin_logxor)
	__(extract_2_lisptags_(imm0,arg_y,arg_z))
	__(bne- cr0,1f)
	__(xor arg_z,arg_y,arg_z)
	__(blr)
1:
	__(jump_builtin(_builtin_logxor,2))

_spentry(builtin_aref1)
	.globl _SPsubtag_misc_ref
	__(extract_typecode(imm0,arg_y))
	__(cmpwi cr0,imm0,min_vector_subtag)
	__(box_fixnum(arg_x,imm0))
	__(bgt cr0,1f)
	__(jump_builtin(_builtin_aref1,2))
1:
	__(b _SPsubtag_misc_ref)

_spentry(builtin_aset1)
	.globl _SPsubtag_misc_set
	__(extract_typecode(imm0,arg_x))
	__(cmpwi cr0,imm0,min_vector_subtag)
	__(box_fixnum(temp0,imm0))
	__(bgt cr0,1f)
	__(jump_builtin(_builtin_aset1,3))
1:
	__(b _SPsubtag_misc_set)

	_endfile
