/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of OpenMCL.  

   OpenMCL is licensed under the terms of the Lisp Lesser GNU Public
   License , known as the LLGPL and distributed with OpenMCL as the
   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
   which is distributed with OpenMCL as the file "LGPL".  Where these
   conflict, the preamble takes precedence.  

   OpenMCL is referenced in the preamble as the "LIBRARY."

   The LLGPL is also available online at
   http://opensource.franz.com/preamble.html
*/


	include(lisp.s)
	_beginfile
	.globl funcall

/* funcall temp0, returning multiple values if it does. */
_spentry(mvpass)
	__(mflr loc_pc)
	__(mr imm0,vsp)
	__(cmpwi cr0,nargs,4*nargregs)
	__(create_lisp_frame())
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(stw fn,lisp_frame.savefn(sp))
	__(ref_global(loc_pc,ret1val_addr))
	__(ble+ cr0,1f)
	__(subi imm0,imm0,4*nargregs)
	 __(add imm0,imm0,nargs)
1:
	__(stw imm0,lisp_frame.savevsp(sp))
	__(li fn,0)
	__(mtlr loc_pc)
	__(b funcall)
	_endfn


/* ret1valn returns "1 multiple value" when a called function does not */
/* return multiple values.  Its presence on the stack (as a return address) */
/* identifies the stack frame to code which returns multiple values. */

_exportfn(.ret1valn)
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(mtlr loc_pc)
	__(lwz fn,lisp_frame.savefn(sp))
	__(discard_lisp_frame())
	__(vpush(arg_z))
	__(set_nargs(1))
	__(blr)

	.globl .nvalret
	/* Come here with saved context on top of stack. */
_spentry(nvalret)
.nvalret:	
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz temp0,lisp_frame.savevsp(sp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(discard_lisp_frame())
	__(b _local_label(return_values))

	/* Come here to return multiple values when */
	/* the caller's context isn't saved in a lisp_frame. */
	/* lr, fn valid; temp0 = entry vsp */

_spentry(values)
	__(mflr loc_pc)
_local_label(return_values):
	__(ref_global(imm0,ret1val_addr))
	__(mr arg_z,rnil)
	/* max tsp frame is 4K. 8+8 is overhead for save_values_to_tsp below */
	/* and @do_unwind in nthrowvalues in "sp_catch.s". */
	__(cmpwi cr2,nargs,4096-(8+8))
	__(cmpw cr1,imm0,loc_pc)
	__(cmpwi cr0,nargs,fixnum_one)
	__(bge cr2,2f)
	__(beq+ cr1,3f)
	__(mtlr loc_pc)
	__(add imm0,nargs,vsp)
	__(blt- cr0,1f)
	__(lwz arg_z,-4(imm0))
1:
	__(mr vsp,temp0)
	__(blr)

2:
	__(uuo_interr(error_too_many_values,nargs))
	__(b 2b)

/* Return multiple values to real caller. */
3:
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(add imm1,nargs,vsp)
	__(mtlr loc_pc)
	__(lwz imm0,lisp_frame.savevsp(sp))
	__(cmpw cr0,imm1,imm0) /* a fairly common case */
	__(lwz fn,lisp_frame.savefn(sp))
	__(cmpwi cr1,nargs,fixnum_one) /* sadly, a very common case */
	__(discard_lisp_frame())
	__(beqlr cr0) /* already in the right place */
	__(bne cr1,4f)
	 __(lwz arg_z,0(vsp))
	 __(mr vsp,imm0)
	 __(vpush(arg_z))
	 __(blr)
4:
	__(blt cr1,6f)
	__(li imm2,fixnum_one)
5:
	__(cmpw cr0,imm2,nargs)
	__(addi imm2,imm2,fixnum_one)
	__(lwzu arg_z,-4(imm1))
	__(push(arg_z,imm0))
	__(bne cr0,5b)
6:
	__(mr vsp,imm0)
	__(blr)

_spentry(fitvals)
	__(subf. imm0,nargs,imm0)
	__(bge 2f)
	__(sub vsp,vsp,imm0)
	__(blr)
1:
	__(subic. imm0,imm0,4)
	__(vpush(rnil))
	__(addi nargs,nargs,4)
2:
	__(bne 1b)
	__(blr)

_spentry(nthvalue)
	__(add imm0,vsp,nargs)
	__(lwz imm1,0(imm0))
	__(cmplw imm1,nargs)	/*  do unsigned compare:	 if (n < 0) => nil. */
	__(mr arg_z,rnil)
	__(neg imm1,imm1)
	__(subi imm1,imm1,4)
	__(bge 1f)
	__(lwzx arg_z,imm0,imm1)
1:	
	__(la vsp,4(imm0))
	__(blr)



/* "slide" nargs worth of values up the vstack.  IMM0 contains */
/* the difference between the current VSP and the target. */
_spentry(mvslide)
	__(cmpwi cr0,nargs,0)
	__(mr imm3,nargs)
	__(add imm2,vsp,nargs)
	__(add imm2,imm2,imm0)
	__(add imm0,vsp,nargs)
	__(beq 2f)
1:
	__(cmpwi cr0,imm3,1<<fixnumshift)
	__(subi imm3,imm3,1<<fixnumshift)
	__(lwzu temp0,-4(imm0))
	__(stwu temp0,-4(imm2))
	__(bne cr0,1b)
2:
	__(mr vsp,imm2)
	__(blr)

/* Build a new TSP area to hold nargs worth of multiple-values. */
/* Pop the multiple values off of the vstack. */
/* The new TSP frame will look like this: */
/* */
/* +--------+-------+-------+---------+--------+--------+--------+======+----------+ */
/* | ptr to | zero  | nargs | ptr to  | valn-1 | valn-2 | val-0  | ???? | prev TSP | */
/* |  prev  |       |       |  prev   |        |        |        | fill |          | */
/* | TSP    |       |       | segment |        |        |        |      |          | */
/* +--------+-------+-------+---------+--------+--------+--------+------+----------+ */
/* */
/* e.g., the first multiple value goes in the last cell in the frame, the */
/* count of values goes in the first word, and the word after the value count */
/* is 0 if the number of values is even (for alignment). */
/* Subsequent calls to .SPadd_values preserve this alignment. */
/* .SPrecover_values is therefore pretty simple. */

_spentry(save_values)
	__(mr imm1,tsp)

/* common exit: nargs = values in this set, imm1 = ptr to tsp before call to save_values */
save_values_to_tsp:
	__(li imm0,-(8+8)) /* space for backptr, zero, count, link */
	__(mr imm2,tsp)
	__(sub imm0,imm0,nargs)
	__(bitclr(imm0,imm0,2)) /* down to dword boundary */
	__(mr initptr,tsp) /* uninterruptable */
	__(stwux imm1,tsp,imm0) /* keep one tsp "frame" as far as rest of lisp is concerned */
	__(sub initptr,tsp,imm0) /* correct for stack overflow */
	__(stw rzero,-4(initptr)) /* just in case odd values */
	__(stw rzero,4(tsp)) /* lisp frame */
	__(stw nargs,8(tsp))
	__(stw imm2,12(tsp)) /* previous tsp */
	__(la initptr,16(tsp))
	__(add initptr,initptr,nargs)
	__(add imm0,vsp,nargs)
	__(cmpw cr0,imm0,vsp)
	__(b 2f)
1:
	__(lwzu arg_z,-4(imm0))
	__(cmpw cr0,imm0,vsp)
	__(stwu arg_z,-4(initptr))
2:
	__(bne cr0,1b)
	__(mr initptr,freeptr)
	__(add vsp,vsp,nargs) /*  discard values */
	__(blr)

/* Add the multiple values that are on top of the vstack to the set */
/* saved in the top tsp frame, popping them off of the vstack in the */
/* process.  It is an error (a bad one) if the TSP contains something */
/* other than a previously saved set of multiple-values. */
/* Since adding to the TSP may cause a new TSP segment to be allocated, */
/* each add_values call adds another linked element to the list of */
/* values. This makes recover_values harder. */

_spentry(add_values)
	__(cmpwi cr0,nargs,0)
	__(lwz imm1,0(tsp))
	__(bne cr0,save_values_to_tsp)
	__(blr)

/* vpush the values in the value set atop the vsp, incrementing nargs. */
/* Discard the tsp frame; leave values atop the vsp. */

_spentry(recover_values)

/* First, walk the segments reversing the pointer to previous segment pointers */
/* Can tell the end because that previous segment pointer is the prev tsp pointer */
	__(lwz imm0,0(tsp)) /* previous tsp */
	__(mr imm1,tsp) /* current segment */
	__(mr imm2,tsp) /* last segment */
walkloop:
	__(lwz imm3,12(imm1)) /* next segment */
	__(cmpw cr0,imm0,imm3) /* last segment? */
	__(stw imm2,12(imm1)) /* reverse pointer */
	__(mr imm2,imm1) /* last segment <- current segment */
	__(mr imm1,imm3) /* current segment <- next segment */
	__(bne cr0,walkloop)

/* the final segment ptr is now in imm2 */
/* walk backwards, pushing values on VSP and incrementing NARGS */
pushloop:
	__(lwz imm0,8(imm2)) /* nargs in segment */
	__(cmpwi cr0,imm0,0)
	__(cmpw cr1,imm2,tsp)
	__(la initptr,16(imm2))
	__(add initptr,initptr,imm0)
	__(add nargs,nargs,imm0)
	__(b 2f)
1:
	__(lwzu arg_z,-4(initptr))
	__(cmpwi cr0,imm0,fixnum_one)
	__(subi imm0,imm0,fixnum_one)
	__(vpush(arg_z))
2:
	__(bne cr0,1b)
	__(lwz imm2,12(imm2)) /* previous segment */
	__(bne cr1,pushloop)
	__(mr initptr,freeptr)
	__(unlink(tsp))
	__(blr)

	_endfile

	