/* -------------------------------------------------------------------------- *
 *                                   OpenMMAmoeba                             *
 * -------------------------------------------------------------------------- *
 * This is part of the OpenMM molecular simulation toolkit originating from   *
 * Simbios, the NIH National Center for Physics-Based Simulation of           *
 * Biological Structures at Stanford, funded under the NIH Roadmap for        *
 * Medical Research, grant U54 GM072970. See https://simtk.org.               *
 *                                                                            *
 * Portions copyright (c) 2008-2016 Stanford University and the Authors.      *
 * Authors: Peter Eastman                                                     *
 * Contributors:                                                              *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS, CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,    *
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR      *
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE  *
 * USE OR OTHER DEALINGS IN THE SOFTWARE.                                     *
 * -------------------------------------------------------------------------- */

/**
 * This tests the Reference implementation of AmoebaTorsionTorsionForce.
 */

#include "openmm/internal/AssertionUtilities.h"
#include "openmm/Context.h"
#include "OpenMMAmoeba.h"
#include "openmm/System.h"
//#include "AmoebaTinkerParameterFile.h"
#include "openmm/AmoebaTorsionTorsionForce.h"
#include "openmm/LangevinIntegrator.h"
#include <iostream>
#include <vector>

using namespace OpenMM;

extern "C" OPENMM_EXPORT void registerAmoebaReferenceKernelFactories();

const double TOL = 1e-4;

TorsionTorsionGrid getTorsionGrid(int gridIndex, bool includeDerivs) {

static double grid[4][625][6] = { 
    {
    {    -180.0000,    -180.0000,  0.000000000E+00,  0.552257112E-05,  0.000000000E+00, -0.126199335E-02 }, 
    {    -165.0000,    -180.0000, -0.159180000E+00, -0.166906548E-01, -0.179394657E-01, -0.106268484E-02 }, 
    {    -150.0000,    -180.0000, -0.469240000E+00, -0.270909033E-01, -0.293045871E-01, -0.348184728E-03 }, 
    {    -135.0000,    -180.0000, -0.948870000E+00, -0.328837318E-01, -0.287196052E-01,  0.299395850E-03 }, 
    {    -120.0000,    -180.0000, -0.141919000E+01, -0.313641693E-01, -0.228156086E-01,  0.448397027E-03 }, 
    {    -105.0000,    -180.0000, -0.189608000E+01, -0.311015908E-01, -0.174245535E-01,  0.166026389E-03 }, 
    {     -90.0000,    -180.0000, -0.235024000E+01, -0.304394676E-01, -0.173433944E-01, -0.180597422E-04 }, 
    {     -75.0000,    -180.0000, -0.281648000E+01, -0.312205390E-01, -0.172186852E-01, -0.526137649E-04 }, 
    {     -60.0000,    -180.0000, -0.317758000E+01, -0.101463764E-01, -0.161063106E-01,  0.475931576E-03 }, 
    {     -45.0000,    -180.0000, -0.291092000E+01,  0.529180444E-01, -0.460494424E-02,  0.671635664E-03 }, 
    {     -30.0000,    -180.0000, -0.184916000E+01,  0.641581986E-01,  0.604688652E-02,  0.126816519E-02 }, 
    {     -15.0000,    -180.0000, -0.618680000E+00,  0.148897161E+00,  0.240060782E-01, -0.220919394E-04 }, 
    {       0.0000,    -180.0000,  0.144957000E+01, -0.843083945E-06, -0.138777878E-16, -0.238917474E-02 }, 
    {      15.0000,    -180.0000, -0.618680000E+00, -0.148893789E+00, -0.240062071E-01, -0.236661683E-04 }, 
    {      30.0000,    -180.0000, -0.184916000E+01, -0.641700018E-01, -0.605043409E-02,  0.127375259E-02 }, 
    {      45.0000,    -180.0000, -0.291092000E+01, -0.528742041E-01,  0.460494424E-02,  0.650886067E-03 }, 
    {      60.0000,    -180.0000, -0.317758000E+01,  0.998281807E-02,  0.161063106E-01,  0.554052075E-03 }, 
    {      75.0000,    -180.0000, -0.281793000E+01,  0.315409318E-01,  0.182254525E-01, -0.142992706E-03 }, 
    {      90.0000,    -180.0000, -0.234954000E+01,  0.294614547E-01,  0.157303403E-01, -0.572753043E-04 }, 
    {     105.0000,    -180.0000, -0.191578000E+01,  0.310432493E-01,  0.179437362E-01,  0.315750647E-03 }, 
    {     120.0000,    -180.0000, -0.141919000E+01,  0.324355481E-01,  0.237264021E-01,  0.393485071E-03 }, 
    {     135.0000,    -180.0000, -0.948870000E+00,  0.325965581E-01,  0.287196052E-01,  0.265482885E-03 }, 
    {     150.0000,    -180.0000, -0.469240000E+00,  0.271682193E-01,  0.293080068E-01, -0.339095672E-03 }, 
    {     165.0000,    -180.0000, -0.159180000E+00,  0.166685645E-01,  0.179394658E-01, -0.106512808E-02 }, 
    {     180.0000,    -180.0000,  0.000000000E+00,  0.552257112E-05,  0.000000000E+00, -0.126199335E-02 }, 
    {    -180.0000,    -165.0000, -0.304300000E-01, -0.179832760E-01, -0.437672944E-02, -0.107152527E-02 }, 
    {    -165.0000,    -165.0000, -0.402820000E+00, -0.291497190E-01, -0.143205279E-01, -0.393186107E-03 }, 
    {    -150.0000,    -165.0000, -0.842880000E+00, -0.279078479E-01, -0.158206253E-01,  0.355490531E-03 }, 
    {    -135.0000,    -165.0000, -0.122723000E+01, -0.241008893E-01, -0.503796008E-02,  0.827737542E-03 }, 
    {    -120.0000,    -165.0000, -0.158634000E+01, -0.243805950E-01,  0.440318053E-02,  0.378320458E-03 }, 
    {    -105.0000,    -165.0000, -0.198317000E+01, -0.295647308E-01,  0.662367233E-02, -0.869289336E-05 }, 
    {     -90.0000,    -165.0000, -0.246682000E+01, -0.334564819E-01,  0.476335381E-02, -0.271514228E-03 }, 
    {     -75.0000,    -165.0000, -0.296238000E+01, -0.324513417E-01,  0.437966491E-03, -0.142391360E-03 }, 
    {     -60.0000,    -165.0000, -0.327921000E+01,  0.783848567E-03,  0.460311419E-02,  0.809031745E-03 }, 
    {     -45.0000,    -165.0000, -0.285897000E+01,  0.499979474E-01,  0.131415370E-01, -0.553021522E-03 }, 
    {     -30.0000,    -165.0000, -0.166034000E+01,  0.122998362E+00,  0.220506944E-01,  0.489257038E-02 }, 
    {     -15.0000,    -165.0000,  0.286540000E+00,  0.871106053E-01,  0.899820396E-01, -0.364915945E-02 }, 
    {       0.0000,    -165.0000,  0.475830000E+00, -0.442067830E-01, -0.467861405E-01, -0.406329954E-02 }, 
    {      15.0000,    -165.0000, -0.593280000E+00, -0.862474733E-01,  0.100423868E-01,  0.391442707E-02 }, 
    {      30.0000,    -165.0000, -0.185441000E+01, -0.768513239E-01,  0.742519094E-02, -0.752142438E-03 }, 
    {      45.0000,    -165.0000, -0.272832000E+01, -0.333552312E-01,  0.208517588E-01,  0.125601709E-02 }, 
    {      60.0000,    -165.0000, -0.282977000E+01,  0.152002488E-01,  0.300658719E-01,  0.256210283E-03 }, 
    {      75.0000,    -165.0000, -0.243750000E+01,  0.307182359E-01,  0.328596241E-01,  0.120714835E-03 }, 
    {      90.0000,    -165.0000, -0.197978000E+01,  0.319248075E-01,  0.351973987E-01,  0.287235735E-03 }, 
    {     105.0000,    -165.0000, -0.147132000E+01,  0.348185340E-01,  0.402120635E-01,  0.200830109E-03 }, 
    {     120.0000,    -165.0000, -0.949890000E+00,  0.347790566E-01,  0.401866996E-01, -0.926959877E-04 }, 
    {     135.0000,    -165.0000, -0.441660000E+00,  0.319972398E-01,  0.371976189E-01, -0.432935069E-03 }, 
    {     150.0000,    -165.0000, -0.405500000E-01,  0.190999843E-01,  0.274261100E-01, -0.727681662E-03 }, 
    {     165.0000,    -165.0000,  0.101460000E+00,  0.226822911E-03,  0.147776092E-01, -0.114034024E-02 }, 
    {     180.0000,    -165.0000, -0.304300000E-01, -0.179832760E-01, -0.437672944E-02, -0.107152527E-02 }, 
    {    -180.0000,    -150.0000, -0.548700000E-01, -0.290709431E-01,  0.653291777E-02, -0.267198730E-03 }, 
    {    -165.0000,    -150.0000, -0.496390000E+00, -0.275168201E-01,  0.777957722E-02,  0.470196210E-03 }, 
    {    -150.0000,    -150.0000, -0.834180000E+00, -0.167237766E-01,  0.195990881E-01,  0.999647962E-03 }, 
    {    -135.0000,    -150.0000, -0.102443000E+01, -0.111960737E-01,  0.337594456E-01,  0.727185609E-03 }, 
    {    -120.0000,    -150.0000, -0.124614000E+01, -0.208839287E-01,  0.398128865E-01,  0.134369277E-03 }, 
    {    -105.0000,    -150.0000, -0.165671000E+01, -0.317242116E-01,  0.388038642E-01, -0.255778987E-03 }, 
    {     -90.0000,    -150.0000, -0.217397000E+01, -0.377852248E-01,  0.335439792E-01, -0.365034793E-03 }, 
    {     -75.0000,    -150.0000, -0.273078000E+01, -0.319488892E-01,  0.326068193E-01,  0.476509175E-03 }, 
    {     -60.0000,    -150.0000, -0.295919000E+01,  0.853678149E-02,  0.413718538E-01,  0.245730146E-04 }, 
    {     -45.0000,    -150.0000, -0.236553000E+01,  0.708517632E-01,  0.611167963E-01,  0.512719418E-02 }, 
    {     -30.0000,    -150.0000, -0.655940000E+00,  0.168706166E+00,  0.144394336E+00,  0.711467234E-04 }, 
    {     -15.0000,    -150.0000,  0.160921000E+01,  0.492715741E-01,  0.616437634E-01, -0.530638766E-02 }, 
    {       0.0000,    -150.0000,  0.681970000E+00, -0.982104620E-01,  0.336245620E-01, -0.999550874E-03 }, 
    {      15.0000,    -150.0000, -0.475030000E+00, -0.732777261E-01,  0.125666598E-01, -0.510829560E-03 }, 
    {      30.0000,    -150.0000, -0.160792000E+01, -0.666566337E-01,  0.245976703E-01,  0.123749078E-02 }, 
    {      45.0000,    -150.0000, -0.228172000E+01, -0.214337391E-01,  0.378280205E-01,  0.613138578E-03 }, 
    {      60.0000,    -150.0000, -0.227657000E+01,  0.186615902E-01,  0.438322019E-01,  0.156861223E-03 }, 
    {      75.0000,    -150.0000, -0.184368000E+01,  0.343953783E-01,  0.451860511E-01,  0.231022666E-03 }, 
    {      90.0000,    -150.0000, -0.132072000E+01,  0.349268966E-01,  0.492440650E-01,  0.142073802E-05 }, 
    {     105.0000,    -150.0000, -0.796930000E+00,  0.352470353E-01,  0.449780099E-01, -0.278313874E-03 }, 
    {     120.0000,    -150.0000, -0.275020000E+00,  0.332249621E-01,  0.443607996E-01,  0.135181670E-03 }, 
    {     135.0000,    -150.0000,  0.157920000E+00,  0.228231163E-01,  0.438479190E-01, -0.488430981E-03 }, 
    {     150.0000,    -150.0000,  0.373940000E+00,  0.527457278E-02,  0.296235534E-01, -0.112890699E-02 }, 
    {     165.0000,    -150.0000,  0.300070000E+00, -0.154914074E-01,  0.148000975E-01, -0.805505350E-03 }, 
    {     180.0000,    -150.0000, -0.548700000E-01, -0.290709431E-01,  0.653291777E-02, -0.267198730E-03 }, 
    {    -180.0000,    -135.0000,  0.221370000E+00, -0.262012513E-01,  0.286050584E-01,  0.496725113E-03 }, 
    {    -165.0000,    -135.0000, -0.115070000E+00, -0.166359174E-01,  0.407522190E-01,  0.101516158E-02 }, 
    {    -150.0000,    -135.0000, -0.250690000E+00, -0.166707891E-02,  0.558622727E-01,  0.894071424E-03 }, 
    {    -135.0000,    -135.0000, -0.251200000E+00, -0.392176690E-02,  0.652061779E-01,  0.299344496E-03 }, 
    {    -120.0000,    -135.0000, -0.453720000E+00, -0.232518535E-01,  0.628692734E-01, -0.690049264E-03 }, 
    {    -105.0000,    -135.0000, -0.914940000E+00, -0.358188192E-01,  0.518068708E-01, -0.219008843E-03 }, 
    {     -90.0000,    -135.0000, -0.148283000E+01, -0.392948697E-01,  0.578587294E-01,  0.563975838E-03 }, 
    {     -75.0000,    -135.0000, -0.197985000E+01, -0.199837020E-01,  0.656407564E-01,  0.729882601E-03 }, 
    {     -60.0000,    -135.0000, -0.199291000E+01,  0.172136775E-01,  0.871694706E-01,  0.237864199E-02 }, 
    {     -45.0000,    -135.0000, -0.873170000E+00,  0.172464992E+00,  0.139551278E+00,  0.453765369E-02 }, 
    {     -30.0000,    -135.0000,  0.215102000E+01,  0.121712355E+00,  0.162643961E+00, -0.543435860E-02 }, 
    {     -15.0000,    -135.0000,  0.208125000E+01, -0.684304125E-01,  0.223849069E-01, -0.623349346E-02 }, 
    {       0.0000,    -135.0000,  0.101469000E+01, -0.752567051E-01,  0.200598924E-01,  0.185151863E-02 }, 
    {      15.0000,    -135.0000, -0.134090000E+00, -0.736107672E-01,  0.315289741E-01,  0.656232395E-03 }, 
    {      30.0000,    -135.0000, -0.108446000E+01, -0.501302262E-01,  0.481741277E-01,  0.114639885E-02 }, 
    {      45.0000,    -135.0000, -0.157764000E+01, -0.145783280E-01,  0.579721593E-01,  0.468092550E-04 }, 
    {      60.0000,    -135.0000, -0.154005000E+01,  0.173255381E-01,  0.525493204E-01, -0.458597322E-03 }, 
    {      75.0000,    -135.0000, -0.111846000E+01,  0.371121756E-01,  0.502041713E-01,  0.233982443E-03 }, 
    {      90.0000,    -135.0000, -0.548820000E+00,  0.324717595E-01,  0.540183412E-01, -0.183528302E-03 }, 
    {     105.0000,    -135.0000, -0.143530000E+00,  0.279867866E-01,  0.454338971E-01, -0.453924093E-03 }, 
    {     120.0000,    -135.0000,  0.350590000E+00,  0.354630943E-01,  0.424661020E-01, -0.311223152E-03 }, 
    {     135.0000,    -135.0000,  0.789610000E+00,  0.167888364E-01,  0.336647051E-01, -0.655021687E-03 }, 
    {     150.0000,    -135.0000,  0.821760000E+00, -0.838443979E-02,  0.265416765E-01, -0.253575201E-03 }, 
    {     165.0000,    -135.0000,  0.599000000E+00, -0.213730772E-01,  0.255300007E-01,  0.423816136E-04 }, 
    {     180.0000,    -135.0000,  0.221370000E+00, -0.262012513E-01,  0.286050584E-01,  0.496725113E-03 }, 
    {    -180.0000,    -120.0000,  0.762820000E+00, -0.163297527E-01,  0.425848488E-01,  0.828536362E-03 }, 
    {    -165.0000,    -120.0000,  0.650490000E+00,  0.301610870E-03,  0.585875468E-01,  0.103284365E-02 }, 
    {    -150.0000,    -120.0000,  0.732260000E+00,  0.901130923E-02,  0.702398211E-01,  0.571083499E-03 }, 
    {    -135.0000,    -120.0000,  0.803020000E+00, -0.584084779E-02,  0.709058430E-01, -0.853518412E-03 }, 
    {    -120.0000,    -120.0000,  0.467670000E+00, -0.385659181E-01,  0.514720198E-01, -0.910570101E-03 }, 
    {    -105.0000,    -120.0000, -0.175780000E+00, -0.356554799E-01,  0.501546524E-01,  0.345560703E-03 }, 
    {     -90.0000,    -120.0000, -0.558680000E+00, -0.240821623E-01,  0.580791031E-01,  0.849743949E-03 }, 
    {     -75.0000,    -120.0000, -0.870220000E+00, -0.690387102E-02,  0.769421552E-01,  0.161296405E-02 }, 
    {     -60.0000,    -120.0000, -0.446240000E+00,  0.741856464E-01,  0.112540264E+00,  0.359063200E-02 }, 
    {     -45.0000,    -120.0000,  0.142775000E+01,  0.169755286E+00,  0.139334093E+00, -0.349710448E-02 }, 
    {     -30.0000,    -120.0000,  0.349117000E+01,  0.342752113E-01,  0.344518183E-01, -0.521990321E-02 }, 
    {     -15.0000,    -120.0000,  0.247433000E+01, -0.975401307E-01,  0.218406091E-01,  0.878020526E-03 }, 
    {       0.0000,    -120.0000,  0.140660000E+01, -0.610286883E-01,  0.310618683E-01,  0.102983111E-02 }, 
    {      15.0000,    -120.0000,  0.511320000E+00, -0.509471160E-01,  0.585874439E-01,  0.235202200E-02 }, 
    {      30.0000,    -120.0000, -0.796400000E-01, -0.324308477E-01,  0.883618189E-01,  0.102207103E-02 }, 
    {      45.0000,    -120.0000, -0.497870000E+00, -0.211674932E-01,  0.870533423E-01, -0.747126421E-03 }, 
    {      60.0000,    -120.0000, -0.644870000E+00,  0.405482064E-02,  0.723105164E-01, -0.124382585E-02 }, 
    {      75.0000,    -120.0000, -0.357550000E+00,  0.330122107E-01,  0.512232635E-01, -0.144358596E-02 }, 
    {      90.0000,    -120.0000,  0.188030000E+00,  0.304763366E-01,  0.364325703E-01, -0.157419525E-03 }, 
    {     105.0000,    -120.0000,  0.545500000E+00,  0.256924428E-01,  0.417724019E-01,  0.183091744E-03 }, 
    {     120.0000,    -120.0000,  0.972890000E+00,  0.237258921E-01,  0.353567923E-01, -0.790103062E-03 }, 
    {     135.0000,    -120.0000,  0.116949000E+01,  0.420198877E-02,  0.238072605E-01, -0.615707771E-03 }, 
    {     150.0000,    -120.0000,  0.115910000E+01, -0.329184719E-02,  0.212417405E-01,  0.429923799E-03 }, 
    {     165.0000,    -120.0000,  0.105012000E+01, -0.149086000E-01,  0.330898995E-01,  0.752540374E-03 }, 
    {     180.0000,    -120.0000,  0.762820000E+00, -0.163297527E-01,  0.425848488E-01,  0.828536362E-03 }, 
    {    -180.0000,    -105.0000,  0.142827000E+01, -0.381685133E-02,  0.424355465E-01,  0.666009441E-03 }, 
    {    -165.0000,    -105.0000,  0.150406000E+01,  0.130108168E-01,  0.487235937E-01,  0.782810668E-03 }, 
    {    -150.0000,    -105.0000,  0.172284000E+01,  0.106875842E-01,  0.578844431E-01, -0.707472798E-03 }, 
    {    -135.0000,    -105.0000,  0.164917000E+01, -0.267391535E-01,  0.312444502E-01, -0.144874817E-02 }, 
    {    -120.0000,    -105.0000,  0.103764000E+01, -0.407709701E-01,  0.295146474E-01,  0.828506348E-03 }, 
    {    -105.0000,    -105.0000,  0.564750000E+00, -0.270609662E-01,  0.435125194E-01,  0.588336632E-03 }, 
    {     -90.0000,    -105.0000,  0.200840000E+00, -0.183451651E-01,  0.465588581E-01,  0.226989278E-03 }, 
    {     -75.0000,    -105.0000,  0.208210000E+00,  0.291336268E-01,  0.642026229E-01,  0.264172695E-02 }, 
    {     -60.0000,    -105.0000,  0.122814000E+01,  0.107270658E+00,  0.106879474E+00,  0.127022611E-02 }, 
    {     -45.0000,    -105.0000,  0.298189000E+01,  0.965197412E-01,  0.741243503E-01, -0.573828591E-02 }, 
    {     -30.0000,    -105.0000,  0.357647000E+01, -0.236836228E-01, -0.153612345E-01, -0.276522417E-02 }, 
    {     -15.0000,    -105.0000,  0.265211000E+01, -0.677412501E-01,  0.442465663E-02,  0.285924384E-02 }, 
    {       0.0000,    -105.0000,  0.195317000E+01, -0.300113769E-01,  0.433886343E-01,  0.307822258E-02 }, 
    {      15.0000,    -105.0000,  0.165224000E+01, -0.121872424E-01,  0.913872503E-01,  0.222038457E-02 }, 
    {      30.0000,    -105.0000,  0.143567000E+01, -0.247396534E-01,  0.102404597E+00, -0.156568393E-03 }, 
    {      45.0000,    -105.0000,  0.924860000E+00, -0.343301439E-01,  0.943144715E-01, -0.100866676E-02 }, 
    {      60.0000,    -105.0000,  0.550650000E+00, -0.149437710E-01,  0.763486141E-01, -0.101996110E-02 }, 
    {      75.0000,    -105.0000,  0.460270000E+00,  0.118722773E-02,  0.606487748E-01, -0.164462818E-02 }, 
    {      90.0000,    -105.0000,  0.604700000E+00,  0.210048600E-01,  0.309553776E-01, -0.148017349E-02 }, 
    {     105.0000,    -105.0000,  0.102077000E+01,  0.268933322E-01,  0.203364954E-01, -0.497133758E-03 }, 
    {     120.0000,    -105.0000,  0.133189000E+01,  0.168598112E-01,  0.123667289E-01, -0.249021206E-03 }, 
    {     135.0000,    -105.0000,  0.151499000E+01,  0.451142291E-02,  0.161822529E-01,  0.662370078E-03 }, 
    {     150.0000,    -105.0000,  0.150886000E+01,  0.488497135E-03,  0.259113614E-01,  0.308467391E-03 }, 
    {     165.0000,    -105.0000,  0.153133000E+01, -0.319741145E-02,  0.285764013E-01,  0.582590045E-03 }, 
    {     180.0000,    -105.0000,  0.142827000E+01, -0.381685133E-02,  0.424355465E-01,  0.666009441E-03 }, 
    {    -180.0000,     -90.0000,  0.190401000E+01,  0.543857642E-02,  0.159109652E-01,  0.861091701E-03 }, 
    {    -165.0000,     -90.0000,  0.203939000E+01,  0.203260480E-01,  0.242980785E-01, -0.159198894E-03 }, 
    {    -150.0000,     -90.0000,  0.229924000E+01, -0.769676846E-02,  0.116184066E-01, -0.108280784E-02 }, 
    {    -135.0000,     -90.0000,  0.179055000E+01, -0.393069742E-01,  0.162235629E-02, -0.447141674E-04 }, 
    {    -120.0000,     -90.0000,  0.135280000E+01, -0.243633349E-01,  0.749539078E-02,  0.437061344E-03 }, 
    {    -105.0000,     -90.0000,  0.102391000E+01, -0.165676863E-01,  0.157332698E-01,  0.111865150E-02 }, 
    {     -90.0000,     -90.0000,  0.905620000E+00,  0.119807998E-02,  0.485454644E-01,  0.329834739E-02 }, 
    {     -75.0000,     -90.0000,  0.123397000E+01,  0.537873663E-01,  0.870853532E-01, -0.416243586E-04 }, 
    {     -60.0000,     -90.0000,  0.245075000E+01,  0.926784546E-01,  0.393398402E-01, -0.497297479E-02 }, 
    {     -45.0000,     -90.0000,  0.345522000E+01,  0.197488152E-01, -0.303374942E-01, -0.355104595E-02 }, 
    {     -30.0000,     -90.0000,  0.309983000E+01, -0.418577153E-01, -0.512748802E-01,  0.105421455E-02 }, 
    {     -15.0000,     -90.0000,  0.262493000E+01, -0.183759540E-01, -0.941923564E-02,  0.351783947E-02 }, 
    {       0.0000,     -90.0000,  0.265047000E+01,  0.254895313E-01,  0.441575944E-01,  0.396092249E-02 }, 
    {      15.0000,     -90.0000,  0.309474000E+01,  0.103798289E-01,  0.925475550E-01,  0.103182869E-02 }, 
    {      30.0000,     -90.0000,  0.279428000E+01, -0.382468469E-01,  0.768037941E-01, -0.155899730E-02 }, 
    {      45.0000,     -90.0000,  0.215793000E+01, -0.447544412E-01,  0.668487718E-01,  0.644038655E-04 }, 
    {      60.0000,     -90.0000,  0.157482000E+01, -0.266273882E-01,  0.662330273E-01, -0.812771517E-03 }, 
    {      75.0000,     -90.0000,  0.133310000E+01, -0.137020060E-01,  0.443116374E-01, -0.132074467E-02 }, 
    {      90.0000,     -90.0000,  0.113012000E+01, -0.750458767E-02,  0.281639194E-01, -0.151807139E-02 }, 
    {     105.0000,     -90.0000,  0.117449000E+01,  0.119983567E-01,  0.267961662E-02, -0.933373929E-03 }, 
    {     120.0000,     -90.0000,  0.141199000E+01,  0.158851608E-01,  0.299629197E-02,  0.218041619E-03 }, 
    {     135.0000,     -90.0000,  0.162671000E+01,  0.149050002E-01,  0.290772809E-02,  0.106829747E-03 }, 
    {     150.0000,     -90.0000,  0.181755000E+01,  0.560683837E-02,  0.680281374E-02,  0.115943749E-03 }, 
    {     165.0000,     -90.0000,  0.182118000E+01,  0.156164630E-02,  0.681649536E-02,  0.211148711E-03 }, 
    {     180.0000,     -90.0000,  0.190401000E+01,  0.543857642E-02,  0.159109652E-01,  0.861091701E-03 }, 
    {    -180.0000,     -75.0000,  0.180621000E+01,  0.179152914E-01, -0.304914073E-01,  0.236052308E-03 }, 
    {    -165.0000,     -75.0000,  0.208080000E+01,  0.107458041E-01, -0.305679076E-01, -0.599017638E-03 }, 
    {    -150.0000,     -75.0000,  0.203556000E+01, -0.150285077E-01, -0.418140696E-01, -0.104514204E-03 }, 
    {    -135.0000,     -75.0000,  0.168691000E+01, -0.294097733E-01, -0.301858754E-01,  0.109348089E-02 }, 
    {    -120.0000,     -75.0000,  0.129208000E+01, -0.160283992E-01, -0.860821049E-02,  0.237176245E-02 }, 
    {    -105.0000,     -75.0000,  0.122509000E+01,  0.115937011E-02,  0.256224012E-01,  0.581124641E-03 }, 
    {     -90.0000,     -75.0000,  0.143311000E+01,  0.395969188E-01,  0.571328438E-02, -0.183196204E-02 }, 
    {     -75.0000,     -75.0000,  0.216375000E+01,  0.281849548E-01, -0.214360359E-01, -0.266496391E-02 }, 
    {     -60.0000,     -75.0000,  0.217320000E+01, -0.431873790E-02, -0.752268346E-01, -0.369620612E-02 }, 
    {     -45.0000,     -75.0000,  0.221268000E+01, -0.112400319E-02, -0.106616373E+00,  0.413720856E-03 }, 
    {     -30.0000,     -75.0000,  0.213049000E+01,  0.272750652E-03, -0.687352449E-01,  0.333964065E-02 }, 
    {     -15.0000,     -75.0000,  0.240205000E+01,  0.379070006E-01, -0.167597141E-01,  0.419904843E-02 }, 
    {       0.0000,     -75.0000,  0.324329000E+01,  0.706592470E-01,  0.380049882E-01,  0.121221222E-02 }, 
    {      15.0000,     -75.0000,  0.406613000E+01,  0.122720113E-01,  0.212005297E-01, -0.145584858E-02 }, 
    {      30.0000,     -75.0000,  0.357523000E+01, -0.533592923E-01,  0.182922268E-01,  0.668629818E-03 }, 
    {      45.0000,     -75.0000,  0.286443000E+01, -0.391748421E-01,  0.262044414E-01, -0.217888342E-03 }, 
    {      60.0000,     -75.0000,  0.231976000E+01, -0.410353393E-01,  0.125412766E-01, -0.947266493E-03 }, 
    {      75.0000,     -75.0000,  0.166472000E+01, -0.366258009E-01,  0.299467555E-02, -0.634998862E-03 }, 
    {      90.0000,     -75.0000,  0.127852000E+01, -0.207094572E-01, -0.884705516E-02, -0.790404405E-03 }, 
    {     105.0000,     -75.0000,  0.109103000E+01,  0.472562984E-02, -0.170029618E-01, -0.202910998E-03 }, 
    {     120.0000,     -75.0000,  0.136656000E+01,  0.194149379E-01, -0.174178968E-01, -0.112119936E-03 }, 
    {     135.0000,     -75.0000,  0.153314000E+01,  0.603661857E-02, -0.241831652E-01, -0.784649932E-03 }, 
    {     150.0000,     -75.0000,  0.159747000E+01,  0.262058781E-02, -0.354006164E-01, -0.345824252E-03 }, 
    {     165.0000,     -75.0000,  0.164225000E+01,  0.530303019E-02, -0.336583827E-01,  0.272903439E-03 }, 
    {     180.0000,     -75.0000,  0.180621000E+01,  0.179152914E-01, -0.304914073E-01,  0.236052308E-03 }, 
    {    -180.0000,     -60.0000,  0.941330000E+00,  0.118186977E-01, -0.864813358E-01, -0.529276683E-03 }, 
    {    -165.0000,     -60.0000,  0.107716000E+01,  0.427829487E-02, -0.944724482E-01, -0.654281180E-03 }, 
    {    -150.0000,     -60.0000,  0.106365000E+01, -0.446787716E-02, -0.914801283E-01,  0.214664292E-02 }, 
    {    -135.0000,     -60.0000,  0.962110000E+00, -0.941678624E-02, -0.465668549E-01,  0.164882817E-02 }, 
    {    -120.0000,     -60.0000,  0.944110000E+00,  0.182270221E-01, -0.548005488E-01, -0.140603973E-02 }, 
    {    -105.0000,     -60.0000,  0.125994000E+01, -0.392530226E-02, -0.710168748E-01, -0.914673259E-03 }, 
    {     -90.0000,     -60.0000,  0.796280000E+00, -0.320918131E-01, -0.932666019E-01, -0.262847785E-02 }, 
    {     -75.0000,     -60.0000,  0.575620000E+00, -0.457144538E-02, -0.133011210E+00, -0.970282337E-03 }, 
    {     -60.0000,     -60.0000,  0.565770000E+00,  0.427559460E-02, -0.115428502E+00,  0.207722726E-02 }, 
    {     -45.0000,     -60.0000,  0.745720000E+00,  0.214890670E-01, -0.850970118E-01,  0.224421289E-02 }, 
    {     -30.0000,     -60.0000,  0.124745000E+01,  0.461041375E-01, -0.442601404E-01,  0.317959342E-02 }, 
    {     -15.0000,     -60.0000,  0.221612000E+01,  0.881743830E-01, -0.530390806E-02,  0.996034197E-03 }, 
    {       0.0000,     -60.0000,  0.354214000E+01,  0.601363305E-01, -0.178435471E-01, -0.188041154E-02 }, 
    {      15.0000,     -60.0000,  0.378367000E+01, -0.152097051E-01, -0.395636737E-01, -0.326341176E-03 }, 
    {      30.0000,     -60.0000,  0.340120000E+01, -0.274855100E-01, -0.285887012E-01,  0.103674541E-02 }, 
    {      45.0000,     -60.0000,  0.289718000E+01, -0.521462548E-01, -0.238165375E-01, -0.671213209E-03 }, 
    {      60.0000,     -60.0000,  0.194715000E+01, -0.547394708E-01, -0.419321336E-01, -0.102057904E-02 }, 
    {      75.0000,     -60.0000,  0.136042000E+01, -0.362478618E-01, -0.508263396E-01, -0.648431044E-03 }, 
    {      90.0000,     -60.0000,  0.792500000E+00, -0.311990818E-01, -0.602996987E-01, -0.592098121E-04 }, 
    {     105.0000,     -60.0000,  0.577690000E+00,  0.449818897E-02, -0.540277692E-01,  0.244984367E-03 }, 
    {     120.0000,     -60.0000,  0.779350000E+00,  0.105763259E-01, -0.598527047E-01, -0.831328847E-03 }, 
    {     135.0000,     -60.0000,  0.793510000E+00, -0.363949261E-02, -0.728150673E-01, -0.677128584E-03 }, 
    {     150.0000,     -60.0000,  0.753670000E+00, -0.115435546E-02, -0.779763481E-01, -0.848855055E-04 }, 
    {     165.0000,     -60.0000,  0.785810000E+00,  0.671691445E-02, -0.792569645E-01, -0.271708837E-03 }, 
    {     180.0000,     -60.0000,  0.941330000E+00,  0.118186977E-01, -0.864813358E-01, -0.529276683E-03 }, 
    {    -180.0000,     -45.0000, -0.672750000E+00,  0.319066325E-02, -0.119375249E+00, -0.106387121E-02 }, 
    {    -165.0000,     -45.0000, -0.592120000E+00,  0.459098920E-02, -0.126126300E+00,  0.198517939E-02 }, 
    {    -150.0000,     -45.0000, -0.422000000E+00,  0.285953800E-01, -0.837774174E-01,  0.242720059E-03 }, 
    {    -135.0000,     -45.0000, -0.110600000E-01, -0.276050906E-02, -0.123140705E+00, -0.235894074E-02 }, 
    {    -120.0000,     -45.0000, -0.514700000E+00, -0.360933437E-01, -0.133545594E+00, -0.760592447E-03 }, 
    {    -105.0000,     -45.0000, -0.809220000E+00, -0.124981161E-01, -0.148416902E+00,  0.346071160E-03 }, 
    {     -90.0000,     -45.0000, -0.995380000E+00, -0.100501920E-01, -0.118344877E+00,  0.241645128E-02 }, 
    {     -75.0000,     -45.0000, -0.106430000E+01,  0.168288403E-02, -0.921291251E-01,  0.124567911E-02 }, 
    {     -60.0000,     -45.0000, -0.878440000E+00,  0.267066559E-01, -0.733871591E-01,  0.159237584E-02 }, 
    {     -45.0000,     -45.0000, -0.245760000E+00,  0.551984925E-01, -0.446835792E-01,  0.187392673E-02 }, 
    {     -30.0000,     -45.0000,  0.776340000E+00,  0.834553740E-01, -0.250541935E-01,  0.578510356E-03 }, 
    {     -15.0000,     -45.0000,  0.205251000E+01,  0.706340114E-01, -0.319326537E-01, -0.163778306E-02 }, 
    {       0.0000,     -45.0000,  0.278505000E+01,  0.357505803E-01, -0.582787999E-01, -0.672299404E-03 }, 
    {      15.0000,     -45.0000,  0.313379000E+01,  0.261966721E-02, -0.494138347E-01,  0.830744462E-03 }, 
    {      30.0000,     -45.0000,  0.285045000E+01, -0.331492492E-01, -0.488934218E-01, -0.773602836E-03 }, 
    {      45.0000,     -45.0000,  0.219151000E+01, -0.584786704E-01, -0.655222916E-01, -0.958024486E-03 }, 
    {      60.0000,     -45.0000,  0.116243000E+01, -0.705400691E-01, -0.762787422E-01, -0.871363300E-03 }, 
    {      75.0000,     -45.0000,  0.207200000E+00, -0.562230532E-01, -0.911933171E-01, -0.690727417E-03 }, 
    {      90.0000,     -45.0000, -0.422370000E+00, -0.215277183E-01, -0.901321498E-01,  0.863591448E-03 }, 
    {     105.0000,     -45.0000, -0.464600000E+00,  0.797392622E-02, -0.780119612E-01, -0.127367193E-03 }, 
    {     120.0000,     -45.0000, -0.386650000E+00, -0.322398663E-02, -0.938132844E-01, -0.109034958E-02 }, 
    {     135.0000,     -45.0000, -0.552320000E+00, -0.126219797E-01, -0.101648566E+00, -0.238555388E-03 }, 
    {     150.0000,     -45.0000, -0.670780000E+00, -0.311409453E-02, -0.106343991E+00, -0.461570193E-03 }, 
    {     165.0000,     -45.0000, -0.678300000E+00, -0.117642180E-03, -0.113423759E+00, -0.270202564E-03 }, 
    {     180.0000,     -45.0000, -0.672750000E+00,  0.319066325E-02, -0.119375249E+00, -0.106387121E-02 }, 
    {    -180.0000,     -30.0000, -0.246944000E+01, -0.414153948E-02, -0.118171667E+00,  0.159271411E-02 }, 
    {    -165.0000,     -30.0000, -0.232595000E+01,  0.406458683E-01, -0.816443537E-01, -0.129216810E-04 }, 
    {    -150.0000,     -30.0000, -0.171439000E+01, -0.743193368E-02, -0.129018202E+00, -0.371033446E-02 }, 
    {    -135.0000,     -30.0000, -0.248703000E+01, -0.431341336E-01, -0.150698325E+00,  0.104346533E-02 }, 
    {    -120.0000,     -30.0000, -0.256054000E+01,  0.107384680E-01, -0.111947074E+00,  0.295069868E-02 }, 
    {    -105.0000,     -30.0000, -0.246215000E+01,  0.515626167E-02, -0.797335173E-01,  0.134670140E-02 }, 
    {     -90.0000,     -30.0000, -0.237111000E+01,  0.652248535E-02, -0.668318908E-01,  0.685532429E-03 }, 
    {     -75.0000,     -30.0000, -0.219037000E+01,  0.231097969E-01, -0.516702898E-01,  0.152381436E-02 }, 
    {     -60.0000,     -30.0000, -0.162432000E+01,  0.503963269E-01, -0.290408622E-01,  0.777415847E-03 }, 
    {     -45.0000,     -30.0000, -0.723700000E+00,  0.686388956E-01, -0.300526715E-01, -0.309954080E-03 }, 
    {     -30.0000,     -30.0000,  0.358950000E+00,  0.717020908E-01, -0.332230854E-01, -0.374044181E-03 }, 
    {     -15.0000,     -30.0000,  0.135947000E+01,  0.611867411E-01, -0.382954772E-01,  0.157569657E-03 }, 
    {       0.0000,     -30.0000,  0.212358000E+01,  0.364769446E-01, -0.327532534E-01, -0.162268031E-03 }, 
    {      15.0000,     -30.0000,  0.236496000E+01, -0.599651957E-02, -0.465229874E-01, -0.115399956E-02 }, 
    {      30.0000,     -30.0000,  0.196636000E+01, -0.439348663E-01, -0.628056114E-01, -0.123220533E-02 }, 
    {      45.0000,     -30.0000,  0.105275000E+01, -0.807060151E-01, -0.829802963E-01, -0.120864092E-02 }, 
    {      60.0000,     -30.0000, -0.261830000E+00, -0.788790731E-01, -0.947488975E-01, -0.321888209E-03 }, 
    {      75.0000,     -30.0000, -0.116368000E+01, -0.470636924E-01, -0.892203921E-01,  0.124817459E-02 }, 
    {      90.0000,     -30.0000, -0.165442000E+01, -0.113841571E-01, -0.685557019E-01,  0.567828949E-03 }, 
    {     105.0000,     -30.0000, -0.164196000E+01, -0.305567900E-02, -0.778543861E-01, -0.124628919E-02 }, 
    {     120.0000,     -30.0000, -0.186484000E+01, -0.184771269E-01, -0.937321578E-01, -0.617963377E-03 }, 
    {     135.0000,     -30.0000, -0.209366000E+01, -0.133758135E-01, -0.980246698E-01, -0.315914046E-03 }, 
    {     150.0000,     -30.0000, -0.228268000E+01, -0.115876190E-01, -0.103917688E+00, -0.155486436E-03 }, 
    {     165.0000,     -30.0000, -0.241932000E+01, -0.540571037E-02, -0.108073998E+00, -0.107200587E-02 }, 
    {     180.0000,     -30.0000, -0.246944000E+01, -0.414153948E-02, -0.118171667E+00,  0.159271411E-02 }, 
    {    -180.0000,     -15.0000, -0.382546000E+01,  0.334050611E-01, -0.384800833E-01,  0.735894346E-03 }, 
    {    -165.0000,     -15.0000, -0.322967000E+01, -0.490258072E-02, -0.748062857E-01, -0.383220665E-02 }, 
    {    -150.0000,     -15.0000, -0.393518000E+01, -0.357387382E-01, -0.102785774E+00,  0.173179413E-02 }, 
    {    -135.0000,     -15.0000, -0.385949000E+01,  0.218935336E-01, -0.437519964E-01,  0.311588796E-02 }, 
    {    -120.0000,     -15.0000, -0.358321000E+01,  0.185586037E-01, -0.323681079E-01, -0.111812799E-03 }, 
    {    -105.0000,     -15.0000, -0.328549000E+01,  0.186720515E-01, -0.279030289E-01,  0.501156736E-03 }, 
    {     -90.0000,     -15.0000, -0.301617000E+01,  0.201611903E-01, -0.184855599E-01,  0.883695458E-03 }, 
    {     -75.0000,     -15.0000, -0.260005000E+01,  0.377711874E-01, -0.833971552E-02, -0.123275884E-03 }, 
    {     -60.0000,     -15.0000, -0.192147000E+01,  0.476940600E-01, -0.190553922E-01, -0.504558393E-03 }, 
    {     -45.0000,     -15.0000, -0.114234000E+01,  0.629945725E-01, -0.144217349E-01,  0.925105588E-03 }, 
    {     -30.0000,     -15.0000, -0.873000000E-02,  0.828756499E-01,  0.932535297E-03,  0.801721548E-03 }, 
    {     -15.0000,     -15.0000,  0.114445000E+01,  0.628608278E-01,  0.350256257E-02, -0.547132294E-03 }, 
    {       0.0000,     -15.0000,  0.177335000E+01,  0.220970389E-01, -0.130481867E-01, -0.140933676E-02 }, 
    {      15.0000,     -15.0000,  0.179047000E+01, -0.220449834E-01, -0.331582158E-01, -0.114767633E-02 }, 
    {      30.0000,     -15.0000,  0.109507000E+01, -0.695731054E-01, -0.509601326E-01, -0.158234709E-02 }, 
    {      45.0000,     -15.0000, -0.162970000E+00, -0.903505952E-01, -0.734525232E-01, -0.581796781E-03 }, 
    {      60.0000,     -15.0000, -0.143516000E+01, -0.750705140E-01, -0.642436679E-01,  0.125282716E-02 }, 
    {      75.0000,     -15.0000, -0.226699000E+01, -0.301713489E-01, -0.467631145E-01,  0.908369881E-03 }, 
    {      90.0000,     -15.0000, -0.245933000E+01, -0.907809027E-02, -0.430370427E-01, -0.644981645E-03 }, 
    {     105.0000,     -15.0000, -0.270542000E+01, -0.212022900E-01, -0.587344944E-01, -0.722719292E-03 }, 
    {     120.0000,     -15.0000, -0.303929000E+01, -0.221047498E-01, -0.617860844E-01, -0.213949533E-03 }, 
    {     135.0000,     -15.0000, -0.335545000E+01, -0.203847110E-01, -0.668787549E-01, -0.503346795E-04 }, 
    {     150.0000,     -15.0000, -0.362364000E+01, -0.132264063E-01, -0.685572578E-01, -0.938946424E-03 }, 
    {     165.0000,     -15.0000, -0.379758000E+01, -0.151356637E-01, -0.781362481E-01,  0.155462174E-02 }, 
    {     180.0000,     -15.0000, -0.382546000E+01,  0.334050611E-01, -0.384800833E-01,  0.735894346E-03 }, 
    {    -180.0000,       0.0000, -0.382990000E+01,  0.179354324E-07, -0.325260652E-18, -0.370798001E-02 }, 
    {    -165.0000,       0.0000, -0.437645000E+01, -0.282088485E-01, -0.292305035E-01,  0.157080491E-02 }, 
    {    -150.0000,       0.0000, -0.429456000E+01,  0.199033760E-01,  0.241272974E-01,  0.225021986E-02 }, 
    {    -135.0000,       0.0000, -0.401846000E+01,  0.201933445E-01,  0.194203104E-01, -0.841521567E-03 }, 
    {    -120.0000,       0.0000, -0.366843000E+01,  0.245492462E-01,  0.198415061E-01,  0.258708148E-03 }, 
    {    -105.0000,       0.0000, -0.331240000E+01,  0.228216709E-01,  0.212956330E-01,  0.181753501E-03 }, 
    {     -90.0000,       0.0000, -0.296646000E+01,  0.245580701E-01,  0.217041303E-01, -0.613197300E-03 }, 
    {     -75.0000,       0.0000, -0.258028000E+01,  0.253700485E-01,  0.704715191E-02, -0.578660521E-03 }, 
    {     -60.0000,       0.0000, -0.208554000E+01,  0.501457359E-01,  0.130184311E-01,  0.119069953E-02 }, 
    {     -45.0000,       0.0000, -0.990500000E+00,  0.920030079E-01,  0.343796109E-01,  0.128235419E-02 }, 
    {     -30.0000,       0.0000,  0.422610000E+00,  0.834722326E-01,  0.422249443E-01, -0.478813653E-03 }, 
    {     -15.0000,       0.0000,  0.135374000E+01,  0.429560617E-01,  0.231392270E-01, -0.161517637E-02 }, 
    {       0.0000,       0.0000,  0.169885000E+01, -0.484794739E-04, -0.867361738E-18, -0.150546973E-02 }, 
    {      15.0000,       0.0000,  0.135374000E+01, -0.427621438E-01, -0.230881493E-01, -0.160841995E-02 }, 
    {      30.0000,       0.0000,  0.422610000E+00, -0.841509452E-01, -0.421038582E-01, -0.481622097E-03 }, 
    {      45.0000,       0.0000, -0.100310000E+01, -0.920020752E-01, -0.343796109E-01,  0.127661603E-02 }, 
    {      60.0000,       0.0000, -0.208554000E+01, -0.494707538E-01, -0.130184311E-01,  0.119224342E-02 }, 
    {      75.0000,       0.0000, -0.258028000E+01, -0.255509094E-01, -0.704714998E-02, -0.579097509E-03 }, 
    {      90.0000,       0.0000, -0.296646000E+01, -0.245096086E-01, -0.217041275E-01, -0.612992662E-03 }, 
    {     105.0000,       0.0000, -0.331240000E+01, -0.228346562E-01, -0.212956362E-01,  0.181370921E-03 }, 
    {     120.0000,       0.0000, -0.366843000E+01, -0.245457667E-01, -0.198415046E-01,  0.260033547E-03 }, 
    {     135.0000,       0.0000, -0.401846000E+01, -0.201942771E-01, -0.194203104E-01, -0.846439951E-03 }, 
    {     150.0000,       0.0000, -0.429456000E+01, -0.199031249E-01, -0.242292811E-01,  0.224817096E-02 }, 
    {     165.0000,       0.0000, -0.437645000E+01,  0.282087767E-01,  0.291929906E-01,  0.157641632E-02 }, 
    {     180.0000,       0.0000, -0.382990000E+01,  0.179354324E-07, -0.325260652E-18, -0.370798001E-02 }, 
    {    -180.0000,      15.0000, -0.382546000E+01, -0.333675482E-01,  0.384800833E-01,  0.741503838E-03 }, 
    {    -165.0000,      15.0000, -0.379758000E+01,  0.151256121E-01,  0.781462997E-01,  0.155462559E-02 }, 
    {    -150.0000,      15.0000, -0.362364000E+01,  0.132290996E-01,  0.685845842E-01, -0.939105993E-03 }, 
    {    -135.0000,      15.0000, -0.335545000E+01,  0.203839893E-01,  0.668787549E-01, -0.517105566E-04 }, 
    {    -120.0000,      15.0000, -0.303929000E+01,  0.221049431E-01,  0.617860836E-01, -0.213751912E-03 }, 
    {    -105.0000,      15.0000, -0.270542000E+01,  0.212022382E-01,  0.587344969E-01, -0.722133405E-03 }, 
    {     -90.0000,      15.0000, -0.245933000E+01,  0.907810415E-02,  0.430370385E-01, -0.647523482E-03 }, 
    {     -75.0000,      15.0000, -0.226699000E+01,  0.301713452E-01,  0.467631079E-01,  0.917949526E-03 }, 
    {     -60.0000,      15.0000, -0.143516000E+01,  0.750705150E-01,  0.642436679E-01,  0.121705125E-02 }, 
    {     -45.0000,      15.0000, -0.162970000E+00,  0.903505949E-01,  0.727772912E-01, -0.583317863E-03 }, 
    {     -30.0000,      15.0000,  0.109507000E+01,  0.695731054E-01,  0.509276877E-01, -0.154697583E-02 }, 
    {     -15.0000,      15.0000,  0.179047000E+01,  0.220449834E-01,  0.331445296E-01, -0.115533113E-02 }, 
    {       0.0000,      15.0000,  0.177335000E+01, -0.220970390E-01,  0.130481867E-01, -0.140759987E-02 }, 
    {      15.0000,      15.0000,  0.114445000E+01, -0.628608275E-01, -0.369318682E-02, -0.581812683E-03 }, 
    {      30.0000,      15.0000, -0.873000000E-02, -0.828756509E-01, -0.138443453E-02,  0.848326365E-03 }, 
    {      45.0000,      15.0000, -0.114234000E+01, -0.629945688E-01,  0.150969668E-01,  0.946537950E-03 }, 
    {      60.0000,      15.0000, -0.192147000E+01, -0.476940739E-01,  0.190553922E-01, -0.546512814E-03 }, 
    {      75.0000,      15.0000, -0.260005000E+01, -0.377711356E-01,  0.833971438E-02, -0.111937182E-03 }, 
    {      90.0000,      15.0000, -0.301617000E+01, -0.201613836E-01,  0.184855526E-01,  0.880293620E-03 }, 
    {     105.0000,      15.0000, -0.328549000E+01, -0.186713298E-01,  0.279030391E-01,  0.503427640E-03 }, 
    {     120.0000,      15.0000, -0.358321000E+01, -0.185612970E-01,  0.323681030E-01, -0.117494107E-03 }, 
    {     135.0000,      15.0000, -0.385949000E+01, -0.218834821E-01,  0.437519964E-01,  0.313634026E-02 }, 
    {     150.0000,      15.0000, -0.393518000E+01,  0.357012253E-01,  0.103166382E+00,  0.173178893E-02 }, 
    {     165.0000,      15.0000, -0.323037000E+01,  0.490258072E-02,  0.748062857E-01, -0.385263815E-02 }, 
    {     180.0000,      15.0000, -0.382546000E+01, -0.333675482E-01,  0.384800833E-01,  0.741503838E-03 }, 
    {    -180.0000,      30.0000, -0.246944000E+01,  0.424348770E-02,  0.118171667E+00,  0.159065861E-02 }, 
    {    -165.0000,      30.0000, -0.241932000E+01,  0.537839337E-02,  0.108071305E+00, -0.107185888E-02 }, 
    {    -150.0000,      30.0000, -0.228268000E+01,  0.115949388E-01,  0.103910366E+00, -0.155483326E-03 }, 
    {    -135.0000,      30.0000, -0.209366000E+01,  0.133738514E-01,  0.980246698E-01, -0.315534819E-03 }, 
    {    -120.0000,      30.0000, -0.186484000E+01,  0.184776556E-01,  0.937321596E-01, -0.618018613E-03 }, 
    {    -105.0000,      30.0000, -0.164196000E+01,  0.305552622E-02,  0.778543794E-01, -0.124644882E-02 }, 
    {     -90.0000,      30.0000, -0.165442000E+01,  0.113842395E-01,  0.685557157E-01,  0.568525100E-03 }, 
    {     -75.0000,      30.0000, -0.116368000E+01,  0.470635157E-01,  0.892204166E-01,  0.124555587E-02 }, 
    {     -60.0000,      30.0000, -0.261830000E+00,  0.788796976E-01,  0.947488975E-01, -0.312112213E-03 }, 
    {     -45.0000,      30.0000,  0.105275000E+01,  0.807036940E-01,  0.831612242E-01, -0.120894551E-02 }, 
    {     -30.0000,      30.0000,  0.196636000E+01,  0.439435263E-01,  0.628143050E-01, -0.123902426E-02 }, 
    {     -15.0000,      30.0000,  0.236496000E+01,  0.596420060E-02,  0.465266546E-01, -0.116187135E-02 }, 
    {       0.0000,      30.0000,  0.212358000E+01, -0.363563287E-01,  0.327532534E-01, -0.125700637E-03 }, 
    {      15.0000,      30.0000,  0.135947000E+01, -0.616368857E-01,  0.390068966E-01,  0.160722314E-03 }, 
    {      30.0000,      30.0000,  0.350550000E+00, -0.717021286E-01,  0.332295963E-01, -0.421920028E-03 }, 
    {      45.0000,      30.0000, -0.723700000E+00, -0.681886001E-01,  0.298717436E-01, -0.300072803E-03 }, 
    {      60.0000,      30.0000, -0.162432000E+01, -0.505174710E-01,  0.290408622E-01,  0.784464411E-03 }, 
    {      75.0000,      30.0000, -0.219037000E+01, -0.230755160E-01,  0.516702924E-01,  0.152192492E-02 }, 
    {      90.0000,      30.0000, -0.237111000E+01, -0.653846515E-02,  0.668319170E-01,  0.686046874E-03 }, 
    {     105.0000,      30.0000, -0.246215000E+01, -0.512662342E-02,  0.797334799E-01,  0.134652507E-02 }, 
    {     120.0000,      30.0000, -0.256054000E+01, -0.108410412E-01,  0.111947093E+00,  0.295088799E-02 }, 
    {     135.0000,      30.0000, -0.248703000E+01,  0.435147880E-01,  0.150698325E+00,  0.104289193E-02 }, 
    {     150.0000,      30.0000, -0.170729000E+01,  0.743188904E-02,  0.129017752E+00, -0.370832390E-02 }, 
    {     165.0000,      30.0000, -0.232595000E+01, -0.410263442E-01,  0.816818666E-01, -0.128879225E-04 }, 
    {     180.0000,      30.0000, -0.246944000E+01,  0.424348770E-02,  0.118171667E+00,  0.159065861E-02 }, 
    {    -180.0000,      45.0000, -0.672750000E+00, -0.319066402E-02,  0.119375249E+00, -0.106876145E-02 }, 
    {    -165.0000,      45.0000, -0.678300000E+00,  0.117642180E-03,  0.113424481E+00, -0.268784064E-03 }, 
    {    -150.0000,      45.0000, -0.670780000E+00,  0.311409531E-02,  0.106345953E+00, -0.461961571E-03 }, 
    {    -135.0000,      45.0000, -0.552320000E+00,  0.126219766E-01,  0.101648566E+00, -0.238552711E-03 }, 
    {    -120.0000,      45.0000, -0.386650000E+00,  0.322399830E-02,  0.938132779E-01, -0.109036260E-02 }, 
    {    -105.0000,      45.0000, -0.464600000E+00, -0.797396980E-02,  0.780119856E-01, -0.127312912E-03 }, 
    {     -90.0000,      45.0000, -0.422370000E+00,  0.215278809E-01,  0.901320988E-01,  0.863378433E-03 }, 
    {     -75.0000,      45.0000,  0.207200000E+00,  0.562224462E-01,  0.911932257E-01, -0.689952802E-03 }, 
    {     -60.0000,      45.0000,  0.116243000E+01,  0.705423343E-01,  0.762787422E-01, -0.874238535E-03 }, 
    {     -45.0000,      45.0000,  0.219151000E+01,  0.584702166E-01,  0.654738121E-01, -0.956975775E-03 }, 
    {     -30.0000,      45.0000,  0.285045000E+01,  0.331807993E-01,  0.488910924E-01, -0.775388327E-03 }, 
    {     -15.0000,      45.0000,  0.313379000E+01, -0.273741392E-02,  0.494128521E-01,  0.846337086E-03 }, 
    {       0.0000,      45.0000,  0.278505000E+01, -0.353111437E-01,  0.582787999E-01, -0.732418525E-03 }, 
    {      15.0000,      45.0000,  0.206071000E+01, -0.706340114E-01,  0.309176003E-01, -0.161571335E-02 }, 
    {      30.0000,      45.0000,  0.776340000E+00, -0.838948107E-01,  0.254800492E-01,  0.635521791E-03 }, 
    {      45.0000,      45.0000, -0.245760000E+00, -0.550807458E-01,  0.447320586E-01,  0.183651786E-02 }, 
    {      60.0000,      45.0000, -0.878440000E+00, -0.267382060E-01,  0.733871591E-01,  0.159982875E-02 }, 
    {      75.0000,      45.0000, -0.106430000E+01, -0.167443020E-02,  0.921291158E-01,  0.124357858E-02 }, 
    {      90.0000,      45.0000, -0.995380000E+00,  0.100479268E-01,  0.118344779E+00,  0.241738097E-02 }, 
    {     105.0000,      45.0000, -0.809220000E+00,  0.124987230E-01,  0.148417041E+00,  0.344482652E-03 }, 
    {     120.0000,      45.0000, -0.514700000E+00,  0.360931811E-01,  0.133545526E+00, -0.755162216E-03 }, 
    {     135.0000,      45.0000, -0.110600000E-01,  0.276055264E-02,  0.123140705E+00, -0.237910104E-02 }, 
    {     150.0000,      45.0000, -0.422000000E+00, -0.285953916E-01,  0.833986107E-01,  0.242183284E-03 }, 
    {     165.0000,      45.0000, -0.592120000E+00, -0.459098608E-02,  0.126116248E+00,  0.200547648E-02 }, 
    {     180.0000,      45.0000, -0.672750000E+00, -0.319066402E-02,  0.119375249E+00, -0.106876145E-02 }, 
    {    -180.0000,      60.0000,  0.941330000E+00, -0.118186959E-01,  0.864813358E-01, -0.528049530E-03 }, 
    {    -165.0000,      60.0000,  0.785810000E+00, -0.671691445E-02,  0.792567711E-01, -0.272066428E-03 }, 
    {    -150.0000,      60.0000,  0.753670000E+00,  0.115435368E-02,  0.779758225E-01, -0.847874161E-04 }, 
    {    -135.0000,      60.0000,  0.793510000E+00,  0.363949971E-02,  0.728150673E-01, -0.677124676E-03 }, 
    {    -120.0000,      60.0000,  0.779350000E+00, -0.105763525E-01,  0.598527289E-01, -0.831332603E-03 }, 
    {    -105.0000,      60.0000,  0.577690000E+00, -0.449808959E-02,  0.540276783E-01,  0.244977304E-03 }, 
    {     -90.0000,      60.0000,  0.792500000E+00,  0.311987109E-01,  0.602998892E-01, -0.591445554E-04 }, 
    {     -75.0000,      60.0000,  0.136042000E+01,  0.362492460E-01,  0.508266807E-01, -0.648598607E-03 }, 
    {     -60.0000,      60.0000,  0.194715000E+01,  0.547343051E-01,  0.419321336E-01, -0.102001214E-02 }, 
    {     -45.0000,      60.0000,  0.289718000E+01,  0.521655336E-01,  0.238295275E-01, -0.670783470E-03 }, 
    {     -30.0000,      60.0000,  0.340120000E+01,  0.274135603E-01,  0.285893253E-01,  0.103458437E-02 }, 
    {     -15.0000,      60.0000,  0.378367000E+01,  0.154782250E-01,  0.395639370E-01, -0.320672099E-03 }, 
    {       0.0000,      60.0000,  0.354214000E+01, -0.611384605E-01,  0.178435471E-01, -0.190105162E-02 }, 
    {      15.0000,      60.0000,  0.219742000E+01, -0.881743830E-01,  0.491270224E-02,  0.994631622E-03 }, 
    {      30.0000,      60.0000,  0.124745000E+01, -0.451020075E-01,  0.442302068E-01,  0.319985707E-02 }, 
    {      45.0000,      60.0000,  0.745720000E+00, -0.217575869E-01,  0.850840218E-01,  0.224020402E-02 }, 
    {      60.0000,      60.0000,  0.565770000E+00, -0.420364491E-02,  0.115428502E+00,  0.207898581E-02 }, 
    {      75.0000,      60.0000,  0.575620000E+00,  0.455216651E-02,  0.133011244E+00, -0.970702764E-03 }, 
    {      90.0000,      60.0000,  0.796280000E+00,  0.320969788E-01,  0.932669656E-01, -0.262848195E-02 }, 
    {     105.0000,      60.0000,  0.125994000E+01,  0.392391810E-02,  0.710163545E-01, -0.914347376E-03 }, 
    {     120.0000,      60.0000,  0.944110000E+00, -0.182266512E-01,  0.548008026E-01, -0.140736114E-02 }, 
    {     135.0000,      60.0000,  0.962110000E+00,  0.941668687E-02,  0.465668549E-01,  0.165389201E-02 }, 
    {     150.0000,      60.0000,  0.106365000E+01,  0.446790378E-02,  0.915758056E-01,  0.214679372E-02 }, 
    {     165.0000,      60.0000,  0.107716000E+01, -0.427830197E-02,  0.944751415E-01, -0.659409537E-03 }, 
    {     180.0000,      60.0000,  0.941330000E+00, -0.118186959E-01,  0.864813358E-01, -0.528049530E-03 }, 
    {    -180.0000,      75.0000,  0.180621000E+01, -0.179152915E-01,  0.304914073E-01,  0.236034070E-03 }, 
    {    -165.0000,      75.0000,  0.164225000E+01, -0.530303019E-02,  0.336584345E-01,  0.272915304E-03 }, 
    {    -150.0000,      75.0000,  0.159747000E+01, -0.262058772E-02,  0.354007569E-01, -0.345825371E-03 }, 
    {    -135.0000,      75.0000,  0.153314000E+01, -0.603661891E-02,  0.241831652E-01, -0.784667687E-03 }, 
    {    -120.0000,      75.0000,  0.136656000E+01, -0.194149366E-01,  0.174178065E-01, -0.112093968E-03 }, 
    {    -105.0000,      75.0000,  0.109103000E+01, -0.472563462E-02,  0.170033011E-01, -0.202929268E-03 }, 
    {     -90.0000,      75.0000,  0.127852000E+01,  0.207094751E-01,  0.884634444E-02, -0.790481374E-03 }, 
    {     -75.0000,      75.0000,  0.166472000E+01,  0.366257343E-01, -0.299594853E-02, -0.634995160E-03 }, 
    {     -60.0000,      75.0000,  0.231976000E+01,  0.410355879E-01, -0.125412766E-01, -0.947062185E-03 }, 
    {     -45.0000,      75.0000,  0.286443000E+01,  0.391739143E-01, -0.262079221E-01, -0.219150812E-03 }, 
    {     -30.0000,      75.0000,  0.357523000E+01,  0.533627551E-01, -0.182923937E-01,  0.673442010E-03 }, 
    {     -15.0000,      75.0000,  0.406613000E+01, -0.122849347E-01, -0.212006002E-01, -0.147315285E-02 }, 
    {       0.0000,      75.0000,  0.324329000E+01, -0.706110162E-01, -0.380049882E-01,  0.127665051E-02 }, 
    {      15.0000,      75.0000,  0.240295000E+01, -0.379070006E-01,  0.178795908E-01,  0.418258903E-02 }, 
    {      30.0000,      75.0000,  0.213049000E+01, -0.320981507E-03,  0.684291238E-01,  0.327981578E-02 }, 
    {      45.0000,      75.0000,  0.221268000E+01,  0.113692661E-02,  0.106619854E+00,  0.446200540E-03 }, 
    {      60.0000,      75.0000,  0.217320000E+01,  0.431527508E-02,  0.752268346E-01, -0.370507576E-02 }, 
    {      75.0000,      75.0000,  0.216375000E+01, -0.281840269E-01,  0.214359073E-01, -0.266268687E-02 }, 
    {      90.0000,      75.0000,  0.143311000E+01, -0.395971674E-01, -0.571464167E-02, -0.183247201E-02 }, 
    {     105.0000,      75.0000,  0.122509000E+01, -0.115930349E-02, -0.256204595E-01,  0.581301545E-03 }, 
    {     120.0000,      75.0000,  0.129208000E+01,  0.160283814E-01,  0.860726336E-02,  0.237164683E-02 }, 
    {     135.0000,      75.0000,  0.168691000E+01,  0.294097781E-01,  0.301858754E-01,  0.109337810E-02 }, 
    {     150.0000,      75.0000,  0.203556000E+01,  0.150285064E-01,  0.418101668E-01, -0.104578533E-03 }, 
    {     165.0000,      75.0000,  0.208080000E+01, -0.107458037E-01,  0.305671859E-01, -0.598801855E-03 }, 
    {     180.0000,      75.0000,  0.180621000E+01, -0.179152915E-01,  0.304914073E-01,  0.236034070E-03 }, 
    {    -180.0000,      90.0000,  0.190401000E+01, -0.543857760E-02, -0.159109652E-01,  0.859936910E-03 }, 
    {    -165.0000,      90.0000,  0.182118000E+01, -0.156164601E-02, -0.681650924E-02,  0.211458900E-03 }, 
    {    -150.0000,      90.0000,  0.181755000E+01, -0.560683837E-02, -0.680285022E-02,  0.115850488E-03 }, 
    {    -135.0000,      90.0000,  0.162671000E+01, -0.149050005E-01, -0.290772809E-02,  0.106895379E-03 }, 
    {    -120.0000,      90.0000,  0.141199000E+01, -0.158851596E-01, -0.299595489E-02,  0.217947063E-03 }, 
    {    -105.0000,      90.0000,  0.117449000E+01, -0.119983611E-01, -0.268088265E-02, -0.933314543E-03 }, 
    {     -90.0000,      90.0000,  0.113012000E+01,  0.750460415E-02, -0.281612669E-01, -0.151775130E-02 }, 
    {     -75.0000,      90.0000,  0.133310000E+01,  0.137019446E-01, -0.443068866E-01, -0.132088104E-02 }, 
    {     -60.0000,      90.0000,  0.157482000E+01,  0.266276176E-01, -0.662330273E-01, -0.813076607E-03 }, 
    {     -45.0000,      90.0000,  0.215793000E+01,  0.447535849E-01, -0.668478391E-01,  0.649969627E-04 }, 
    {     -30.0000,      90.0000,  0.279428000E+01,  0.382500429E-01, -0.768037506E-01, -0.156105590E-02 }, 
    {     -15.0000,      90.0000,  0.309474000E+01, -0.103917564E-01, -0.925475362E-01,  0.103928723E-02 }, 
    {       0.0000,      90.0000,  0.265047000E+01, -0.254450173E-01, -0.441575944E-01,  0.393313825E-02 }, 
    {      15.0000,      90.0000,  0.262493000E+01,  0.182098255E-01,  0.907093473E-02,  0.355185397E-02 }, 
    {      30.0000,      90.0000,  0.309673000E+01,  0.418577153E-01,  0.519092982E-01,  0.107282438E-02 }, 
    {      45.0000,      90.0000,  0.345522000E+01, -0.195826867E-01,  0.303365616E-01, -0.359002614E-02 }, 
    {      60.0000,      90.0000,  0.245075000E+01, -0.927229686E-01, -0.393398402E-01, -0.496254751E-02 }, 
    {      75.0000,      90.0000,  0.123397000E+01, -0.537754389E-01, -0.870848733E-01, -0.440708128E-04 }, 
    {      90.0000,      90.0000,  0.905620000E+00, -0.120127594E-02, -0.485403989E-01,  0.329871901E-02 }, 
    {     105.0000,      90.0000,  0.102391000E+01,  0.165685426E-01, -0.157405166E-01,  0.111806610E-02 }, 
    {     120.0000,      90.0000,  0.135280000E+01,  0.243631054E-01, -0.749185607E-02,  0.438725150E-03 }, 
    {     135.0000,      90.0000,  0.179055000E+01,  0.393070356E-01, -0.162235629E-02, -0.493346347E-04 }, 
    {     150.0000,      90.0000,  0.229924000E+01,  0.769675199E-02, -0.116984727E-01, -0.108270994E-02 }, 
    {     165.0000,      90.0000,  0.203939000E+01, -0.203260436E-01, -0.242978851E-01, -0.154931367E-03 }, 
    {     180.0000,      90.0000,  0.190401000E+01, -0.543857760E-02, -0.159109652E-01,  0.859936910E-03 }, 
    {    -180.0000,     105.0000,  0.142827000E+01,  0.380536841E-02, -0.424355465E-01,  0.668350277E-03 }, 
    {    -165.0000,     105.0000,  0.153133000E+01,  0.320048837E-02, -0.285763976E-01,  0.581952807E-03 }, 
    {    -150.0000,     105.0000,  0.150886000E+01, -0.489321899E-03, -0.259113560E-01,  0.308676584E-03 }, 
    {    -135.0000,     105.0000,  0.151499000E+01, -0.451120078E-02, -0.161822529E-01,  0.662169799E-03 }, 
    {    -120.0000,     105.0000,  0.133189000E+01, -0.168598750E-01, -0.123679869E-01, -0.248681960E-03 }, 
    {    -105.0000,     105.0000,  0.102077000E+01, -0.268932992E-01, -0.203317705E-01, -0.497345483E-03 }, 
    {     -90.0000,     105.0000,  0.604700000E+00, -0.210049280E-01, -0.309652767E-01, -0.148139405E-02 }, 
    {     -75.0000,     105.0000,  0.460270000E+00, -0.118698860E-02, -0.606665052E-01, -0.164402524E-02 }, 
    {     -60.0000,     105.0000,  0.550650000E+00,  0.149428824E-01, -0.763486141E-01, -0.101917248E-02 }, 
    {     -45.0000,     105.0000,  0.924860000E+00,  0.343334589E-01, -0.943147214E-01, -0.100892811E-02 }, 
    {     -30.0000,     105.0000,  0.143567000E+01,  0.247272820E-01, -0.102404604E+00, -0.156313051E-03 }, 
    {     -15.0000,     105.0000,  0.165224000E+01,  0.122334133E-01, -0.913872552E-01,  0.221967356E-02 }, 
    {       0.0000,     105.0000,  0.195317000E+01,  0.298390649E-01, -0.433886343E-01,  0.308081273E-02 }, 
    {      15.0000,     105.0000,  0.265211000E+01,  0.683843270E-01, -0.433132968E-02,  0.286826061E-02 }, 
    {      30.0000,     105.0000,  0.358847000E+01,  0.236836270E-01,  0.155296835E-01, -0.277019160E-02 }, 
    {      45.0000,     105.0000,  0.298189000E+01, -0.971628351E-01, -0.741241004E-01, -0.574604834E-02 }, 
    {      60.0000,     105.0000,  0.122814000E+01, -0.107098287E+00, -0.106879474E+00,  0.127255346E-02 }, 
    {      75.0000,     105.0000,  0.208210000E+00, -0.291800187E-01, -0.642044140E-01,  0.263977177E-02 }, 
    {      90.0000,     105.0000,  0.200840000E+00,  0.183583614E-01, -0.465777628E-01,  0.228701707E-03 }, 
    {     105.0000,     105.0000,  0.564750000E+00,  0.270545732E-01, -0.434854741E-01,  0.589209395E-03 }, 
    {     120.0000,     105.0000,  0.103764000E+01,  0.407833458E-01, -0.295278391E-01,  0.824445454E-03 }, 
    {     135.0000,     105.0000,  0.164917000E+01,  0.266960437E-01, -0.312444502E-01, -0.143878644E-02 }, 
    {     150.0000,     105.0000,  0.172204000E+01, -0.106875204E-01, -0.577202759E-01, -0.707787074E-03 }, 
    {     165.0000,     105.0000,  0.150406000E+01, -0.129679620E-01, -0.487236455E-01,  0.774095670E-03 }, 
    {     180.0000,     105.0000,  0.142827000E+01,  0.380536841E-02, -0.424355465E-01,  0.668350277E-03 }, 
    {    -180.0000,     120.0000,  0.762820000E+00,  0.163742667E-01, -0.425848488E-01,  0.829230845E-03 }, 
    {    -165.0000,     120.0000,  0.105012000E+01,  0.148966725E-01, -0.330899005E-01,  0.752393579E-03 }, 
    {    -150.0000,     120.0000,  0.115910000E+01,  0.329504315E-02, -0.212417256E-01,  0.429819479E-03 }, 
    {    -135.0000,     120.0000,  0.116949000E+01, -0.420284513E-02, -0.238072605E-01, -0.615143498E-03 }, 
    {    -120.0000,     120.0000,  0.972890000E+00, -0.237256626E-01, -0.353520973E-01, -0.791319833E-03 }, 
    {    -105.0000,     120.0000,  0.545500000E+00, -0.256925043E-01, -0.417900354E-01,  0.183867845E-03 }, 
    {     -90.0000,     120.0000,  0.188030000E+00, -0.304763202E-01, -0.363956263E-01, -0.152857345E-03 }, 
    {     -75.0000,     120.0000, -0.357550000E+00, -0.330122151E-01, -0.511570928E-01, -0.144584994E-02 }, 
    {     -60.0000,     120.0000, -0.644870000E+00, -0.405481946E-02, -0.723105164E-01, -0.124672091E-02 }, 
    {     -45.0000,     120.0000, -0.497870000E+00,  0.211674929E-01, -0.870532753E-01, -0.746502917E-03 }, 
    {     -30.0000,     120.0000, -0.796400000E-01,  0.324308477E-01, -0.883618340E-01,  0.102246906E-02 }, 
    {     -15.0000,     120.0000,  0.511320000E+00,  0.509471163E-01, -0.585874432E-01,  0.234979309E-02 }, 
    {       0.0000,     120.0000,  0.140660000E+01,  0.610286871E-01, -0.310618683E-01,  0.103835171E-02 }, 
    {      15.0000,     120.0000,  0.247433000E+01,  0.975401352E-01, -0.218656160E-01,  0.841165530E-03 }, 
    {      30.0000,     120.0000,  0.349117000E+01, -0.342752278E-01, -0.351400321E-01, -0.521864658E-02 }, 
    {      45.0000,     120.0000,  0.142775000E+01, -0.169755224E+00, -0.139334160E+00, -0.346028800E-02 }, 
    {      60.0000,     120.0000, -0.446240000E+00, -0.741858758E-01, -0.112540264E+00,  0.357975222E-02 }, 
    {      75.0000,     120.0000, -0.870220000E+00,  0.690472738E-02, -0.769354706E-01,  0.162101699E-02 }, 
    {      90.0000,     120.0000, -0.558680000E+00,  0.240789663E-01, -0.580085500E-01,  0.842522608E-03 }, 
    {     105.0000,     120.0000, -0.175780000E+00,  0.356674074E-01, -0.502555872E-01,  0.344869276E-03 }, 
    {     120.0000,     120.0000,  0.467670000E+00,  0.385214041E-01, -0.514227876E-01, -0.904847238E-03 }, 
    {     135.0000,     120.0000,  0.803020000E+00,  0.600697629E-02, -0.709058430E-01, -0.855531490E-03 }, 
    {     150.0000,     120.0000,  0.735360000E+00, -0.901130923E-02, -0.701964236E-01,  0.572245991E-03 }, 
    {     165.0000,     120.0000,  0.650490000E+00, -0.467739370E-03, -0.585875330E-01,  0.103020953E-02 }, 
    {     180.0000,     120.0000,  0.762820000E+00,  0.163742667E-01, -0.425848488E-01,  0.829230845E-03 }, 
    {    -180.0000,     135.0000,  0.221370000E+00,  0.262012513E-01, -0.286050584E-01,  0.493902929E-03 }, 
    {    -165.0000,     135.0000,  0.599000000E+00,  0.213730772E-01, -0.255300005E-01,  0.429906467E-04 }, 
    {    -150.0000,     135.0000,  0.821760000E+00,  0.838443979E-02, -0.265417416E-01, -0.253202162E-03 }, 
    {    -135.0000,     135.0000,  0.789610000E+00, -0.167888364E-01, -0.336647051E-01, -0.657122929E-03 }, 
    {    -120.0000,     135.0000,  0.350590000E+00, -0.354630943E-01, -0.424836238E-01, -0.306682559E-03 }, 
    {    -105.0000,     135.0000, -0.143530000E+00, -0.279867866E-01, -0.453680878E-01, -0.456823362E-03 }, 
    {     -90.0000,     135.0000, -0.548820000E+00, -0.324717595E-01, -0.541562181E-01, -0.200542849E-03 }, 
    {     -75.0000,     135.0000, -0.111846000E+01, -0.371121756E-01, -0.504511236E-01,  0.242387587E-03 }, 
    {     -60.0000,     135.0000, -0.154005000E+01, -0.173255381E-01, -0.525493204E-01, -0.447627975E-03 }, 
    {     -45.0000,     135.0000, -0.157764000E+01,  0.145783280E-01, -0.579721772E-01,  0.439135867E-04 }, 
    {     -30.0000,     135.0000, -0.108446000E+01,  0.501302262E-01, -0.481740603E-01,  0.114702565E-02 }, 
    {     -15.0000,     135.0000, -0.134090000E+00,  0.736107672E-01, -0.315289720E-01,  0.656624863E-03 }, 
    {       0.0000,     135.0000,  0.101469000E+01,  0.752567051E-01, -0.200598924E-01,  0.184930847E-02 }, 
    {      15.0000,     135.0000,  0.208125000E+01,  0.684304125E-01, -0.223782063E-01, -0.622370562E-02 }, 
    {      30.0000,     135.0000,  0.215102000E+01, -0.121712355E+00, -0.162459555E+00, -0.543441851E-02 }, 
    {      45.0000,     135.0000, -0.873170000E+00, -0.172464992E+00, -0.139551260E+00,  0.452676899E-02 }, 
    {      60.0000,     135.0000, -0.199291000E+01, -0.172136775E-01, -0.871694706E-01,  0.238535946E-02 }, 
    {      75.0000,     135.0000, -0.197985000E+01,  0.199837020E-01, -0.656657034E-01,  0.708904414E-03 }, 
    {      90.0000,     135.0000, -0.148283000E+01,  0.392948697E-01, -0.581220373E-01,  0.588509529E-03 }, 
    {     105.0000,     135.0000, -0.914940000E+00,  0.358188192E-01, -0.514301773E-01, -0.215837299E-03 }, 
    {     120.0000,     135.0000, -0.453720000E+00,  0.232518535E-01, -0.630530105E-01, -0.711354965E-03 }, 
    {     135.0000,     135.0000, -0.251200000E+00,  0.392176690E-02, -0.652061779E-01,  0.306057047E-03 }, 
    {     150.0000,     135.0000, -0.250690000E+00,  0.166707891E-02, -0.560400295E-01,  0.889722976E-03 }, 
    {     165.0000,     135.0000, -0.115070000E+00,  0.166359174E-01, -0.407522227E-01,  0.102584208E-02 }, 
    {     180.0000,     135.0000,  0.221370000E+00,  0.262012513E-01, -0.286050584E-01,  0.493902929E-03 }, 
    {    -180.0000,     150.0000, -0.548700000E-01,  0.290601283E-01, -0.653291777E-02, -0.267670239E-03 }, 
    {    -165.0000,     150.0000,  0.300070000E+00,  0.154950266E-01, -0.148000976E-01, -0.804685346E-03 }, 
    {    -150.0000,     150.0000,  0.373940000E+00, -0.527823486E-02, -0.296233081E-01, -0.113166643E-02 }, 
    {    -135.0000,     150.0000,  0.157920000E+00, -0.228120872E-01, -0.438479190E-01, -0.478213201E-03 }, 
    {    -120.0000,     150.0000, -0.275020000E+00, -0.332654163E-01, -0.442954076E-01,  0.110099333E-03 }, 
    {    -105.0000,     150.0000, -0.796930000E+00, -0.350962475E-01, -0.452236135E-01, -0.237323034E-03 }, 
    {     -90.0000,     150.0000, -0.132072000E+01, -0.354895938E-01, -0.487295015E-01, -0.476259807E-04 }, 
    {     -75.0000,     150.0000, -0.185418000E+01, -0.343953775E-01, -0.463644127E-01,  0.199667112E-03 }, 
    {     -60.0000,     150.0000, -0.227657000E+01, -0.180988963E-01, -0.438322019E-01,  0.228417443E-03 }, 
    {     -45.0000,     150.0000, -0.228172000E+01,  0.212829627E-01, -0.378280157E-01,  0.593942522E-03 }, 
    {     -30.0000,     150.0000, -0.160792000E+01,  0.666970455E-01, -0.245979248E-01,  0.124266789E-02 }, 
    {     -15.0000,     150.0000, -0.475030000E+00,  0.732668553E-01, -0.125666689E-01, -0.512344737E-03 }, 
    {       0.0000,     150.0000,  0.681970000E+00,  0.982135332E-01, -0.336245620E-01, -0.998616383E-03 }, 
    {      15.0000,     150.0000,  0.160921000E+01, -0.492729882E-01, -0.616455588E-01, -0.530896770E-02 }, 
    {      30.0000,     150.0000, -0.655940000E+00, -0.168703581E+00, -0.144443748E+00,  0.706500770E-04 }, 
    {      45.0000,     150.0000, -0.236553000E+01, -0.708606897E-01, -0.611168011E-01,  0.513211893E-02 }, 
    {      60.0000,     150.0000, -0.295919000E+01, -0.850366059E-02, -0.413718538E-01,  0.152529711E-04 }, 
    {      75.0000,     150.0000, -0.273078000E+01,  0.318253321E-01, -0.325137156E-01,  0.527486298E-03 }, 
    {      90.0000,     150.0000, -0.217397000E+01,  0.382463322E-01, -0.325613007E-01, -0.363087539E-03 }, 
    {     105.0000,     150.0000, -0.165041000E+01,  0.312633390E-01, -0.389497036E-01, -0.362333756E-03 }, 
    {     120.0000,     150.0000, -0.125474000E+01,  0.205463117E-01, -0.408471704E-01,  0.155248622E-03 }, 
    {     135.0000,     150.0000, -0.102443000E+01,  0.117474142E-01, -0.337594456E-01,  0.779390888E-03 }, 
    {     150.0000,     150.0000, -0.834180000E+00,  0.165760314E-01, -0.195514583E-01,  0.986330237E-03 }, 
    {     165.0000,     150.0000, -0.496390000E+00,  0.275564601E-01, -0.777957622E-02,  0.471262029E-03 }, 
    {     180.0000,     150.0000, -0.548700000E-01,  0.290601283E-01, -0.653291777E-02, -0.267670239E-03 }, 
    {    -180.0000,     165.0000, -0.304300000E-01,  0.179657892E-01,  0.437672944E-02, -0.107031439E-02 }, 
    {    -165.0000,     165.0000,  0.101460000E+00, -0.217884100E-03, -0.147776092E-01, -0.114244153E-02 }, 
    {    -150.0000,     165.0000, -0.405500000E-01, -0.191182528E-01, -0.274270262E-01, -0.720670634E-03 }, 
    {    -135.0000,     165.0000, -0.441660000E+00, -0.319331045E-01, -0.371976189E-01, -0.458877893E-03 }, 
    {    -120.0000,     165.0000, -0.949890000E+00, -0.350173291E-01, -0.404307459E-01, -0.445617408E-04 }, 
    {    -105.0000,     165.0000, -0.147132000E+01, -0.339295791E-01, -0.392954582E-01,  0.217556996E-03 }, 
    {     -90.0000,     165.0000, -0.196898000E+01, -0.330823546E-01, -0.349577760E-01,  0.268927741E-03 }, 
    {     -75.0000,     165.0000, -0.245910000E+01, -0.312970025E-01, -0.322192255E-01,  0.121978586E-03 }, 
    {     -60.0000,     165.0000, -0.282977000E+01, -0.138876354E-01, -0.300658719E-01,  0.221538743E-03 }, 
    {     -45.0000,     165.0000, -0.272832000E+01,  0.330035440E-01, -0.208517600E-01,  0.126535954E-02 }, 
    {     -30.0000,     165.0000, -0.185441000E+01,  0.769454592E-01, -0.742424042E-02, -0.754650614E-03 }, 
    {     -15.0000,     165.0000, -0.593280000E+00,  0.862226190E-01, -0.100423523E-01,  0.391512446E-02 }, 
    {       0.0000,     165.0000,  0.475830000E+00,  0.442120646E-01,  0.467861405E-01, -0.406377104E-02 }, 
    {      15.0000,     165.0000,  0.286540000E+00, -0.871068774E-01, -0.899815585E-01, -0.364788156E-02 }, 
    {      30.0000,     165.0000, -0.166034000E+01, -0.123018555E+00, -0.220374546E-01,  0.489057827E-02 }, 
    {      45.0000,     165.0000, -0.285897000E+01, -0.499209032E-01, -0.131415358E-01, -0.546426966E-03 }, 
    {      60.0000,     165.0000, -0.327921000E+01, -0.107183243E-02, -0.460311419E-02,  0.781997672E-03 }, 
    {      75.0000,     165.0000, -0.296238000E+01,  0.335262329E-01, -0.785434241E-03, -0.110343413E-03 }, 
    {      90.0000,     165.0000, -0.244752000E+01,  0.333049008E-01, -0.457075991E-02, -0.334153164E-03 }, 
    {     105.0000,     165.0000, -0.199117000E+01,  0.274961640E-01, -0.801700813E-02,  0.641290148E-06 }, 
    {     120.0000,     165.0000, -0.160564000E+01,  0.250864431E-01, -0.394230792E-02,  0.457278400E-03 }, 
    {     135.0000,     165.0000, -0.122723000E+01,  0.249460637E-01,  0.503796008E-02,  0.781238752E-03 }, 
    {     150.0000,     165.0000, -0.842880000E+00,  0.276813023E-01,  0.158078629E-01,  0.367800754E-03 }, 
    {     165.0000,     165.0000, -0.402820000E+00,  0.292107271E-01,  0.143205276E-01, -0.395928263E-03 }, 
    {     180.0000,     165.0000, -0.304300000E-01,  0.179657892E-01,  0.437672944E-02, -0.107031439E-02 }, 
    {    -180.0000,     180.0000,  0.000000000E+00,  0.552257112E-05,  0.000000000E+00, -0.126199335E-02 }, 
    {    -165.0000,     180.0000, -0.159180000E+00, -0.166906548E-01, -0.179394657E-01, -0.106268484E-02 }, 
    {    -150.0000,     180.0000, -0.469240000E+00, -0.270909033E-01, -0.293045871E-01, -0.348184728E-03 }, 
    {    -135.0000,     180.0000, -0.948870000E+00, -0.328837318E-01, -0.287196052E-01,  0.299395850E-03 }, 
    {    -120.0000,     180.0000, -0.141919000E+01, -0.313641693E-01, -0.228156086E-01,  0.448397027E-03 }, 
    {    -105.0000,     180.0000, -0.189608000E+01, -0.311015908E-01, -0.174245535E-01,  0.166026389E-03 }, 
    {     -90.0000,     180.0000, -0.235024000E+01, -0.304394676E-01, -0.173433944E-01, -0.180597422E-04 }, 
    {     -75.0000,     180.0000, -0.281648000E+01, -0.312205390E-01, -0.172186852E-01, -0.526137649E-04 }, 
    {     -60.0000,     180.0000, -0.317758000E+01, -0.101463764E-01, -0.161063106E-01,  0.475931576E-03 }, 
    {     -45.0000,     180.0000, -0.291092000E+01,  0.529180444E-01, -0.460494424E-02,  0.671635664E-03 }, 
    {     -30.0000,     180.0000, -0.184916000E+01,  0.641581986E-01,  0.604688652E-02,  0.126816519E-02 }, 
    {     -15.0000,     180.0000, -0.618680000E+00,  0.148897161E+00,  0.240060782E-01, -0.220919394E-04 }, 
    {       0.0000,     180.0000,  0.144957000E+01, -0.843083945E-06, -0.138777878E-16, -0.238917474E-02 }, 
    {      15.0000,     180.0000, -0.618680000E+00, -0.148893789E+00, -0.240062071E-01, -0.236661683E-04 }, 
    {      30.0000,     180.0000, -0.184916000E+01, -0.641700018E-01, -0.605043409E-02,  0.127375259E-02 }, 
    {      45.0000,     180.0000, -0.291092000E+01, -0.528742041E-01,  0.460494424E-02,  0.650886067E-03 }, 
    {      60.0000,     180.0000, -0.317758000E+01,  0.998281807E-02,  0.161063106E-01,  0.554052075E-03 }, 
    {      75.0000,     180.0000, -0.281793000E+01,  0.315409318E-01,  0.182254525E-01, -0.142992706E-03 }, 
    {      90.0000,     180.0000, -0.234954000E+01,  0.294614547E-01,  0.157303403E-01, -0.572753043E-04 }, 
    {     105.0000,     180.0000, -0.191578000E+01,  0.310432493E-01,  0.179437362E-01,  0.315750647E-03 }, 
    {     120.0000,     180.0000, -0.141919000E+01,  0.324355481E-01,  0.237264021E-01,  0.393485071E-03 }, 
    {     135.0000,     180.0000, -0.948870000E+00,  0.325965581E-01,  0.287196052E-01,  0.265482885E-03 }, 
    {     150.0000,     180.0000, -0.469240000E+00,  0.271682193E-01,  0.293080068E-01, -0.339095672E-03 }, 
    {     165.0000,     180.0000, -0.159180000E+00,  0.166685645E-01,  0.179394658E-01, -0.106512808E-02 }, 
    {     180.0000,     180.0000,  0.000000000E+00,  0.552257112E-05,  0.000000000E+00, -0.126199335E-02 } },
{
{    -180.0000,    -180.0000,  0.000000000E+00,  0.552257112E-05,  0.000000000E+00, -0.126199335E-02 }, 
{    -165.0000,    -180.0000, -0.159180000E+00, -0.166906548E-01, -0.179394657E-01, -0.106268484E-02 }, 
{    -150.0000,    -180.0000, -0.469240000E+00, -0.270909033E-01, -0.293045871E-01, -0.348184728E-03 }, 
{    -135.0000,    -180.0000, -0.948870000E+00, -0.328837318E-01, -0.287196052E-01,  0.299395850E-03 }, 
{    -120.0000,    -180.0000, -0.141919000E+01, -0.313641693E-01, -0.228156086E-01,  0.448397027E-03 }, 
{    -105.0000,    -180.0000, -0.189608000E+01, -0.311015908E-01, -0.174245535E-01,  0.166026389E-03 }, 
{     -90.0000,    -180.0000, -0.235024000E+01, -0.304394676E-01, -0.173433944E-01, -0.180597422E-04 }, 
{     -75.0000,    -180.0000, -0.281648000E+01, -0.312205390E-01, -0.172186852E-01, -0.526137649E-04 }, 
{     -60.0000,    -180.0000, -0.317758000E+01, -0.101463764E-01, -0.161063106E-01,  0.475931576E-03 }, 
{     -45.0000,    -180.0000, -0.291092000E+01,  0.529180444E-01, -0.460494424E-02,  0.671635664E-03 }, 
{     -30.0000,    -180.0000, -0.184916000E+01,  0.641581986E-01,  0.604688652E-02,  0.126816519E-02 }, 
{     -15.0000,    -180.0000, -0.618680000E+00,  0.148897161E+00,  0.240060782E-01, -0.220919394E-04 }, 
{       0.0000,    -180.0000,  0.144957000E+01, -0.843083945E-06, -0.138777878E-16, -0.238917474E-02 }, 
{      15.0000,    -180.0000, -0.618680000E+00, -0.148893789E+00, -0.240062071E-01, -0.236661683E-04 }, 
{      30.0000,    -180.0000, -0.184916000E+01, -0.641700018E-01, -0.605043409E-02,  0.127375259E-02 }, 
{      45.0000,    -180.0000, -0.291092000E+01, -0.528742041E-01,  0.460494424E-02,  0.650886067E-03 }, 
{      60.0000,    -180.0000, -0.317758000E+01,  0.998281807E-02,  0.161063106E-01,  0.554052075E-03 }, 
{      75.0000,    -180.0000, -0.281793000E+01,  0.315409318E-01,  0.182254525E-01, -0.142992706E-03 }, 
{      90.0000,    -180.0000, -0.234954000E+01,  0.294614547E-01,  0.157303403E-01, -0.572753043E-04 }, 
{     105.0000,    -180.0000, -0.191578000E+01,  0.310432493E-01,  0.179437362E-01,  0.315750647E-03 }, 
{     120.0000,    -180.0000, -0.141919000E+01,  0.324355481E-01,  0.237264021E-01,  0.393485071E-03 }, 
{     135.0000,    -180.0000, -0.948870000E+00,  0.325965581E-01,  0.287196052E-01,  0.265482885E-03 }, 
{     150.0000,    -180.0000, -0.469240000E+00,  0.271682193E-01,  0.293080068E-01, -0.339095672E-03 }, 
{     165.0000,    -180.0000, -0.159180000E+00,  0.166685645E-01,  0.179394658E-01, -0.106512808E-02 }, 
{     180.0000,    -180.0000,  0.000000000E+00,  0.552257112E-05,  0.000000000E+00, -0.126199335E-02 }, 
{    -180.0000,    -165.0000, -0.304300000E-01, -0.179832760E-01, -0.437672944E-02, -0.107152527E-02 }, 
{    -165.0000,    -165.0000, -0.402820000E+00, -0.291497190E-01, -0.143205279E-01, -0.393186107E-03 }, 
{    -150.0000,    -165.0000, -0.842880000E+00, -0.279078479E-01, -0.158206253E-01,  0.355490531E-03 }, 
{    -135.0000,    -165.0000, -0.122723000E+01, -0.241008893E-01, -0.503796008E-02,  0.827737542E-03 }, 
{    -120.0000,    -165.0000, -0.158634000E+01, -0.243805950E-01,  0.440318053E-02,  0.378320458E-03 }, 
{    -105.0000,    -165.0000, -0.198317000E+01, -0.295647308E-01,  0.662367233E-02, -0.869289336E-05 }, 
{     -90.0000,    -165.0000, -0.246682000E+01, -0.334564819E-01,  0.476335381E-02, -0.271514228E-03 }, 
{     -75.0000,    -165.0000, -0.296238000E+01, -0.324513417E-01,  0.437966491E-03, -0.142391360E-03 }, 
{     -60.0000,    -165.0000, -0.327921000E+01,  0.783848567E-03,  0.460311419E-02,  0.809031745E-03 }, 
{     -45.0000,    -165.0000, -0.285897000E+01,  0.499979474E-01,  0.131415370E-01, -0.553021522E-03 }, 
{     -30.0000,    -165.0000, -0.166034000E+01,  0.122998362E+00,  0.220506944E-01,  0.489257038E-02 }, 
{     -15.0000,    -165.0000,  0.286540000E+00,  0.871106053E-01,  0.899820396E-01, -0.364915945E-02 }, 
{       0.0000,    -165.0000,  0.475830000E+00, -0.442067830E-01, -0.467861405E-01, -0.406329954E-02 }, 
{      15.0000,    -165.0000, -0.593280000E+00, -0.862474733E-01,  0.100423868E-01,  0.391442707E-02 }, 
{      30.0000,    -165.0000, -0.185441000E+01, -0.768513239E-01,  0.742519094E-02, -0.752142438E-03 }, 
{      45.0000,    -165.0000, -0.272832000E+01, -0.333552312E-01,  0.208517588E-01,  0.125601709E-02 }, 
{      60.0000,    -165.0000, -0.282977000E+01,  0.152002488E-01,  0.300658719E-01,  0.256210283E-03 }, 
{      75.0000,    -165.0000, -0.243750000E+01,  0.307182359E-01,  0.328596241E-01,  0.120714835E-03 }, 
{      90.0000,    -165.0000, -0.197978000E+01,  0.319248075E-01,  0.351973987E-01,  0.287235735E-03 }, 
{     105.0000,    -165.0000, -0.147132000E+01,  0.348185340E-01,  0.402120635E-01,  0.200830109E-03 }, 
{     120.0000,    -165.0000, -0.949890000E+00,  0.347790566E-01,  0.401866996E-01, -0.926959877E-04 }, 
{     135.0000,    -165.0000, -0.441660000E+00,  0.319972398E-01,  0.371976189E-01, -0.432935069E-03 }, 
{     150.0000,    -165.0000, -0.405500000E-01,  0.190999843E-01,  0.274261100E-01, -0.727681662E-03 }, 
{     165.0000,    -165.0000,  0.101460000E+00,  0.226822911E-03,  0.147776092E-01, -0.114034024E-02 }, 
{     180.0000,    -165.0000, -0.304300000E-01, -0.179832760E-01, -0.437672944E-02, -0.107152527E-02 }, 
{    -180.0000,    -150.0000, -0.548700000E-01, -0.290709431E-01,  0.653291777E-02, -0.267198730E-03 }, 
{    -165.0000,    -150.0000, -0.496390000E+00, -0.275168201E-01,  0.777957722E-02,  0.470196210E-03 }, 
{    -150.0000,    -150.0000, -0.834180000E+00, -0.167237766E-01,  0.195990881E-01,  0.999647962E-03 }, 
{    -135.0000,    -150.0000, -0.102443000E+01, -0.111960737E-01,  0.337594456E-01,  0.727185609E-03 }, 
{    -120.0000,    -150.0000, -0.124614000E+01, -0.208839287E-01,  0.398128865E-01,  0.134369277E-03 }, 
{    -105.0000,    -150.0000, -0.165671000E+01, -0.317242116E-01,  0.388038642E-01, -0.255778987E-03 }, 
{     -90.0000,    -150.0000, -0.217397000E+01, -0.377852248E-01,  0.335439792E-01, -0.365034793E-03 }, 
{     -75.0000,    -150.0000, -0.273078000E+01, -0.319488892E-01,  0.326068193E-01,  0.476509175E-03 }, 
{     -60.0000,    -150.0000, -0.295919000E+01,  0.853678149E-02,  0.413718538E-01,  0.245730146E-04 }, 
{     -45.0000,    -150.0000, -0.236553000E+01,  0.708517632E-01,  0.611167963E-01,  0.512719418E-02 }, 
{     -30.0000,    -150.0000, -0.655940000E+00,  0.168706166E+00,  0.144394336E+00,  0.711467234E-04 }, 
{     -15.0000,    -150.0000,  0.160921000E+01,  0.492715741E-01,  0.616437634E-01, -0.530638766E-02 }, 
{       0.0000,    -150.0000,  0.681970000E+00, -0.982104620E-01,  0.336245620E-01, -0.999550874E-03 }, 
{      15.0000,    -150.0000, -0.475030000E+00, -0.732777261E-01,  0.125666598E-01, -0.510829560E-03 }, 
{      30.0000,    -150.0000, -0.160792000E+01, -0.666566337E-01,  0.245976703E-01,  0.123749078E-02 }, 
{      45.0000,    -150.0000, -0.228172000E+01, -0.214337391E-01,  0.378280205E-01,  0.613138578E-03 }, 
{      60.0000,    -150.0000, -0.227657000E+01,  0.186615902E-01,  0.438322019E-01,  0.156861223E-03 }, 
{      75.0000,    -150.0000, -0.184368000E+01,  0.343953783E-01,  0.451860511E-01,  0.231022666E-03 }, 
{      90.0000,    -150.0000, -0.132072000E+01,  0.349268966E-01,  0.492440650E-01,  0.142073802E-05 }, 
{     105.0000,    -150.0000, -0.796930000E+00,  0.352470353E-01,  0.449780099E-01, -0.278313874E-03 }, 
{     120.0000,    -150.0000, -0.275020000E+00,  0.332249621E-01,  0.443607996E-01,  0.135181670E-03 }, 
{     135.0000,    -150.0000,  0.157920000E+00,  0.228231163E-01,  0.438479190E-01, -0.488430981E-03 }, 
{     150.0000,    -150.0000,  0.373940000E+00,  0.527457278E-02,  0.296235534E-01, -0.112890699E-02 }, 
{     165.0000,    -150.0000,  0.300070000E+00, -0.154914074E-01,  0.148000975E-01, -0.805505350E-03 }, 
{     180.0000,    -150.0000, -0.548700000E-01, -0.290709431E-01,  0.653291777E-02, -0.267198730E-03 }, 
{    -180.0000,    -135.0000,  0.221370000E+00, -0.262012513E-01,  0.286050584E-01,  0.496725113E-03 }, 
{    -165.0000,    -135.0000, -0.115070000E+00, -0.166359174E-01,  0.407522190E-01,  0.101516158E-02 }, 
{    -150.0000,    -135.0000, -0.250690000E+00, -0.166707891E-02,  0.558622727E-01,  0.894071424E-03 }, 
{    -135.0000,    -135.0000, -0.251200000E+00, -0.392176690E-02,  0.652061779E-01,  0.299344496E-03 }, 
{    -120.0000,    -135.0000, -0.453720000E+00, -0.232518535E-01,  0.628692734E-01, -0.690049264E-03 }, 
{    -105.0000,    -135.0000, -0.914940000E+00, -0.358188192E-01,  0.518068708E-01, -0.219008843E-03 }, 
{     -90.0000,    -135.0000, -0.148283000E+01, -0.392948697E-01,  0.578587294E-01,  0.563975838E-03 }, 
{     -75.0000,    -135.0000, -0.197985000E+01, -0.199837020E-01,  0.656407564E-01,  0.729882601E-03 }, 
{     -60.0000,    -135.0000, -0.199291000E+01,  0.172136775E-01,  0.871694706E-01,  0.237864199E-02 }, 
{     -45.0000,    -135.0000, -0.873170000E+00,  0.172464992E+00,  0.139551278E+00,  0.453765369E-02 }, 
{     -30.0000,    -135.0000,  0.215102000E+01,  0.121712355E+00,  0.162643961E+00, -0.543435860E-02 }, 
{     -15.0000,    -135.0000,  0.208125000E+01, -0.684304125E-01,  0.223849069E-01, -0.623349346E-02 }, 
{       0.0000,    -135.0000,  0.101469000E+01, -0.752567051E-01,  0.200598924E-01,  0.185151863E-02 }, 
{      15.0000,    -135.0000, -0.134090000E+00, -0.736107672E-01,  0.315289741E-01,  0.656232395E-03 }, 
{      30.0000,    -135.0000, -0.108446000E+01, -0.501302262E-01,  0.481741277E-01,  0.114639885E-02 }, 
{      45.0000,    -135.0000, -0.157764000E+01, -0.145783280E-01,  0.579721593E-01,  0.468092550E-04 }, 
{      60.0000,    -135.0000, -0.154005000E+01,  0.173255381E-01,  0.525493204E-01, -0.458597322E-03 }, 
{      75.0000,    -135.0000, -0.111846000E+01,  0.371121756E-01,  0.502041713E-01,  0.233982443E-03 }, 
{      90.0000,    -135.0000, -0.548820000E+00,  0.324717595E-01,  0.540183412E-01, -0.183528302E-03 }, 
{     105.0000,    -135.0000, -0.143530000E+00,  0.279867866E-01,  0.454338971E-01, -0.453924093E-03 }, 
{     120.0000,    -135.0000,  0.350590000E+00,  0.354630943E-01,  0.424661020E-01, -0.311223152E-03 }, 
{     135.0000,    -135.0000,  0.789610000E+00,  0.167888364E-01,  0.336647051E-01, -0.655021687E-03 }, 
{     150.0000,    -135.0000,  0.821760000E+00, -0.838443979E-02,  0.265416765E-01, -0.253575201E-03 }, 
{     165.0000,    -135.0000,  0.599000000E+00, -0.213730772E-01,  0.255300007E-01,  0.423816136E-04 }, 
{     180.0000,    -135.0000,  0.221370000E+00, -0.262012513E-01,  0.286050584E-01,  0.496725113E-03 }, 
{    -180.0000,    -120.0000,  0.762820000E+00, -0.163297527E-01,  0.425848488E-01,  0.828536362E-03 }, 
{    -165.0000,    -120.0000,  0.650490000E+00,  0.301610870E-03,  0.585875468E-01,  0.103284365E-02 }, 
{    -150.0000,    -120.0000,  0.732260000E+00,  0.901130923E-02,  0.702398211E-01,  0.571083499E-03 }, 
{    -135.0000,    -120.0000,  0.803020000E+00, -0.584084779E-02,  0.709058430E-01, -0.853518412E-03 }, 
{    -120.0000,    -120.0000,  0.467670000E+00, -0.385659181E-01,  0.514720198E-01, -0.910570101E-03 }, 
{    -105.0000,    -120.0000, -0.175780000E+00, -0.356554799E-01,  0.501546524E-01,  0.345560703E-03 }, 
{     -90.0000,    -120.0000, -0.558680000E+00, -0.240821623E-01,  0.580791031E-01,  0.849743949E-03 }, 
{     -75.0000,    -120.0000, -0.870220000E+00, -0.690387102E-02,  0.769421552E-01,  0.161296405E-02 }, 
{     -60.0000,    -120.0000, -0.446240000E+00,  0.741856464E-01,  0.112540264E+00,  0.359063200E-02 }, 
{     -45.0000,    -120.0000,  0.142775000E+01,  0.169755286E+00,  0.139334093E+00, -0.349710448E-02 }, 
{     -30.0000,    -120.0000,  0.349117000E+01,  0.342752113E-01,  0.344518183E-01, -0.521990321E-02 }, 
{     -15.0000,    -120.0000,  0.247433000E+01, -0.975401307E-01,  0.218406091E-01,  0.878020526E-03 }, 
{       0.0000,    -120.0000,  0.140660000E+01, -0.610286883E-01,  0.310618683E-01,  0.102983111E-02 }, 
{      15.0000,    -120.0000,  0.511320000E+00, -0.509471160E-01,  0.585874439E-01,  0.235202200E-02 }, 
{      30.0000,    -120.0000, -0.796400000E-01, -0.324308477E-01,  0.883618189E-01,  0.102207103E-02 }, 
{      45.0000,    -120.0000, -0.497870000E+00, -0.211674932E-01,  0.870533423E-01, -0.747126421E-03 }, 
{      60.0000,    -120.0000, -0.644870000E+00,  0.405482064E-02,  0.723105164E-01, -0.124382585E-02 }, 
{      75.0000,    -120.0000, -0.357550000E+00,  0.330122107E-01,  0.512232635E-01, -0.144358596E-02 }, 
{      90.0000,    -120.0000,  0.188030000E+00,  0.304763366E-01,  0.364325703E-01, -0.157419525E-03 }, 
{     105.0000,    -120.0000,  0.545500000E+00,  0.256924428E-01,  0.417724019E-01,  0.183091744E-03 }, 
{     120.0000,    -120.0000,  0.972890000E+00,  0.237258921E-01,  0.353567923E-01, -0.790103062E-03 }, 
{     135.0000,    -120.0000,  0.116949000E+01,  0.420198877E-02,  0.238072605E-01, -0.615707771E-03 }, 
{     150.0000,    -120.0000,  0.115910000E+01, -0.329184719E-02,  0.212417405E-01,  0.429923799E-03 }, 
{     165.0000,    -120.0000,  0.105012000E+01, -0.149086000E-01,  0.330898995E-01,  0.752540374E-03 }, 
{     180.0000,    -120.0000,  0.762820000E+00, -0.163297527E-01,  0.425848488E-01,  0.828536362E-03 }, 
{    -180.0000,    -105.0000,  0.142827000E+01, -0.381685133E-02,  0.424355465E-01,  0.666009441E-03 }, 
{    -165.0000,    -105.0000,  0.150406000E+01,  0.130108168E-01,  0.487235937E-01,  0.782810668E-03 }, 
{    -150.0000,    -105.0000,  0.172284000E+01,  0.106875842E-01,  0.578844431E-01, -0.707472798E-03 }, 
{    -135.0000,    -105.0000,  0.164917000E+01, -0.267391535E-01,  0.312444502E-01, -0.144874817E-02 }, 
{    -120.0000,    -105.0000,  0.103764000E+01, -0.407709701E-01,  0.295146474E-01,  0.828506348E-03 }, 
{    -105.0000,    -105.0000,  0.564750000E+00, -0.270609662E-01,  0.435125194E-01,  0.588336632E-03 }, 
{     -90.0000,    -105.0000,  0.200840000E+00, -0.183451651E-01,  0.465588581E-01,  0.226989278E-03 }, 
{     -75.0000,    -105.0000,  0.208210000E+00,  0.291336268E-01,  0.642026229E-01,  0.264172695E-02 }, 
{     -60.0000,    -105.0000,  0.122814000E+01,  0.107270658E+00,  0.106879474E+00,  0.127022611E-02 }, 
{     -45.0000,    -105.0000,  0.298189000E+01,  0.965197412E-01,  0.741243503E-01, -0.573828591E-02 }, 
{     -30.0000,    -105.0000,  0.357647000E+01, -0.236836228E-01, -0.153612345E-01, -0.276522417E-02 }, 
{     -15.0000,    -105.0000,  0.265211000E+01, -0.677412501E-01,  0.442465663E-02,  0.285924384E-02 }, 
{       0.0000,    -105.0000,  0.195317000E+01, -0.300113769E-01,  0.433886343E-01,  0.307822258E-02 }, 
{      15.0000,    -105.0000,  0.165224000E+01, -0.121872424E-01,  0.913872503E-01,  0.222038457E-02 }, 
{      30.0000,    -105.0000,  0.143567000E+01, -0.247396534E-01,  0.102404597E+00, -0.156568393E-03 }, 
{      45.0000,    -105.0000,  0.924860000E+00, -0.343301439E-01,  0.943144715E-01, -0.100866676E-02 }, 
{      60.0000,    -105.0000,  0.550650000E+00, -0.149437710E-01,  0.763486141E-01, -0.101996110E-02 }, 
{      75.0000,    -105.0000,  0.460270000E+00,  0.118722773E-02,  0.606487748E-01, -0.164462818E-02 }, 
{      90.0000,    -105.0000,  0.604700000E+00,  0.210048600E-01,  0.309553776E-01, -0.148017349E-02 }, 
{     105.0000,    -105.0000,  0.102077000E+01,  0.268933322E-01,  0.203364954E-01, -0.497133758E-03 }, 
{     120.0000,    -105.0000,  0.133189000E+01,  0.168598112E-01,  0.123667289E-01, -0.249021206E-03 }, 
{     135.0000,    -105.0000,  0.151499000E+01,  0.451142291E-02,  0.161822529E-01,  0.662370078E-03 }, 
{     150.0000,    -105.0000,  0.150886000E+01,  0.488497135E-03,  0.259113614E-01,  0.308467391E-03 }, 
{     165.0000,    -105.0000,  0.153133000E+01, -0.319741145E-02,  0.285764013E-01,  0.582590045E-03 }, 
{     180.0000,    -105.0000,  0.142827000E+01, -0.381685133E-02,  0.424355465E-01,  0.666009441E-03 }, 
{    -180.0000,     -90.0000,  0.190401000E+01,  0.543857642E-02,  0.159109652E-01,  0.861091701E-03 }, 
{    -165.0000,     -90.0000,  0.203939000E+01,  0.203260480E-01,  0.242980785E-01, -0.159198894E-03 }, 
{    -150.0000,     -90.0000,  0.229924000E+01, -0.769676846E-02,  0.116184066E-01, -0.108280784E-02 }, 
{    -135.0000,     -90.0000,  0.179055000E+01, -0.393069742E-01,  0.162235629E-02, -0.447141674E-04 }, 
{    -120.0000,     -90.0000,  0.135280000E+01, -0.243633349E-01,  0.749539078E-02,  0.437061344E-03 }, 
{    -105.0000,     -90.0000,  0.102391000E+01, -0.165676863E-01,  0.157332698E-01,  0.111865150E-02 }, 
{     -90.0000,     -90.0000,  0.905620000E+00,  0.119807998E-02,  0.485454644E-01,  0.329834739E-02 }, 
{     -75.0000,     -90.0000,  0.123397000E+01,  0.537873663E-01,  0.870853532E-01, -0.416243586E-04 }, 
{     -60.0000,     -90.0000,  0.245075000E+01,  0.926784546E-01,  0.393398402E-01, -0.497297479E-02 }, 
{     -45.0000,     -90.0000,  0.345522000E+01,  0.197488152E-01, -0.303374942E-01, -0.355104595E-02 }, 
{     -30.0000,     -90.0000,  0.309983000E+01, -0.418577153E-01, -0.512748802E-01,  0.105421455E-02 }, 
{     -15.0000,     -90.0000,  0.262493000E+01, -0.183759540E-01, -0.941923564E-02,  0.351783947E-02 }, 
{       0.0000,     -90.0000,  0.265047000E+01,  0.254895313E-01,  0.441575944E-01,  0.396092249E-02 }, 
{      15.0000,     -90.0000,  0.309474000E+01,  0.103798289E-01,  0.925475550E-01,  0.103182869E-02 }, 
{      30.0000,     -90.0000,  0.279428000E+01, -0.382468469E-01,  0.768037941E-01, -0.155899730E-02 }, 
{      45.0000,     -90.0000,  0.215793000E+01, -0.447544412E-01,  0.668487718E-01,  0.644038655E-04 }, 
{      60.0000,     -90.0000,  0.157482000E+01, -0.266273882E-01,  0.662330273E-01, -0.812771517E-03 }, 
{      75.0000,     -90.0000,  0.133310000E+01, -0.137020060E-01,  0.443116374E-01, -0.132074467E-02 }, 
{      90.0000,     -90.0000,  0.113012000E+01, -0.750458767E-02,  0.281639194E-01, -0.151807139E-02 }, 
{     105.0000,     -90.0000,  0.117449000E+01,  0.119983567E-01,  0.267961662E-02, -0.933373929E-03 }, 
{     120.0000,     -90.0000,  0.141199000E+01,  0.158851608E-01,  0.299629197E-02,  0.218041619E-03 }, 
{     135.0000,     -90.0000,  0.162671000E+01,  0.149050002E-01,  0.290772809E-02,  0.106829747E-03 }, 
{     150.0000,     -90.0000,  0.181755000E+01,  0.560683837E-02,  0.680281374E-02,  0.115943749E-03 }, 
{     165.0000,     -90.0000,  0.182118000E+01,  0.156164630E-02,  0.681649536E-02,  0.211148711E-03 }, 
{     180.0000,     -90.0000,  0.190401000E+01,  0.543857642E-02,  0.159109652E-01,  0.861091701E-03 }, 
{    -180.0000,     -75.0000,  0.180621000E+01,  0.179152914E-01, -0.304914073E-01,  0.236052308E-03 }, 
{    -165.0000,     -75.0000,  0.208080000E+01,  0.107458041E-01, -0.305679076E-01, -0.599017638E-03 }, 
{    -150.0000,     -75.0000,  0.203556000E+01, -0.150285077E-01, -0.418140696E-01, -0.104514204E-03 }, 
{    -135.0000,     -75.0000,  0.168691000E+01, -0.294097733E-01, -0.301858754E-01,  0.109348089E-02 }, 
{    -120.0000,     -75.0000,  0.129208000E+01, -0.160283992E-01, -0.860821049E-02,  0.237176245E-02 }, 
{    -105.0000,     -75.0000,  0.122509000E+01,  0.115937011E-02,  0.256224012E-01,  0.581124641E-03 }, 
{     -90.0000,     -75.0000,  0.143311000E+01,  0.395969188E-01,  0.571328438E-02, -0.183196204E-02 }, 
{     -75.0000,     -75.0000,  0.216375000E+01,  0.281849548E-01, -0.214360359E-01, -0.266496391E-02 }, 
{     -60.0000,     -75.0000,  0.217320000E+01, -0.431873790E-02, -0.752268346E-01, -0.369620612E-02 }, 
{     -45.0000,     -75.0000,  0.221268000E+01, -0.112400319E-02, -0.106616373E+00,  0.413720856E-03 }, 
{     -30.0000,     -75.0000,  0.213049000E+01,  0.272750652E-03, -0.687352449E-01,  0.333964065E-02 }, 
{     -15.0000,     -75.0000,  0.240205000E+01,  0.379070006E-01, -0.167597141E-01,  0.419904843E-02 }, 
{       0.0000,     -75.0000,  0.324329000E+01,  0.706592470E-01,  0.380049882E-01,  0.121221222E-02 }, 
{      15.0000,     -75.0000,  0.406613000E+01,  0.122720113E-01,  0.212005297E-01, -0.145584858E-02 }, 
{      30.0000,     -75.0000,  0.357523000E+01, -0.533592923E-01,  0.182922268E-01,  0.668629818E-03 }, 
{      45.0000,     -75.0000,  0.286443000E+01, -0.391748421E-01,  0.262044414E-01, -0.217888342E-03 }, 
{      60.0000,     -75.0000,  0.231976000E+01, -0.410353393E-01,  0.125412766E-01, -0.947266493E-03 }, 
{      75.0000,     -75.0000,  0.166472000E+01, -0.366258009E-01,  0.299467555E-02, -0.634998862E-03 }, 
{      90.0000,     -75.0000,  0.127852000E+01, -0.207094572E-01, -0.884705516E-02, -0.790404405E-03 }, 
{     105.0000,     -75.0000,  0.109103000E+01,  0.472562984E-02, -0.170029618E-01, -0.202910998E-03 }, 
{     120.0000,     -75.0000,  0.136656000E+01,  0.194149379E-01, -0.174178968E-01, -0.112119936E-03 }, 
{     135.0000,     -75.0000,  0.153314000E+01,  0.603661857E-02, -0.241831652E-01, -0.784649932E-03 }, 
{     150.0000,     -75.0000,  0.159747000E+01,  0.262058781E-02, -0.354006164E-01, -0.345824252E-03 }, 
{     165.0000,     -75.0000,  0.164225000E+01,  0.530303019E-02, -0.336583827E-01,  0.272903439E-03 }, 
{     180.0000,     -75.0000,  0.180621000E+01,  0.179152914E-01, -0.304914073E-01,  0.236052308E-03 }, 
{    -180.0000,     -60.0000,  0.941330000E+00,  0.118186977E-01, -0.864813358E-01, -0.529276683E-03 }, 
{    -165.0000,     -60.0000,  0.107716000E+01,  0.427829487E-02, -0.944724482E-01, -0.654281180E-03 }, 
{    -150.0000,     -60.0000,  0.106365000E+01, -0.446787716E-02, -0.914801283E-01,  0.214664292E-02 }, 
{    -135.0000,     -60.0000,  0.962110000E+00, -0.941678624E-02, -0.465668549E-01,  0.164882817E-02 }, 
{    -120.0000,     -60.0000,  0.944110000E+00,  0.182270221E-01, -0.548005488E-01, -0.140603973E-02 }, 
{    -105.0000,     -60.0000,  0.125994000E+01, -0.392530226E-02, -0.710168748E-01, -0.914673259E-03 }, 
{     -90.0000,     -60.0000,  0.796280000E+00, -0.320918131E-01, -0.932666019E-01, -0.262847785E-02 }, 
{     -75.0000,     -60.0000,  0.575620000E+00, -0.457144538E-02, -0.133011210E+00, -0.970282337E-03 }, 
{     -60.0000,     -60.0000,  0.565770000E+00,  0.427559460E-02, -0.115428502E+00,  0.207722726E-02 }, 
{     -45.0000,     -60.0000,  0.745720000E+00,  0.214890670E-01, -0.850970118E-01,  0.224421289E-02 }, 
{     -30.0000,     -60.0000,  0.124745000E+01,  0.461041375E-01, -0.442601404E-01,  0.317959342E-02 }, 
{     -15.0000,     -60.0000,  0.221612000E+01,  0.881743830E-01, -0.530390806E-02,  0.996034197E-03 }, 
{       0.0000,     -60.0000,  0.354214000E+01,  0.601363305E-01, -0.178435471E-01, -0.188041154E-02 }, 
{      15.0000,     -60.0000,  0.378367000E+01, -0.152097051E-01, -0.395636737E-01, -0.326341176E-03 }, 
{      30.0000,     -60.0000,  0.340120000E+01, -0.274855100E-01, -0.285887012E-01,  0.103674541E-02 }, 
{      45.0000,     -60.0000,  0.289718000E+01, -0.521462548E-01, -0.238165375E-01, -0.671213209E-03 }, 
{      60.0000,     -60.0000,  0.194715000E+01, -0.547394708E-01, -0.419321336E-01, -0.102057904E-02 }, 
{      75.0000,     -60.0000,  0.136042000E+01, -0.362478618E-01, -0.508263396E-01, -0.648431044E-03 }, 
{      90.0000,     -60.0000,  0.792500000E+00, -0.311990818E-01, -0.602996987E-01, -0.592098121E-04 }, 
{     105.0000,     -60.0000,  0.577690000E+00,  0.449818897E-02, -0.540277692E-01,  0.244984367E-03 }, 
{     120.0000,     -60.0000,  0.779350000E+00,  0.105763259E-01, -0.598527047E-01, -0.831328847E-03 }, 
{     135.0000,     -60.0000,  0.793510000E+00, -0.363949261E-02, -0.728150673E-01, -0.677128584E-03 }, 
{     150.0000,     -60.0000,  0.753670000E+00, -0.115435546E-02, -0.779763481E-01, -0.848855055E-04 }, 
{     165.0000,     -60.0000,  0.785810000E+00,  0.671691445E-02, -0.792569645E-01, -0.271708837E-03 }, 
{     180.0000,     -60.0000,  0.941330000E+00,  0.118186977E-01, -0.864813358E-01, -0.529276683E-03 }, 
{    -180.0000,     -45.0000, -0.672750000E+00,  0.319066325E-02, -0.119375249E+00, -0.106387121E-02 }, 
{    -165.0000,     -45.0000, -0.592120000E+00,  0.459098920E-02, -0.126126300E+00,  0.198517939E-02 }, 
{    -150.0000,     -45.0000, -0.422000000E+00,  0.285953800E-01, -0.837774174E-01,  0.242720059E-03 }, 
{    -135.0000,     -45.0000, -0.110600000E-01, -0.276050906E-02, -0.123140705E+00, -0.235894074E-02 }, 
{    -120.0000,     -45.0000, -0.514700000E+00, -0.360933437E-01, -0.133545594E+00, -0.760592447E-03 }, 
{    -105.0000,     -45.0000, -0.809220000E+00, -0.124981161E-01, -0.148416902E+00,  0.346071160E-03 }, 
{     -90.0000,     -45.0000, -0.995380000E+00, -0.100501920E-01, -0.118344877E+00,  0.241645128E-02 }, 
{     -75.0000,     -45.0000, -0.106430000E+01,  0.168288403E-02, -0.921291251E-01,  0.124567911E-02 }, 
{     -60.0000,     -45.0000, -0.878440000E+00,  0.267066559E-01, -0.733871591E-01,  0.159237584E-02 }, 
{     -45.0000,     -45.0000, -0.245760000E+00,  0.551984925E-01, -0.446835792E-01,  0.187392673E-02 }, 
{     -30.0000,     -45.0000,  0.776340000E+00,  0.834553740E-01, -0.250541935E-01,  0.578510356E-03 }, 
{     -15.0000,     -45.0000,  0.205251000E+01,  0.706340114E-01, -0.319326537E-01, -0.163778306E-02 }, 
{       0.0000,     -45.0000,  0.278505000E+01,  0.357505803E-01, -0.582787999E-01, -0.672299404E-03 }, 
{      15.0000,     -45.0000,  0.313379000E+01,  0.261966721E-02, -0.494138347E-01,  0.830744462E-03 }, 
{      30.0000,     -45.0000,  0.285045000E+01, -0.331492492E-01, -0.488934218E-01, -0.773602836E-03 }, 
{      45.0000,     -45.0000,  0.219151000E+01, -0.584786704E-01, -0.655222916E-01, -0.958024486E-03 }, 
{      60.0000,     -45.0000,  0.116243000E+01, -0.705400691E-01, -0.762787422E-01, -0.871363300E-03 }, 
{      75.0000,     -45.0000,  0.207200000E+00, -0.562230532E-01, -0.911933171E-01, -0.690727417E-03 }, 
{      90.0000,     -45.0000, -0.422370000E+00, -0.215277183E-01, -0.901321498E-01,  0.863591448E-03 }, 
{     105.0000,     -45.0000, -0.464600000E+00,  0.797392622E-02, -0.780119612E-01, -0.127367193E-03 }, 
{     120.0000,     -45.0000, -0.386650000E+00, -0.322398663E-02, -0.938132844E-01, -0.109034958E-02 }, 
{     135.0000,     -45.0000, -0.552320000E+00, -0.126219797E-01, -0.101648566E+00, -0.238555388E-03 }, 
{     150.0000,     -45.0000, -0.670780000E+00, -0.311409453E-02, -0.106343991E+00, -0.461570193E-03 }, 
{     165.0000,     -45.0000, -0.678300000E+00, -0.117642180E-03, -0.113423759E+00, -0.270202564E-03 }, 
{     180.0000,     -45.0000, -0.672750000E+00,  0.319066325E-02, -0.119375249E+00, -0.106387121E-02 }, 
{    -180.0000,     -30.0000, -0.246944000E+01, -0.414153948E-02, -0.118171667E+00,  0.159271411E-02 }, 
{    -165.0000,     -30.0000, -0.232595000E+01,  0.406458683E-01, -0.816443537E-01, -0.129216810E-04 }, 
{    -150.0000,     -30.0000, -0.171439000E+01, -0.743193368E-02, -0.129018202E+00, -0.371033446E-02 }, 
{    -135.0000,     -30.0000, -0.248703000E+01, -0.431341336E-01, -0.150698325E+00,  0.104346533E-02 }, 
{    -120.0000,     -30.0000, -0.256054000E+01,  0.107384680E-01, -0.111947074E+00,  0.295069868E-02 }, 
{    -105.0000,     -30.0000, -0.246215000E+01,  0.515626167E-02, -0.797335173E-01,  0.134670140E-02 }, 
{     -90.0000,     -30.0000, -0.237111000E+01,  0.652248535E-02, -0.668318908E-01,  0.685532429E-03 }, 
{     -75.0000,     -30.0000, -0.219037000E+01,  0.231097969E-01, -0.516702898E-01,  0.152381436E-02 }, 
{     -60.0000,     -30.0000, -0.162432000E+01,  0.503963269E-01, -0.290408622E-01,  0.777415847E-03 }, 
{     -45.0000,     -30.0000, -0.723700000E+00,  0.686388956E-01, -0.300526715E-01, -0.309954080E-03 }, 
{     -30.0000,     -30.0000,  0.358950000E+00,  0.717020908E-01, -0.332230854E-01, -0.374044181E-03 }, 
{     -15.0000,     -30.0000,  0.135947000E+01,  0.611867411E-01, -0.382954772E-01,  0.157569657E-03 }, 
{       0.0000,     -30.0000,  0.212358000E+01,  0.364769446E-01, -0.327532534E-01, -0.162268031E-03 }, 
{      15.0000,     -30.0000,  0.236496000E+01, -0.599651957E-02, -0.465229874E-01, -0.115399956E-02 }, 
{      30.0000,     -30.0000,  0.196636000E+01, -0.439348663E-01, -0.628056114E-01, -0.123220533E-02 }, 
{      45.0000,     -30.0000,  0.105275000E+01, -0.807060151E-01, -0.829802963E-01, -0.120864092E-02 }, 
{      60.0000,     -30.0000, -0.261830000E+00, -0.788790731E-01, -0.947488975E-01, -0.321888209E-03 }, 
{      75.0000,     -30.0000, -0.116368000E+01, -0.470636924E-01, -0.892203921E-01,  0.124817459E-02 }, 
{      90.0000,     -30.0000, -0.165442000E+01, -0.113841571E-01, -0.685557019E-01,  0.567828949E-03 }, 
{     105.0000,     -30.0000, -0.164196000E+01, -0.305567900E-02, -0.778543861E-01, -0.124628919E-02 }, 
{     120.0000,     -30.0000, -0.186484000E+01, -0.184771269E-01, -0.937321578E-01, -0.617963377E-03 }, 
{     135.0000,     -30.0000, -0.209366000E+01, -0.133758135E-01, -0.980246698E-01, -0.315914046E-03 }, 
{     150.0000,     -30.0000, -0.228268000E+01, -0.115876190E-01, -0.103917688E+00, -0.155486436E-03 }, 
{     165.0000,     -30.0000, -0.241932000E+01, -0.540571037E-02, -0.108073998E+00, -0.107200587E-02 }, 
{     180.0000,     -30.0000, -0.246944000E+01, -0.414153948E-02, -0.118171667E+00,  0.159271411E-02 }, 
{    -180.0000,     -15.0000, -0.382546000E+01,  0.334050611E-01, -0.384800833E-01,  0.735894346E-03 }, 
{    -165.0000,     -15.0000, -0.322967000E+01, -0.490258072E-02, -0.748062857E-01, -0.383220665E-02 }, 
{    -150.0000,     -15.0000, -0.393518000E+01, -0.357387382E-01, -0.102785774E+00,  0.173179413E-02 }, 
{    -135.0000,     -15.0000, -0.385949000E+01,  0.218935336E-01, -0.437519964E-01,  0.311588796E-02 }, 
{    -120.0000,     -15.0000, -0.358321000E+01,  0.185586037E-01, -0.323681079E-01, -0.111812799E-03 }, 
{    -105.0000,     -15.0000, -0.328549000E+01,  0.186720515E-01, -0.279030289E-01,  0.501156736E-03 }, 
{     -90.0000,     -15.0000, -0.301617000E+01,  0.201611903E-01, -0.184855599E-01,  0.883695458E-03 }, 
{     -75.0000,     -15.0000, -0.260005000E+01,  0.377711874E-01, -0.833971552E-02, -0.123275884E-03 }, 
{     -60.0000,     -15.0000, -0.192147000E+01,  0.476940600E-01, -0.190553922E-01, -0.504558393E-03 }, 
{     -45.0000,     -15.0000, -0.114234000E+01,  0.629945725E-01, -0.144217349E-01,  0.925105588E-03 }, 
{     -30.0000,     -15.0000, -0.873000000E-02,  0.828756499E-01,  0.932535297E-03,  0.801721548E-03 }, 
{     -15.0000,     -15.0000,  0.114445000E+01,  0.628608278E-01,  0.350256257E-02, -0.547132294E-03 }, 
{       0.0000,     -15.0000,  0.177335000E+01,  0.220970389E-01, -0.130481867E-01, -0.140933676E-02 }, 
{      15.0000,     -15.0000,  0.179047000E+01, -0.220449834E-01, -0.331582158E-01, -0.114767633E-02 }, 
{      30.0000,     -15.0000,  0.109507000E+01, -0.695731054E-01, -0.509601326E-01, -0.158234709E-02 }, 
{      45.0000,     -15.0000, -0.162970000E+00, -0.903505952E-01, -0.734525232E-01, -0.581796781E-03 }, 
{      60.0000,     -15.0000, -0.143516000E+01, -0.750705140E-01, -0.642436679E-01,  0.125282716E-02 }, 
{      75.0000,     -15.0000, -0.226699000E+01, -0.301713489E-01, -0.467631145E-01,  0.908369881E-03 }, 
{      90.0000,     -15.0000, -0.245933000E+01, -0.907809027E-02, -0.430370427E-01, -0.644981645E-03 }, 
{     105.0000,     -15.0000, -0.270542000E+01, -0.212022900E-01, -0.587344944E-01, -0.722719292E-03 }, 
{     120.0000,     -15.0000, -0.303929000E+01, -0.221047498E-01, -0.617860844E-01, -0.213949533E-03 }, 
{     135.0000,     -15.0000, -0.335545000E+01, -0.203847110E-01, -0.668787549E-01, -0.503346795E-04 }, 
{     150.0000,     -15.0000, -0.362364000E+01, -0.132264063E-01, -0.685572578E-01, -0.938946424E-03 }, 
{     165.0000,     -15.0000, -0.379758000E+01, -0.151356637E-01, -0.781362481E-01,  0.155462174E-02 }, 
{     180.0000,     -15.0000, -0.382546000E+01,  0.334050611E-01, -0.384800833E-01,  0.735894346E-03 }, 
{    -180.0000,       0.0000, -0.382990000E+01,  0.179354324E-07, -0.325260652E-18, -0.370798001E-02 }, 
{    -165.0000,       0.0000, -0.437645000E+01, -0.282088485E-01, -0.292305035E-01,  0.157080491E-02 }, 
{    -150.0000,       0.0000, -0.429456000E+01,  0.199033760E-01,  0.241272974E-01,  0.225021986E-02 }, 
{    -135.0000,       0.0000, -0.401846000E+01,  0.201933445E-01,  0.194203104E-01, -0.841521567E-03 }, 
{    -120.0000,       0.0000, -0.366843000E+01,  0.245492462E-01,  0.198415061E-01,  0.258708148E-03 }, 
{    -105.0000,       0.0000, -0.331240000E+01,  0.228216709E-01,  0.212956330E-01,  0.181753501E-03 }, 
{     -90.0000,       0.0000, -0.296646000E+01,  0.245580701E-01,  0.217041303E-01, -0.613197300E-03 }, 
{     -75.0000,       0.0000, -0.258028000E+01,  0.253700485E-01,  0.704715191E-02, -0.578660521E-03 }, 
{     -60.0000,       0.0000, -0.208554000E+01,  0.501457359E-01,  0.130184311E-01,  0.119069953E-02 }, 
{     -45.0000,       0.0000, -0.990500000E+00,  0.920030079E-01,  0.343796109E-01,  0.128235419E-02 }, 
{     -30.0000,       0.0000,  0.422610000E+00,  0.834722326E-01,  0.422249443E-01, -0.478813653E-03 }, 
{     -15.0000,       0.0000,  0.135374000E+01,  0.429560617E-01,  0.231392270E-01, -0.161517637E-02 }, 
{       0.0000,       0.0000,  0.169885000E+01, -0.484794739E-04, -0.867361738E-18, -0.150546973E-02 }, 
{      15.0000,       0.0000,  0.135374000E+01, -0.427621438E-01, -0.230881493E-01, -0.160841995E-02 }, 
{      30.0000,       0.0000,  0.422610000E+00, -0.841509452E-01, -0.421038582E-01, -0.481622097E-03 }, 
{      45.0000,       0.0000, -0.100310000E+01, -0.920020752E-01, -0.343796109E-01,  0.127661603E-02 }, 
{      60.0000,       0.0000, -0.208554000E+01, -0.494707538E-01, -0.130184311E-01,  0.119224342E-02 }, 
{      75.0000,       0.0000, -0.258028000E+01, -0.255509094E-01, -0.704714998E-02, -0.579097509E-03 }, 
{      90.0000,       0.0000, -0.296646000E+01, -0.245096086E-01, -0.217041275E-01, -0.612992662E-03 }, 
{     105.0000,       0.0000, -0.331240000E+01, -0.228346562E-01, -0.212956362E-01,  0.181370921E-03 }, 
{     120.0000,       0.0000, -0.366843000E+01, -0.245457667E-01, -0.198415046E-01,  0.260033547E-03 }, 
{     135.0000,       0.0000, -0.401846000E+01, -0.201942771E-01, -0.194203104E-01, -0.846439951E-03 }, 
{     150.0000,       0.0000, -0.429456000E+01, -0.199031249E-01, -0.242292811E-01,  0.224817096E-02 }, 
{     165.0000,       0.0000, -0.437645000E+01,  0.282087767E-01,  0.291929906E-01,  0.157641632E-02 }, 
{     180.0000,       0.0000, -0.382990000E+01,  0.179354324E-07, -0.325260652E-18, -0.370798001E-02 }, 
{    -180.0000,      15.0000, -0.382546000E+01, -0.333675482E-01,  0.384800833E-01,  0.741503838E-03 }, 
{    -165.0000,      15.0000, -0.379758000E+01,  0.151256121E-01,  0.781462997E-01,  0.155462559E-02 }, 
{    -150.0000,      15.0000, -0.362364000E+01,  0.132290996E-01,  0.685845842E-01, -0.939105993E-03 }, 
{    -135.0000,      15.0000, -0.335545000E+01,  0.203839893E-01,  0.668787549E-01, -0.517105566E-04 }, 
{    -120.0000,      15.0000, -0.303929000E+01,  0.221049431E-01,  0.617860836E-01, -0.213751912E-03 }, 
{    -105.0000,      15.0000, -0.270542000E+01,  0.212022382E-01,  0.587344969E-01, -0.722133405E-03 }, 
{     -90.0000,      15.0000, -0.245933000E+01,  0.907810415E-02,  0.430370385E-01, -0.647523482E-03 }, 
{     -75.0000,      15.0000, -0.226699000E+01,  0.301713452E-01,  0.467631079E-01,  0.917949526E-03 }, 
{     -60.0000,      15.0000, -0.143516000E+01,  0.750705150E-01,  0.642436679E-01,  0.121705125E-02 }, 
{     -45.0000,      15.0000, -0.162970000E+00,  0.903505949E-01,  0.727772912E-01, -0.583317863E-03 }, 
{     -30.0000,      15.0000,  0.109507000E+01,  0.695731054E-01,  0.509276877E-01, -0.154697583E-02 }, 
{     -15.0000,      15.0000,  0.179047000E+01,  0.220449834E-01,  0.331445296E-01, -0.115533113E-02 }, 
{       0.0000,      15.0000,  0.177335000E+01, -0.220970390E-01,  0.130481867E-01, -0.140759987E-02 }, 
{      15.0000,      15.0000,  0.114445000E+01, -0.628608275E-01, -0.369318682E-02, -0.581812683E-03 }, 
{      30.0000,      15.0000, -0.873000000E-02, -0.828756509E-01, -0.138443453E-02,  0.848326365E-03 }, 
{      45.0000,      15.0000, -0.114234000E+01, -0.629945688E-01,  0.150969668E-01,  0.946537950E-03 }, 
{      60.0000,      15.0000, -0.192147000E+01, -0.476940739E-01,  0.190553922E-01, -0.546512814E-03 }, 
{      75.0000,      15.0000, -0.260005000E+01, -0.377711356E-01,  0.833971438E-02, -0.111937182E-03 }, 
{      90.0000,      15.0000, -0.301617000E+01, -0.201613836E-01,  0.184855526E-01,  0.880293620E-03 }, 
{     105.0000,      15.0000, -0.328549000E+01, -0.186713298E-01,  0.279030391E-01,  0.503427640E-03 }, 
{     120.0000,      15.0000, -0.358321000E+01, -0.185612970E-01,  0.323681030E-01, -0.117494107E-03 }, 
{     135.0000,      15.0000, -0.385949000E+01, -0.218834821E-01,  0.437519964E-01,  0.313634026E-02 }, 
{     150.0000,      15.0000, -0.393518000E+01,  0.357012253E-01,  0.103166382E+00,  0.173178893E-02 }, 
{     165.0000,      15.0000, -0.323037000E+01,  0.490258072E-02,  0.748062857E-01, -0.385263815E-02 }, 
{     180.0000,      15.0000, -0.382546000E+01, -0.333675482E-01,  0.384800833E-01,  0.741503838E-03 }, 
{    -180.0000,      30.0000, -0.246944000E+01,  0.424348770E-02,  0.118171667E+00,  0.159065861E-02 }, 
{    -165.0000,      30.0000, -0.241932000E+01,  0.537839337E-02,  0.108071305E+00, -0.107185888E-02 }, 
{    -150.0000,      30.0000, -0.228268000E+01,  0.115949388E-01,  0.103910366E+00, -0.155483326E-03 }, 
{    -135.0000,      30.0000, -0.209366000E+01,  0.133738514E-01,  0.980246698E-01, -0.315534819E-03 }, 
{    -120.0000,      30.0000, -0.186484000E+01,  0.184776556E-01,  0.937321596E-01, -0.618018613E-03 }, 
{    -105.0000,      30.0000, -0.164196000E+01,  0.305552622E-02,  0.778543794E-01, -0.124644882E-02 }, 
{     -90.0000,      30.0000, -0.165442000E+01,  0.113842395E-01,  0.685557157E-01,  0.568525100E-03 }, 
{     -75.0000,      30.0000, -0.116368000E+01,  0.470635157E-01,  0.892204166E-01,  0.124555587E-02 }, 
{     -60.0000,      30.0000, -0.261830000E+00,  0.788796976E-01,  0.947488975E-01, -0.312112213E-03 }, 
{     -45.0000,      30.0000,  0.105275000E+01,  0.807036940E-01,  0.831612242E-01, -0.120894551E-02 }, 
{     -30.0000,      30.0000,  0.196636000E+01,  0.439435263E-01,  0.628143050E-01, -0.123902426E-02 }, 
{     -15.0000,      30.0000,  0.236496000E+01,  0.596420060E-02,  0.465266546E-01, -0.116187135E-02 }, 
{       0.0000,      30.0000,  0.212358000E+01, -0.363563287E-01,  0.327532534E-01, -0.125700637E-03 }, 
{      15.0000,      30.0000,  0.135947000E+01, -0.616368857E-01,  0.390068966E-01,  0.160722314E-03 }, 
{      30.0000,      30.0000,  0.350550000E+00, -0.717021286E-01,  0.332295963E-01, -0.421920028E-03 }, 
{      45.0000,      30.0000, -0.723700000E+00, -0.681886001E-01,  0.298717436E-01, -0.300072803E-03 }, 
{      60.0000,      30.0000, -0.162432000E+01, -0.505174710E-01,  0.290408622E-01,  0.784464411E-03 }, 
{      75.0000,      30.0000, -0.219037000E+01, -0.230755160E-01,  0.516702924E-01,  0.152192492E-02 }, 
{      90.0000,      30.0000, -0.237111000E+01, -0.653846515E-02,  0.668319170E-01,  0.686046874E-03 }, 
{     105.0000,      30.0000, -0.246215000E+01, -0.512662342E-02,  0.797334799E-01,  0.134652507E-02 }, 
{     120.0000,      30.0000, -0.256054000E+01, -0.108410412E-01,  0.111947093E+00,  0.295088799E-02 }, 
{     135.0000,      30.0000, -0.248703000E+01,  0.435147880E-01,  0.150698325E+00,  0.104289193E-02 }, 
{     150.0000,      30.0000, -0.170729000E+01,  0.743188904E-02,  0.129017752E+00, -0.370832390E-02 }, 
{     165.0000,      30.0000, -0.232595000E+01, -0.410263442E-01,  0.816818666E-01, -0.128879225E-04 }, 
{     180.0000,      30.0000, -0.246944000E+01,  0.424348770E-02,  0.118171667E+00,  0.159065861E-02 }, 
{    -180.0000,      45.0000, -0.672750000E+00, -0.319066402E-02,  0.119375249E+00, -0.106876145E-02 }, 
{    -165.0000,      45.0000, -0.678300000E+00,  0.117642180E-03,  0.113424481E+00, -0.268784064E-03 }, 
{    -150.0000,      45.0000, -0.670780000E+00,  0.311409531E-02,  0.106345953E+00, -0.461961571E-03 }, 
{    -135.0000,      45.0000, -0.552320000E+00,  0.126219766E-01,  0.101648566E+00, -0.238552711E-03 }, 
{    -120.0000,      45.0000, -0.386650000E+00,  0.322399830E-02,  0.938132779E-01, -0.109036260E-02 }, 
{    -105.0000,      45.0000, -0.464600000E+00, -0.797396980E-02,  0.780119856E-01, -0.127312912E-03 }, 
{     -90.0000,      45.0000, -0.422370000E+00,  0.215278809E-01,  0.901320988E-01,  0.863378433E-03 }, 
{     -75.0000,      45.0000,  0.207200000E+00,  0.562224462E-01,  0.911932257E-01, -0.689952802E-03 }, 
{     -60.0000,      45.0000,  0.116243000E+01,  0.705423343E-01,  0.762787422E-01, -0.874238535E-03 }, 
{     -45.0000,      45.0000,  0.219151000E+01,  0.584702166E-01,  0.654738121E-01, -0.956975775E-03 }, 
{     -30.0000,      45.0000,  0.285045000E+01,  0.331807993E-01,  0.488910924E-01, -0.775388327E-03 }, 
{     -15.0000,      45.0000,  0.313379000E+01, -0.273741392E-02,  0.494128521E-01,  0.846337086E-03 }, 
{       0.0000,      45.0000,  0.278505000E+01, -0.353111437E-01,  0.582787999E-01, -0.732418525E-03 }, 
{      15.0000,      45.0000,  0.206071000E+01, -0.706340114E-01,  0.309176003E-01, -0.161571335E-02 }, 
{      30.0000,      45.0000,  0.776340000E+00, -0.838948107E-01,  0.254800492E-01,  0.635521791E-03 }, 
{      45.0000,      45.0000, -0.245760000E+00, -0.550807458E-01,  0.447320586E-01,  0.183651786E-02 }, 
{      60.0000,      45.0000, -0.878440000E+00, -0.267382060E-01,  0.733871591E-01,  0.159982875E-02 }, 
{      75.0000,      45.0000, -0.106430000E+01, -0.167443020E-02,  0.921291158E-01,  0.124357858E-02 }, 
{      90.0000,      45.0000, -0.995380000E+00,  0.100479268E-01,  0.118344779E+00,  0.241738097E-02 }, 
{     105.0000,      45.0000, -0.809220000E+00,  0.124987230E-01,  0.148417041E+00,  0.344482652E-03 }, 
{     120.0000,      45.0000, -0.514700000E+00,  0.360931811E-01,  0.133545526E+00, -0.755162216E-03 }, 
{     135.0000,      45.0000, -0.110600000E-01,  0.276055264E-02,  0.123140705E+00, -0.237910104E-02 }, 
{     150.0000,      45.0000, -0.422000000E+00, -0.285953916E-01,  0.833986107E-01,  0.242183284E-03 }, 
{     165.0000,      45.0000, -0.592120000E+00, -0.459098608E-02,  0.126116248E+00,  0.200547648E-02 }, 
{     180.0000,      45.0000, -0.672750000E+00, -0.319066402E-02,  0.119375249E+00, -0.106876145E-02 }, 
{    -180.0000,      60.0000,  0.941330000E+00, -0.118186959E-01,  0.864813358E-01, -0.528049530E-03 }, 
{    -165.0000,      60.0000,  0.785810000E+00, -0.671691445E-02,  0.792567711E-01, -0.272066428E-03 }, 
{    -150.0000,      60.0000,  0.753670000E+00,  0.115435368E-02,  0.779758225E-01, -0.847874161E-04 }, 
{    -135.0000,      60.0000,  0.793510000E+00,  0.363949971E-02,  0.728150673E-01, -0.677124676E-03 }, 
{    -120.0000,      60.0000,  0.779350000E+00, -0.105763525E-01,  0.598527289E-01, -0.831332603E-03 }, 
{    -105.0000,      60.0000,  0.577690000E+00, -0.449808959E-02,  0.540276783E-01,  0.244977304E-03 }, 
{     -90.0000,      60.0000,  0.792500000E+00,  0.311987109E-01,  0.602998892E-01, -0.591445554E-04 }, 
{     -75.0000,      60.0000,  0.136042000E+01,  0.362492460E-01,  0.508266807E-01, -0.648598607E-03 }, 
{     -60.0000,      60.0000,  0.194715000E+01,  0.547343051E-01,  0.419321336E-01, -0.102001214E-02 }, 
{     -45.0000,      60.0000,  0.289718000E+01,  0.521655336E-01,  0.238295275E-01, -0.670783470E-03 }, 
{     -30.0000,      60.0000,  0.340120000E+01,  0.274135603E-01,  0.285893253E-01,  0.103458437E-02 }, 
{     -15.0000,      60.0000,  0.378367000E+01,  0.154782250E-01,  0.395639370E-01, -0.320672099E-03 }, 
{       0.0000,      60.0000,  0.354214000E+01, -0.611384605E-01,  0.178435471E-01, -0.190105162E-02 }, 
{      15.0000,      60.0000,  0.219742000E+01, -0.881743830E-01,  0.491270224E-02,  0.994631622E-03 }, 
{      30.0000,      60.0000,  0.124745000E+01, -0.451020075E-01,  0.442302068E-01,  0.319985707E-02 }, 
{      45.0000,      60.0000,  0.745720000E+00, -0.217575869E-01,  0.850840218E-01,  0.224020402E-02 }, 
{      60.0000,      60.0000,  0.565770000E+00, -0.420364491E-02,  0.115428502E+00,  0.207898581E-02 }, 
{      75.0000,      60.0000,  0.575620000E+00,  0.455216651E-02,  0.133011244E+00, -0.970702764E-03 }, 
{      90.0000,      60.0000,  0.796280000E+00,  0.320969788E-01,  0.932669656E-01, -0.262848195E-02 }, 
{     105.0000,      60.0000,  0.125994000E+01,  0.392391810E-02,  0.710163545E-01, -0.914347376E-03 }, 
{     120.0000,      60.0000,  0.944110000E+00, -0.182266512E-01,  0.548008026E-01, -0.140736114E-02 }, 
{     135.0000,      60.0000,  0.962110000E+00,  0.941668687E-02,  0.465668549E-01,  0.165389201E-02 }, 
{     150.0000,      60.0000,  0.106365000E+01,  0.446790378E-02,  0.915758056E-01,  0.214679372E-02 }, 
{     165.0000,      60.0000,  0.107716000E+01, -0.427830197E-02,  0.944751415E-01, -0.659409537E-03 }, 
{     180.0000,      60.0000,  0.941330000E+00, -0.118186959E-01,  0.864813358E-01, -0.528049530E-03 }, 
{    -180.0000,      75.0000,  0.180621000E+01, -0.179152915E-01,  0.304914073E-01,  0.236034070E-03 }, 
{    -165.0000,      75.0000,  0.164225000E+01, -0.530303019E-02,  0.336584345E-01,  0.272915304E-03 }, 
{    -150.0000,      75.0000,  0.159747000E+01, -0.262058772E-02,  0.354007569E-01, -0.345825371E-03 }, 
{    -135.0000,      75.0000,  0.153314000E+01, -0.603661891E-02,  0.241831652E-01, -0.784667687E-03 }, 
{    -120.0000,      75.0000,  0.136656000E+01, -0.194149366E-01,  0.174178065E-01, -0.112093968E-03 }, 
{    -105.0000,      75.0000,  0.109103000E+01, -0.472563462E-02,  0.170033011E-01, -0.202929268E-03 }, 
{     -90.0000,      75.0000,  0.127852000E+01,  0.207094751E-01,  0.884634444E-02, -0.790481374E-03 }, 
{     -75.0000,      75.0000,  0.166472000E+01,  0.366257343E-01, -0.299594853E-02, -0.634995160E-03 }, 
{     -60.0000,      75.0000,  0.231976000E+01,  0.410355879E-01, -0.125412766E-01, -0.947062185E-03 }, 
{     -45.0000,      75.0000,  0.286443000E+01,  0.391739143E-01, -0.262079221E-01, -0.219150812E-03 }, 
{     -30.0000,      75.0000,  0.357523000E+01,  0.533627551E-01, -0.182923937E-01,  0.673442010E-03 }, 
{     -15.0000,      75.0000,  0.406613000E+01, -0.122849347E-01, -0.212006002E-01, -0.147315285E-02 }, 
{       0.0000,      75.0000,  0.324329000E+01, -0.706110162E-01, -0.380049882E-01,  0.127665051E-02 }, 
{      15.0000,      75.0000,  0.240295000E+01, -0.379070006E-01,  0.178795908E-01,  0.418258903E-02 }, 
{      30.0000,      75.0000,  0.213049000E+01, -0.320981507E-03,  0.684291238E-01,  0.327981578E-02 }, 
{      45.0000,      75.0000,  0.221268000E+01,  0.113692661E-02,  0.106619854E+00,  0.446200540E-03 }, 
{      60.0000,      75.0000,  0.217320000E+01,  0.431527508E-02,  0.752268346E-01, -0.370507576E-02 }, 
{      75.0000,      75.0000,  0.216375000E+01, -0.281840269E-01,  0.214359073E-01, -0.266268687E-02 }, 
{      90.0000,      75.0000,  0.143311000E+01, -0.395971674E-01, -0.571464167E-02, -0.183247201E-02 }, 
{     105.0000,      75.0000,  0.122509000E+01, -0.115930349E-02, -0.256204595E-01,  0.581301545E-03 }, 
{     120.0000,      75.0000,  0.129208000E+01,  0.160283814E-01,  0.860726336E-02,  0.237164683E-02 }, 
{     135.0000,      75.0000,  0.168691000E+01,  0.294097781E-01,  0.301858754E-01,  0.109337810E-02 }, 
{     150.0000,      75.0000,  0.203556000E+01,  0.150285064E-01,  0.418101668E-01, -0.104578533E-03 }, 
{     165.0000,      75.0000,  0.208080000E+01, -0.107458037E-01,  0.305671859E-01, -0.598801855E-03 }, 
{     180.0000,      75.0000,  0.180621000E+01, -0.179152915E-01,  0.304914073E-01,  0.236034070E-03 }, 
{    -180.0000,      90.0000,  0.190401000E+01, -0.543857760E-02, -0.159109652E-01,  0.859936910E-03 }, 
{    -165.0000,      90.0000,  0.182118000E+01, -0.156164601E-02, -0.681650924E-02,  0.211458900E-03 }, 
{    -150.0000,      90.0000,  0.181755000E+01, -0.560683837E-02, -0.680285022E-02,  0.115850488E-03 }, 
{    -135.0000,      90.0000,  0.162671000E+01, -0.149050005E-01, -0.290772809E-02,  0.106895379E-03 }, 
{    -120.0000,      90.0000,  0.141199000E+01, -0.158851596E-01, -0.299595489E-02,  0.217947063E-03 }, 
{    -105.0000,      90.0000,  0.117449000E+01, -0.119983611E-01, -0.268088265E-02, -0.933314543E-03 }, 
{     -90.0000,      90.0000,  0.113012000E+01,  0.750460415E-02, -0.281612669E-01, -0.151775130E-02 }, 
{     -75.0000,      90.0000,  0.133310000E+01,  0.137019446E-01, -0.443068866E-01, -0.132088104E-02 }, 
{     -60.0000,      90.0000,  0.157482000E+01,  0.266276176E-01, -0.662330273E-01, -0.813076607E-03 }, 
{     -45.0000,      90.0000,  0.215793000E+01,  0.447535849E-01, -0.668478391E-01,  0.649969627E-04 }, 
{     -30.0000,      90.0000,  0.279428000E+01,  0.382500429E-01, -0.768037506E-01, -0.156105590E-02 }, 
{     -15.0000,      90.0000,  0.309474000E+01, -0.103917564E-01, -0.925475362E-01,  0.103928723E-02 }, 
{       0.0000,      90.0000,  0.265047000E+01, -0.254450173E-01, -0.441575944E-01,  0.393313825E-02 }, 
{      15.0000,      90.0000,  0.262493000E+01,  0.182098255E-01,  0.907093473E-02,  0.355185397E-02 }, 
{      30.0000,      90.0000,  0.309673000E+01,  0.418577153E-01,  0.519092982E-01,  0.107282438E-02 }, 
{      45.0000,      90.0000,  0.345522000E+01, -0.195826867E-01,  0.303365616E-01, -0.359002614E-02 }, 
{      60.0000,      90.0000,  0.245075000E+01, -0.927229686E-01, -0.393398402E-01, -0.496254751E-02 }, 
{      75.0000,      90.0000,  0.123397000E+01, -0.537754389E-01, -0.870848733E-01, -0.440708128E-04 }, 
{      90.0000,      90.0000,  0.905620000E+00, -0.120127594E-02, -0.485403989E-01,  0.329871901E-02 }, 
{     105.0000,      90.0000,  0.102391000E+01,  0.165685426E-01, -0.157405166E-01,  0.111806610E-02 }, 
{     120.0000,      90.0000,  0.135280000E+01,  0.243631054E-01, -0.749185607E-02,  0.438725150E-03 }, 
{     135.0000,      90.0000,  0.179055000E+01,  0.393070356E-01, -0.162235629E-02, -0.493346347E-04 }, 
{     150.0000,      90.0000,  0.229924000E+01,  0.769675199E-02, -0.116984727E-01, -0.108270994E-02 }, 
{     165.0000,      90.0000,  0.203939000E+01, -0.203260436E-01, -0.242978851E-01, -0.154931367E-03 }, 
{     180.0000,      90.0000,  0.190401000E+01, -0.543857760E-02, -0.159109652E-01,  0.859936910E-03 }, 
{    -180.0000,     105.0000,  0.142827000E+01,  0.380536841E-02, -0.424355465E-01,  0.668350277E-03 }, 
{    -165.0000,     105.0000,  0.153133000E+01,  0.320048837E-02, -0.285763976E-01,  0.581952807E-03 }, 
{    -150.0000,     105.0000,  0.150886000E+01, -0.489321899E-03, -0.259113560E-01,  0.308676584E-03 }, 
{    -135.0000,     105.0000,  0.151499000E+01, -0.451120078E-02, -0.161822529E-01,  0.662169799E-03 }, 
{    -120.0000,     105.0000,  0.133189000E+01, -0.168598750E-01, -0.123679869E-01, -0.248681960E-03 }, 
{    -105.0000,     105.0000,  0.102077000E+01, -0.268932992E-01, -0.203317705E-01, -0.497345483E-03 }, 
{     -90.0000,     105.0000,  0.604700000E+00, -0.210049280E-01, -0.309652767E-01, -0.148139405E-02 }, 
{     -75.0000,     105.0000,  0.460270000E+00, -0.118698860E-02, -0.606665052E-01, -0.164402524E-02 }, 
{     -60.0000,     105.0000,  0.550650000E+00,  0.149428824E-01, -0.763486141E-01, -0.101917248E-02 }, 
{     -45.0000,     105.0000,  0.924860000E+00,  0.343334589E-01, -0.943147214E-01, -0.100892811E-02 }, 
{     -30.0000,     105.0000,  0.143567000E+01,  0.247272820E-01, -0.102404604E+00, -0.156313051E-03 }, 
{     -15.0000,     105.0000,  0.165224000E+01,  0.122334133E-01, -0.913872552E-01,  0.221967356E-02 }, 
{       0.0000,     105.0000,  0.195317000E+01,  0.298390649E-01, -0.433886343E-01,  0.308081273E-02 }, 
{      15.0000,     105.0000,  0.265211000E+01,  0.683843270E-01, -0.433132968E-02,  0.286826061E-02 }, 
{      30.0000,     105.0000,  0.358847000E+01,  0.236836270E-01,  0.155296835E-01, -0.277019160E-02 }, 
{      45.0000,     105.0000,  0.298189000E+01, -0.971628351E-01, -0.741241004E-01, -0.574604834E-02 }, 
{      60.0000,     105.0000,  0.122814000E+01, -0.107098287E+00, -0.106879474E+00,  0.127255346E-02 }, 
{      75.0000,     105.0000,  0.208210000E+00, -0.291800187E-01, -0.642044140E-01,  0.263977177E-02 }, 
{      90.0000,     105.0000,  0.200840000E+00,  0.183583614E-01, -0.465777628E-01,  0.228701707E-03 }, 
{     105.0000,     105.0000,  0.564750000E+00,  0.270545732E-01, -0.434854741E-01,  0.589209395E-03 }, 
{     120.0000,     105.0000,  0.103764000E+01,  0.407833458E-01, -0.295278391E-01,  0.824445454E-03 }, 
{     135.0000,     105.0000,  0.164917000E+01,  0.266960437E-01, -0.312444502E-01, -0.143878644E-02 }, 
{     150.0000,     105.0000,  0.172204000E+01, -0.106875204E-01, -0.577202759E-01, -0.707787074E-03 }, 
{     165.0000,     105.0000,  0.150406000E+01, -0.129679620E-01, -0.487236455E-01,  0.774095670E-03 }, 
{     180.0000,     105.0000,  0.142827000E+01,  0.380536841E-02, -0.424355465E-01,  0.668350277E-03 }, 
{    -180.0000,     120.0000,  0.762820000E+00,  0.163742667E-01, -0.425848488E-01,  0.829230845E-03 }, 
{    -165.0000,     120.0000,  0.105012000E+01,  0.148966725E-01, -0.330899005E-01,  0.752393579E-03 }, 
{    -150.0000,     120.0000,  0.115910000E+01,  0.329504315E-02, -0.212417256E-01,  0.429819479E-03 }, 
{    -135.0000,     120.0000,  0.116949000E+01, -0.420284513E-02, -0.238072605E-01, -0.615143498E-03 }, 
{    -120.0000,     120.0000,  0.972890000E+00, -0.237256626E-01, -0.353520973E-01, -0.791319833E-03 }, 
{    -105.0000,     120.0000,  0.545500000E+00, -0.256925043E-01, -0.417900354E-01,  0.183867845E-03 }, 
{     -90.0000,     120.0000,  0.188030000E+00, -0.304763202E-01, -0.363956263E-01, -0.152857345E-03 }, 
{     -75.0000,     120.0000, -0.357550000E+00, -0.330122151E-01, -0.511570928E-01, -0.144584994E-02 }, 
{     -60.0000,     120.0000, -0.644870000E+00, -0.405481946E-02, -0.723105164E-01, -0.124672091E-02 }, 
{     -45.0000,     120.0000, -0.497870000E+00,  0.211674929E-01, -0.870532753E-01, -0.746502917E-03 }, 
{     -30.0000,     120.0000, -0.796400000E-01,  0.324308477E-01, -0.883618340E-01,  0.102246906E-02 }, 
{     -15.0000,     120.0000,  0.511320000E+00,  0.509471163E-01, -0.585874432E-01,  0.234979309E-02 }, 
{       0.0000,     120.0000,  0.140660000E+01,  0.610286871E-01, -0.310618683E-01,  0.103835171E-02 }, 
{      15.0000,     120.0000,  0.247433000E+01,  0.975401352E-01, -0.218656160E-01,  0.841165530E-03 }, 
{      30.0000,     120.0000,  0.349117000E+01, -0.342752278E-01, -0.351400321E-01, -0.521864658E-02 }, 
{      45.0000,     120.0000,  0.142775000E+01, -0.169755224E+00, -0.139334160E+00, -0.346028800E-02 }, 
{      60.0000,     120.0000, -0.446240000E+00, -0.741858758E-01, -0.112540264E+00,  0.357975222E-02 }, 
{      75.0000,     120.0000, -0.870220000E+00,  0.690472738E-02, -0.769354706E-01,  0.162101699E-02 }, 
{      90.0000,     120.0000, -0.558680000E+00,  0.240789663E-01, -0.580085500E-01,  0.842522608E-03 }, 
{     105.0000,     120.0000, -0.175780000E+00,  0.356674074E-01, -0.502555872E-01,  0.344869276E-03 }, 
{     120.0000,     120.0000,  0.467670000E+00,  0.385214041E-01, -0.514227876E-01, -0.904847238E-03 }, 
{     135.0000,     120.0000,  0.803020000E+00,  0.600697629E-02, -0.709058430E-01, -0.855531490E-03 }, 
{     150.0000,     120.0000,  0.735360000E+00, -0.901130923E-02, -0.701964236E-01,  0.572245991E-03 }, 
{     165.0000,     120.0000,  0.650490000E+00, -0.467739370E-03, -0.585875330E-01,  0.103020953E-02 }, 
{     180.0000,     120.0000,  0.762820000E+00,  0.163742667E-01, -0.425848488E-01,  0.829230845E-03 }, 
{    -180.0000,     135.0000,  0.221370000E+00,  0.262012513E-01, -0.286050584E-01,  0.493902929E-03 }, 
{    -165.0000,     135.0000,  0.599000000E+00,  0.213730772E-01, -0.255300005E-01,  0.429906467E-04 }, 
{    -150.0000,     135.0000,  0.821760000E+00,  0.838443979E-02, -0.265417416E-01, -0.253202162E-03 }, 
{    -135.0000,     135.0000,  0.789610000E+00, -0.167888364E-01, -0.336647051E-01, -0.657122929E-03 }, 
{    -120.0000,     135.0000,  0.350590000E+00, -0.354630943E-01, -0.424836238E-01, -0.306682559E-03 }, 
{    -105.0000,     135.0000, -0.143530000E+00, -0.279867866E-01, -0.453680878E-01, -0.456823362E-03 }, 
{     -90.0000,     135.0000, -0.548820000E+00, -0.324717595E-01, -0.541562181E-01, -0.200542849E-03 }, 
{     -75.0000,     135.0000, -0.111846000E+01, -0.371121756E-01, -0.504511236E-01,  0.242387587E-03 }, 
{     -60.0000,     135.0000, -0.154005000E+01, -0.173255381E-01, -0.525493204E-01, -0.447627975E-03 }, 
{     -45.0000,     135.0000, -0.157764000E+01,  0.145783280E-01, -0.579721772E-01,  0.439135867E-04 }, 
{     -30.0000,     135.0000, -0.108446000E+01,  0.501302262E-01, -0.481740603E-01,  0.114702565E-02 }, 
{     -15.0000,     135.0000, -0.134090000E+00,  0.736107672E-01, -0.315289720E-01,  0.656624863E-03 }, 
{       0.0000,     135.0000,  0.101469000E+01,  0.752567051E-01, -0.200598924E-01,  0.184930847E-02 }, 
{      15.0000,     135.0000,  0.208125000E+01,  0.684304125E-01, -0.223782063E-01, -0.622370562E-02 }, 
{      30.0000,     135.0000,  0.215102000E+01, -0.121712355E+00, -0.162459555E+00, -0.543441851E-02 }, 
{      45.0000,     135.0000, -0.873170000E+00, -0.172464992E+00, -0.139551260E+00,  0.452676899E-02 }, 
{      60.0000,     135.0000, -0.199291000E+01, -0.172136775E-01, -0.871694706E-01,  0.238535946E-02 }, 
{      75.0000,     135.0000, -0.197985000E+01,  0.199837020E-01, -0.656657034E-01,  0.708904414E-03 }, 
{      90.0000,     135.0000, -0.148283000E+01,  0.392948697E-01, -0.581220373E-01,  0.588509529E-03 }, 
{     105.0000,     135.0000, -0.914940000E+00,  0.358188192E-01, -0.514301773E-01, -0.215837299E-03 }, 
{     120.0000,     135.0000, -0.453720000E+00,  0.232518535E-01, -0.630530105E-01, -0.711354965E-03 }, 
{     135.0000,     135.0000, -0.251200000E+00,  0.392176690E-02, -0.652061779E-01,  0.306057047E-03 }, 
{     150.0000,     135.0000, -0.250690000E+00,  0.166707891E-02, -0.560400295E-01,  0.889722976E-03 }, 
{     165.0000,     135.0000, -0.115070000E+00,  0.166359174E-01, -0.407522227E-01,  0.102584208E-02 }, 
{     180.0000,     135.0000,  0.221370000E+00,  0.262012513E-01, -0.286050584E-01,  0.493902929E-03 }, 
{    -180.0000,     150.0000, -0.548700000E-01,  0.290601283E-01, -0.653291777E-02, -0.267670239E-03 }, 
{    -165.0000,     150.0000,  0.300070000E+00,  0.154950266E-01, -0.148000976E-01, -0.804685346E-03 }, 
{    -150.0000,     150.0000,  0.373940000E+00, -0.527823486E-02, -0.296233081E-01, -0.113166643E-02 }, 
{    -135.0000,     150.0000,  0.157920000E+00, -0.228120872E-01, -0.438479190E-01, -0.478213201E-03 }, 
{    -120.0000,     150.0000, -0.275020000E+00, -0.332654163E-01, -0.442954076E-01,  0.110099333E-03 }, 
{    -105.0000,     150.0000, -0.796930000E+00, -0.350962475E-01, -0.452236135E-01, -0.237323034E-03 }, 
{     -90.0000,     150.0000, -0.132072000E+01, -0.354895938E-01, -0.487295015E-01, -0.476259807E-04 }, 
{     -75.0000,     150.0000, -0.185418000E+01, -0.343953775E-01, -0.463644127E-01,  0.199667112E-03 }, 
{     -60.0000,     150.0000, -0.227657000E+01, -0.180988963E-01, -0.438322019E-01,  0.228417443E-03 }, 
{     -45.0000,     150.0000, -0.228172000E+01,  0.212829627E-01, -0.378280157E-01,  0.593942522E-03 }, 
{     -30.0000,     150.0000, -0.160792000E+01,  0.666970455E-01, -0.245979248E-01,  0.124266789E-02 }, 
{     -15.0000,     150.0000, -0.475030000E+00,  0.732668553E-01, -0.125666689E-01, -0.512344737E-03 }, 
{       0.0000,     150.0000,  0.681970000E+00,  0.982135332E-01, -0.336245620E-01, -0.998616383E-03 }, 
{      15.0000,     150.0000,  0.160921000E+01, -0.492729882E-01, -0.616455588E-01, -0.530896770E-02 }, 
{      30.0000,     150.0000, -0.655940000E+00, -0.168703581E+00, -0.144443748E+00,  0.706500770E-04 }, 
{      45.0000,     150.0000, -0.236553000E+01, -0.708606897E-01, -0.611168011E-01,  0.513211893E-02 }, 
{      60.0000,     150.0000, -0.295919000E+01, -0.850366059E-02, -0.413718538E-01,  0.152529711E-04 }, 
{      75.0000,     150.0000, -0.273078000E+01,  0.318253321E-01, -0.325137156E-01,  0.527486298E-03 }, 
{      90.0000,     150.0000, -0.217397000E+01,  0.382463322E-01, -0.325613007E-01, -0.363087539E-03 }, 
{     105.0000,     150.0000, -0.165041000E+01,  0.312633390E-01, -0.389497036E-01, -0.362333756E-03 }, 
{     120.0000,     150.0000, -0.125474000E+01,  0.205463117E-01, -0.408471704E-01,  0.155248622E-03 }, 
{     135.0000,     150.0000, -0.102443000E+01,  0.117474142E-01, -0.337594456E-01,  0.779390888E-03 }, 
{     150.0000,     150.0000, -0.834180000E+00,  0.165760314E-01, -0.195514583E-01,  0.986330237E-03 }, 
{     165.0000,     150.0000, -0.496390000E+00,  0.275564601E-01, -0.777957622E-02,  0.471262029E-03 }, 
{     180.0000,     150.0000, -0.548700000E-01,  0.290601283E-01, -0.653291777E-02, -0.267670239E-03 }, 
{    -180.0000,     165.0000, -0.304300000E-01,  0.179657892E-01,  0.437672944E-02, -0.107031439E-02 }, 
{    -165.0000,     165.0000,  0.101460000E+00, -0.217884100E-03, -0.147776092E-01, -0.114244153E-02 }, 
{    -150.0000,     165.0000, -0.405500000E-01, -0.191182528E-01, -0.274270262E-01, -0.720670634E-03 }, 
{    -135.0000,     165.0000, -0.441660000E+00, -0.319331045E-01, -0.371976189E-01, -0.458877893E-03 }, 
{    -120.0000,     165.0000, -0.949890000E+00, -0.350173291E-01, -0.404307459E-01, -0.445617408E-04 }, 
{    -105.0000,     165.0000, -0.147132000E+01, -0.339295791E-01, -0.392954582E-01,  0.217556996E-03 }, 
{     -90.0000,     165.0000, -0.196898000E+01, -0.330823546E-01, -0.349577760E-01,  0.268927741E-03 }, 
{     -75.0000,     165.0000, -0.245910000E+01, -0.312970025E-01, -0.322192255E-01,  0.121978586E-03 }, 
{     -60.0000,     165.0000, -0.282977000E+01, -0.138876354E-01, -0.300658719E-01,  0.221538743E-03 }, 
{     -45.0000,     165.0000, -0.272832000E+01,  0.330035440E-01, -0.208517600E-01,  0.126535954E-02 }, 
{     -30.0000,     165.0000, -0.185441000E+01,  0.769454592E-01, -0.742424042E-02, -0.754650614E-03 }, 
{     -15.0000,     165.0000, -0.593280000E+00,  0.862226190E-01, -0.100423523E-01,  0.391512446E-02 }, 
{       0.0000,     165.0000,  0.475830000E+00,  0.442120646E-01,  0.467861405E-01, -0.406377104E-02 }, 
{      15.0000,     165.0000,  0.286540000E+00, -0.871068774E-01, -0.899815585E-01, -0.364788156E-02 }, 
{      30.0000,     165.0000, -0.166034000E+01, -0.123018555E+00, -0.220374546E-01,  0.489057827E-02 }, 
{      45.0000,     165.0000, -0.285897000E+01, -0.499209032E-01, -0.131415358E-01, -0.546426966E-03 }, 
{      60.0000,     165.0000, -0.327921000E+01, -0.107183243E-02, -0.460311419E-02,  0.781997672E-03 }, 
{      75.0000,     165.0000, -0.296238000E+01,  0.335262329E-01, -0.785434241E-03, -0.110343413E-03 }, 
{      90.0000,     165.0000, -0.244752000E+01,  0.333049008E-01, -0.457075991E-02, -0.334153164E-03 }, 
{     105.0000,     165.0000, -0.199117000E+01,  0.274961640E-01, -0.801700813E-02,  0.641290148E-06 }, 
{     120.0000,     165.0000, -0.160564000E+01,  0.250864431E-01, -0.394230792E-02,  0.457278400E-03 }, 
{     135.0000,     165.0000, -0.122723000E+01,  0.249460637E-01,  0.503796008E-02,  0.781238752E-03 }, 
{     150.0000,     165.0000, -0.842880000E+00,  0.276813023E-01,  0.158078629E-01,  0.367800754E-03 }, 
{     165.0000,     165.0000, -0.402820000E+00,  0.292107271E-01,  0.143205276E-01, -0.395928263E-03 }, 
{     180.0000,     165.0000, -0.304300000E-01,  0.179657892E-01,  0.437672944E-02, -0.107031439E-02 }, 
{    -180.0000,     180.0000,  0.000000000E+00,  0.552257112E-05,  0.000000000E+00, -0.126199335E-02 }, 
{    -165.0000,     180.0000, -0.159180000E+00, -0.166906548E-01, -0.179394657E-01, -0.106268484E-02 }, 
{    -150.0000,     180.0000, -0.469240000E+00, -0.270909033E-01, -0.293045871E-01, -0.348184728E-03 }, 
{    -135.0000,     180.0000, -0.948870000E+00, -0.328837318E-01, -0.287196052E-01,  0.299395850E-03 }, 
{    -120.0000,     180.0000, -0.141919000E+01, -0.313641693E-01, -0.228156086E-01,  0.448397027E-03 }, 
{    -105.0000,     180.0000, -0.189608000E+01, -0.311015908E-01, -0.174245535E-01,  0.166026389E-03 }, 
{     -90.0000,     180.0000, -0.235024000E+01, -0.304394676E-01, -0.173433944E-01, -0.180597422E-04 }, 
{     -75.0000,     180.0000, -0.281648000E+01, -0.312205390E-01, -0.172186852E-01, -0.526137649E-04 }, 
{     -60.0000,     180.0000, -0.317758000E+01, -0.101463764E-01, -0.161063106E-01,  0.475931576E-03 }, 
{     -45.0000,     180.0000, -0.291092000E+01,  0.529180444E-01, -0.460494424E-02,  0.671635664E-03 }, 
{     -30.0000,     180.0000, -0.184916000E+01,  0.641581986E-01,  0.604688652E-02,  0.126816519E-02 }, 
{     -15.0000,     180.0000, -0.618680000E+00,  0.148897161E+00,  0.240060782E-01, -0.220919394E-04 }, 
{       0.0000,     180.0000,  0.144957000E+01, -0.843083945E-06, -0.138777878E-16, -0.238917474E-02 }, 
{      15.0000,     180.0000, -0.618680000E+00, -0.148893789E+00, -0.240062071E-01, -0.236661683E-04 }, 
{      30.0000,     180.0000, -0.184916000E+01, -0.641700018E-01, -0.605043409E-02,  0.127375259E-02 }, 
{      45.0000,     180.0000, -0.291092000E+01, -0.528742041E-01,  0.460494424E-02,  0.650886067E-03 }, 
{      60.0000,     180.0000, -0.317758000E+01,  0.998281807E-02,  0.161063106E-01,  0.554052075E-03 }, 
{      75.0000,     180.0000, -0.281793000E+01,  0.315409318E-01,  0.182254525E-01, -0.142992706E-03 }, 
{      90.0000,     180.0000, -0.234954000E+01,  0.294614547E-01,  0.157303403E-01, -0.572753043E-04 }, 
{     105.0000,     180.0000, -0.191578000E+01,  0.310432493E-01,  0.179437362E-01,  0.315750647E-03 }, 
{     120.0000,     180.0000, -0.141919000E+01,  0.324355481E-01,  0.237264021E-01,  0.393485071E-03 }, 
{     135.0000,     180.0000, -0.948870000E+00,  0.325965581E-01,  0.287196052E-01,  0.265482885E-03 }, 
{     150.0000,     180.0000, -0.469240000E+00,  0.271682193E-01,  0.293080068E-01, -0.339095672E-03 }, 
{     165.0000,     180.0000, -0.159180000E+00,  0.166685645E-01,  0.179394658E-01, -0.106512808E-02 }, 
{     180.0000,     180.0000,  0.000000000E+00,  0.552257112E-05,  0.000000000E+00, -0.126199335E-02 } },
{
{    -180.0000,    -180.0000, -0.146854000E+01,  0.491175487E-02,  0.195601580E-02, -0.163177030E-02 }, 
{    -165.0000,    -180.0000, -0.171132000E+01, -0.337083049E-01, -0.211755104E-01, -0.128139745E-02 }, 
{    -150.0000,    -180.0000, -0.232191000E+01, -0.407525353E-01, -0.344179241E-01, -0.517427860E-03 }, 
{    -135.0000,    -180.0000, -0.282200000E+01, -0.254175539E-01, -0.363754505E-01,  0.311120885E-03 }, 
{    -120.0000,    -180.0000, -0.309109000E+01, -0.114132491E-01, -0.276071493E-01,  0.635099272E-03 }, 
{    -105.0000,    -180.0000, -0.317704000E+01,  0.625502477E-04, -0.197338807E-01,  0.476795981E-03 }, 
{     -90.0000,    -180.0000, -0.316347000E+01, -0.331295190E-02, -0.155748405E-01, -0.135821438E-03 }, 
{     -75.0000,    -180.0000, -0.331935000E+01, -0.152727426E-01, -0.211457600E-01, -0.215886083E-03 }, 
{     -60.0000,    -180.0000, -0.357978000E+01, -0.188580776E-01, -0.188846883E-01,  0.337396219E-03 }, 
{     -45.0000,    -180.0000, -0.373419000E+01,  0.773705294E-02, -0.117897439E-01,  0.737504418E-03 }, 
{     -30.0000,    -180.0000, -0.344056000E+01,  0.157538658E-01, -0.773055529E-02, -0.105658729E-02 }, 
{     -15.0000,    -180.0000, -0.291290000E+01,  0.935054838E-01, -0.276036546E-01,  0.326062604E-03 }, 
{       0.0000,    -180.0000, -0.140592000E+01,  0.171521990E-01, -0.539799978E-02,  0.218847975E-03 }, 
{      15.0000,    -180.0000, -0.256214000E+01, -0.919622797E-01, -0.280982308E-01, -0.130036975E-02 }, 
{      30.0000,    -180.0000, -0.329734000E+01, -0.275870801E-01, -0.272885790E-01,  0.604515175E-03 }, 
{      45.0000,    -180.0000, -0.349478000E+01,  0.157826001E-01, -0.207497125E-01,  0.352012717E-03 }, 
{      60.0000,    -180.0000, -0.286320000E+01,  0.512846799E-01, -0.166032592E-01,  0.124497929E-03 }, 
{      75.0000,    -180.0000, -0.226579000E+01,  0.248766805E-01, -0.157490408E-01,  0.150129902E-03 }, 
{      90.0000,    -180.0000, -0.214254000E+01, -0.665940194E-02, -0.107099019E-01,  0.453653923E-03 }, 
{     105.0000,    -180.0000, -0.242944000E+01, -0.309690728E-01, -0.149055264E-02,  0.886952040E-03 }, 
{     120.0000,    -180.0000, -0.290813000E+01, -0.225823070E-01,  0.154312849E-01,  0.122677527E-02 }, 
{     135.0000,    -180.0000, -0.294808000E+01,  0.175703009E-01,  0.307565334E-01,  0.655364064E-03 }, 
{     150.0000,    -180.0000, -0.245932000E+01,  0.420631034E-01,  0.333765482E-01, -0.259178877E-03 }, 
{     165.0000,    -180.0000, -0.182999000E+01,  0.377952854E-01,  0.233583295E-01, -0.109828932E-02 }, 
{     180.0000,    -180.0000, -0.146854000E+01,  0.491175487E-02,  0.195601580E-02, -0.163177030E-02 }, 
{    -180.0000,    -165.0000, -0.137589000E+01, -0.202380313E-01,  0.934575510E-02, -0.130135690E-02 }, 
{    -165.0000,    -165.0000, -0.194385000E+01, -0.509644305E-01, -0.836884785E-02, -0.903274625E-03 }, 
{    -150.0000,    -165.0000, -0.271993000E+01, -0.447122466E-01, -0.143235771E-01,  0.180588975E-03 }, 
{    -135.0000,    -165.0000, -0.317264000E+01, -0.159445829E-01, -0.451221178E-02,  0.952245941E-03 }, 
{    -120.0000,    -165.0000, -0.325398000E+01,  0.168057832E-02,  0.100731645E-01,  0.889775578E-03 }, 
{    -105.0000,    -165.0000, -0.319334000E+01,  0.508226963E-02,  0.184187189E-01,  0.748378854E-04 }, 
{     -90.0000,    -165.0000, -0.317385000E+01, -0.598365685E-02,  0.157614869E-01, -0.514626399E-04 }, 
{     -75.0000,    -165.0000, -0.338265000E+01, -0.190096422E-01,  0.161450415E-01, -0.323722798E-03 }, 
{     -60.0000,    -165.0000, -0.366037000E+01, -0.152817742E-01,  0.992242200E-02,  0.178540850E-03 }, 
{     -45.0000,    -165.0000, -0.377497000E+01,  0.167273915E-02,  0.711411094E-02, -0.219662672E-02 }, 
{     -30.0000,    -165.0000, -0.359488000E+01,  0.216888176E-01, -0.136138679E-01,  0.390070805E-02 }, 
{     -15.0000,    -165.0000, -0.303260000E+01,  0.600459903E-01,  0.703507621E-01, -0.758875239E-03 }, 
{       0.0000,    -165.0000, -0.223489000E+01,  0.101252211E-01, -0.288875412E-01, -0.391994174E-02 }, 
{      15.0000,    -165.0000, -0.282694000E+01, -0.594148746E-01,  0.890879736E-03,  0.254666573E-02 }, 
{      30.0000,    -165.0000, -0.353012000E+01, -0.315117226E-01,  0.587866139E-04, -0.477455635E-03 }, 
{      45.0000,    -165.0000, -0.362752000E+01,  0.253457650E-01,  0.790529464E-02,  0.766039786E-03 }, 
{      60.0000,    -165.0000, -0.290549000E+01,  0.550546627E-01,  0.150830173E-01,  0.418142627E-03 }, 
{      75.0000,    -165.0000, -0.224790000E+01,  0.303595842E-01,  0.230505643E-01,  0.590443634E-03 }, 
{      90.0000,    -165.0000, -0.202431000E+01, -0.256999560E-03,  0.313710974E-01,  0.477698850E-03 }, 
{     105.0000,    -165.0000, -0.220106000E+01, -0.199635860E-01,  0.378747599E-01,  0.463600095E-03 }, 
{     120.0000,    -165.0000, -0.246619000E+01, -0.826465654E-02,  0.444005662E-01,  0.273794543E-03 }, 
{     135.0000,    -165.0000, -0.235440000E+01,  0.223542121E-01,  0.453050104E-01, -0.727281655E-04 }, 
{     150.0000,    -165.0000, -0.187193000E+01,  0.376998080E-01,  0.414698129E-01, -0.569032549E-03 }, 
{     165.0000,    -165.0000, -0.138645000E+01,  0.204365558E-01,  0.278676910E-01, -0.113860553E-02 }, 
{     180.0000,    -165.0000, -0.137589000E+01, -0.202380313E-01,  0.934575510E-02, -0.130135690E-02 }, 
{    -180.0000,    -150.0000, -0.115099000E+01, -0.310417390E-01,  0.241709638E-01, -0.353500842E-03 }, 
{    -165.0000,    -150.0000, -0.187041000E+01, -0.574382190E-01,  0.228329018E-01,  0.148513124E-03 }, 
{    -150.0000,    -150.0000, -0.263447000E+01, -0.359013849E-01,  0.292002323E-01,  0.765302051E-03 }, 
{    -135.0000,    -150.0000, -0.287523000E+01,  0.797584610E-04,  0.437782976E-01,  0.979357826E-03 }, 
{    -120.0000,    -150.0000, -0.276065000E+01,  0.103463510E-01,  0.534024913E-01,  0.157718437E-03 }, 
{    -105.0000,    -150.0000, -0.265655000E+01,  0.227083750E-02,  0.501570051E-01, -0.334490071E-03 }, 
{     -90.0000,    -150.0000, -0.269447000E+01, -0.619370101E-02,  0.463288929E-01, -0.234477824E-03 }, 
{     -75.0000,    -150.0000, -0.287999000E+01, -0.221840335E-01,  0.444375938E-01,  0.128519108E-03 }, 
{     -60.0000,    -150.0000, -0.325866000E+01, -0.179081652E-01,  0.434190003E-01, -0.861577134E-03 }, 
{     -45.0000,    -150.0000, -0.338680000E+01, -0.754530591E-02,  0.528113002E-01,  0.499253070E-02 }, 
{     -30.0000,    -150.0000, -0.297043000E+01,  0.105735389E+00,  0.156212027E+00,  0.345005969E-02 }, 
{     -15.0000,    -150.0000, -0.103367000E+01,  0.552297508E-01,  0.122046606E+00, -0.494570826E-02 }, 
{       0.0000,    -150.0000, -0.171478000E+01, -0.755243918E-01,  0.591761645E-01, -0.307439916E-02 }, 
{      15.0000,    -150.0000, -0.252395000E+01, -0.511881835E-01,  0.321727119E-01, -0.731473946E-03 }, 
{      30.0000,    -150.0000, -0.327577000E+01, -0.319208741E-01,  0.313674326E-01,  0.438548556E-03 }, 
{      45.0000,    -150.0000, -0.323972000E+01,  0.357176800E-01,  0.401405339E-01,  0.570844128E-03 }, 
{      60.0000,    -150.0000, -0.240665000E+01,  0.628741541E-01,  0.475811900E-01,  0.520826415E-03 }, 
{      75.0000,    -150.0000, -0.159834000E+01,  0.410617035E-01,  0.570367837E-01,  0.725100163E-03 }, 
{      90.0000,    -150.0000, -0.123549000E+01,  0.711103178E-02,  0.666355124E-01,  0.389637421E-03 }, 
{     105.0000,    -150.0000, -0.134347000E+01, -0.185318306E-01,  0.671855129E-01, -0.253903996E-03 }, 
{     120.0000,    -150.0000, -0.163936000E+01, -0.137577092E-01,  0.607204502E-01, -0.557033880E-03 }, 
{     135.0000,    -150.0000, -0.162896000E+01,  0.164646674E-01,  0.518474249E-01, -0.585578094E-03 }, 
{     150.0000,    -150.0000, -0.124795000E+01,  0.261810394E-01,  0.430182003E-01, -0.641103725E-03 }, 
{     165.0000,    -150.0000, -0.992700000E+00,  0.606317489E-02,  0.326289065E-01, -0.693710682E-03 }, 
{     180.0000,    -150.0000, -0.115099000E+01, -0.310417390E-01,  0.241709638E-01, -0.353500842E-03 }, 
{    -180.0000,    -135.0000, -0.623800000E+00, -0.318603942E-01,  0.443883896E-01,  0.390887695E-03 }, 
{    -165.0000,    -135.0000, -0.126193000E+01, -0.485337577E-01,  0.534212405E-01,  0.795356687E-03 }, 
{    -150.0000,    -135.0000, -0.187630000E+01, -0.245045749E-01,  0.662486477E-01,  0.799737166E-03 }, 
{    -135.0000,    -135.0000, -0.195058000E+01,  0.882205738E-02,  0.738110213E-01,  0.836508158E-04 }, 
{    -120.0000,    -135.0000, -0.179284000E+01,  0.590834540E-02,  0.685448703E-01, -0.675095911E-03 }, 
{    -105.0000,    -135.0000, -0.180435000E+01, -0.320943896E-02,  0.587512606E-01, -0.395219318E-03 }, 
{     -90.0000,    -135.0000, -0.188558000E+01, -0.116185895E-01,  0.565769414E-01, -0.137612603E-03 }, 
{     -75.0000,    -135.0000, -0.212688000E+01, -0.148222029E-01,  0.572585832E-01,  0.647134242E-03 }, 
{     -60.0000,    -135.0000, -0.234588000E+01, -0.211525990E-01,  0.792995768E-01,  0.209360273E-02 }, 
{     -45.0000,    -135.0000, -0.200096000E+01,  0.124616599E+00,  0.136442688E+00,  0.681527589E-02 }, 
{     -30.0000,    -135.0000,  0.485020000E+00,  0.888662031E-01,  0.204745760E+00, -0.426546969E-02 }, 
{     -15.0000,    -135.0000, -0.443000000E-02, -0.807754115E-01,  0.470968135E-01, -0.762257210E-02 }, 
{       0.0000,    -135.0000, -0.100421000E+01, -0.636105571E-01,  0.383188831E-01,  0.147038276E-02 }, 
{      15.0000,    -135.0000, -0.198371000E+01, -0.606383602E-01,  0.390642728E-01,  0.134532926E-03 }, 
{      30.0000,    -135.0000, -0.263328000E+01, -0.196500020E-01,  0.538394831E-01,  0.109560553E-02 }, 
{      45.0000,    -135.0000, -0.247979000E+01,  0.400223683E-01,  0.610785697E-01, -0.114095640E-03 }, 
{      60.0000,    -135.0000, -0.160032000E+01,  0.661525290E-01,  0.556262227E-01, -0.281875035E-03 }, 
{      75.0000,    -135.0000, -0.712370000E+00,  0.488515159E-01,  0.559083011E-01,  0.207542049E-03 }, 
{      90.0000,    -135.0000, -0.243680000E+00,  0.976940749E-02,  0.582128529E-01, -0.309671239E-04 }, 
{     105.0000,    -135.0000, -0.393000000E+00, -0.240551459E-01,  0.549951884E-01, -0.266296086E-03 }, 
{     120.0000,    -135.0000, -0.774170000E+00, -0.196468240E-01,  0.511216330E-01, -0.322092525E-03 }, 
{     135.0000,    -135.0000, -0.874290000E+00,  0.638444205E-02,  0.433272901E-01, -0.778913474E-03 }, 
{     150.0000,    -135.0000, -0.637980000E+00,  0.213470558E-01,  0.332473859E-01, -0.137102984E-03 }, 
{     165.0000,    -135.0000, -0.398740000E+00,  0.333733460E-02,  0.391586831E-01,  0.493604007E-03 }, 
{     180.0000,    -135.0000, -0.623800000E+00, -0.318603942E-01,  0.443883896E-01,  0.390887695E-03 }, 
{    -180.0000,    -120.0000,  0.786600000E-01, -0.198388571E-01,  0.442054776E-01,  0.103052643E-02 }, 
{    -165.0000,    -120.0000, -0.404460000E+00, -0.376487481E-01,  0.566721362E-01,  0.627954317E-03 }, 
{    -150.0000,    -120.0000, -0.847370000E+00, -0.147721505E-01,  0.632251769E-01,  0.261596155E-03 }, 
{    -135.0000,    -120.0000, -0.872280000E+00,  0.317335008E-02,  0.615676171E-01, -0.695242765E-03 }, 
{    -120.0000,    -120.0000, -0.889760000E+00, -0.639924982E-02,  0.465960275E-01, -0.806454958E-03 }, 
{    -105.0000,    -120.0000, -0.102383000E+01, -0.788635080E-02,  0.413819525E-01, -0.116070316E-03 }, 
{     -90.0000,    -120.0000, -0.110879000E+01, -0.586134697E-02,  0.444993416E-01,  0.851399045E-03 }, 
{     -75.0000,    -120.0000, -0.119031000E+01, -0.196426133E-02,  0.644640736E-01,  0.132689835E-02 }, 
{     -60.0000,    -120.0000, -0.955880000E+00,  0.443003923E-01,  0.999386925E-01,  0.492887772E-02 }, 
{     -45.0000,    -120.0000,  0.386820000E+00,  0.140188692E+00,  0.156141946E+00, -0.270683466E-02 }, 
{     -30.0000,    -120.0000,  0.211255000E+01,  0.863083906E-02,  0.414009336E-01, -0.580909086E-02 }, 
{     -15.0000,    -120.0000,  0.665110000E+00, -0.119054048E+00,  0.293221401E-01,  0.579236836E-03 }, 
{       0.0000,    -120.0000, -0.527510000E+00, -0.604266454E-01,  0.250023030E-01,  0.212417400E-03 }, 
{      15.0000,    -120.0000, -0.134483000E+01, -0.412273699E-01,  0.473941971E-01,  0.218550497E-02 }, 
{      30.0000,    -120.0000, -0.167220000E+01, -0.360187514E-02,  0.739886351E-01,  0.842829130E-03 }, 
{      45.0000,    -120.0000, -0.146859000E+01,  0.308828704E-01,  0.697711872E-01, -0.108142348E-02 }, 
{      60.0000,    -120.0000, -0.813130000E+00,  0.518843934E-01,  0.486179190E-01, -0.159127842E-02 }, 
{      75.0000,    -120.0000, -0.569900000E-01,  0.438995559E-01,  0.276000120E-01, -0.987697878E-03 }, 
{      90.0000,    -120.0000,  0.370100000E+00,  0.916338286E-02,  0.216310758E-01,  0.144701291E-03 }, 
{     105.0000,    -120.0000,  0.227770000E+00, -0.236010874E-01,  0.270817334E-01,  0.305236994E-03 }, 
{     120.0000,    -120.0000, -0.178280000E+00, -0.244350333E-01,  0.270090179E-01, -0.290060845E-03 }, 
{     135.0000,    -120.0000, -0.392720000E+00, -0.275677934E-02,  0.220914146E-01, -0.143057368E-03 }, 
{     150.0000,    -120.0000, -0.248810000E+00,  0.213561507E-01,  0.238202559E-01,  0.224537913E-03 }, 
{     165.0000,    -120.0000,  0.100590000E+00,  0.159941766E-01,  0.293943610E-01,  0.705494998E-03 }, 
{     180.0000,    -120.0000,  0.786600000E-01, -0.198388571E-01,  0.442054776E-01,  0.103052643E-02 }, 
{    -180.0000,    -105.0000,  0.676330000E+00, -0.754522271E-02,  0.388157000E-01,  0.350040890E-03 }, 
{    -165.0000,    -105.0000,  0.353400000E+00, -0.308684692E-01,  0.429562147E-01,  0.225883752E-03 }, 
{    -150.0000,    -105.0000, -0.743100000E-01, -0.191089006E-01,  0.412486449E-01, -0.766986914E-03 }, 
{    -135.0000,    -105.0000, -0.237320000E+00, -0.108399286E-01,  0.225705104E-01, -0.123507694E-02 }, 
{    -120.0000,    -105.0000, -0.456770000E+00, -0.140233852E-01,  0.122850196E-01, -0.854303709E-04 }, 
{    -105.0000,    -105.0000, -0.596760000E+00, -0.495453071E-02,  0.172389295E-01,  0.510482231E-03 }, 
{     -90.0000,    -105.0000, -0.579310000E+00,  0.933350803E-02,  0.266796921E-01,  0.922435938E-03 }, 
{     -75.0000,    -105.0000, -0.291530000E+00,  0.286664986E-01,  0.519551226E-01,  0.274301265E-02 }, 
{     -60.0000,    -105.0000,  0.532990000E+00,  0.984604976E-01,  0.967196533E-01,  0.211350573E-02 }, 
{     -45.0000,    -105.0000,  0.220360000E+01,  0.765175110E-01,  0.799015261E-01, -0.560775486E-02 }, 
{     -30.0000,    -105.0000,  0.221673000E+01, -0.677825416E-01, -0.240074943E-01, -0.382791581E-02 }, 
{     -15.0000,    -105.0000,  0.757140000E+00, -0.946793446E-01, -0.120713737E-01,  0.252483813E-02 }, 
{       0.0000,    -105.0000, -0.213960000E+00, -0.396380799E-01,  0.197219047E-01,  0.247444308E-02 }, 
{      15.0000,    -105.0000, -0.529020000E+00, -0.400033595E-02,  0.622969388E-01,  0.245105204E-02 }, 
{      30.0000,    -105.0000, -0.478280000E+00,  0.277542364E-02,  0.812059764E-01,  0.181630820E-04 }, 
{      45.0000,    -105.0000, -0.437090000E+00,  0.112846414E-01,  0.683766816E-01, -0.130775580E-02 }, 
{      60.0000,    -105.0000, -0.117530000E+00,  0.242360108E-01,  0.464601011E-01, -0.173631492E-02 }, 
{      75.0000,    -105.0000,  0.187330000E+00,  0.166553153E-01,  0.136316509E-01, -0.269599065E-02 }, 
{      90.0000,    -105.0000,  0.379520000E+00,  0.855272787E-02, -0.200971563E-01, -0.791173967E-03 }, 
{     105.0000,    -105.0000,  0.378270000E+00, -0.126782268E-01, -0.906812204E-02,  0.132073192E-02 }, 
{     120.0000,    -105.0000,  0.461900000E-01, -0.245058207E-01,  0.491429524E-02,  0.510536577E-03 }, 
{     135.0000,    -105.0000, -0.162340000E+00,  0.257950952E-02,  0.106970513E-01,  0.590156439E-03 }, 
{     150.0000,    -105.0000,  0.121480000E+00,  0.292457826E-01,  0.233635903E-01,  0.818696687E-03 }, 
{     165.0000,    -105.0000,  0.547060000E+00,  0.223173600E-01,  0.324238727E-01,  0.480421088E-03 }, 
{     180.0000,    -105.0000,  0.676330000E+00, -0.754522271E-02,  0.388157000E-01,  0.350040890E-03 }, 
{    -180.0000,     -90.0000,  0.117430000E+01, -0.907524145E-02,  0.196597225E-01, -0.277966853E-03 }, 
{    -165.0000,     -90.0000,  0.790960000E+00, -0.332766342E-01,  0.105870051E-01, -0.657066543E-03 }, 
{    -150.0000,     -90.0000,  0.302190000E+00, -0.322402218E-01,  0.169224360E-02, -0.687262757E-03 }, 
{    -135.0000,     -90.0000, -0.159660000E+00, -0.278864786E-01, -0.932565882E-02, -0.576415207E-03 }, 
{    -120.0000,     -90.0000, -0.469070000E+00, -0.104658636E-01, -0.115981059E-01,  0.334853676E-03 }, 
{    -105.0000,     -90.0000, -0.456010000E+00,  0.104799332E-01,  0.322632967E-02,  0.174739820E-02 }, 
{     -90.0000,     -90.0000, -0.153780000E+00,  0.316041307E-01,  0.397838901E-01,  0.295195274E-02 }, 
{     -75.0000,     -90.0000,  0.535670000E+00,  0.614395439E-01,  0.729114360E-01,  0.381812103E-03 }, 
{     -60.0000,     -90.0000,  0.166178000E+01,  0.857496937E-01,  0.367146942E-01, -0.509304035E-02 }, 
{     -45.0000,     -90.0000,  0.252447000E+01, -0.667831884E-02, -0.482180509E-01, -0.423554809E-02 }, 
{     -30.0000,     -90.0000,  0.150282000E+01, -0.908284184E-01, -0.673169563E-01,  0.122890262E-02 }, 
{     -15.0000,     -90.0000,  0.419250000E+00, -0.510520077E-01, -0.302086451E-01,  0.292181877E-02 }, 
{       0.0000,     -90.0000,  0.617400000E-01,  0.682044915E-02,  0.139600781E-01,  0.333922919E-02 }, 
{      15.0000,     -90.0000,  0.422440000E+00,  0.244082111E-01,  0.568720477E-01,  0.113740305E-02 }, 
{      30.0000,     -90.0000,  0.563520000E+00, -0.409729359E-02,  0.483314594E-01, -0.101456515E-02 }, 
{      45.0000,     -90.0000,  0.446290000E+00, -0.324903674E-02,  0.396980864E-01, -0.513934737E-03 }, 
{      60.0000,     -90.0000,  0.499750000E+00,  0.433944057E-02,  0.281176766E-01, -0.972452460E-03 }, 
{      75.0000,     -90.0000,  0.389010000E+00, -0.255647255E-01,  0.707338435E-02, -0.212119583E-02 }, 
{      90.0000,     -90.0000, -0.728200000E-01, -0.165945384E-01, -0.298264507E-01, -0.213158968E-02 }, 
{     105.0000,     -90.0000, -0.291900000E-01,  0.830287919E-02, -0.422012452E-01,  0.792628625E-03 }, 
{     120.0000,     -90.0000, -0.230100000E-01, -0.665497836E-02, -0.156121989E-01,  0.180392553E-02 }, 
{     135.0000,     -90.0000, -0.612500000E-01,  0.119050342E-01,  0.141438009E-02,  0.714794327E-03 }, 
{     150.0000,     -90.0000,  0.389030000E+00,  0.414428414E-01,  0.102933827E-01,  0.518013492E-03 }, 
{     165.0000,     -90.0000,  0.982990000E+00,  0.311716000E-01,  0.173901482E-01,  0.408305330E-03 }, 
{     180.0000,     -90.0000,  0.117430000E+01, -0.907524145E-02,  0.196597225E-01, -0.277966853E-03 }, 
{    -180.0000,     -75.0000,  0.110152000E+01, -0.131838174E-01, -0.324165900E-01, -0.365892423E-03 }, 
{    -165.0000,     -75.0000,  0.593230000E+00, -0.441163968E-01, -0.373382350E-01, -0.247203106E-03 }, 
{    -150.0000,     -75.0000, -0.410700000E-01, -0.388685953E-01, -0.413696193E-01, -0.435901002E-03 }, 
{    -135.0000,     -75.0000, -0.516390000E+00, -0.223332220E-01, -0.410818752E-01,  0.124207908E-02 }, 
{    -120.0000,     -75.0000, -0.661030000E+00,  0.420948333E-02, -0.674459584E-02,  0.239258937E-02 }, 
{    -105.0000,     -75.0000, -0.381970000E+00,  0.323792887E-01,  0.128137519E-01, -0.333111455E-04 }, 
{     -90.0000,     -75.0000,  0.334870000E+00,  0.654533619E-01, -0.297925261E-02, -0.150627614E-02 }, 
{     -75.0000,     -75.0000,  0.127562000E+01,  0.373252638E-01, -0.301708667E-01, -0.253850801E-02 }, 
{     -60.0000,     -75.0000,  0.134926000E+01, -0.118764172E-01, -0.803244300E-01, -0.380872730E-02 }, 
{     -45.0000,     -75.0000,  0.104556000E+01, -0.358315951E-01, -0.118637323E+00,  0.801260250E-04 }, 
{     -30.0000,     -75.0000,  0.344610000E+00, -0.457272025E-01, -0.811486804E-01,  0.332337314E-02 }, 
{     -15.0000,     -75.0000, -0.807000000E-01, -0.651159475E-02, -0.346620459E-01,  0.342143677E-02 }, 
{       0.0000,     -75.0000,  0.203790000E+00,  0.436095815E-01,  0.798778293E-02,  0.818172452E-03 }, 
{      15.0000,     -75.0000,  0.881790000E+00,  0.245712686E-01, -0.762312977E-02, -0.128634335E-02 }, 
{      30.0000,     -75.0000,  0.830660000E+00, -0.165206560E-01, -0.127438139E-01,  0.180881582E-03 }, 
{      45.0000,     -75.0000,  0.646310000E+00, -0.558464466E-02, -0.104890271E-01, -0.103624550E-04 }, 
{      60.0000,     -75.0000,  0.605560000E+00, -0.616076538E-02, -0.143128074E-01, -0.453230477E-03 }, 
{      75.0000,     -75.0000,  0.296940000E+00, -0.396462938E-01, -0.200031883E-01, -0.795478745E-04 }, 
{      90.0000,     -75.0000, -0.432400000E+00, -0.428460593E-01, -0.229810411E-01, -0.962224752E-03 }, 
{     105.0000,     -75.0000, -0.725990000E+00,  0.644453104E-02, -0.429788970E-01, -0.666694858E-03 }, 
{     120.0000,     -75.0000, -0.426050000E+00,  0.183379351E-01, -0.369134996E-01,  0.842512475E-03 }, 
{     135.0000,     -75.0000, -0.219430000E+00,  0.215157284E-01, -0.277725717E-01,  0.337910030E-03 }, 
{     150.0000,     -75.0000,  0.313820000E+00,  0.435731513E-01, -0.260691212E-01, -0.252769234E-04 }, 
{     165.0000,     -75.0000,  0.918550000E+00,  0.317876665E-01, -0.276864655E-01, -0.219581103E-03 }, 
{     180.0000,     -75.0000,  0.110152000E+01, -0.131838174E-01, -0.324165900E-01, -0.365892423E-03 }, 
{    -180.0000,     -60.0000,  0.184510000E+00, -0.182088462E-01, -0.879513624E-01, -0.851843984E-04 }, 
{    -165.0000,     -60.0000, -0.341640000E+00, -0.436914516E-01, -0.877540651E-01, -0.437084523E-03 }, 
{    -150.0000,     -60.0000, -0.947820000E+00, -0.334913472E-01, -0.862157665E-01,  0.218064168E-02 }, 
{    -135.0000,     -60.0000, -0.123013000E+01, -0.411594023E-04, -0.404408405E-01,  0.117716273E-02 }, 
{    -120.0000,     -60.0000, -0.971460000E+00,  0.289279848E-01, -0.619015107E-01, -0.202644145E-02 }, 
{    -105.0000,     -60.0000, -0.584950000E+00,  0.133652200E-01, -0.802693371E-01, -0.103709626E-02 }, 
{     -90.0000,     -60.0000, -0.537130000E+00,  0.447713509E-02, -0.104536880E+00, -0.235224731E-02 }, 
{     -75.0000,     -60.0000, -0.377080000E+00,  0.103002396E-01, -0.134777969E+00, -0.455640907E-03 }, 
{     -60.0000,     -60.0000, -0.340110000E+00, -0.627409352E-02, -0.115794974E+00,  0.192319208E-02 }, 
{     -45.0000,     -60.0000, -0.531630000E+00, -0.161138655E-01, -0.884526588E-01,  0.202793466E-02 }, 
{     -30.0000,     -60.0000, -0.724250000E+00, -0.609844441E-02, -0.535023223E-01,  0.242359963E-02 }, 
{     -15.0000,     -60.0000, -0.564000000E+00,  0.340336431E-01, -0.277931713E-01,  0.409564330E-03 }, 
{       0.0000,     -60.0000,  0.866400000E-01,  0.321418718E-01, -0.409312098E-01, -0.154763446E-02 }, 
{      15.0000,     -60.0000,  0.272770000E+00,  0.475286960E-02, -0.563135287E-01,  0.769020340E-04 }, 
{      30.0000,     -60.0000,  0.343150000E+00,  0.148649802E-03, -0.414302040E-01,  0.114022750E-02 }, 
{      45.0000,     -60.0000,  0.251590000E+00, -0.958346880E-02, -0.366819778E-01, -0.711501854E-03 }, 
{      60.0000,     -60.0000,  0.826800000E-01, -0.139087746E-01, -0.542804469E-01, -0.864268666E-03 }, 
{      75.0000,     -60.0000, -0.264530000E+00, -0.380054328E-01, -0.577686311E-01, -0.487541335E-04 }, 
{      90.0000,     -60.0000, -0.971080000E+00, -0.448214941E-01, -0.579013851E-01,  0.335097555E-03 }, 
{     105.0000,     -60.0000, -0.135929000E+01, -0.166059089E-02, -0.519031667E-01, -0.118543209E-03 }, 
{     120.0000,     -60.0000, -0.114928000E+01,  0.158238576E-01, -0.619878027E-01, -0.678208231E-03 }, 
{     135.0000,     -60.0000, -0.943440000E+00,  0.215351604E-01, -0.667620934E-01, -0.140409215E-03 }, 
{     150.0000,     -60.0000, -0.433040000E+00,  0.412835008E-01, -0.704308978E-01, -0.448773923E-03 }, 
{     165.0000,     -60.0000,  0.115450000E+00,  0.251088363E-01, -0.801522862E-01, -0.742533651E-03 }, 
{     180.0000,     -60.0000,  0.184510000E+00, -0.182088462E-01, -0.879513624E-01, -0.851843984E-04 }, 
{    -180.0000,     -45.0000, -0.141673000E+01, -0.223918033E-01, -0.119427960E+00, -0.113496717E-02 }, 
{    -165.0000,     -45.0000, -0.195928000E+01, -0.430368239E-01, -0.122147505E+00,  0.221145578E-02 }, 
{    -150.0000,     -45.0000, -0.236546000E+01,  0.479309897E-02, -0.786453149E-01,  0.445673150E-03 }, 
{    -135.0000,     -45.0000, -0.211313000E+01, -0.690557196E-02, -0.116502763E+00, -0.286520000E-02 }, 
{    -120.0000,     -45.0000, -0.261839000E+01, -0.277568111E-01, -0.137121361E+00, -0.680082462E-03 }, 
{    -105.0000,     -45.0000, -0.262430000E+01,  0.156988164E-01, -0.140202403E+00,  0.845601729E-03 }, 
{     -90.0000,     -45.0000, -0.233200000E+01,  0.222395455E-01, -0.112247229E+00,  0.227250212E-02 }, 
{     -75.0000,     -45.0000, -0.200648000E+01,  0.189070016E-01, -0.871372565E-01,  0.677419186E-03 }, 
{     -60.0000,     -45.0000, -0.176604000E+01,  0.153244483E-01, -0.795556740E-01,  0.155613206E-02 }, 
{     -45.0000,     -45.0000, -0.152939000E+01,  0.152132053E-01, -0.425420423E-01,  0.201709542E-02 }, 
{     -30.0000,     -45.0000, -0.130296000E+01,  0.164387304E-01, -0.343560306E-01, -0.584585053E-03 }, 
{     -15.0000,     -45.0000, -0.106202000E+01,  0.125058730E-01, -0.504292690E-01, -0.125620055E-02 }, 
{       0.0000,     -45.0000, -0.869050000E+00,  0.203197777E-01, -0.588309437E-01,  0.714404624E-03 }, 
{      15.0000,     -45.0000, -0.470810000E+00,  0.244570162E-01, -0.376427556E-01,  0.955884732E-03 }, 
{      30.0000,     -45.0000, -0.258490000E+00,  0.396415744E-02, -0.393653703E-01, -0.644828883E-03 }, 
{      45.0000,     -45.0000, -0.391740000E+00, -0.244996460E-01, -0.503930616E-01, -0.926630393E-03 }, 
{      60.0000,     -45.0000, -0.888220000E+00, -0.319115735E-01, -0.673214050E-01, -0.123985649E-02 }, 
{      75.0000,     -45.0000, -0.137110000E+01, -0.437260600E-01, -0.825302874E-01, -0.541388823E-03 }, 
{      90.0000,     -45.0000, -0.210106000E+01, -0.357521865E-01, -0.791454185E-01,  0.104060909E-02 }, 
{     105.0000,     -45.0000, -0.230318000E+01,  0.318806141E-03, -0.648464362E-01, -0.842772844E-04 }, 
{     120.0000,     -45.0000, -0.225641000E+01,  0.340696197E-02, -0.812072897E-01, -0.111587418E-02 }, 
{     135.0000,     -45.0000, -0.214075000E+01,  0.185393460E-01, -0.894430545E-01, -0.371549659E-03 }, 
{     150.0000,     -45.0000, -0.171196000E+01,  0.313256542E-01, -0.973632877E-01, -0.629126800E-03 }, 
{     165.0000,     -45.0000, -0.135890000E+01,  0.125280373E-01, -0.107194390E+00, -0.662210143E-03 }, 
{     180.0000,     -45.0000, -0.141673000E+01, -0.223918033E-01, -0.119427960E+00, -0.113496717E-02 }, 
{    -180.0000,     -30.0000, -0.307130000E+01, -0.301231364E-01, -0.854987959E-01,  0.224219502E-02 }, 
{    -165.0000,     -30.0000, -0.353917000E+01, -0.796473078E-02, -0.631619162E-01, -0.126339443E-02 }, 
{    -150.0000,     -30.0000, -0.353958000E+01, -0.316739405E-01, -0.117554974E+00, -0.359985292E-02 }, 
{    -135.0000,     -30.0000, -0.442996000E+01, -0.434975074E-01, -0.133514108E+00,  0.159236766E-02 }, 
{    -120.0000,     -30.0000, -0.447148000E+01,  0.192839700E-01, -0.896170438E-01,  0.281796834E-02 }, 
{    -105.0000,     -30.0000, -0.410460000E+01,  0.314336272E-01, -0.628510495E-01,  0.126837079E-02 }, 
{     -90.0000,     -30.0000, -0.355682000E+01,  0.379135210E-01, -0.504122061E-01, -0.504839638E-04 }, 
{     -75.0000,     -30.0000, -0.299677000E+01,  0.384782887E-01, -0.406110049E-01,  0.338157398E-02 }, 
{     -60.0000,     -30.0000, -0.241581000E+01,  0.363753242E-01,  0.188776699E-01,  0.382163236E-03 }, 
{     -45.0000,     -30.0000, -0.199124000E+01,  0.171264144E-01, -0.333011719E-01, -0.344826034E-02 }, 
{     -30.0000,     -30.0000, -0.190181000E+01, -0.208098193E-02, -0.445855553E-01,  0.718233078E-03 }, 
{     -15.0000,     -30.0000, -0.185246000E+01,  0.189535133E-01, -0.281817527E-01,  0.159921188E-02 }, 
{       0.0000,     -30.0000, -0.132972000E+01,  0.406849287E-01, -0.701701555E-02,  0.398627345E-03 }, 
{      15.0000,     -30.0000, -0.847940000E+00,  0.192107718E-01, -0.172574489E-01, -0.100886052E-02 }, 
{      30.0000,     -30.0000, -0.809280000E+00, -0.134400160E-01, -0.315943148E-01, -0.127864512E-02 }, 
{      45.0000,     -30.0000, -0.121194000E+01, -0.382507080E-01, -0.544517759E-01, -0.131542441E-02 }, 
{      60.0000,     -30.0000, -0.188152000E+01, -0.480051521E-01, -0.692739330E-01, -0.995580891E-03 }, 
{      75.0000,     -30.0000, -0.260158000E+01, -0.476566836E-01, -0.795202195E-01,  0.284059264E-03 }, 
{      90.0000,     -30.0000, -0.315607000E+01, -0.162781133E-01, -0.625149409E-01,  0.121114225E-02 }, 
{     105.0000,     -30.0000, -0.320162000E+01, -0.723886305E-02, -0.571770885E-01, -0.660002085E-03 }, 
{     120.0000,     -30.0000, -0.345891000E+01, -0.153344345E-01, -0.751090387E-01, -0.108995346E-02 }, 
{     135.0000,     -30.0000, -0.348535000E+01,  0.118306010E-01, -0.838476884E-01, -0.314304037E-03 }, 
{     150.0000,     -30.0000, -0.318558000E+01,  0.226780307E-01, -0.906239513E-01, -0.755812909E-03 }, 
{     165.0000,     -30.0000, -0.293476000E+01,  0.757527644E-02, -0.101112156E+00, -0.115337757E-03 }, 
{     180.0000,     -30.0000, -0.307130000E+01, -0.301231364E-01, -0.854987959E-01,  0.224219502E-02 }, 
{    -180.0000,     -15.0000, -0.426272000E+01,  0.602086072E-02, -0.107774856E+00, -0.215128008E-02 }, 
{    -165.0000,     -15.0000, -0.429968000E+01, -0.521562919E-01, -0.932848306E-01,  0.101822835E-02 }, 
{    -150.0000,     -15.0000, -0.553484000E+01, -0.518196930E-01, -0.850107888E-01,  0.263118013E-02 }, 
{    -135.0000,     -15.0000, -0.546735000E+01,  0.259010641E-01, -0.202848035E-01,  0.305705656E-02 }, 
{    -120.0000,     -15.0000, -0.514571000E+01,  0.260414366E-01, -0.987446357E-02,  0.167858665E-03 }, 
{    -105.0000,     -15.0000, -0.458142000E+01,  0.471191894E-01,  0.182601158E-03,  0.364989702E-03 }, 
{     -90.0000,     -15.0000, -0.390491000E+01,  0.336418059E-01, -0.685947074E-03,  0.209885827E-03 }, 
{     -75.0000,     -15.0000, -0.324057000E+01,  0.864835869E-01,  0.276327597E-02, -0.688398048E-03 }, 
{     -60.0000,     -15.0000, -0.189175000E+01,  0.230558466E-01, -0.210970056E-01, -0.153850534E-02 }, 
{     -45.0000,     -15.0000, -0.253686000E+01, -0.379649733E-01, -0.257472699E-01,  0.114031022E-02 }, 
{     -30.0000,     -15.0000, -0.233510000E+01,  0.401340466E-01,  0.627025193E-02,  0.245071598E-02 }, 
{     -15.0000,     -15.0000, -0.172931000E+01,  0.389387869E-01,  0.296982796E-01,  0.145935792E-03 }, 
{       0.0000,     -15.0000, -0.124042000E+01,  0.230468059E-01,  0.126250059E-01, -0.176350836E-02 }, 
{      15.0000,     -15.0000, -0.105797000E+01,  0.314198935E-02, -0.107594487E-01, -0.118344803E-02 }, 
{      30.0000,     -15.0000, -0.122154000E+01, -0.318387634E-01, -0.268673705E-01, -0.140117481E-02 }, 
{      45.0000,     -15.0000, -0.198839000E+01, -0.618709359E-01, -0.511298348E-01, -0.128592995E-02 }, 
{      60.0000,     -15.0000, -0.289394000E+01, -0.551574930E-01, -0.567268629E-01,  0.572996141E-03 }, 
{      75.0000,     -15.0000, -0.350491000E+01, -0.208030919E-01, -0.261508348E-01,  0.398974538E-02 }, 
{      90.0000,     -15.0000, -0.364469000E+01, -0.117801393E-01,  0.204791822E-01, -0.109076864E-02 }, 
{     105.0000,     -15.0000, -0.400273000E+01, -0.316403510E-01, -0.463552096E-01, -0.366754580E-02 }, 
{     120.0000,     -15.0000, -0.444345000E+01, -0.214104569E-01, -0.557645556E-01,  0.512204254E-03 }, 
{     135.0000,     -15.0000, -0.456253000E+01,  0.532217843E-02, -0.595221920E-01, -0.101466770E-02 }, 
{     150.0000,     -15.0000, -0.434373000E+01,  0.200657431E-01, -0.664949072E-01,  0.140039623E-02 }, 
{     165.0000,     -15.0000, -0.414696000E+01, -0.247115096E-02, -0.459689884E-01, -0.187627648E-02 }, 
{     180.0000,     -15.0000, -0.426272000E+01,  0.602086072E-02, -0.107774856E+00, -0.215128008E-02 }, 
{    -180.0000,       0.0000, -0.598372000E+01, -0.581804030E-01, -0.658857799E-01,  0.751471992E-03 }, 
{    -165.0000,       0.0000, -0.594426000E+01,  0.278900576E-01, -0.447167614E-01,  0.436143870E-02 }, 
{    -150.0000,       0.0000, -0.562295000E+01,  0.187741726E-01,  0.409241292E-01,  0.316475502E-02 }, 
{    -135.0000,       0.0000, -0.533032000E+01,  0.198012519E-01,  0.345813223E-01, -0.116084206E-02 }, 
{    -120.0000,       0.0000, -0.494188000E+01,  0.382348199E-01,  0.350348980E-01,  0.300766978E-03 }, 
{    -105.0000,       0.0000, -0.424888000E+01,  0.435474685E-01,  0.332646448E-01, -0.305561347E-03 }, 
{     -90.0000,       0.0000, -0.368237000E+01,  0.394773061E-01,  0.280459944E-01, -0.476302321E-03 }, 
{     -75.0000,       0.0000, -0.312300000E+01,  0.237193070E-01,  0.431190101E-02, -0.357977813E-02 }, 
{     -60.0000,       0.0000, -0.294185000E+01,  0.137494660E-01, -0.396976476E-01,  0.124668646E-02 }, 
{     -45.0000,       0.0000, -0.250222000E+01,  0.454388292E-01,  0.340942516E-01,  0.454950244E-02 }, 
{     -30.0000,       0.0000, -0.172945000E+01,  0.469752172E-01,  0.539765476E-01, -0.709857159E-03 }, 
{     -15.0000,       0.0000, -0.122644000E+01,  0.218163020E-01,  0.345926341E-01, -0.161039731E-02 }, 
{       0.0000,       0.0000, -0.105288000E+01,  0.107357479E-02,  0.118849921E-01, -0.126686470E-02 }, 
{      15.0000,       0.0000, -0.118766000E+01, -0.183546012E-01, -0.764875636E-02, -0.177042196E-02 }, 
{      30.0000,       0.0000, -0.167253000E+01, -0.515851701E-01, -0.335862030E-01, -0.745686467E-03 }, 
{      45.0000,       0.0000, -0.260495000E+01, -0.587627185E-01, -0.196308850E-01,  0.235674211E-02 }, 
{      60.0000,       0.0000, -0.328522000E+01, -0.359019558E-01,  0.154413848E-01,  0.112423558E-02 }, 
{      75.0000,       0.0000, -0.349217000E+01,  0.249265418E-01,  0.600555875E-02, -0.172639571E-02 }, 
{      90.0000,       0.0000, -0.315561000E+01, -0.378822113E-01, -0.193097879E-01, -0.116888730E-02 }, 
{     105.0000,       0.0000, -0.454402000E+01, -0.837676967E-01, -0.258820730E-01,  0.244185369E-04 }, 
{     120.0000,       0.0000, -0.509107000E+01, -0.141390018E-01, -0.282647388E-01, -0.719777030E-03 }, 
{     135.0000,       0.0000, -0.526456000E+01, -0.378429588E-02, -0.339055436E-01,  0.124999546E-02 }, 
{     150.0000,       0.0000, -0.504043000E+01,  0.394041854E-01, -0.143664200E-01, -0.150054105E-02 }, 
{     165.0000,       0.0000, -0.470775000E+01, -0.424704456E-01, -0.696098911E-01, -0.238870073E-02 }, 
{     180.0000,       0.0000, -0.598372000E+01, -0.581804030E-01, -0.658857799E-01,  0.751471992E-03 }, 
{    -180.0000,      15.0000, -0.578157000E+01,  0.347999178E-01,  0.675479757E-01,  0.490120352E-02 }, 
{    -165.0000,      15.0000, -0.521525000E+01,  0.357946655E-01,  0.890378761E-01, -0.873791683E-03 }, 
{    -150.0000,      15.0000, -0.478750000E+01,  0.208354203E-01,  0.707822719E-01, -0.759177535E-03 }, 
{    -135.0000,      15.0000, -0.452684000E+01,  0.185456532E-01,  0.700615143E-01,  0.115229482E-03 }, 
{    -120.0000,      15.0000, -0.416265000E+01,  0.299519670E-01,  0.663468714E-01, -0.588820501E-03 }, 
{    -105.0000,      15.0000, -0.365267000E+01,  0.364804788E-01,  0.525088196E-01, -0.127048643E-02 }, 
{     -90.0000,      15.0000, -0.318661000E+01,  0.193341180E-01,  0.321619695E-01, -0.116621414E-02 }, 
{     -75.0000,      15.0000, -0.298796000E+01,  0.191250494E-01,  0.305111200E-01,  0.153580308E-02 }, 
{     -60.0000,      15.0000, -0.245967000E+01,  0.495536846E-01,  0.663035959E-01,  0.185132712E-02 }, 
{     -45.0000,      15.0000, -0.163290000E+01,  0.536722122E-01,  0.701622634E-01, -0.101088286E-02 }, 
{     -30.0000,      15.0000, -0.978810000E+00,  0.319294667E-01,  0.490815577E-01, -0.125220333E-02 }, 
{     -15.0000,      15.0000, -0.712560000E+00,  0.267792110E-02,  0.352811840E-01, -0.956519703E-03 }, 
{       0.0000,      15.0000, -0.866460000E+00, -0.201711511E-01,  0.146270258E-01, -0.181262423E-02 }, 
{      15.0000,      15.0000, -0.129416000E+01, -0.383133168E-01, -0.588352589E-02, -0.259253444E-04 }, 
{      30.0000,      15.0000, -0.194904000E+01, -0.430915819E-01,  0.157121826E-01,  0.213335697E-02 }, 
{      45.0000,      15.0000, -0.244548000E+01, -0.195843557E-01,  0.382353746E-01,  0.316277540E-03 }, 
{      60.0000,      15.0000, -0.273747000E+01, -0.362569952E-01,  0.262553237E-01, -0.128983891E-02 }, 
{      75.0000,      15.0000, -0.352752000E+01, -0.517956634E-01, -0.239340018E-02, -0.328267685E-02 }, 
{      90.0000,      15.0000, -0.414017000E+01, -0.371003513E-01, -0.423360307E-01,  0.702275411E-03 }, 
{     105.0000,      15.0000, -0.471769000E+01, -0.378369314E-01,  0.689150161E-02,  0.233055556E-02 }, 
{     120.0000,      15.0000, -0.522956000E+01, -0.294299231E-01,  0.116015107E-01,  0.763010625E-03 }, 
{     135.0000,      15.0000, -0.536127000E+01,  0.268406237E-01,  0.353963665E-01,  0.318374914E-03 }, 
{     150.0000,      15.0000, -0.494167000E+01, -0.203545718E-01,  0.437258712E-02, -0.348229500E-02 }, 
{     165.0000,      15.0000, -0.586219000E+01, -0.456063365E-01, -0.186374474E-01,  0.280404230E-02 }, 
{     180.0000,      15.0000, -0.578157000E+01,  0.347999178E-01,  0.675479757E-01,  0.490120352E-02 }, 
{    -180.0000,      30.0000, -0.439795000E+01,  0.370248830E-01,  0.112847877E+00, -0.131522887E-02 }, 
{    -165.0000,      30.0000, -0.389601000E+01,  0.294976686E-01,  0.982152571E-01, -0.544749763E-03 }, 
{    -150.0000,      30.0000, -0.353457000E+01,  0.176604425E-01,  0.936227830E-01, -0.350790909E-03 }, 
{    -135.0000,      30.0000, -0.332088000E+01,  0.148865614E-01,  0.870606203E-01, -0.283013960E-03 }, 
{    -120.0000,      30.0000, -0.303056000E+01,  0.235953119E-01,  0.818416164E-01, -0.873386581E-03 }, 
{    -105.0000,      30.0000, -0.273504000E+01,  0.790019108E-02,  0.594680769E-01, -0.174194840E-02 }, 
{     -90.0000,      30.0000, -0.266786000E+01,  0.173439238E-01,  0.462081276E-01,  0.714482414E-03 }, 
{     -75.0000,      30.0000, -0.213835000E+01,  0.420621137E-01,  0.705736190E-01,  0.110512716E-02 }, 
{     -60.0000,      30.0000, -0.147167000E+01,  0.536456216E-01,  0.685192638E-01, -0.672763801E-03 }, 
{     -45.0000,      30.0000, -0.628520000E+00,  0.453214001E-01,  0.599966947E-01, -0.529456815E-03 }, 
{     -30.0000,      30.0000, -0.221790000E+00,  0.150447780E-01,  0.512292217E-01, -0.667417361E-03 }, 
{     -15.0000,      30.0000, -0.157860000E+00, -0.113685122E-01,  0.379986298E-01, -0.120048672E-02 }, 
{       0.0000,      30.0000, -0.569340000E+00, -0.390807291E-01,  0.263149047E-01,  0.486500852E-03 }, 
{      15.0000,      30.0000, -0.111306000E+01, -0.233485712E-01,  0.461028599E-01,  0.875329337E-03 }, 
{      30.0000,      30.0000, -0.132128000E+01, -0.179129861E-01,  0.409874725E-01, -0.105330463E-02 }, 
{      45.0000,      30.0000, -0.183104000E+01, -0.485954845E-01,  0.214713866E-01, -0.158840546E-02 }, 
{      60.0000,      30.0000, -0.265553000E+01, -0.545550760E-01,  0.547532027E-02,  0.304496030E-03 }, 
{      75.0000,      30.0000, -0.334579000E+01, -0.361342116E-01,  0.328440420E-01,  0.264495242E-02 }, 
{      90.0000,      30.0000, -0.378149000E+01, -0.261000777E-01,  0.634779107E-01,  0.716212372E-03 }, 
{     105.0000,      30.0000, -0.420428000E+01, -0.311634778E-01,  0.662640666E-01,  0.117420301E-02 }, 
{     120.0000,      30.0000, -0.449813000E+01,  0.742598870E-02,  0.100446696E+00,  0.198073264E-02 }, 
{     135.0000,      30.0000, -0.425139000E+01, -0.796247703E-02,  0.949540777E-01, -0.335913135E-02 }, 
{     150.0000,      30.0000, -0.479071000E+01, -0.340920806E-01,  0.468200715E-01,  0.730467851E-03 }, 
{     165.0000,      30.0000, -0.487852000E+01,  0.189047994E-01,  0.110005681E+00,  0.344758054E-02 }, 
{     180.0000,      30.0000, -0.439795000E+01,  0.370248830E-01,  0.112847877E+00, -0.131522887E-02 }, 
{    -180.0000,      45.0000, -0.258112000E+01,  0.289620636E-01,  0.121150515E+00, -0.807858860E-03 }, 
{    -165.0000,      45.0000, -0.227145000E+01,  0.153982668E-01,  0.106861095E+00, -0.102648901E-02 }, 
{    -150.0000,      45.0000, -0.209565000E+01,  0.653886937E-02,  0.930965959E-01, -0.696969022E-03 }, 
{    -135.0000,      45.0000, -0.200634000E+01,  0.114682557E-01,  0.857960043E-01, -0.398653124E-03 }, 
{    -120.0000,      45.0000, -0.182282000E+01,  0.215410764E-02,  0.742526630E-01, -0.147720505E-02 }, 
{    -105.0000,      45.0000, -0.192017000E+01, -0.285068630E-02,  0.561188727E-01,  0.372047019E-03 }, 
{     -90.0000,      45.0000, -0.170270000E+01,  0.332726376E-01,  0.797875202E-01,  0.109598840E-02 }, 
{     -75.0000,      45.0000, -0.103572000E+01,  0.466501360E-01,  0.776424040E-01, -0.451294380E-03 }, 
{     -60.0000,      45.0000, -0.397500000E+00,  0.411668184E-01,  0.720533488E-01, -0.837645155E-03 }, 
{     -45.0000,      45.0000,  0.189460000E+00,  0.337185903E-01,  0.543229578E-01, -0.862014245E-03 }, 
{     -30.0000,      45.0000,  0.536700000E+00,  0.107988202E-01,  0.491035555E-01, -0.304256520E-03 }, 
{     -15.0000,      45.0000,  0.464280000E+00, -0.219498712E-01,  0.480922968E-01,  0.832908129E-03 }, 
{       0.0000,      45.0000,  0.459900000E-01, -0.211413354E-01,  0.626033554E-01, -0.327416034E-03 }, 
{      15.0000,      45.0000, -0.238240000E+00, -0.339887873E-01,  0.326560862E-01, -0.261048611E-02 }, 
{      30.0000,      45.0000, -0.102104000E+01, -0.563095155E-01,  0.593792719E-02, -0.563725168E-03 }, 
{      45.0000,      45.0000, -0.172492000E+01, -0.381091506E-01,  0.199910790E-01,  0.233238533E-02 }, 
{      60.0000,      45.0000, -0.218120000E+01, -0.232858820E-01,  0.630973952E-01,  0.266607744E-02 }, 
{      75.0000,      45.0000, -0.243358000E+01, -0.104793214E-01,  0.898052322E-01,  0.966135566E-03 }, 
{      90.0000,      45.0000, -0.256353000E+01, -0.112628324E-01,  0.103752388E+00,  0.160037887E-02 }, 
{     105.0000,      45.0000, -0.267214000E+01,  0.781865118E-02,  0.137162232E+00,  0.210374891E-02 }, 
{     120.0000,      45.0000, -0.246632000E+01, -0.569772260E-03,  0.139259706E+00, -0.291391102E-02 }, 
{     135.0000,      45.0000, -0.285658000E+01, -0.424275621E-01,  0.857253227E-01, -0.735486705E-03 }, 
{     150.0000,      45.0000, -0.336934000E+01, -0.103239792E-01,  0.122813127E+00,  0.256654212E-02 }, 
{     165.0000,      45.0000, -0.310144000E+01,  0.347514789E-01,  0.130764725E+00, -0.522801384E-03 }, 
{     180.0000,      45.0000, -0.258112000E+01,  0.289620636E-01,  0.121150515E+00, -0.807858860E-03 }, 
{    -180.0000,      60.0000, -0.948650000E+00,  0.737434129E-02,  0.924100609E-01, -0.138344403E-02 }, 
{    -165.0000,      60.0000, -0.869300000E+00,  0.321988958E-02,  0.796823612E-01, -0.604850010E-03 }, 
{    -150.0000,      60.0000, -0.847540000E+00, -0.318996128E-04,  0.713968334E-01, -0.399801424E-03 }, 
{    -135.0000,      60.0000, -0.849650000E+00,  0.837708870E-03,  0.640013624E-01, -0.932144052E-03 }, 
{    -120.0000,      60.0000, -0.893240000E+00, -0.124589359E-01,  0.486117314E-01, -0.428642759E-03 }, 
{    -105.0000,      60.0000, -0.104409000E+01,  0.101100346E-01,  0.542464321E-01,  0.695729027E-03 }, 
{     -90.0000,      60.0000, -0.537280000E+00,  0.432107975E-01,  0.607577917E-01,  0.749386988E-04 }, 
{     -75.0000,      60.0000,  0.664900000E-01,  0.391627755E-01,  0.598247649E-01,  0.120182732E-03 }, 
{     -60.0000,      60.0000,  0.616370000E+00,  0.308681005E-01,  0.608753409E-01, -0.532159790E-03 }, 
{     -45.0000,      60.0000,  0.979600000E+00,  0.199868225E-01,  0.443354741E-01, -0.108940173E-02 }, 
{     -30.0000,      60.0000,  0.121765000E+01,  0.944060954E-02,  0.402445561E-01,  0.763609745E-03 }, 
{     -15.0000,      60.0000,  0.125138000E+01, -0.339326065E-02,  0.514801830E-01, -0.536095480E-03 }, 
{       0.0000,      60.0000,  0.908350000E+00, -0.577275669E-01,  0.188096739E-01, -0.290620427E-02 }, 
{      15.0000,      60.0000, -0.263950000E+00, -0.687624716E-01, -0.690520481E-02,  0.483835005E-03 }, 
{      30.0000,      60.0000, -0.832370000E+00, -0.153665465E-01,  0.330428187E-01,  0.381749322E-02 }, 
{      45.0000,      60.0000, -0.899680000E+00,  0.308265780E-02,  0.848362975E-01,  0.259449259E-02 }, 
{      60.0000,      60.0000, -0.822330000E+00,  0.504391535E-02,  0.108775099E+00,  0.950992485E-03 }, 
{      75.0000,      60.0000, -0.782500000E+00,  0.177680786E-03,  0.120593029E+00,  0.752883791E-03 }, 
{      90.0000,      60.0000, -0.739980000E+00,  0.107153615E-01,  0.129814537E+00,  0.245359965E-03 }, 
{     105.0000,      60.0000, -0.558380000E+00,  0.178487321E-02,  0.114267005E+00, -0.299952845E-02 }, 
{     120.0000,      60.0000, -0.897520000E+00, -0.493628543E-01,  0.626364821E-01, -0.168285717E-02 }, 
{     135.0000,      60.0000, -0.166307000E+01, -0.252714558E-01,  0.798086315E-01,  0.283928241E-02 }, 
{     150.0000,      60.0000, -0.150829000E+01,  0.282946776E-01,  0.118411421E+00,  0.148071533E-02 }, 
{     165.0000,      60.0000, -0.112821000E+01,  0.190647453E-01,  0.116997421E+00, -0.132438583E-02 }, 
{     180.0000,      60.0000, -0.948650000E+00,  0.737434129E-02,  0.924100609E-01, -0.138344403E-02 }, 
{    -180.0000,      75.0000,  0.820000000E-01, -0.576074991E-02,  0.418332411E-01, -0.602927726E-03 }, 
{    -165.0000,      75.0000,  0.530200000E-01, -0.441765371E-03,  0.393034597E-01,  0.277882623E-03 }, 
{    -150.0000,      75.0000,  0.135100000E-01, -0.617018860E-02,  0.431480705E-01, -0.245636876E-03 }, 
{    -135.0000,      75.0000, -0.135630000E+00, -0.126074802E-01,  0.323405460E-01, -0.687917863E-03 }, 
{    -120.0000,      75.0000, -0.332440000E+00, -0.125898905E-01,  0.293764112E-01,  0.242976459E-03 }, 
{    -105.0000,      75.0000, -0.398930000E+00,  0.103070422E-01,  0.311433987E-01, -0.523417420E-03 }, 
{     -90.0000,      75.0000,  0.000000000E+00,  0.378497216E-01,  0.177213131E-01, -0.480326397E-03 }, 
{     -75.0000,      75.0000,  0.639070000E+00,  0.458940714E-01,  0.180165364E-01, -0.180649465E-03 }, 
{     -60.0000,      75.0000,  0.122291000E+01,  0.231559927E-01,  0.852728769E-02, -0.635880819E-03 }, 
{     -45.0000,      75.0000,  0.136484000E+01,  0.663595760E-02,  0.341114567E-02, -0.196905398E-03 }, 
{     -30.0000,      75.0000,  0.158462000E+01,  0.226421769E-01, -0.497780037E-03, -0.381511132E-03 }, 
{     -15.0000,      75.0000,  0.166036000E+01, -0.381006650E-01, -0.147970288E-01, -0.191868497E-02 }, 
{       0.0000,      75.0000,  0.560870000E+00, -0.749895168E-01, -0.348660509E-01,  0.118259685E-02 }, 
{      15.0000,      75.0000, -0.107260000E+00, -0.154652680E-01,  0.211607330E-01,  0.437984995E-02 }, 
{      30.0000,      75.0000,  0.358400000E-01,  0.318445886E-01,  0.732667980E-01,  0.292457313E-02 }, 
{      45.0000,      75.0000,  0.623620000E+00,  0.342629136E-01,  0.110371731E+00,  0.176405716E-02 }, 
{      60.0000,      75.0000,  0.907260000E+00,  0.538775717E-02,  0.119494209E+00, -0.735319543E-03 }, 
{      75.0000,      75.0000,  0.899960000E+00, -0.545942228E-03,  0.945306517E-01, -0.199099490E-02 }, 
{      90.0000,      75.0000,  0.863380000E+00, -0.119799883E-01,  0.623714640E-01, -0.272524990E-02 }, 
{     105.0000,      75.0000,  0.404990000E+00, -0.505281047E-01,  0.211957477E-01, -0.177498631E-02 }, 
{     120.0000,      75.0000, -0.395160000E+00, -0.376155927E-01,  0.244263663E-01,  0.223617559E-02 }, 
{     135.0000,      75.0000, -0.498550000E+00,  0.202824757E-01,  0.666461512E-01,  0.192036465E-02 }, 
{     150.0000,      75.0000, -0.364600000E-01,  0.282256898E-01,  0.701171892E-01, -0.779469639E-03 }, 
{     165.0000,      75.0000,  0.168910000E+00,  0.306765026E-03,  0.553155914E-01, -0.106859806E-02 }, 
{     180.0000,      75.0000,  0.820000000E-01, -0.576074991E-02,  0.418332411E-01, -0.602927726E-03 }, 
{    -180.0000,      90.0000,  0.325570000E+00, -0.755744453E-02, -0.489902508E-02,  0.808797771E-03 }, 
{    -165.0000,      90.0000,  0.326450000E+00,  0.183280332E-02,  0.225380005E-02, -0.784097732E-03 }, 
{    -150.0000,      90.0000,  0.293360000E+00, -0.621576877E-02, -0.158091154E-01,  0.145575096E-03 }, 
{    -135.0000,      90.0000,  0.159770000E+00, -0.103057283E-01,  0.852045369E-02,  0.145512808E-02 }, 
{    -120.0000,      90.0000,  0.819000000E-02, -0.959531819E-02,  0.141686239E-01,  0.294604568E-04 }, 
{    -105.0000,      90.0000, -0.750800000E-01,  0.171700102E-02,  0.149819729E-01, -0.280666062E-03 }, 
{     -90.0000,      90.0000,  0.124580000E+00,  0.260053141E-01,  0.728956015E-03, -0.159472978E-02 }, 
{     -75.0000,      90.0000,  0.585550000E+00,  0.263877425E-01, -0.280789104E-01, -0.195259146E-02 }, 
{     -60.0000,      90.0000,  0.839350000E+00,  0.113977157E-01, -0.503884916E-01, -0.818393890E-03 }, 
{     -45.0000,      90.0000,  0.994770000E+00,  0.986539458E-02, -0.549460568E-01, -0.147262262E-03 }, 
{     -30.0000,      90.0000,  0.108297000E+01, -0.213529405E-02, -0.651894360E-01, -0.155274593E-02 }, 
{     -15.0000,      90.0000,  0.808160000E+00, -0.386462184E-01, -0.809360677E-01,  0.116024381E-02 }, 
{       0.0000,      90.0000,  0.152250000E+00, -0.294238324E-01, -0.305654704E-01,  0.383656379E-02 }, 
{      15.0000,      90.0000,  0.208730000E+00,  0.364555480E-01,  0.167982728E-01,  0.304036912E-02 }, 
{      30.0000,      90.0000,  0.108505000E+01,  0.701616406E-01,  0.573739893E-01,  0.158985168E-02 }, 
{      45.0000,      90.0000,  0.199650000E+01,  0.404518898E-01,  0.529127777E-01, -0.217687483E-02 }, 
{      60.0000,      90.0000,  0.216868000E+01, -0.152431998E-01,  0.114500644E-01, -0.206713733E-02 }, 
{      75.0000,      90.0000,  0.169212000E+01, -0.403550908E-01, -0.379163563E-02, -0.895458506E-03 }, 
{      90.0000,      90.0000,  0.105631000E+01, -0.458104372E-01, -0.200423929E-01, -0.649520116E-03 }, 
{     105.0000,      90.0000,  0.369410000E+00, -0.409451605E-01, -0.134919958E-01,  0.155346694E-02 }, 
{     120.0000,      90.0000, -0.190400000E-01, -0.547892085E-02,  0.153540528E-01,  0.151494150E-02 }, 
{     135.0000,      90.0000,  0.175690000E+00,  0.241168439E-01,  0.213587635E-01, -0.643081084E-03 }, 
{     150.0000,      90.0000,  0.505380000E+00,  0.138955453E-01,  0.385382240E-02, -0.124266324E-02 }, 
{     165.0000,      90.0000,  0.521310000E+00, -0.105750252E-01, -0.835578666E-02, -0.329176008E-03 }, 
{     180.0000,      90.0000,  0.325570000E+00, -0.755744453E-02, -0.489902508E-02,  0.808797771E-03 }, 
{    -180.0000,     105.0000,  0.340000000E-01,  0.128346907E-01, -0.318371407E-01,  0.108682477E-02 }, 
{    -165.0000,     105.0000,  0.194850000E+00, -0.114939339E-01, -0.199526599E-01,  0.648074600E-03 }, 
{    -150.0000,     105.0000, -0.145370000E+00, -0.273295510E-02, -0.116876089E-01,  0.350783191E-03 }, 
{    -135.0000,     105.0000,  0.148830000E+00,  0.132217543E-01, -0.953036073E-02,  0.332524625E-04 }, 
{    -120.0000,     105.0000,  0.541000000E-01, -0.102600621E-01, -0.874290672E-02,  0.105147398E-03 }, 
{    -105.0000,     105.0000,  0.149000000E-01,  0.103249401E-02, -0.830529033E-02, -0.208827975E-03 }, 
{     -90.0000,     105.0000,  0.315000000E-02, -0.405991396E-02, -0.200071371E-01, -0.152268158E-02 }, 
{     -75.0000,     105.0000, -0.744100000E-01, -0.265483816E-02, -0.483968948E-01, -0.171876660E-02 }, 
{     -60.0000,     105.0000, -0.801100000E-01, -0.197273338E-02, -0.675773212E-01, -0.111628885E-02 }, 
{     -45.0000,     105.0000, -0.140070000E+00, -0.258622831E-02, -0.846089184E-01, -0.105848274E-02 }, 
{     -30.0000,     105.0000, -0.192690000E+00, -0.101983534E-01, -0.942064761E-01,  0.243888253E-04 }, 
{     -15.0000,     105.0000, -0.425790000E+00, -0.137643582E-01, -0.786887002E-01,  0.214497107E-02 }, 
{       0.0000,     105.0000, -0.412450000E+00,  0.213037862E-01, -0.375360675E-01,  0.272980858E-02 }, 
{      15.0000,     105.0000,  0.322380000E+00,  0.781832134E-01, -0.242582407E-02,  0.218836984E-02 }, 
{      30.0000,     105.0000,  0.159977000E+01,  0.684073602E-01,  0.100232446E-01, -0.197142551E-02 }, 
{      45.0000,     105.0000,  0.196406000E+01, -0.234766543E-01, -0.539348421E-01, -0.460447141E-02 }, 
{      60.0000,     105.0000,  0.127150000E+01, -0.401547431E-01, -0.924464669E-01, -0.104631167E-03 }, 
{      75.0000,     105.0000,  0.957900000E+00, -0.171363735E-01, -0.677761091E-01,  0.225474267E-02 }, 
{      90.0000,     105.0000,  0.567470000E+00, -0.321057630E-01, -0.413838923E-01,  0.129817542E-02 }, 
{     105.0000,     105.0000,  0.102460000E+00, -0.255285747E-01, -0.277337645E-01,  0.561024576E-03 }, 
{     120.0000,     105.0000, -0.898600000E-01,  0.275406159E-02, -0.247825773E-01, -0.222010731E-03 }, 
{     135.0000,     105.0000,  0.882400000E-01,  0.116683283E-01, -0.347232053E-01, -0.107086980E-02 }, 
{     150.0000,     105.0000,  0.138200000E+00, -0.381537484E-02, -0.506004788E-01, -0.658090348E-03 }, 
{     165.0000,     105.0000,  0.329500000E-01, -0.746482897E-02, -0.490844448E-01,  0.830983295E-03 }, 
{     180.0000,     105.0000,  0.340000000E-01,  0.128346907E-01, -0.318371407E-01,  0.108682477E-02 }, 
{    -180.0000,     120.0000, -0.522510000E+00,  0.216553706E-01, -0.373684120E-01,  0.686466179E-03 }, 
{    -165.0000,     120.0000, -0.209940000E+00,  0.175506926E-01, -0.297211606E-01,  0.133537718E-02 }, 
{    -150.0000,     120.0000, -0.551200000E-01,  0.161985907E-02, -0.713644892E-02,  0.184177049E-04 }, 
{    -135.0000,     120.0000, -0.134660000E+00, -0.897412884E-02, -0.292850108E-01, -0.132181804E-02 }, 
{    -120.0000,     120.0000, -0.265950000E+00, -0.788934372E-02, -0.340249970E-01, -0.108855156E-03 }, 
{    -105.0000,     120.0000, -0.368220000E+00, -0.618049630E-02, -0.403888116E-01, -0.463521502E-03 }, 
{     -90.0000,     120.0000, -0.493950000E+00, -0.129886711E-01, -0.444064075E-01, -0.113340931E-03 }, 
{     -75.0000,     120.0000, -0.763400000E+00, -0.209008193E-01, -0.481235103E-01, -0.630054514E-03 }, 
{     -60.0000,     120.0000, -0.107554000E+01, -0.197260517E-01, -0.622802234E-01, -0.941204208E-03 }, 
{     -45.0000,     120.0000, -0.133794000E+01, -0.151029739E-01, -0.731602694E-01, -0.612480482E-03 }, 
{     -30.0000,     120.0000, -0.151123000E+01, -0.700005288E-02, -0.768246598E-01,  0.482238868E-03 }, 
{     -15.0000,     120.0000, -0.145599000E+01,  0.194931854E-01, -0.571391313E-01,  0.188775264E-02 }, 
{       0.0000,     120.0000, -0.922130000E+00,  0.468473114E-01, -0.341662594E-01,  0.498430652E-03 }, 
{      15.0000,     120.0000,  0.926800000E-01,  0.102851569E+00, -0.303049765E-01,  0.148535572E-02 }, 
{      30.0000,     120.0000,  0.144313000E+01,  0.147984127E-01, -0.258509678E-01, -0.477679521E-02 }, 
{      45.0000,     120.0000,  0.514020000E+00, -0.777772199E-01, -0.133669409E+00, -0.305106147E-02 }, 
{      60.0000,     120.0000, -0.738100000E-01, -0.707753321E-02, -0.901621967E-01,  0.411879531E-02 }, 
{      75.0000,     120.0000,  0.506000000E-02,  0.429535271E-02, -0.625159279E-01,  0.806576520E-03 }, 
{      90.0000,     120.0000, -0.124550000E+00, -0.202518776E-01, -0.505940380E-01,  0.568530356E-03 }, 
{     105.0000,     120.0000, -0.492020000E+00, -0.227038422E-01, -0.478589461E-01, -0.149301591E-03 }, 
{     120.0000,     120.0000, -0.722050000E+00, -0.843275342E-02, -0.568257435E-01, -0.121766509E-02 }, 
{     135.0000,     120.0000, -0.798800000E+00, -0.492114410E-02, -0.773639424E-01, -0.881037303E-03 }, 
{     150.0000,     120.0000, -0.870410000E+00, -0.155467020E-02, -0.766099074E-01,  0.784981523E-03 }, 
{     165.0000,     120.0000, -0.792650000E+00,  0.123698249E-01, -0.580984343E-01,  0.159421284E-02 }, 
{     180.0000,     120.0000, -0.522510000E+00,  0.216553706E-01, -0.373684120E-01,  0.686466179E-03 }, 
{    -180.0000,     135.0000, -0.102882000E+01,  0.351094509E-01, -0.312532114E-01,  0.622262542E-03 }, 
{    -165.0000,     135.0000, -0.651770000E+00,  0.154332388E-01, -0.304866979E-01, -0.604148793E-03 }, 
{    -150.0000,     135.0000, -0.560740000E+00, -0.322640592E-02, -0.428405954E-01, -0.523144175E-03 }, 
{    -135.0000,     135.0000, -0.712020000E+00, -0.145776151E-01, -0.454995962E-01, -0.305854175E-03 }, 
{    -120.0000,     135.0000, -0.941040000E+00, -0.145231337E-01, -0.541851053E-01, -0.522341101E-03 }, 
{    -105.0000,     135.0000, -0.112185000E+01, -0.929585011E-02, -0.574894633E-01, -0.275484147E-05 }, 
{     -90.0000,     135.0000, -0.126606000E+01, -0.132974659E-01, -0.562092330E-01,  0.128534924E-03 }, 
{     -75.0000,     135.0000, -0.154884000E+01, -0.229122864E-01, -0.539950640E-01,  0.187495000E-03 }, 
{     -60.0000,     135.0000, -0.192530000E+01, -0.269013884E-01, -0.523397850E-01, -0.104625325E-03 }, 
{     -45.0000,     135.0000, -0.230228000E+01, -0.201701599E-01, -0.551920038E-01, -0.838165980E-05 }, 
{     -30.0000,     135.0000, -0.244135000E+01,  0.437202815E-02, -0.482268848E-01,  0.960732008E-03 }, 
{     -15.0000,     135.0000, -0.213523000E+01,  0.360920473E-01, -0.346427746E-01,  0.275299481E-03 }, 
{       0.0000,     135.0000, -0.144080000E+01,  0.513697825E-01, -0.314688948E-01,  0.128966806E-02 }, 
{      15.0000,     135.0000, -0.465710000E+00,  0.923328228E-01, -0.339722700E-01, -0.529987083E-02 }, 
{      30.0000,     135.0000,  0.381110000E+00, -0.563190736E-01, -0.150351373E+00, -0.386668043E-02 }, 
{      45.0000,     135.0000, -0.155691000E+01, -0.852965285E-01, -0.115581520E+00,  0.444474245E-02 }, 
{      60.0000,     135.0000, -0.135419000E+01,  0.504451875E-01, -0.720427463E-01,  0.174943604E-02 }, 
{      75.0000,     135.0000, -0.907580000E+00,  0.133817783E-01, -0.552561793E-01,  0.622581611E-03 }, 
{      90.0000,     135.0000, -0.901520000E+00, -0.134383008E-01, -0.500379559E-01,  0.161195588E-03 }, 
{     105.0000,     135.0000, -0.125345000E+01, -0.288025751E-01, -0.520124510E-01, -0.618618301E-03 }, 
{     120.0000,     135.0000, -0.168612000E+01, -0.282713988E-01, -0.671664488E-01, -0.111242097E-02 }, 
{     135.0000,     135.0000, -0.202075000E+01, -0.115718298E-01, -0.776190249E-01, -0.530126106E-04 }, 
{     150.0000,     135.0000, -0.198551000E+01,  0.146807180E-01, -0.677018917E-01,  0.121738282E-02 }, 
{     165.0000,     135.0000, -0.160806000E+01,  0.353869578E-01, -0.467238181E-01,  0.136252268E-02 }, 
{     180.0000,     135.0000, -0.102882000E+01,  0.351094509E-01, -0.312532114E-01,  0.622262542E-03 }, 
{    -180.0000,     150.0000, -0.140265000E+01,  0.351711419E-01, -0.136467426E-01, -0.472362088E-03 }, 
{    -165.0000,     150.0000, -0.108685000E+01,  0.764138829E-02, -0.237140479E-01, -0.900642866E-03 }, 
{    -150.0000,     150.0000, -0.114225000E+01, -0.136566951E-01, -0.389271695E-01, -0.981151832E-03 }, 
{    -135.0000,     150.0000, -0.144392000E+01, -0.244286080E-01, -0.505686044E-01, -0.545661097E-03 }, 
{    -120.0000,     150.0000, -0.179431000E+01, -0.190408728E-01, -0.549065819E-01, -0.320862556E-04 }, 
{    -105.0000,     150.0000, -0.198737000E+01, -0.809790083E-02, -0.534833352E-01,  0.910599615E-04 }, 
{     -90.0000,     150.0000, -0.209728000E+01, -0.916152391E-02, -0.514226606E-01,  0.364630671E-03 }, 
{     -75.0000,     150.0000, -0.230285000E+01, -0.183520035E-01, -0.437862336E-01,  0.389837668E-03 }, 
{     -60.0000,     150.0000, -0.264023000E+01, -0.260204620E-01, -0.412986366E-01,  0.100823459E-03 }, 
{     -45.0000,     150.0000, -0.299514000E+01, -0.160241486E-01, -0.375117152E-01,  0.461772165E-03 }, 
{     -30.0000,     150.0000, -0.299946000E+01,  0.182710565E-01, -0.279138011E-01,  0.729054977E-03 }, 
{     -15.0000,     150.0000, -0.255243000E+01,  0.314819226E-01, -0.235777704E-01, -0.591203108E-03 }, 
{       0.0000,     150.0000, -0.190769000E+01,  0.741552530E-01, -0.370701614E-01, -0.195514605E-03 }, 
{      15.0000,     150.0000, -0.100235000E+01, -0.180869344E-01, -0.528119434E-01, -0.447357306E-02 }, 
{      30.0000,     150.0000, -0.231986000E+01, -0.842415152E-01, -0.125341539E+00,  0.435531324E-03 }, 
{      45.0000,     150.0000, -0.268419000E+01,  0.186849952E-01, -0.436465087E-01,  0.456453470E-02 }, 
{      60.0000,     150.0000, -0.214117000E+01,  0.452395343E-01, -0.351388183E-01, -0.653125985E-03 }, 
{      75.0000,     150.0000, -0.157168000E+01,  0.228588675E-01, -0.318073549E-01,  0.415799993E-03 }, 
{      90.0000,     150.0000, -0.153158000E+01, -0.147570043E-01, -0.306601386E-01, -0.114338044E-03 }, 
{     105.0000,     150.0000, -0.194553000E+01, -0.386008503E-01, -0.347932499E-01, -0.555626818E-03 }, 
{     120.0000,     150.0000, -0.256850000E+01, -0.382235945E-01, -0.437984613E-01, -0.290819237E-03 }, 
{     135.0000,     150.0000, -0.293976000E+01, -0.735077188E-02, -0.403519578E-01,  0.607162189E-03 }, 
{     150.0000,     150.0000, -0.274531000E+01,  0.322646820E-01, -0.275625257E-01,  0.110935761E-02 }, 
{     165.0000,     150.0000, -0.207985000E+01,  0.502740440E-01, -0.124462932E-01,  0.536540272E-03 }, 
{     180.0000,     150.0000, -0.140265000E+01,  0.351711419E-01, -0.136467426E-01, -0.472362088E-03 }, 
{    -180.0000,     165.0000, -0.145988000E+01,  0.238388405E-01, -0.371818305E-03, -0.986936255E-03 }, 
{    -165.0000,     165.0000, -0.137849000E+01, -0.132102354E-01, -0.200011104E-01, -0.152197458E-02 }, 
{    -150.0000,     165.0000, -0.175672000E+01, -0.303658989E-01, -0.406467266E-01, -0.980147089E-03 }, 
{    -135.0000,     165.0000, -0.218673000E+01, -0.269741691E-01, -0.471679863E-01,  0.918775987E-05 }, 
{    -120.0000,     165.0000, -0.253115000E+01, -0.166234247E-01, -0.442105672E-01,  0.230627931E-03 }, 
{    -105.0000,     165.0000, -0.268486000E+01, -0.615813225E-02, -0.411791960E-01,  0.266058568E-03 }, 
{     -90.0000,     165.0000, -0.275836000E+01, -0.418604636E-02, -0.365601247E-01,  0.235226292E-03 }, 
{     -75.0000,     165.0000, -0.286750000E+01, -0.136256823E-01, -0.345920016E-01,  0.110475149E-03 }, 
{     -60.0000,     165.0000, -0.317263000E+01, -0.241652244E-01, -0.319316688E-01,  0.248564300E-03 }, 
{     -45.0000,     165.0000, -0.345161000E+01, -0.653542027E-02, -0.246271352E-01,  0.888240933E-03 }, 
{     -30.0000,     165.0000, -0.330648000E+01,  0.235369054E-01, -0.131439109E-01, -0.439764563E-04 }, 
{     -15.0000,     165.0000, -0.280614000E+01,  0.414817985E-01, -0.522814375E-02,  0.316746318E-02 }, 
{       0.0000,     165.0000, -0.216102000E+01,  0.396279005E-01,  0.357055403E-01, -0.285598604E-02 }, 
{      15.0000,     165.0000, -0.198062000E+01, -0.348894005E-01, -0.577619565E-01, -0.225028156E-02 }, 
{      30.0000,     165.0000, -0.293106000E+01, -0.540782986E-01, -0.107164705E-01,  0.257271013E-02 }, 
{      45.0000,     165.0000, -0.312990000E+01,  0.213465948E-01, -0.244304447E-01, -0.137425661E-02 }, 
{      60.0000,     165.0000, -0.253301000E+01,  0.483019195E-01, -0.231659806E-01,  0.434414290E-03 }, 
{      75.0000,     165.0000, -0.193409000E+01,  0.246077271E-01, -0.228164011E-01, -0.405918223E-04 }, 
{      90.0000,     165.0000, -0.186594000E+01, -0.133188280E-01, -0.202054899E-01,  0.320051148E-03 }, 
{     105.0000,     165.0000, -0.228500000E+01, -0.415144151E-01, -0.151245494E-01,  0.298757572E-03 }, 
{     120.0000,     165.0000, -0.294737000E+01, -0.369095115E-01, -0.988970590E-02,  0.548075361E-03 }, 
{     135.0000,     165.0000, -0.320597000E+01,  0.495846130E-02,  0.198285611E-02,  0.930422076E-03 }, 
{     150.0000,     165.0000, -0.281104000E+01,  0.443416664E-01,  0.128459944E-01,  0.277376388E-03 }, 
{     165.0000,     165.0000, -0.204178000E+01,  0.505128733E-01,  0.976499092E-02, -0.483500667E-03 }, 
{     180.0000,     165.0000, -0.145988000E+01,  0.238388405E-01, -0.371818305E-03, -0.986936255E-03 }, 
{    -180.0000,     180.0000, -0.146854000E+01,  0.491175487E-02,  0.195601580E-02, -0.163177030E-02 }, 
{    -165.0000,     180.0000, -0.171132000E+01, -0.337083049E-01, -0.211755104E-01, -0.128139745E-02 }, 
{    -150.0000,     180.0000, -0.232191000E+01, -0.407525353E-01, -0.344179241E-01, -0.517427860E-03 }, 
{    -135.0000,     180.0000, -0.282200000E+01, -0.254175539E-01, -0.363754505E-01,  0.311120885E-03 }, 
{    -120.0000,     180.0000, -0.309109000E+01, -0.114132491E-01, -0.276071493E-01,  0.635099272E-03 }, 
{    -105.0000,     180.0000, -0.317704000E+01,  0.625502477E-04, -0.197338807E-01,  0.476795981E-03 }, 
{     -90.0000,     180.0000, -0.316347000E+01, -0.331295190E-02, -0.155748405E-01, -0.135821438E-03 }, 
{     -75.0000,     180.0000, -0.331935000E+01, -0.152727426E-01, -0.211457600E-01, -0.215886083E-03 }, 
{     -60.0000,     180.0000, -0.357978000E+01, -0.188580776E-01, -0.188846883E-01,  0.337396219E-03 }, 
{     -45.0000,     180.0000, -0.373419000E+01,  0.773705294E-02, -0.117897439E-01,  0.737504418E-03 }, 
{     -30.0000,     180.0000, -0.344056000E+01,  0.157538658E-01, -0.773055529E-02, -0.105658729E-02 }, 
{     -15.0000,     180.0000, -0.291290000E+01,  0.935054838E-01, -0.276036546E-01,  0.326062604E-03 }, 
{       0.0000,     180.0000, -0.140592000E+01,  0.171521990E-01, -0.539799978E-02,  0.218847975E-03 }, 
{      15.0000,     180.0000, -0.256214000E+01, -0.919622797E-01, -0.280982308E-01, -0.130036975E-02 }, 
{      30.0000,     180.0000, -0.329734000E+01, -0.275870801E-01, -0.272885790E-01,  0.604515175E-03 }, 
{      45.0000,     180.0000, -0.349478000E+01,  0.157826001E-01, -0.207497125E-01,  0.352012717E-03 }, 
{      60.0000,     180.0000, -0.286320000E+01,  0.512846799E-01, -0.166032592E-01,  0.124497929E-03 }, 
{      75.0000,     180.0000, -0.226579000E+01,  0.248766805E-01, -0.157490408E-01,  0.150129902E-03 }, 
{      90.0000,     180.0000, -0.214254000E+01, -0.665940194E-02, -0.107099019E-01,  0.453653923E-03 }, 
{     105.0000,     180.0000, -0.242944000E+01, -0.309690728E-01, -0.149055264E-02,  0.886952040E-03 }, 
{     120.0000,     180.0000, -0.290813000E+01, -0.225823070E-01,  0.154312849E-01,  0.122677527E-02 }, 
{     135.0000,     180.0000, -0.294808000E+01,  0.175703009E-01,  0.307565334E-01,  0.655364064E-03 }, 
{     150.0000,     180.0000, -0.245932000E+01,  0.420631034E-01,  0.333765482E-01, -0.259178877E-03 }, 
{     165.0000,     180.0000, -0.182999000E+01,  0.377952854E-01,  0.233583295E-01, -0.109828932E-02 }, 
{     180.0000,     180.0000, -0.146854000E+01,  0.491175487E-02,  0.195601580E-02, -0.163177030E-02 } }, 
{
{    -180.0000,    -180.0000, -0.146854000E+01,  0.491175487E-02,  0.195601580E-02, -0.163177030E-02 }, 
{    -165.0000,    -180.0000, -0.171132000E+01, -0.337083049E-01, -0.211755104E-01, -0.128139745E-02 }, 
{    -150.0000,    -180.0000, -0.232191000E+01, -0.407525353E-01, -0.344179241E-01, -0.517427860E-03 }, 
{    -135.0000,    -180.0000, -0.282200000E+01, -0.254175539E-01, -0.363754505E-01,  0.311120885E-03 }, 
{    -120.0000,    -180.0000, -0.309109000E+01, -0.114132491E-01, -0.276071493E-01,  0.635099272E-03 }, 
{    -105.0000,    -180.0000, -0.317704000E+01,  0.625502477E-04, -0.197338807E-01,  0.476795981E-03 }, 
{     -90.0000,    -180.0000, -0.316347000E+01, -0.331295190E-02, -0.155748405E-01, -0.135821438E-03 }, 
{     -75.0000,    -180.0000, -0.331935000E+01, -0.152727426E-01, -0.211457600E-01, -0.215886083E-03 }, 
{     -60.0000,    -180.0000, -0.357978000E+01, -0.188580776E-01, -0.188846883E-01,  0.337396219E-03 }, 
{     -45.0000,    -180.0000, -0.373419000E+01,  0.773705294E-02, -0.117897439E-01,  0.737504418E-03 }, 
{     -30.0000,    -180.0000, -0.344056000E+01,  0.157538658E-01, -0.773055529E-02, -0.105658729E-02 }, 
{     -15.0000,    -180.0000, -0.291290000E+01,  0.935054838E-01, -0.276036546E-01,  0.326062604E-03 }, 
{       0.0000,    -180.0000, -0.140592000E+01,  0.171521990E-01, -0.539799978E-02,  0.218847975E-03 }, 
{      15.0000,    -180.0000, -0.256214000E+01, -0.919622797E-01, -0.280982308E-01, -0.130036975E-02 }, 
{      30.0000,    -180.0000, -0.329734000E+01, -0.275870801E-01, -0.272885790E-01,  0.604515175E-03 }, 
{      45.0000,    -180.0000, -0.349478000E+01,  0.157826001E-01, -0.207497125E-01,  0.352012717E-03 }, 
{      60.0000,    -180.0000, -0.286320000E+01,  0.512846799E-01, -0.166032592E-01,  0.124497929E-03 }, 
{      75.0000,    -180.0000, -0.226579000E+01,  0.248766805E-01, -0.157490408E-01,  0.150129902E-03 }, 
{      90.0000,    -180.0000, -0.214254000E+01, -0.665940194E-02, -0.107099019E-01,  0.453653923E-03 }, 
{     105.0000,    -180.0000, -0.242944000E+01, -0.309690728E-01, -0.149055264E-02,  0.886952040E-03 }, 
{     120.0000,    -180.0000, -0.290813000E+01, -0.225823070E-01,  0.154312849E-01,  0.122677527E-02 }, 
{     135.0000,    -180.0000, -0.294808000E+01,  0.175703009E-01,  0.307565334E-01,  0.655364064E-03 }, 
{     150.0000,    -180.0000, -0.245932000E+01,  0.420631034E-01,  0.333765482E-01, -0.259178877E-03 }, 
{     165.0000,    -180.0000, -0.182999000E+01,  0.377952854E-01,  0.233583295E-01, -0.109828932E-02 }, 
{     180.0000,    -180.0000, -0.146854000E+01,  0.491175487E-02,  0.195601580E-02, -0.163177030E-02 }, 
{    -180.0000,    -165.0000, -0.137589000E+01, -0.202380313E-01,  0.934575510E-02, -0.130135690E-02 }, 
{    -165.0000,    -165.0000, -0.194385000E+01, -0.509644305E-01, -0.836884785E-02, -0.903274625E-03 }, 
{    -150.0000,    -165.0000, -0.271993000E+01, -0.447122466E-01, -0.143235771E-01,  0.180588975E-03 }, 
{    -135.0000,    -165.0000, -0.317264000E+01, -0.159445829E-01, -0.451221178E-02,  0.952245941E-03 }, 
{    -120.0000,    -165.0000, -0.325398000E+01,  0.168057832E-02,  0.100731645E-01,  0.889775578E-03 }, 
{    -105.0000,    -165.0000, -0.319334000E+01,  0.508226963E-02,  0.184187189E-01,  0.748378854E-04 }, 
{     -90.0000,    -165.0000, -0.317385000E+01, -0.598365685E-02,  0.157614869E-01, -0.514626399E-04 }, 
{     -75.0000,    -165.0000, -0.338265000E+01, -0.190096422E-01,  0.161450415E-01, -0.323722798E-03 }, 
{     -60.0000,    -165.0000, -0.366037000E+01, -0.152817742E-01,  0.992242200E-02,  0.178540850E-03 }, 
{     -45.0000,    -165.0000, -0.377497000E+01,  0.167273915E-02,  0.711411094E-02, -0.219662672E-02 }, 
{     -30.0000,    -165.0000, -0.359488000E+01,  0.216888176E-01, -0.136138679E-01,  0.390070805E-02 }, 
{     -15.0000,    -165.0000, -0.303260000E+01,  0.600459903E-01,  0.703507621E-01, -0.758875239E-03 }, 
{       0.0000,    -165.0000, -0.223489000E+01,  0.101252211E-01, -0.288875412E-01, -0.391994174E-02 }, 
{      15.0000,    -165.0000, -0.282694000E+01, -0.594148746E-01,  0.890879736E-03,  0.254666573E-02 }, 
{      30.0000,    -165.0000, -0.353012000E+01, -0.315117226E-01,  0.587866139E-04, -0.477455635E-03 }, 
{      45.0000,    -165.0000, -0.362752000E+01,  0.253457650E-01,  0.790529464E-02,  0.766039786E-03 }, 
{      60.0000,    -165.0000, -0.290549000E+01,  0.550546627E-01,  0.150830173E-01,  0.418142627E-03 }, 
{      75.0000,    -165.0000, -0.224790000E+01,  0.303595842E-01,  0.230505643E-01,  0.590443634E-03 }, 
{      90.0000,    -165.0000, -0.202431000E+01, -0.256999560E-03,  0.313710974E-01,  0.477698850E-03 }, 
{     105.0000,    -165.0000, -0.220106000E+01, -0.199635860E-01,  0.378747599E-01,  0.463600095E-03 }, 
{     120.0000,    -165.0000, -0.246619000E+01, -0.826465654E-02,  0.444005662E-01,  0.273794543E-03 }, 
{     135.0000,    -165.0000, -0.235440000E+01,  0.223542121E-01,  0.453050104E-01, -0.727281655E-04 }, 
{     150.0000,    -165.0000, -0.187193000E+01,  0.376998080E-01,  0.414698129E-01, -0.569032549E-03 }, 
{     165.0000,    -165.0000, -0.138645000E+01,  0.204365558E-01,  0.278676910E-01, -0.113860553E-02 }, 
{     180.0000,    -165.0000, -0.137589000E+01, -0.202380313E-01,  0.934575510E-02, -0.130135690E-02 }, 
{    -180.0000,    -150.0000, -0.115099000E+01, -0.310417390E-01,  0.241709638E-01, -0.353500842E-03 }, 
{    -165.0000,    -150.0000, -0.187041000E+01, -0.574382190E-01,  0.228329018E-01,  0.148513124E-03 }, 
{    -150.0000,    -150.0000, -0.263447000E+01, -0.359013849E-01,  0.292002323E-01,  0.765302051E-03 }, 
{    -135.0000,    -150.0000, -0.287523000E+01,  0.797584610E-04,  0.437782976E-01,  0.979357826E-03 }, 
{    -120.0000,    -150.0000, -0.276065000E+01,  0.103463510E-01,  0.534024913E-01,  0.157718437E-03 }, 
{    -105.0000,    -150.0000, -0.265655000E+01,  0.227083750E-02,  0.501570051E-01, -0.334490071E-03 }, 
{     -90.0000,    -150.0000, -0.269447000E+01, -0.619370101E-02,  0.463288929E-01, -0.234477824E-03 }, 
{     -75.0000,    -150.0000, -0.287999000E+01, -0.221840335E-01,  0.444375938E-01,  0.128519108E-03 }, 
{     -60.0000,    -150.0000, -0.325866000E+01, -0.179081652E-01,  0.434190003E-01, -0.861577134E-03 }, 
{     -45.0000,    -150.0000, -0.338680000E+01, -0.754530591E-02,  0.528113002E-01,  0.499253070E-02 }, 
{     -30.0000,    -150.0000, -0.297043000E+01,  0.105735389E+00,  0.156212027E+00,  0.345005969E-02 }, 
{     -15.0000,    -150.0000, -0.103367000E+01,  0.552297508E-01,  0.122046606E+00, -0.494570826E-02 }, 
{       0.0000,    -150.0000, -0.171478000E+01, -0.755243918E-01,  0.591761645E-01, -0.307439916E-02 }, 
{      15.0000,    -150.0000, -0.252395000E+01, -0.511881835E-01,  0.321727119E-01, -0.731473946E-03 }, 
{      30.0000,    -150.0000, -0.327577000E+01, -0.319208741E-01,  0.313674326E-01,  0.438548556E-03 }, 
{      45.0000,    -150.0000, -0.323972000E+01,  0.357176800E-01,  0.401405339E-01,  0.570844128E-03 }, 
{      60.0000,    -150.0000, -0.240665000E+01,  0.628741541E-01,  0.475811900E-01,  0.520826415E-03 }, 
{      75.0000,    -150.0000, -0.159834000E+01,  0.410617035E-01,  0.570367837E-01,  0.725100163E-03 }, 
{      90.0000,    -150.0000, -0.123549000E+01,  0.711103178E-02,  0.666355124E-01,  0.389637421E-03 }, 
{     105.0000,    -150.0000, -0.134347000E+01, -0.185318306E-01,  0.671855129E-01, -0.253903996E-03 }, 
{     120.0000,    -150.0000, -0.163936000E+01, -0.137577092E-01,  0.607204502E-01, -0.557033880E-03 }, 
{     135.0000,    -150.0000, -0.162896000E+01,  0.164646674E-01,  0.518474249E-01, -0.585578094E-03 }, 
{     150.0000,    -150.0000, -0.124795000E+01,  0.261810394E-01,  0.430182003E-01, -0.641103725E-03 }, 
{     165.0000,    -150.0000, -0.992700000E+00,  0.606317489E-02,  0.326289065E-01, -0.693710682E-03 }, 
{     180.0000,    -150.0000, -0.115099000E+01, -0.310417390E-01,  0.241709638E-01, -0.353500842E-03 }, 
{    -180.0000,    -135.0000, -0.623800000E+00, -0.318603942E-01,  0.443883896E-01,  0.390887695E-03 }, 
{    -165.0000,    -135.0000, -0.126193000E+01, -0.485337577E-01,  0.534212405E-01,  0.795356687E-03 }, 
{    -150.0000,    -135.0000, -0.187630000E+01, -0.245045749E-01,  0.662486477E-01,  0.799737166E-03 }, 
{    -135.0000,    -135.0000, -0.195058000E+01,  0.882205738E-02,  0.738110213E-01,  0.836508158E-04 }, 
{    -120.0000,    -135.0000, -0.179284000E+01,  0.590834540E-02,  0.685448703E-01, -0.675095911E-03 }, 
{    -105.0000,    -135.0000, -0.180435000E+01, -0.320943896E-02,  0.587512606E-01, -0.395219318E-03 }, 
{     -90.0000,    -135.0000, -0.188558000E+01, -0.116185895E-01,  0.565769414E-01, -0.137612603E-03 }, 
{     -75.0000,    -135.0000, -0.212688000E+01, -0.148222029E-01,  0.572585832E-01,  0.647134242E-03 }, 
{     -60.0000,    -135.0000, -0.234588000E+01, -0.211525990E-01,  0.792995768E-01,  0.209360273E-02 }, 
{     -45.0000,    -135.0000, -0.200096000E+01,  0.124616599E+00,  0.136442688E+00,  0.681527589E-02 }, 
{     -30.0000,    -135.0000,  0.485020000E+00,  0.888662031E-01,  0.204745760E+00, -0.426546969E-02 }, 
{     -15.0000,    -135.0000, -0.443000000E-02, -0.807754115E-01,  0.470968135E-01, -0.762257210E-02 }, 
{       0.0000,    -135.0000, -0.100421000E+01, -0.636105571E-01,  0.383188831E-01,  0.147038276E-02 }, 
{      15.0000,    -135.0000, -0.198371000E+01, -0.606383602E-01,  0.390642728E-01,  0.134532926E-03 }, 
{      30.0000,    -135.0000, -0.263328000E+01, -0.196500020E-01,  0.538394831E-01,  0.109560553E-02 }, 
{      45.0000,    -135.0000, -0.247979000E+01,  0.400223683E-01,  0.610785697E-01, -0.114095640E-03 }, 
{      60.0000,    -135.0000, -0.160032000E+01,  0.661525290E-01,  0.556262227E-01, -0.281875035E-03 }, 
{      75.0000,    -135.0000, -0.712370000E+00,  0.488515159E-01,  0.559083011E-01,  0.207542049E-03 }, 
{      90.0000,    -135.0000, -0.243680000E+00,  0.976940749E-02,  0.582128529E-01, -0.309671239E-04 }, 
{     105.0000,    -135.0000, -0.393000000E+00, -0.240551459E-01,  0.549951884E-01, -0.266296086E-03 }, 
{     120.0000,    -135.0000, -0.774170000E+00, -0.196468240E-01,  0.511216330E-01, -0.322092525E-03 }, 
{     135.0000,    -135.0000, -0.874290000E+00,  0.638444205E-02,  0.433272901E-01, -0.778913474E-03 }, 
{     150.0000,    -135.0000, -0.637980000E+00,  0.213470558E-01,  0.332473859E-01, -0.137102984E-03 }, 
{     165.0000,    -135.0000, -0.398740000E+00,  0.333733460E-02,  0.391586831E-01,  0.493604007E-03 }, 
{     180.0000,    -135.0000, -0.623800000E+00, -0.318603942E-01,  0.443883896E-01,  0.390887695E-03 }, 
{    -180.0000,    -120.0000,  0.786600000E-01, -0.198388571E-01,  0.442054776E-01,  0.103052643E-02 }, 
{    -165.0000,    -120.0000, -0.404460000E+00, -0.376487481E-01,  0.566721362E-01,  0.627954317E-03 }, 
{    -150.0000,    -120.0000, -0.847370000E+00, -0.147721505E-01,  0.632251769E-01,  0.261596155E-03 }, 
{    -135.0000,    -120.0000, -0.872280000E+00,  0.317335008E-02,  0.615676171E-01, -0.695242765E-03 }, 
{    -120.0000,    -120.0000, -0.889760000E+00, -0.639924982E-02,  0.465960275E-01, -0.806454958E-03 }, 
{    -105.0000,    -120.0000, -0.102383000E+01, -0.788635080E-02,  0.413819525E-01, -0.116070316E-03 }, 
{     -90.0000,    -120.0000, -0.110879000E+01, -0.586134697E-02,  0.444993416E-01,  0.851399045E-03 }, 
{     -75.0000,    -120.0000, -0.119031000E+01, -0.196426133E-02,  0.644640736E-01,  0.132689835E-02 }, 
{     -60.0000,    -120.0000, -0.955880000E+00,  0.443003923E-01,  0.999386925E-01,  0.492887772E-02 }, 
{     -45.0000,    -120.0000,  0.386820000E+00,  0.140188692E+00,  0.156141946E+00, -0.270683466E-02 }, 
{     -30.0000,    -120.0000,  0.211255000E+01,  0.863083906E-02,  0.414009336E-01, -0.580909086E-02 }, 
{     -15.0000,    -120.0000,  0.665110000E+00, -0.119054048E+00,  0.293221401E-01,  0.579236836E-03 }, 
{       0.0000,    -120.0000, -0.527510000E+00, -0.604266454E-01,  0.250023030E-01,  0.212417400E-03 }, 
{      15.0000,    -120.0000, -0.134483000E+01, -0.412273699E-01,  0.473941971E-01,  0.218550497E-02 }, 
{      30.0000,    -120.0000, -0.167220000E+01, -0.360187514E-02,  0.739886351E-01,  0.842829130E-03 }, 
{      45.0000,    -120.0000, -0.146859000E+01,  0.308828704E-01,  0.697711872E-01, -0.108142348E-02 }, 
{      60.0000,    -120.0000, -0.813130000E+00,  0.518843934E-01,  0.486179190E-01, -0.159127842E-02 }, 
{      75.0000,    -120.0000, -0.569900000E-01,  0.438995559E-01,  0.276000120E-01, -0.987697878E-03 }, 
{      90.0000,    -120.0000,  0.370100000E+00,  0.916338286E-02,  0.216310758E-01,  0.144701291E-03 }, 
{     105.0000,    -120.0000,  0.227770000E+00, -0.236010874E-01,  0.270817334E-01,  0.305236994E-03 }, 
{     120.0000,    -120.0000, -0.178280000E+00, -0.244350333E-01,  0.270090179E-01, -0.290060845E-03 }, 
{     135.0000,    -120.0000, -0.392720000E+00, -0.275677934E-02,  0.220914146E-01, -0.143057368E-03 }, 
{     150.0000,    -120.0000, -0.248810000E+00,  0.213561507E-01,  0.238202559E-01,  0.224537913E-03 }, 
{     165.0000,    -120.0000,  0.100590000E+00,  0.159941766E-01,  0.293943610E-01,  0.705494998E-03 }, 
{     180.0000,    -120.0000,  0.786600000E-01, -0.198388571E-01,  0.442054776E-01,  0.103052643E-02 }, 
{    -180.0000,    -105.0000,  0.676330000E+00, -0.754522271E-02,  0.388157000E-01,  0.350040890E-03 }, 
{    -165.0000,    -105.0000,  0.353400000E+00, -0.308684692E-01,  0.429562147E-01,  0.225883752E-03 }, 
{    -150.0000,    -105.0000, -0.743100000E-01, -0.191089006E-01,  0.412486449E-01, -0.766986914E-03 }, 
{    -135.0000,    -105.0000, -0.237320000E+00, -0.108399286E-01,  0.225705104E-01, -0.123507694E-02 }, 
{    -120.0000,    -105.0000, -0.456770000E+00, -0.140233852E-01,  0.122850196E-01, -0.854303709E-04 }, 
{    -105.0000,    -105.0000, -0.596760000E+00, -0.495453071E-02,  0.172389295E-01,  0.510482231E-03 }, 
{     -90.0000,    -105.0000, -0.579310000E+00,  0.933350803E-02,  0.266796921E-01,  0.922435938E-03 }, 
{     -75.0000,    -105.0000, -0.291530000E+00,  0.286664986E-01,  0.519551226E-01,  0.274301265E-02 }, 
{     -60.0000,    -105.0000,  0.532990000E+00,  0.984604976E-01,  0.967196533E-01,  0.211350573E-02 }, 
{     -45.0000,    -105.0000,  0.220360000E+01,  0.765175110E-01,  0.799015261E-01, -0.560775486E-02 }, 
{     -30.0000,    -105.0000,  0.221673000E+01, -0.677825416E-01, -0.240074943E-01, -0.382791581E-02 }, 
{     -15.0000,    -105.0000,  0.757140000E+00, -0.946793446E-01, -0.120713737E-01,  0.252483813E-02 }, 
{       0.0000,    -105.0000, -0.213960000E+00, -0.396380799E-01,  0.197219047E-01,  0.247444308E-02 }, 
{      15.0000,    -105.0000, -0.529020000E+00, -0.400033595E-02,  0.622969388E-01,  0.245105204E-02 }, 
{      30.0000,    -105.0000, -0.478280000E+00,  0.277542364E-02,  0.812059764E-01,  0.181630820E-04 }, 
{      45.0000,    -105.0000, -0.437090000E+00,  0.112846414E-01,  0.683766816E-01, -0.130775580E-02 }, 
{      60.0000,    -105.0000, -0.117530000E+00,  0.242360108E-01,  0.464601011E-01, -0.173631492E-02 }, 
{      75.0000,    -105.0000,  0.187330000E+00,  0.166553153E-01,  0.136316509E-01, -0.269599065E-02 }, 
{      90.0000,    -105.0000,  0.379520000E+00,  0.855272787E-02, -0.200971563E-01, -0.791173967E-03 }, 
{     105.0000,    -105.0000,  0.378270000E+00, -0.126782268E-01, -0.906812204E-02,  0.132073192E-02 }, 
{     120.0000,    -105.0000,  0.461900000E-01, -0.245058207E-01,  0.491429524E-02,  0.510536577E-03 }, 
{     135.0000,    -105.0000, -0.162340000E+00,  0.257950952E-02,  0.106970513E-01,  0.590156439E-03 }, 
{     150.0000,    -105.0000,  0.121480000E+00,  0.292457826E-01,  0.233635903E-01,  0.818696687E-03 }, 
{     165.0000,    -105.0000,  0.547060000E+00,  0.223173600E-01,  0.324238727E-01,  0.480421088E-03 }, 
{     180.0000,    -105.0000,  0.676330000E+00, -0.754522271E-02,  0.388157000E-01,  0.350040890E-03 }, 
{    -180.0000,     -90.0000,  0.117430000E+01, -0.907524145E-02,  0.196597225E-01, -0.277966853E-03 }, 
{    -165.0000,     -90.0000,  0.790960000E+00, -0.332766342E-01,  0.105870051E-01, -0.657066543E-03 }, 
{    -150.0000,     -90.0000,  0.302190000E+00, -0.322402218E-01,  0.169224360E-02, -0.687262757E-03 }, 
{    -135.0000,     -90.0000, -0.159660000E+00, -0.278864786E-01, -0.932565882E-02, -0.576415207E-03 }, 
{    -120.0000,     -90.0000, -0.469070000E+00, -0.104658636E-01, -0.115981059E-01,  0.334853676E-03 }, 
{    -105.0000,     -90.0000, -0.456010000E+00,  0.104799332E-01,  0.322632967E-02,  0.174739820E-02 }, 
{     -90.0000,     -90.0000, -0.153780000E+00,  0.316041307E-01,  0.397838901E-01,  0.295195274E-02 }, 
{     -75.0000,     -90.0000,  0.535670000E+00,  0.614395439E-01,  0.729114360E-01,  0.381812103E-03 }, 
{     -60.0000,     -90.0000,  0.166178000E+01,  0.857496937E-01,  0.367146942E-01, -0.509304035E-02 }, 
{     -45.0000,     -90.0000,  0.252447000E+01, -0.667831884E-02, -0.482180509E-01, -0.423554809E-02 }, 
{     -30.0000,     -90.0000,  0.150282000E+01, -0.908284184E-01, -0.673169563E-01,  0.122890262E-02 }, 
{     -15.0000,     -90.0000,  0.419250000E+00, -0.510520077E-01, -0.302086451E-01,  0.292181877E-02 }, 
{       0.0000,     -90.0000,  0.617400000E-01,  0.682044915E-02,  0.139600781E-01,  0.333922919E-02 }, 
{      15.0000,     -90.0000,  0.422440000E+00,  0.244082111E-01,  0.568720477E-01,  0.113740305E-02 }, 
{      30.0000,     -90.0000,  0.563520000E+00, -0.409729359E-02,  0.483314594E-01, -0.101456515E-02 }, 
{      45.0000,     -90.0000,  0.446290000E+00, -0.324903674E-02,  0.396980864E-01, -0.513934737E-03 }, 
{      60.0000,     -90.0000,  0.499750000E+00,  0.433944057E-02,  0.281176766E-01, -0.972452460E-03 }, 
{      75.0000,     -90.0000,  0.389010000E+00, -0.255647255E-01,  0.707338435E-02, -0.212119583E-02 }, 
{      90.0000,     -90.0000, -0.728200000E-01, -0.165945384E-01, -0.298264507E-01, -0.213158968E-02 }, 
{     105.0000,     -90.0000, -0.291900000E-01,  0.830287919E-02, -0.422012452E-01,  0.792628625E-03 }, 
{     120.0000,     -90.0000, -0.230100000E-01, -0.665497836E-02, -0.156121989E-01,  0.180392553E-02 }, 
{     135.0000,     -90.0000, -0.612500000E-01,  0.119050342E-01,  0.141438009E-02,  0.714794327E-03 }, 
{     150.0000,     -90.0000,  0.389030000E+00,  0.414428414E-01,  0.102933827E-01,  0.518013492E-03 }, 
{     165.0000,     -90.0000,  0.982990000E+00,  0.311716000E-01,  0.173901482E-01,  0.408305330E-03 }, 
{     180.0000,     -90.0000,  0.117430000E+01, -0.907524145E-02,  0.196597225E-01, -0.277966853E-03 }, 
{    -180.0000,     -75.0000,  0.110152000E+01, -0.131838174E-01, -0.324165900E-01, -0.365892423E-03 }, 
{    -165.0000,     -75.0000,  0.593230000E+00, -0.441163968E-01, -0.373382350E-01, -0.247203106E-03 }, 
{    -150.0000,     -75.0000, -0.410700000E-01, -0.388685953E-01, -0.413696193E-01, -0.435901002E-03 }, 
{    -135.0000,     -75.0000, -0.516390000E+00, -0.223332220E-01, -0.410818752E-01,  0.124207908E-02 }, 
{    -120.0000,     -75.0000, -0.661030000E+00,  0.420948333E-02, -0.674459584E-02,  0.239258937E-02 }, 
{    -105.0000,     -75.0000, -0.381970000E+00,  0.323792887E-01,  0.128137519E-01, -0.333111455E-04 }, 
{     -90.0000,     -75.0000,  0.334870000E+00,  0.654533619E-01, -0.297925261E-02, -0.150627614E-02 }, 
{     -75.0000,     -75.0000,  0.127562000E+01,  0.373252638E-01, -0.301708667E-01, -0.253850801E-02 }, 
{     -60.0000,     -75.0000,  0.134926000E+01, -0.118764172E-01, -0.803244300E-01, -0.380872730E-02 }, 
{     -45.0000,     -75.0000,  0.104556000E+01, -0.358315951E-01, -0.118637323E+00,  0.801260250E-04 }, 
{     -30.0000,     -75.0000,  0.344610000E+00, -0.457272025E-01, -0.811486804E-01,  0.332337314E-02 }, 
{     -15.0000,     -75.0000, -0.807000000E-01, -0.651159475E-02, -0.346620459E-01,  0.342143677E-02 }, 
{       0.0000,     -75.0000,  0.203790000E+00,  0.436095815E-01,  0.798778293E-02,  0.818172452E-03 }, 
{      15.0000,     -75.0000,  0.881790000E+00,  0.245712686E-01, -0.762312977E-02, -0.128634335E-02 }, 
{      30.0000,     -75.0000,  0.830660000E+00, -0.165206560E-01, -0.127438139E-01,  0.180881582E-03 }, 
{      45.0000,     -75.0000,  0.646310000E+00, -0.558464466E-02, -0.104890271E-01, -0.103624550E-04 }, 
{      60.0000,     -75.0000,  0.605560000E+00, -0.616076538E-02, -0.143128074E-01, -0.453230477E-03 }, 
{      75.0000,     -75.0000,  0.296940000E+00, -0.396462938E-01, -0.200031883E-01, -0.795478745E-04 }, 
{      90.0000,     -75.0000, -0.432400000E+00, -0.428460593E-01, -0.229810411E-01, -0.962224752E-03 }, 
{     105.0000,     -75.0000, -0.725990000E+00,  0.644453104E-02, -0.429788970E-01, -0.666694858E-03 }, 
{     120.0000,     -75.0000, -0.426050000E+00,  0.183379351E-01, -0.369134996E-01,  0.842512475E-03 }, 
{     135.0000,     -75.0000, -0.219430000E+00,  0.215157284E-01, -0.277725717E-01,  0.337910030E-03 }, 
{     150.0000,     -75.0000,  0.313820000E+00,  0.435731513E-01, -0.260691212E-01, -0.252769234E-04 }, 
{     165.0000,     -75.0000,  0.918550000E+00,  0.317876665E-01, -0.276864655E-01, -0.219581103E-03 }, 
{     180.0000,     -75.0000,  0.110152000E+01, -0.131838174E-01, -0.324165900E-01, -0.365892423E-03 }, 
{    -180.0000,     -60.0000,  0.184510000E+00, -0.182088462E-01, -0.879513624E-01, -0.851843984E-04 }, 
{    -165.0000,     -60.0000, -0.341640000E+00, -0.436914516E-01, -0.877540651E-01, -0.437084523E-03 }, 
{    -150.0000,     -60.0000, -0.947820000E+00, -0.334913472E-01, -0.862157665E-01,  0.218064168E-02 }, 
{    -135.0000,     -60.0000, -0.123013000E+01, -0.411594023E-04, -0.404408405E-01,  0.117716273E-02 }, 
{    -120.0000,     -60.0000, -0.971460000E+00,  0.289279848E-01, -0.619015107E-01, -0.202644145E-02 }, 
{    -105.0000,     -60.0000, -0.584950000E+00,  0.133652200E-01, -0.802693371E-01, -0.103709626E-02 }, 
{     -90.0000,     -60.0000, -0.537130000E+00,  0.447713509E-02, -0.104536880E+00, -0.235224731E-02 }, 
{     -75.0000,     -60.0000, -0.377080000E+00,  0.103002396E-01, -0.134777969E+00, -0.455640907E-03 }, 
{     -60.0000,     -60.0000, -0.340110000E+00, -0.627409352E-02, -0.115794974E+00,  0.192319208E-02 }, 
{     -45.0000,     -60.0000, -0.531630000E+00, -0.161138655E-01, -0.884526588E-01,  0.202793466E-02 }, 
{     -30.0000,     -60.0000, -0.724250000E+00, -0.609844441E-02, -0.535023223E-01,  0.242359963E-02 }, 
{     -15.0000,     -60.0000, -0.564000000E+00,  0.340336431E-01, -0.277931713E-01,  0.409564330E-03 }, 
{       0.0000,     -60.0000,  0.866400000E-01,  0.321418718E-01, -0.409312098E-01, -0.154763446E-02 }, 
{      15.0000,     -60.0000,  0.272770000E+00,  0.475286960E-02, -0.563135287E-01,  0.769020340E-04 }, 
{      30.0000,     -60.0000,  0.343150000E+00,  0.148649802E-03, -0.414302040E-01,  0.114022750E-02 }, 
{      45.0000,     -60.0000,  0.251590000E+00, -0.958346880E-02, -0.366819778E-01, -0.711501854E-03 }, 
{      60.0000,     -60.0000,  0.826800000E-01, -0.139087746E-01, -0.542804469E-01, -0.864268666E-03 }, 
{      75.0000,     -60.0000, -0.264530000E+00, -0.380054328E-01, -0.577686311E-01, -0.487541335E-04 }, 
{      90.0000,     -60.0000, -0.971080000E+00, -0.448214941E-01, -0.579013851E-01,  0.335097555E-03 }, 
{     105.0000,     -60.0000, -0.135929000E+01, -0.166059089E-02, -0.519031667E-01, -0.118543209E-03 }, 
{     120.0000,     -60.0000, -0.114928000E+01,  0.158238576E-01, -0.619878027E-01, -0.678208231E-03 }, 
{     135.0000,     -60.0000, -0.943440000E+00,  0.215351604E-01, -0.667620934E-01, -0.140409215E-03 }, 
{     150.0000,     -60.0000, -0.433040000E+00,  0.412835008E-01, -0.704308978E-01, -0.448773923E-03 }, 
{     165.0000,     -60.0000,  0.115450000E+00,  0.251088363E-01, -0.801522862E-01, -0.742533651E-03 }, 
{     180.0000,     -60.0000,  0.184510000E+00, -0.182088462E-01, -0.879513624E-01, -0.851843984E-04 }, 
{    -180.0000,     -45.0000, -0.141673000E+01, -0.223918033E-01, -0.119427960E+00, -0.113496717E-02 }, 
{    -165.0000,     -45.0000, -0.195928000E+01, -0.430368239E-01, -0.122147505E+00,  0.221145578E-02 }, 
{    -150.0000,     -45.0000, -0.236546000E+01,  0.479309897E-02, -0.786453149E-01,  0.445673150E-03 }, 
{    -135.0000,     -45.0000, -0.211313000E+01, -0.690557196E-02, -0.116502763E+00, -0.286520000E-02 }, 
{    -120.0000,     -45.0000, -0.261839000E+01, -0.277568111E-01, -0.137121361E+00, -0.680082462E-03 }, 
{    -105.0000,     -45.0000, -0.262430000E+01,  0.156988164E-01, -0.140202403E+00,  0.845601729E-03 }, 
{     -90.0000,     -45.0000, -0.233200000E+01,  0.222395455E-01, -0.112247229E+00,  0.227250212E-02 }, 
{     -75.0000,     -45.0000, -0.200648000E+01,  0.189070016E-01, -0.871372565E-01,  0.677419186E-03 }, 
{     -60.0000,     -45.0000, -0.176604000E+01,  0.153244483E-01, -0.795556740E-01,  0.155613206E-02 }, 
{     -45.0000,     -45.0000, -0.152939000E+01,  0.152132053E-01, -0.425420423E-01,  0.201709542E-02 }, 
{     -30.0000,     -45.0000, -0.130296000E+01,  0.164387304E-01, -0.343560306E-01, -0.584585053E-03 }, 
{     -15.0000,     -45.0000, -0.106202000E+01,  0.125058730E-01, -0.504292690E-01, -0.125620055E-02 }, 
{       0.0000,     -45.0000, -0.869050000E+00,  0.203197777E-01, -0.588309437E-01,  0.714404624E-03 }, 
{      15.0000,     -45.0000, -0.470810000E+00,  0.244570162E-01, -0.376427556E-01,  0.955884732E-03 }, 
{      30.0000,     -45.0000, -0.258490000E+00,  0.396415744E-02, -0.393653703E-01, -0.644828883E-03 }, 
{      45.0000,     -45.0000, -0.391740000E+00, -0.244996460E-01, -0.503930616E-01, -0.926630393E-03 }, 
{      60.0000,     -45.0000, -0.888220000E+00, -0.319115735E-01, -0.673214050E-01, -0.123985649E-02 }, 
{      75.0000,     -45.0000, -0.137110000E+01, -0.437260600E-01, -0.825302874E-01, -0.541388823E-03 }, 
{      90.0000,     -45.0000, -0.210106000E+01, -0.357521865E-01, -0.791454185E-01,  0.104060909E-02 }, 
{     105.0000,     -45.0000, -0.230318000E+01,  0.318806141E-03, -0.648464362E-01, -0.842772844E-04 }, 
{     120.0000,     -45.0000, -0.225641000E+01,  0.340696197E-02, -0.812072897E-01, -0.111587418E-02 }, 
{     135.0000,     -45.0000, -0.214075000E+01,  0.185393460E-01, -0.894430545E-01, -0.371549659E-03 }, 
{     150.0000,     -45.0000, -0.171196000E+01,  0.313256542E-01, -0.973632877E-01, -0.629126800E-03 }, 
{     165.0000,     -45.0000, -0.135890000E+01,  0.125280373E-01, -0.107194390E+00, -0.662210143E-03 }, 
{     180.0000,     -45.0000, -0.141673000E+01, -0.223918033E-01, -0.119427960E+00, -0.113496717E-02 }, 
{    -180.0000,     -30.0000, -0.307130000E+01, -0.301231364E-01, -0.854987959E-01,  0.224219502E-02 }, 
{    -165.0000,     -30.0000, -0.353917000E+01, -0.796473078E-02, -0.631619162E-01, -0.126339443E-02 }, 
{    -150.0000,     -30.0000, -0.353958000E+01, -0.316739405E-01, -0.117554974E+00, -0.359985292E-02 }, 
{    -135.0000,     -30.0000, -0.442996000E+01, -0.434975074E-01, -0.133514108E+00,  0.159236766E-02 }, 
{    -120.0000,     -30.0000, -0.447148000E+01,  0.192839700E-01, -0.896170438E-01,  0.281796834E-02 }, 
{    -105.0000,     -30.0000, -0.410460000E+01,  0.314336272E-01, -0.628510495E-01,  0.126837079E-02 }, 
{     -90.0000,     -30.0000, -0.355682000E+01,  0.379135210E-01, -0.504122061E-01, -0.504839638E-04 }, 
{     -75.0000,     -30.0000, -0.299677000E+01,  0.384782887E-01, -0.406110049E-01,  0.338157398E-02 }, 
{     -60.0000,     -30.0000, -0.241581000E+01,  0.363753242E-01,  0.188776699E-01,  0.382163236E-03 }, 
{     -45.0000,     -30.0000, -0.199124000E+01,  0.171264144E-01, -0.333011719E-01, -0.344826034E-02 }, 
{     -30.0000,     -30.0000, -0.190181000E+01, -0.208098193E-02, -0.445855553E-01,  0.718233078E-03 }, 
{     -15.0000,     -30.0000, -0.185246000E+01,  0.189535133E-01, -0.281817527E-01,  0.159921188E-02 }, 
{       0.0000,     -30.0000, -0.132972000E+01,  0.406849287E-01, -0.701701555E-02,  0.398627345E-03 }, 
{      15.0000,     -30.0000, -0.847940000E+00,  0.192107718E-01, -0.172574489E-01, -0.100886052E-02 }, 
{      30.0000,     -30.0000, -0.809280000E+00, -0.134400160E-01, -0.315943148E-01, -0.127864512E-02 }, 
{      45.0000,     -30.0000, -0.121194000E+01, -0.382507080E-01, -0.544517759E-01, -0.131542441E-02 }, 
{      60.0000,     -30.0000, -0.188152000E+01, -0.480051521E-01, -0.692739330E-01, -0.995580891E-03 }, 
{      75.0000,     -30.0000, -0.260158000E+01, -0.476566836E-01, -0.795202195E-01,  0.284059264E-03 }, 
{      90.0000,     -30.0000, -0.315607000E+01, -0.162781133E-01, -0.625149409E-01,  0.121114225E-02 }, 
{     105.0000,     -30.0000, -0.320162000E+01, -0.723886305E-02, -0.571770885E-01, -0.660002085E-03 }, 
{     120.0000,     -30.0000, -0.345891000E+01, -0.153344345E-01, -0.751090387E-01, -0.108995346E-02 }, 
{     135.0000,     -30.0000, -0.348535000E+01,  0.118306010E-01, -0.838476884E-01, -0.314304037E-03 }, 
{     150.0000,     -30.0000, -0.318558000E+01,  0.226780307E-01, -0.906239513E-01, -0.755812909E-03 }, 
{     165.0000,     -30.0000, -0.293476000E+01,  0.757527644E-02, -0.101112156E+00, -0.115337757E-03 }, 
{     180.0000,     -30.0000, -0.307130000E+01, -0.301231364E-01, -0.854987959E-01,  0.224219502E-02 }, 
{    -180.0000,     -15.0000, -0.426272000E+01,  0.602086072E-02, -0.107774856E+00, -0.215128008E-02 }, 
{    -165.0000,     -15.0000, -0.429968000E+01, -0.521562919E-01, -0.932848306E-01,  0.101822835E-02 }, 
{    -150.0000,     -15.0000, -0.553484000E+01, -0.518196930E-01, -0.850107888E-01,  0.263118013E-02 }, 
{    -135.0000,     -15.0000, -0.546735000E+01,  0.259010641E-01, -0.202848035E-01,  0.305705656E-02 }, 
{    -120.0000,     -15.0000, -0.514571000E+01,  0.260414366E-01, -0.987446357E-02,  0.167858665E-03 }, 
{    -105.0000,     -15.0000, -0.458142000E+01,  0.471191894E-01,  0.182601158E-03,  0.364989702E-03 }, 
{     -90.0000,     -15.0000, -0.390491000E+01,  0.336418059E-01, -0.685947074E-03,  0.209885827E-03 }, 
{     -75.0000,     -15.0000, -0.324057000E+01,  0.864835869E-01,  0.276327597E-02, -0.688398048E-03 }, 
{     -60.0000,     -15.0000, -0.189175000E+01,  0.230558466E-01, -0.210970056E-01, -0.153850534E-02 }, 
{     -45.0000,     -15.0000, -0.253686000E+01, -0.379649733E-01, -0.257472699E-01,  0.114031022E-02 }, 
{     -30.0000,     -15.0000, -0.233510000E+01,  0.401340466E-01,  0.627025193E-02,  0.245071598E-02 }, 
{     -15.0000,     -15.0000, -0.172931000E+01,  0.389387869E-01,  0.296982796E-01,  0.145935792E-03 }, 
{       0.0000,     -15.0000, -0.124042000E+01,  0.230468059E-01,  0.126250059E-01, -0.176350836E-02 }, 
{      15.0000,     -15.0000, -0.105797000E+01,  0.314198935E-02, -0.107594487E-01, -0.118344803E-02 }, 
{      30.0000,     -15.0000, -0.122154000E+01, -0.318387634E-01, -0.268673705E-01, -0.140117481E-02 }, 
{      45.0000,     -15.0000, -0.198839000E+01, -0.618709359E-01, -0.511298348E-01, -0.128592995E-02 }, 
{      60.0000,     -15.0000, -0.289394000E+01, -0.551574930E-01, -0.567268629E-01,  0.572996141E-03 }, 
{      75.0000,     -15.0000, -0.350491000E+01, -0.208030919E-01, -0.261508348E-01,  0.398974538E-02 }, 
{      90.0000,     -15.0000, -0.364469000E+01, -0.117801393E-01,  0.204791822E-01, -0.109076864E-02 }, 
{     105.0000,     -15.0000, -0.400273000E+01, -0.316403510E-01, -0.463552096E-01, -0.366754580E-02 }, 
{     120.0000,     -15.0000, -0.444345000E+01, -0.214104569E-01, -0.557645556E-01,  0.512204254E-03 }, 
{     135.0000,     -15.0000, -0.456253000E+01,  0.532217843E-02, -0.595221920E-01, -0.101466770E-02 }, 
{     150.0000,     -15.0000, -0.434373000E+01,  0.200657431E-01, -0.664949072E-01,  0.140039623E-02 }, 
{     165.0000,     -15.0000, -0.414696000E+01, -0.247115096E-02, -0.459689884E-01, -0.187627648E-02 }, 
{     180.0000,     -15.0000, -0.426272000E+01,  0.602086072E-02, -0.107774856E+00, -0.215128008E-02 }, 
{    -180.0000,       0.0000, -0.598372000E+01, -0.581804030E-01, -0.658857799E-01,  0.751471992E-03 }, 
{    -165.0000,       0.0000, -0.594426000E+01,  0.278900576E-01, -0.447167614E-01,  0.436143870E-02 }, 
{    -150.0000,       0.0000, -0.562295000E+01,  0.187741726E-01,  0.409241292E-01,  0.316475502E-02 }, 
{    -135.0000,       0.0000, -0.533032000E+01,  0.198012519E-01,  0.345813223E-01, -0.116084206E-02 }, 
{    -120.0000,       0.0000, -0.494188000E+01,  0.382348199E-01,  0.350348980E-01,  0.300766978E-03 }, 
{    -105.0000,       0.0000, -0.424888000E+01,  0.435474685E-01,  0.332646448E-01, -0.305561347E-03 }, 
{     -90.0000,       0.0000, -0.368237000E+01,  0.394773061E-01,  0.280459944E-01, -0.476302321E-03 }, 
{     -75.0000,       0.0000, -0.312300000E+01,  0.237193070E-01,  0.431190101E-02, -0.357977813E-02 }, 
{     -60.0000,       0.0000, -0.294185000E+01,  0.137494660E-01, -0.396976476E-01,  0.124668646E-02 }, 
{     -45.0000,       0.0000, -0.250222000E+01,  0.454388292E-01,  0.340942516E-01,  0.454950244E-02 }, 
{     -30.0000,       0.0000, -0.172945000E+01,  0.469752172E-01,  0.539765476E-01, -0.709857159E-03 }, 
{     -15.0000,       0.0000, -0.122644000E+01,  0.218163020E-01,  0.345926341E-01, -0.161039731E-02 }, 
{       0.0000,       0.0000, -0.105288000E+01,  0.107357479E-02,  0.118849921E-01, -0.126686470E-02 }, 
{      15.0000,       0.0000, -0.118766000E+01, -0.183546012E-01, -0.764875636E-02, -0.177042196E-02 }, 
{      30.0000,       0.0000, -0.167253000E+01, -0.515851701E-01, -0.335862030E-01, -0.745686467E-03 }, 
{      45.0000,       0.0000, -0.260495000E+01, -0.587627185E-01, -0.196308850E-01,  0.235674211E-02 }, 
{      60.0000,       0.0000, -0.328522000E+01, -0.359019558E-01,  0.154413848E-01,  0.112423558E-02 }, 
{      75.0000,       0.0000, -0.349217000E+01,  0.249265418E-01,  0.600555875E-02, -0.172639571E-02 }, 
{      90.0000,       0.0000, -0.315561000E+01, -0.378822113E-01, -0.193097879E-01, -0.116888730E-02 }, 
{     105.0000,       0.0000, -0.454402000E+01, -0.837676967E-01, -0.258820730E-01,  0.244185369E-04 }, 
{     120.0000,       0.0000, -0.509107000E+01, -0.141390018E-01, -0.282647388E-01, -0.719777030E-03 }, 
{     135.0000,       0.0000, -0.526456000E+01, -0.378429588E-02, -0.339055436E-01,  0.124999546E-02 }, 
{     150.0000,       0.0000, -0.504043000E+01,  0.394041854E-01, -0.143664200E-01, -0.150054105E-02 }, 
{     165.0000,       0.0000, -0.470775000E+01, -0.424704456E-01, -0.696098911E-01, -0.238870073E-02 }, 
{     180.0000,       0.0000, -0.598372000E+01, -0.581804030E-01, -0.658857799E-01,  0.751471992E-03 }, 
{    -180.0000,      15.0000, -0.578157000E+01,  0.347999178E-01,  0.675479757E-01,  0.490120352E-02 }, 
{    -165.0000,      15.0000, -0.521525000E+01,  0.357946655E-01,  0.890378761E-01, -0.873791683E-03 }, 
{    -150.0000,      15.0000, -0.478750000E+01,  0.208354203E-01,  0.707822719E-01, -0.759177535E-03 }, 
{    -135.0000,      15.0000, -0.452684000E+01,  0.185456532E-01,  0.700615143E-01,  0.115229482E-03 }, 
{    -120.0000,      15.0000, -0.416265000E+01,  0.299519670E-01,  0.663468714E-01, -0.588820501E-03 }, 
{    -105.0000,      15.0000, -0.365267000E+01,  0.364804788E-01,  0.525088196E-01, -0.127048643E-02 }, 
{     -90.0000,      15.0000, -0.318661000E+01,  0.193341180E-01,  0.321619695E-01, -0.116621414E-02 }, 
{     -75.0000,      15.0000, -0.298796000E+01,  0.191250494E-01,  0.305111200E-01,  0.153580308E-02 }, 
{     -60.0000,      15.0000, -0.245967000E+01,  0.495536846E-01,  0.663035959E-01,  0.185132712E-02 }, 
{     -45.0000,      15.0000, -0.163290000E+01,  0.536722122E-01,  0.701622634E-01, -0.101088286E-02 }, 
{     -30.0000,      15.0000, -0.978810000E+00,  0.319294667E-01,  0.490815577E-01, -0.125220333E-02 }, 
{     -15.0000,      15.0000, -0.712560000E+00,  0.267792110E-02,  0.352811840E-01, -0.956519703E-03 }, 
{       0.0000,      15.0000, -0.866460000E+00, -0.201711511E-01,  0.146270258E-01, -0.181262423E-02 }, 
{      15.0000,      15.0000, -0.129416000E+01, -0.383133168E-01, -0.588352589E-02, -0.259253444E-04 }, 
{      30.0000,      15.0000, -0.194904000E+01, -0.430915819E-01,  0.157121826E-01,  0.213335697E-02 }, 
{      45.0000,      15.0000, -0.244548000E+01, -0.195843557E-01,  0.382353746E-01,  0.316277540E-03 }, 
{      60.0000,      15.0000, -0.273747000E+01, -0.362569952E-01,  0.262553237E-01, -0.128983891E-02 }, 
{      75.0000,      15.0000, -0.352752000E+01, -0.517956634E-01, -0.239340018E-02, -0.328267685E-02 }, 
{      90.0000,      15.0000, -0.414017000E+01, -0.371003513E-01, -0.423360307E-01,  0.702275411E-03 }, 
{     105.0000,      15.0000, -0.471769000E+01, -0.378369314E-01,  0.689150161E-02,  0.233055556E-02 }, 
{     120.0000,      15.0000, -0.522956000E+01, -0.294299231E-01,  0.116015107E-01,  0.763010625E-03 }, 
{     135.0000,      15.0000, -0.536127000E+01,  0.268406237E-01,  0.353963665E-01,  0.318374914E-03 }, 
{     150.0000,      15.0000, -0.494167000E+01, -0.203545718E-01,  0.437258712E-02, -0.348229500E-02 }, 
{     165.0000,      15.0000, -0.586219000E+01, -0.456063365E-01, -0.186374474E-01,  0.280404230E-02 }, 
{     180.0000,      15.0000, -0.578157000E+01,  0.347999178E-01,  0.675479757E-01,  0.490120352E-02 }, 
{    -180.0000,      30.0000, -0.439795000E+01,  0.370248830E-01,  0.112847877E+00, -0.131522887E-02 }, 
{    -165.0000,      30.0000, -0.389601000E+01,  0.294976686E-01,  0.982152571E-01, -0.544749763E-03 }, 
{    -150.0000,      30.0000, -0.353457000E+01,  0.176604425E-01,  0.936227830E-01, -0.350790909E-03 }, 
{    -135.0000,      30.0000, -0.332088000E+01,  0.148865614E-01,  0.870606203E-01, -0.283013960E-03 }, 
{    -120.0000,      30.0000, -0.303056000E+01,  0.235953119E-01,  0.818416164E-01, -0.873386581E-03 }, 
{    -105.0000,      30.0000, -0.273504000E+01,  0.790019108E-02,  0.594680769E-01, -0.174194840E-02 }, 
{     -90.0000,      30.0000, -0.266786000E+01,  0.173439238E-01,  0.462081276E-01,  0.714482414E-03 }, 
{     -75.0000,      30.0000, -0.213835000E+01,  0.420621137E-01,  0.705736190E-01,  0.110512716E-02 }, 
{     -60.0000,      30.0000, -0.147167000E+01,  0.536456216E-01,  0.685192638E-01, -0.672763801E-03 }, 
{     -45.0000,      30.0000, -0.628520000E+00,  0.453214001E-01,  0.599966947E-01, -0.529456815E-03 }, 
{     -30.0000,      30.0000, -0.221790000E+00,  0.150447780E-01,  0.512292217E-01, -0.667417361E-03 }, 
{     -15.0000,      30.0000, -0.157860000E+00, -0.113685122E-01,  0.379986298E-01, -0.120048672E-02 }, 
{       0.0000,      30.0000, -0.569340000E+00, -0.390807291E-01,  0.263149047E-01,  0.486500852E-03 }, 
{      15.0000,      30.0000, -0.111306000E+01, -0.233485712E-01,  0.461028599E-01,  0.875329337E-03 }, 
{      30.0000,      30.0000, -0.132128000E+01, -0.179129861E-01,  0.409874725E-01, -0.105330463E-02 }, 
{      45.0000,      30.0000, -0.183104000E+01, -0.485954845E-01,  0.214713866E-01, -0.158840546E-02 }, 
{      60.0000,      30.0000, -0.265553000E+01, -0.545550760E-01,  0.547532027E-02,  0.304496030E-03 }, 
{      75.0000,      30.0000, -0.334579000E+01, -0.361342116E-01,  0.328440420E-01,  0.264495242E-02 }, 
{      90.0000,      30.0000, -0.378149000E+01, -0.261000777E-01,  0.634779107E-01,  0.716212372E-03 }, 
{     105.0000,      30.0000, -0.420428000E+01, -0.311634778E-01,  0.662640666E-01,  0.117420301E-02 }, 
{     120.0000,      30.0000, -0.449813000E+01,  0.742598870E-02,  0.100446696E+00,  0.198073264E-02 }, 
{     135.0000,      30.0000, -0.425139000E+01, -0.796247703E-02,  0.949540777E-01, -0.335913135E-02 }, 
{     150.0000,      30.0000, -0.479071000E+01, -0.340920806E-01,  0.468200715E-01,  0.730467851E-03 }, 
{     165.0000,      30.0000, -0.487852000E+01,  0.189047994E-01,  0.110005681E+00,  0.344758054E-02 }, 
{     180.0000,      30.0000, -0.439795000E+01,  0.370248830E-01,  0.112847877E+00, -0.131522887E-02 }, 
{    -180.0000,      45.0000, -0.258112000E+01,  0.289620636E-01,  0.121150515E+00, -0.807858860E-03 }, 
{    -165.0000,      45.0000, -0.227145000E+01,  0.153982668E-01,  0.106861095E+00, -0.102648901E-02 }, 
{    -150.0000,      45.0000, -0.209565000E+01,  0.653886937E-02,  0.930965959E-01, -0.696969022E-03 }, 
{    -135.0000,      45.0000, -0.200634000E+01,  0.114682557E-01,  0.857960043E-01, -0.398653124E-03 }, 
{    -120.0000,      45.0000, -0.182282000E+01,  0.215410764E-02,  0.742526630E-01, -0.147720505E-02 }, 
{    -105.0000,      45.0000, -0.192017000E+01, -0.285068630E-02,  0.561188727E-01,  0.372047019E-03 }, 
{     -90.0000,      45.0000, -0.170270000E+01,  0.332726376E-01,  0.797875202E-01,  0.109598840E-02 }, 
{     -75.0000,      45.0000, -0.103572000E+01,  0.466501360E-01,  0.776424040E-01, -0.451294380E-03 }, 
{     -60.0000,      45.0000, -0.397500000E+00,  0.411668184E-01,  0.720533488E-01, -0.837645155E-03 }, 
{     -45.0000,      45.0000,  0.189460000E+00,  0.337185903E-01,  0.543229578E-01, -0.862014245E-03 }, 
{     -30.0000,      45.0000,  0.536700000E+00,  0.107988202E-01,  0.491035555E-01, -0.304256520E-03 }, 
{     -15.0000,      45.0000,  0.464280000E+00, -0.219498712E-01,  0.480922968E-01,  0.832908129E-03 }, 
{       0.0000,      45.0000,  0.459900000E-01, -0.211413354E-01,  0.626033554E-01, -0.327416034E-03 }, 
{      15.0000,      45.0000, -0.238240000E+00, -0.339887873E-01,  0.326560862E-01, -0.261048611E-02 }, 
{      30.0000,      45.0000, -0.102104000E+01, -0.563095155E-01,  0.593792719E-02, -0.563725168E-03 }, 
{      45.0000,      45.0000, -0.172492000E+01, -0.381091506E-01,  0.199910790E-01,  0.233238533E-02 }, 
{      60.0000,      45.0000, -0.218120000E+01, -0.232858820E-01,  0.630973952E-01,  0.266607744E-02 }, 
{      75.0000,      45.0000, -0.243358000E+01, -0.104793214E-01,  0.898052322E-01,  0.966135566E-03 }, 
{      90.0000,      45.0000, -0.256353000E+01, -0.112628324E-01,  0.103752388E+00,  0.160037887E-02 }, 
{     105.0000,      45.0000, -0.267214000E+01,  0.781865118E-02,  0.137162232E+00,  0.210374891E-02 }, 
{     120.0000,      45.0000, -0.246632000E+01, -0.569772260E-03,  0.139259706E+00, -0.291391102E-02 }, 
{     135.0000,      45.0000, -0.285658000E+01, -0.424275621E-01,  0.857253227E-01, -0.735486705E-03 }, 
{     150.0000,      45.0000, -0.336934000E+01, -0.103239792E-01,  0.122813127E+00,  0.256654212E-02 }, 
{     165.0000,      45.0000, -0.310144000E+01,  0.347514789E-01,  0.130764725E+00, -0.522801384E-03 }, 
{     180.0000,      45.0000, -0.258112000E+01,  0.289620636E-01,  0.121150515E+00, -0.807858860E-03 }, 
{    -180.0000,      60.0000, -0.948650000E+00,  0.737434129E-02,  0.924100609E-01, -0.138344403E-02 }, 
{    -165.0000,      60.0000, -0.869300000E+00,  0.321988958E-02,  0.796823612E-01, -0.604850010E-03 }, 
{    -150.0000,      60.0000, -0.847540000E+00, -0.318996128E-04,  0.713968334E-01, -0.399801424E-03 }, 
{    -135.0000,      60.0000, -0.849650000E+00,  0.837708870E-03,  0.640013624E-01, -0.932144052E-03 }, 
{    -120.0000,      60.0000, -0.893240000E+00, -0.124589359E-01,  0.486117314E-01, -0.428642759E-03 }, 
{    -105.0000,      60.0000, -0.104409000E+01,  0.101100346E-01,  0.542464321E-01,  0.695729027E-03 }, 
{     -90.0000,      60.0000, -0.537280000E+00,  0.432107975E-01,  0.607577917E-01,  0.749386988E-04 }, 
{     -75.0000,      60.0000,  0.664900000E-01,  0.391627755E-01,  0.598247649E-01,  0.120182732E-03 }, 
{     -60.0000,      60.0000,  0.616370000E+00,  0.308681005E-01,  0.608753409E-01, -0.532159790E-03 }, 
{     -45.0000,      60.0000,  0.979600000E+00,  0.199868225E-01,  0.443354741E-01, -0.108940173E-02 }, 
{     -30.0000,      60.0000,  0.121765000E+01,  0.944060954E-02,  0.402445561E-01,  0.763609745E-03 }, 
{     -15.0000,      60.0000,  0.125138000E+01, -0.339326065E-02,  0.514801830E-01, -0.536095480E-03 }, 
{       0.0000,      60.0000,  0.908350000E+00, -0.577275669E-01,  0.188096739E-01, -0.290620427E-02 }, 
{      15.0000,      60.0000, -0.263950000E+00, -0.687624716E-01, -0.690520481E-02,  0.483835005E-03 }, 
{      30.0000,      60.0000, -0.832370000E+00, -0.153665465E-01,  0.330428187E-01,  0.381749322E-02 }, 
{      45.0000,      60.0000, -0.899680000E+00,  0.308265780E-02,  0.848362975E-01,  0.259449259E-02 }, 
{      60.0000,      60.0000, -0.822330000E+00,  0.504391535E-02,  0.108775099E+00,  0.950992485E-03 }, 
{      75.0000,      60.0000, -0.782500000E+00,  0.177680786E-03,  0.120593029E+00,  0.752883791E-03 }, 
{      90.0000,      60.0000, -0.739980000E+00,  0.107153615E-01,  0.129814537E+00,  0.245359965E-03 }, 
{     105.0000,      60.0000, -0.558380000E+00,  0.178487321E-02,  0.114267005E+00, -0.299952845E-02 }, 
{     120.0000,      60.0000, -0.897520000E+00, -0.493628543E-01,  0.626364821E-01, -0.168285717E-02 }, 
{     135.0000,      60.0000, -0.166307000E+01, -0.252714558E-01,  0.798086315E-01,  0.283928241E-02 }, 
{     150.0000,      60.0000, -0.150829000E+01,  0.282946776E-01,  0.118411421E+00,  0.148071533E-02 }, 
{     165.0000,      60.0000, -0.112821000E+01,  0.190647453E-01,  0.116997421E+00, -0.132438583E-02 }, 
{     180.0000,      60.0000, -0.948650000E+00,  0.737434129E-02,  0.924100609E-01, -0.138344403E-02 }, 
{    -180.0000,      75.0000,  0.820000000E-01, -0.576074991E-02,  0.418332411E-01, -0.602927726E-03 }, 
{    -165.0000,      75.0000,  0.530200000E-01, -0.441765371E-03,  0.393034597E-01,  0.277882623E-03 }, 
{    -150.0000,      75.0000,  0.135100000E-01, -0.617018860E-02,  0.431480705E-01, -0.245636876E-03 }, 
{    -135.0000,      75.0000, -0.135630000E+00, -0.126074802E-01,  0.323405460E-01, -0.687917863E-03 }, 
{    -120.0000,      75.0000, -0.332440000E+00, -0.125898905E-01,  0.293764112E-01,  0.242976459E-03 }, 
{    -105.0000,      75.0000, -0.398930000E+00,  0.103070422E-01,  0.311433987E-01, -0.523417420E-03 }, 
{     -90.0000,      75.0000,  0.000000000E+00,  0.378497216E-01,  0.177213131E-01, -0.480326397E-03 }, 
{     -75.0000,      75.0000,  0.639070000E+00,  0.458940714E-01,  0.180165364E-01, -0.180649465E-03 }, 
{     -60.0000,      75.0000,  0.122291000E+01,  0.231559927E-01,  0.852728769E-02, -0.635880819E-03 }, 
{     -45.0000,      75.0000,  0.136484000E+01,  0.663595760E-02,  0.341114567E-02, -0.196905398E-03 }, 
{     -30.0000,      75.0000,  0.158462000E+01,  0.226421769E-01, -0.497780037E-03, -0.381511132E-03 }, 
{     -15.0000,      75.0000,  0.166036000E+01, -0.381006650E-01, -0.147970288E-01, -0.191868497E-02 }, 
{       0.0000,      75.0000,  0.560870000E+00, -0.749895168E-01, -0.348660509E-01,  0.118259685E-02 }, 
{      15.0000,      75.0000, -0.107260000E+00, -0.154652680E-01,  0.211607330E-01,  0.437984995E-02 }, 
{      30.0000,      75.0000,  0.358400000E-01,  0.318445886E-01,  0.732667980E-01,  0.292457313E-02 }, 
{      45.0000,      75.0000,  0.623620000E+00,  0.342629136E-01,  0.110371731E+00,  0.176405716E-02 }, 
{      60.0000,      75.0000,  0.907260000E+00,  0.538775717E-02,  0.119494209E+00, -0.735319543E-03 }, 
{      75.0000,      75.0000,  0.899960000E+00, -0.545942228E-03,  0.945306517E-01, -0.199099490E-02 }, 
{      90.0000,      75.0000,  0.863380000E+00, -0.119799883E-01,  0.623714640E-01, -0.272524990E-02 }, 
{     105.0000,      75.0000,  0.404990000E+00, -0.505281047E-01,  0.211957477E-01, -0.177498631E-02 }, 
{     120.0000,      75.0000, -0.395160000E+00, -0.376155927E-01,  0.244263663E-01,  0.223617559E-02 }, 
{     135.0000,      75.0000, -0.498550000E+00,  0.202824757E-01,  0.666461512E-01,  0.192036465E-02 }, 
{     150.0000,      75.0000, -0.364600000E-01,  0.282256898E-01,  0.701171892E-01, -0.779469639E-03 }, 
{     165.0000,      75.0000,  0.168910000E+00,  0.306765026E-03,  0.553155914E-01, -0.106859806E-02 }, 
{     180.0000,      75.0000,  0.820000000E-01, -0.576074991E-02,  0.418332411E-01, -0.602927726E-03 }, 
{    -180.0000,      90.0000,  0.325570000E+00, -0.755744453E-02, -0.489902508E-02,  0.808797771E-03 }, 
{    -165.0000,      90.0000,  0.326450000E+00,  0.183280332E-02,  0.225380005E-02, -0.784097732E-03 }, 
{    -150.0000,      90.0000,  0.293360000E+00, -0.621576877E-02, -0.158091154E-01,  0.145575096E-03 }, 
{    -135.0000,      90.0000,  0.159770000E+00, -0.103057283E-01,  0.852045369E-02,  0.145512808E-02 }, 
{    -120.0000,      90.0000,  0.819000000E-02, -0.959531819E-02,  0.141686239E-01,  0.294604568E-04 }, 
{    -105.0000,      90.0000, -0.750800000E-01,  0.171700102E-02,  0.149819729E-01, -0.280666062E-03 }, 
{     -90.0000,      90.0000,  0.124580000E+00,  0.260053141E-01,  0.728956015E-03, -0.159472978E-02 }, 
{     -75.0000,      90.0000,  0.585550000E+00,  0.263877425E-01, -0.280789104E-01, -0.195259146E-02 }, 
{     -60.0000,      90.0000,  0.839350000E+00,  0.113977157E-01, -0.503884916E-01, -0.818393890E-03 }, 
{     -45.0000,      90.0000,  0.994770000E+00,  0.986539458E-02, -0.549460568E-01, -0.147262262E-03 }, 
{     -30.0000,      90.0000,  0.108297000E+01, -0.213529405E-02, -0.651894360E-01, -0.155274593E-02 }, 
{     -15.0000,      90.0000,  0.808160000E+00, -0.386462184E-01, -0.809360677E-01,  0.116024381E-02 }, 
{       0.0000,      90.0000,  0.152250000E+00, -0.294238324E-01, -0.305654704E-01,  0.383656379E-02 }, 
{      15.0000,      90.0000,  0.208730000E+00,  0.364555480E-01,  0.167982728E-01,  0.304036912E-02 }, 
{      30.0000,      90.0000,  0.108505000E+01,  0.701616406E-01,  0.573739893E-01,  0.158985168E-02 }, 
{      45.0000,      90.0000,  0.199650000E+01,  0.404518898E-01,  0.529127777E-01, -0.217687483E-02 }, 
{      60.0000,      90.0000,  0.216868000E+01, -0.152431998E-01,  0.114500644E-01, -0.206713733E-02 }, 
{      75.0000,      90.0000,  0.169212000E+01, -0.403550908E-01, -0.379163563E-02, -0.895458506E-03 }, 
{      90.0000,      90.0000,  0.105631000E+01, -0.458104372E-01, -0.200423929E-01, -0.649520116E-03 }, 
{     105.0000,      90.0000,  0.369410000E+00, -0.409451605E-01, -0.134919958E-01,  0.155346694E-02 }, 
{     120.0000,      90.0000, -0.190400000E-01, -0.547892085E-02,  0.153540528E-01,  0.151494150E-02 }, 
{     135.0000,      90.0000,  0.175690000E+00,  0.241168439E-01,  0.213587635E-01, -0.643081084E-03 }, 
{     150.0000,      90.0000,  0.505380000E+00,  0.138955453E-01,  0.385382240E-02, -0.124266324E-02 }, 
{     165.0000,      90.0000,  0.521310000E+00, -0.105750252E-01, -0.835578666E-02, -0.329176008E-03 }, 
{     180.0000,      90.0000,  0.325570000E+00, -0.755744453E-02, -0.489902508E-02,  0.808797771E-03 }, 
{    -180.0000,     105.0000,  0.340000000E-01,  0.128346907E-01, -0.318371407E-01,  0.108682477E-02 }, 
{    -165.0000,     105.0000,  0.194850000E+00, -0.114939339E-01, -0.199526599E-01,  0.648074600E-03 }, 
{    -150.0000,     105.0000, -0.145370000E+00, -0.273295510E-02, -0.116876089E-01,  0.350783191E-03 }, 
{    -135.0000,     105.0000,  0.148830000E+00,  0.132217543E-01, -0.953036073E-02,  0.332524625E-04 }, 
{    -120.0000,     105.0000,  0.541000000E-01, -0.102600621E-01, -0.874290672E-02,  0.105147398E-03 }, 
{    -105.0000,     105.0000,  0.149000000E-01,  0.103249401E-02, -0.830529033E-02, -0.208827975E-03 }, 
{     -90.0000,     105.0000,  0.315000000E-02, -0.405991396E-02, -0.200071371E-01, -0.152268158E-02 }, 
{     -75.0000,     105.0000, -0.744100000E-01, -0.265483816E-02, -0.483968948E-01, -0.171876660E-02 }, 
{     -60.0000,     105.0000, -0.801100000E-01, -0.197273338E-02, -0.675773212E-01, -0.111628885E-02 }, 
{     -45.0000,     105.0000, -0.140070000E+00, -0.258622831E-02, -0.846089184E-01, -0.105848274E-02 }, 
{     -30.0000,     105.0000, -0.192690000E+00, -0.101983534E-01, -0.942064761E-01,  0.243888253E-04 }, 
{     -15.0000,     105.0000, -0.425790000E+00, -0.137643582E-01, -0.786887002E-01,  0.214497107E-02 }, 
{       0.0000,     105.0000, -0.412450000E+00,  0.213037862E-01, -0.375360675E-01,  0.272980858E-02 }, 
{      15.0000,     105.0000,  0.322380000E+00,  0.781832134E-01, -0.242582407E-02,  0.218836984E-02 }, 
{      30.0000,     105.0000,  0.159977000E+01,  0.684073602E-01,  0.100232446E-01, -0.197142551E-02 }, 
{      45.0000,     105.0000,  0.196406000E+01, -0.234766543E-01, -0.539348421E-01, -0.460447141E-02 }, 
{      60.0000,     105.0000,  0.127150000E+01, -0.401547431E-01, -0.924464669E-01, -0.104631167E-03 }, 
{      75.0000,     105.0000,  0.957900000E+00, -0.171363735E-01, -0.677761091E-01,  0.225474267E-02 }, 
{      90.0000,     105.0000,  0.567470000E+00, -0.321057630E-01, -0.413838923E-01,  0.129817542E-02 }, 
{     105.0000,     105.0000,  0.102460000E+00, -0.255285747E-01, -0.277337645E-01,  0.561024576E-03 }, 
{     120.0000,     105.0000, -0.898600000E-01,  0.275406159E-02, -0.247825773E-01, -0.222010731E-03 }, 
{     135.0000,     105.0000,  0.882400000E-01,  0.116683283E-01, -0.347232053E-01, -0.107086980E-02 }, 
{     150.0000,     105.0000,  0.138200000E+00, -0.381537484E-02, -0.506004788E-01, -0.658090348E-03 }, 
{     165.0000,     105.0000,  0.329500000E-01, -0.746482897E-02, -0.490844448E-01,  0.830983295E-03 }, 
{     180.0000,     105.0000,  0.340000000E-01,  0.128346907E-01, -0.318371407E-01,  0.108682477E-02 }, 
{    -180.0000,     120.0000, -0.522510000E+00,  0.216553706E-01, -0.373684120E-01,  0.686466179E-03 }, 
{    -165.0000,     120.0000, -0.209940000E+00,  0.175506926E-01, -0.297211606E-01,  0.133537718E-02 }, 
{    -150.0000,     120.0000, -0.551200000E-01,  0.161985907E-02, -0.713644892E-02,  0.184177049E-04 }, 
{    -135.0000,     120.0000, -0.134660000E+00, -0.897412884E-02, -0.292850108E-01, -0.132181804E-02 }, 
{    -120.0000,     120.0000, -0.265950000E+00, -0.788934372E-02, -0.340249970E-01, -0.108855156E-03 }, 
{    -105.0000,     120.0000, -0.368220000E+00, -0.618049630E-02, -0.403888116E-01, -0.463521502E-03 }, 
{     -90.0000,     120.0000, -0.493950000E+00, -0.129886711E-01, -0.444064075E-01, -0.113340931E-03 }, 
{     -75.0000,     120.0000, -0.763400000E+00, -0.209008193E-01, -0.481235103E-01, -0.630054514E-03 }, 
{     -60.0000,     120.0000, -0.107554000E+01, -0.197260517E-01, -0.622802234E-01, -0.941204208E-03 }, 
{     -45.0000,     120.0000, -0.133794000E+01, -0.151029739E-01, -0.731602694E-01, -0.612480482E-03 }, 
{     -30.0000,     120.0000, -0.151123000E+01, -0.700005288E-02, -0.768246598E-01,  0.482238868E-03 }, 
{     -15.0000,     120.0000, -0.145599000E+01,  0.194931854E-01, -0.571391313E-01,  0.188775264E-02 }, 
{       0.0000,     120.0000, -0.922130000E+00,  0.468473114E-01, -0.341662594E-01,  0.498430652E-03 }, 
{      15.0000,     120.0000,  0.926800000E-01,  0.102851569E+00, -0.303049765E-01,  0.148535572E-02 }, 
{      30.0000,     120.0000,  0.144313000E+01,  0.147984127E-01, -0.258509678E-01, -0.477679521E-02 }, 
{      45.0000,     120.0000,  0.514020000E+00, -0.777772199E-01, -0.133669409E+00, -0.305106147E-02 }, 
{      60.0000,     120.0000, -0.738100000E-01, -0.707753321E-02, -0.901621967E-01,  0.411879531E-02 }, 
{      75.0000,     120.0000,  0.506000000E-02,  0.429535271E-02, -0.625159279E-01,  0.806576520E-03 }, 
{      90.0000,     120.0000, -0.124550000E+00, -0.202518776E-01, -0.505940380E-01,  0.568530356E-03 }, 
{     105.0000,     120.0000, -0.492020000E+00, -0.227038422E-01, -0.478589461E-01, -0.149301591E-03 }, 
{     120.0000,     120.0000, -0.722050000E+00, -0.843275342E-02, -0.568257435E-01, -0.121766509E-02 }, 
{     135.0000,     120.0000, -0.798800000E+00, -0.492114410E-02, -0.773639424E-01, -0.881037303E-03 }, 
{     150.0000,     120.0000, -0.870410000E+00, -0.155467020E-02, -0.766099074E-01,  0.784981523E-03 }, 
{     165.0000,     120.0000, -0.792650000E+00,  0.123698249E-01, -0.580984343E-01,  0.159421284E-02 }, 
{     180.0000,     120.0000, -0.522510000E+00,  0.216553706E-01, -0.373684120E-01,  0.686466179E-03 }, 
{    -180.0000,     135.0000, -0.102882000E+01,  0.351094509E-01, -0.312532114E-01,  0.622262542E-03 }, 
{    -165.0000,     135.0000, -0.651770000E+00,  0.154332388E-01, -0.304866979E-01, -0.604148793E-03 }, 
{    -150.0000,     135.0000, -0.560740000E+00, -0.322640592E-02, -0.428405954E-01, -0.523144175E-03 }, 
{    -135.0000,     135.0000, -0.712020000E+00, -0.145776151E-01, -0.454995962E-01, -0.305854175E-03 }, 
{    -120.0000,     135.0000, -0.941040000E+00, -0.145231337E-01, -0.541851053E-01, -0.522341101E-03 }, 
{    -105.0000,     135.0000, -0.112185000E+01, -0.929585011E-02, -0.574894633E-01, -0.275484147E-05 }, 
{     -90.0000,     135.0000, -0.126606000E+01, -0.132974659E-01, -0.562092330E-01,  0.128534924E-03 }, 
{     -75.0000,     135.0000, -0.154884000E+01, -0.229122864E-01, -0.539950640E-01,  0.187495000E-03 }, 
{     -60.0000,     135.0000, -0.192530000E+01, -0.269013884E-01, -0.523397850E-01, -0.104625325E-03 }, 
{     -45.0000,     135.0000, -0.230228000E+01, -0.201701599E-01, -0.551920038E-01, -0.838165980E-05 }, 
{     -30.0000,     135.0000, -0.244135000E+01,  0.437202815E-02, -0.482268848E-01,  0.960732008E-03 }, 
{     -15.0000,     135.0000, -0.213523000E+01,  0.360920473E-01, -0.346427746E-01,  0.275299481E-03 }, 
{       0.0000,     135.0000, -0.144080000E+01,  0.513697825E-01, -0.314688948E-01,  0.128966806E-02 }, 
{      15.0000,     135.0000, -0.465710000E+00,  0.923328228E-01, -0.339722700E-01, -0.529987083E-02 }, 
{      30.0000,     135.0000,  0.381110000E+00, -0.563190736E-01, -0.150351373E+00, -0.386668043E-02 }, 
{      45.0000,     135.0000, -0.155691000E+01, -0.852965285E-01, -0.115581520E+00,  0.444474245E-02 }, 
{      60.0000,     135.0000, -0.135419000E+01,  0.504451875E-01, -0.720427463E-01,  0.174943604E-02 }, 
{      75.0000,     135.0000, -0.907580000E+00,  0.133817783E-01, -0.552561793E-01,  0.622581611E-03 }, 
{      90.0000,     135.0000, -0.901520000E+00, -0.134383008E-01, -0.500379559E-01,  0.161195588E-03 }, 
{     105.0000,     135.0000, -0.125345000E+01, -0.288025751E-01, -0.520124510E-01, -0.618618301E-03 }, 
{     120.0000,     135.0000, -0.168612000E+01, -0.282713988E-01, -0.671664488E-01, -0.111242097E-02 }, 
{     135.0000,     135.0000, -0.202075000E+01, -0.115718298E-01, -0.776190249E-01, -0.530126106E-04 }, 
{     150.0000,     135.0000, -0.198551000E+01,  0.146807180E-01, -0.677018917E-01,  0.121738282E-02 }, 
{     165.0000,     135.0000, -0.160806000E+01,  0.353869578E-01, -0.467238181E-01,  0.136252268E-02 }, 
{     180.0000,     135.0000, -0.102882000E+01,  0.351094509E-01, -0.312532114E-01,  0.622262542E-03 }, 
{    -180.0000,     150.0000, -0.140265000E+01,  0.351711419E-01, -0.136467426E-01, -0.472362088E-03 }, 
{    -165.0000,     150.0000, -0.108685000E+01,  0.764138829E-02, -0.237140479E-01, -0.900642866E-03 }, 
{    -150.0000,     150.0000, -0.114225000E+01, -0.136566951E-01, -0.389271695E-01, -0.981151832E-03 }, 
{    -135.0000,     150.0000, -0.144392000E+01, -0.244286080E-01, -0.505686044E-01, -0.545661097E-03 }, 
{    -120.0000,     150.0000, -0.179431000E+01, -0.190408728E-01, -0.549065819E-01, -0.320862556E-04 }, 
{    -105.0000,     150.0000, -0.198737000E+01, -0.809790083E-02, -0.534833352E-01,  0.910599615E-04 }, 
{     -90.0000,     150.0000, -0.209728000E+01, -0.916152391E-02, -0.514226606E-01,  0.364630671E-03 }, 
{     -75.0000,     150.0000, -0.230285000E+01, -0.183520035E-01, -0.437862336E-01,  0.389837668E-03 }, 
{     -60.0000,     150.0000, -0.264023000E+01, -0.260204620E-01, -0.412986366E-01,  0.100823459E-03 }, 
{     -45.0000,     150.0000, -0.299514000E+01, -0.160241486E-01, -0.375117152E-01,  0.461772165E-03 }, 
{     -30.0000,     150.0000, -0.299946000E+01,  0.182710565E-01, -0.279138011E-01,  0.729054977E-03 }, 
{     -15.0000,     150.0000, -0.255243000E+01,  0.314819226E-01, -0.235777704E-01, -0.591203108E-03 }, 
{       0.0000,     150.0000, -0.190769000E+01,  0.741552530E-01, -0.370701614E-01, -0.195514605E-03 }, 
{      15.0000,     150.0000, -0.100235000E+01, -0.180869344E-01, -0.528119434E-01, -0.447357306E-02 }, 
{      30.0000,     150.0000, -0.231986000E+01, -0.842415152E-01, -0.125341539E+00,  0.435531324E-03 }, 
{      45.0000,     150.0000, -0.268419000E+01,  0.186849952E-01, -0.436465087E-01,  0.456453470E-02 }, 
{      60.0000,     150.0000, -0.214117000E+01,  0.452395343E-01, -0.351388183E-01, -0.653125985E-03 }, 
{      75.0000,     150.0000, -0.157168000E+01,  0.228588675E-01, -0.318073549E-01,  0.415799993E-03 }, 
{      90.0000,     150.0000, -0.153158000E+01, -0.147570043E-01, -0.306601386E-01, -0.114338044E-03 }, 
{     105.0000,     150.0000, -0.194553000E+01, -0.386008503E-01, -0.347932499E-01, -0.555626818E-03 }, 
{     120.0000,     150.0000, -0.256850000E+01, -0.382235945E-01, -0.437984613E-01, -0.290819237E-03 }, 
{     135.0000,     150.0000, -0.293976000E+01, -0.735077188E-02, -0.403519578E-01,  0.607162189E-03 }, 
{     150.0000,     150.0000, -0.274531000E+01,  0.322646820E-01, -0.275625257E-01,  0.110935761E-02 }, 
{     165.0000,     150.0000, -0.207985000E+01,  0.502740440E-01, -0.124462932E-01,  0.536540272E-03 }, 
{     180.0000,     150.0000, -0.140265000E+01,  0.351711419E-01, -0.136467426E-01, -0.472362088E-03 }, 
{    -180.0000,     165.0000, -0.145988000E+01,  0.238388405E-01, -0.371818305E-03, -0.986936255E-03 }, 
{    -165.0000,     165.0000, -0.137849000E+01, -0.132102354E-01, -0.200011104E-01, -0.152197458E-02 }, 
{    -150.0000,     165.0000, -0.175672000E+01, -0.303658989E-01, -0.406467266E-01, -0.980147089E-03 }, 
{    -135.0000,     165.0000, -0.218673000E+01, -0.269741691E-01, -0.471679863E-01,  0.918775987E-05 }, 
{    -120.0000,     165.0000, -0.253115000E+01, -0.166234247E-01, -0.442105672E-01,  0.230627931E-03 }, 
{    -105.0000,     165.0000, -0.268486000E+01, -0.615813225E-02, -0.411791960E-01,  0.266058568E-03 }, 
{     -90.0000,     165.0000, -0.275836000E+01, -0.418604636E-02, -0.365601247E-01,  0.235226292E-03 }, 
{     -75.0000,     165.0000, -0.286750000E+01, -0.136256823E-01, -0.345920016E-01,  0.110475149E-03 }, 
{     -60.0000,     165.0000, -0.317263000E+01, -0.241652244E-01, -0.319316688E-01,  0.248564300E-03 }, 
{     -45.0000,     165.0000, -0.345161000E+01, -0.653542027E-02, -0.246271352E-01,  0.888240933E-03 }, 
{     -30.0000,     165.0000, -0.330648000E+01,  0.235369054E-01, -0.131439109E-01, -0.439764563E-04 }, 
{     -15.0000,     165.0000, -0.280614000E+01,  0.414817985E-01, -0.522814375E-02,  0.316746318E-02 }, 
{       0.0000,     165.0000, -0.216102000E+01,  0.396279005E-01,  0.357055403E-01, -0.285598604E-02 }, 
{      15.0000,     165.0000, -0.198062000E+01, -0.348894005E-01, -0.577619565E-01, -0.225028156E-02 }, 
{      30.0000,     165.0000, -0.293106000E+01, -0.540782986E-01, -0.107164705E-01,  0.257271013E-02 }, 
{      45.0000,     165.0000, -0.312990000E+01,  0.213465948E-01, -0.244304447E-01, -0.137425661E-02 }, 
{      60.0000,     165.0000, -0.253301000E+01,  0.483019195E-01, -0.231659806E-01,  0.434414290E-03 }, 
{      75.0000,     165.0000, -0.193409000E+01,  0.246077271E-01, -0.228164011E-01, -0.405918223E-04 }, 
{      90.0000,     165.0000, -0.186594000E+01, -0.133188280E-01, -0.202054899E-01,  0.320051148E-03 }, 
{     105.0000,     165.0000, -0.228500000E+01, -0.415144151E-01, -0.151245494E-01,  0.298757572E-03 }, 
{     120.0000,     165.0000, -0.294737000E+01, -0.369095115E-01, -0.988970590E-02,  0.548075361E-03 }, 
{     135.0000,     165.0000, -0.320597000E+01,  0.495846130E-02,  0.198285611E-02,  0.930422076E-03 }, 
{     150.0000,     165.0000, -0.281104000E+01,  0.443416664E-01,  0.128459944E-01,  0.277376388E-03 }, 
{     165.0000,     165.0000, -0.204178000E+01,  0.505128733E-01,  0.976499092E-02, -0.483500667E-03 }, 
{     180.0000,     165.0000, -0.145988000E+01,  0.238388405E-01, -0.371818305E-03, -0.986936255E-03 }, 
{    -180.0000,     180.0000, -0.146854000E+01,  0.491175487E-02,  0.195601580E-02, -0.163177030E-02 }, 
{    -165.0000,     180.0000, -0.171132000E+01, -0.337083049E-01, -0.211755104E-01, -0.128139745E-02 }, 
{    -150.0000,     180.0000, -0.232191000E+01, -0.407525353E-01, -0.344179241E-01, -0.517427860E-03 }, 
{    -135.0000,     180.0000, -0.282200000E+01, -0.254175539E-01, -0.363754505E-01,  0.311120885E-03 }, 
{    -120.0000,     180.0000, -0.309109000E+01, -0.114132491E-01, -0.276071493E-01,  0.635099272E-03 }, 
{    -105.0000,     180.0000, -0.317704000E+01,  0.625502477E-04, -0.197338807E-01,  0.476795981E-03 }, 
{     -90.0000,     180.0000, -0.316347000E+01, -0.331295190E-02, -0.155748405E-01, -0.135821438E-03 }, 
{     -75.0000,     180.0000, -0.331935000E+01, -0.152727426E-01, -0.211457600E-01, -0.215886083E-03 }, 
{     -60.0000,     180.0000, -0.357978000E+01, -0.188580776E-01, -0.188846883E-01,  0.337396219E-03 }, 
{     -45.0000,     180.0000, -0.373419000E+01,  0.773705294E-02, -0.117897439E-01,  0.737504418E-03 }, 
{     -30.0000,     180.0000, -0.344056000E+01,  0.157538658E-01, -0.773055529E-02, -0.105658729E-02 }, 
{     -15.0000,     180.0000, -0.291290000E+01,  0.935054838E-01, -0.276036546E-01,  0.326062604E-03 }, 
{       0.0000,     180.0000, -0.140592000E+01,  0.171521990E-01, -0.539799978E-02,  0.218847975E-03 }, 
{      15.0000,     180.0000, -0.256214000E+01, -0.919622797E-01, -0.280982308E-01, -0.130036975E-02 }, 
{      30.0000,     180.0000, -0.329734000E+01, -0.275870801E-01, -0.272885790E-01,  0.604515175E-03 }, 
{      45.0000,     180.0000, -0.349478000E+01,  0.157826001E-01, -0.207497125E-01,  0.352012717E-03 }, 
{      60.0000,     180.0000, -0.286320000E+01,  0.512846799E-01, -0.166032592E-01,  0.124497929E-03 }, 
{      75.0000,     180.0000, -0.226579000E+01,  0.248766805E-01, -0.157490408E-01,  0.150129902E-03 }, 
{      90.0000,     180.0000, -0.214254000E+01, -0.665940194E-02, -0.107099019E-01,  0.453653923E-03 }, 
{     105.0000,     180.0000, -0.242944000E+01, -0.309690728E-01, -0.149055264E-02,  0.886952040E-03 }, 
{     120.0000,     180.0000, -0.290813000E+01, -0.225823070E-01,  0.154312849E-01,  0.122677527E-02 }, 
{     135.0000,     180.0000, -0.294808000E+01,  0.175703009E-01,  0.307565334E-01,  0.655364064E-03 }, 
{     150.0000,     180.0000, -0.245932000E+01,  0.420631034E-01,  0.333765482E-01, -0.259178877E-03 }, 
{     165.0000,     180.0000, -0.182999000E+01,  0.377952854E-01,  0.233583295E-01, -0.109828932E-02 }, 
{     180.0000,     180.0000, -0.146854000E+01,  0.491175487E-02,  0.195601580E-02, -0.163177030E-02 }  } };

    int elementCount = (includeDerivs ? 6 : 3);
    std::vector<TorsionTorsionGrid> grids(4);
    for (int ii = 0; ii < 4; ii++) {
        grids[ii].resize(25);
        for (int jj = 0; jj < 25; jj++) {
            grids[ii][jj].resize(25);
            for (int kk = 0; kk < 25; kk++) {
                grids[ii][jj][kk].resize(elementCount);
            }
        }
        int index = 0;
        for (int jj = 0; jj < 25; jj++) {
            for (int kk = 0; kk < 25; kk++) {
                int jjIndex = static_cast<int>(((grid[ii][index][0] + 180.0)/15.0)+1.0e-05);
                int kkIndex = static_cast<int>(((grid[ii][index][1] + 180.0)/15.0)+1.0e-05);
                for (int ll = 0; ll < elementCount; ll++) {
                    grids[ii][kk][jj][ll] = grid[ii][index][ll];
                }
                index++;
            }
        }
    }
    return grids[gridIndex];
}

void testTorsionTorsion(int systemId, bool includeDerivs) {

    System system;
    int numberOfParticles = 6;
    for (int ii = 0; ii < numberOfParticles; ii++) {
        system.addParticle(1.0);
    }
    LangevinIntegrator integrator(0.0, 0.1, 0.01);

    AmoebaTorsionTorsionForce* amoebaTorsionTorsionForce = new AmoebaTorsionTorsionForce();

    int chiralCheckAtomIndex;
    int gridIndex;
    std::vector<Vec3> positions(numberOfParticles);
    std::vector<Vec3> expectedForces(numberOfParticles);
    double expectedEnergy;
    if (systemId == 0) {

        // villin: 2     19     20     21     38     25    grid=2
        chiralCheckAtomIndex  = 5;
        gridIndex             = 2;

        positions[0]          = Vec3(-0.422792800E+01, -0.110605910E+02, -0.508156700E+01);
        positions[1]          = Vec3(-0.447153100E+01, -0.978627900E+01, -0.466405800E+01);
        positions[2]          = Vec3(-0.531878400E+01, -0.940508600E+01, -0.352283100E+01);
        positions[3]          = Vec3(-0.679606000E+01, -0.974353100E+01, -0.382975700E+01);
        positions[4]          = Vec3(-0.760612300E+01, -0.992590200E+01, -0.275088400E+01);
        positions[5]          = Vec3(-0.516893900E+01, -0.788347000E+01, -0.316943000E+01);

        expectedForces[0]     = Vec3(0.906091624E+00, -0.529814945E-01,  0.690384140E+00);
        expectedForces[1]     = Vec3(-0.124550232E+01, -0.999341692E+00, -0.590867130E+00);
        expectedForces[2]     = Vec3(0.534419689E+00,  0.612404926E-01,  0.547380310E-01);
        expectedForces[3]     = Vec3(-5.732010432E-01,  2.645718463E+00, -1.585204274E-01);
        expectedForces[4]     = Vec3(3.781920539E-01, -1.654635768E+00,  4.265386268E-03);
        expectedForces[5]     = Vec3(0.0, 0.0, 0.0);

        expectedEnergy        = -2.699654759E+00;

    }
    else if (systemId == 1) {

        // villin: 158    176    177    178    183     -1      0
        chiralCheckAtomIndex  = -1;
        gridIndex             = 0;

        positions[0]          = Vec3(-0.105946640E+02, -0.917797000E+00,  0.105486310E+02);
        positions[1]          = Vec3(-0.115059090E+02, -0.141876700E+01,  0.966933200E+01);
        positions[2]          = Vec3(-0.128314660E+02, -0.876338000E+00,  0.942959800E+01);
        positions[3]          = Vec3(-0.130879850E+02, -0.760280000E-01,  0.814732200E+01);
        positions[4]          = Vec3(-0.120888080E+02,  0.112050000E-01,  0.722704500E+01);
        positions[5]          = Vec3(0.0, 0.0, 0.0);

        expectedForces[0]     = Vec3(4.165851130E-01,  6.608242922E-01, -8.082168261E-01);
        expectedForces[1]     = Vec3(-6.024659721E-01, -8.878744406E-01,  1.322274444E+00);
        expectedForces[2]     = Vec3(3.196925118E-02, -3.137497848E-01, -8.207984001E-01);
        expectedForces[3]     = Vec3(3.842205941E-02,  2.602732089E-01,  1.547586195E-01);
        expectedForces[4]     = Vec3(1.154895485E-01,  2.805267242E-01,  1.519821623E-01);
        expectedForces[5]     = Vec3(0.0, 0.0, 0.0);

        expectedEnergy        = -3.372536909E+00;
    }
    amoebaTorsionTorsionForce->addTorsionTorsion(0, 1, 2, 3, 4, chiralCheckAtomIndex, 0);
    amoebaTorsionTorsionForce->setTorsionTorsionGrid(0, getTorsionGrid(gridIndex, includeDerivs));
    
    system.addForce(amoebaTorsionTorsionForce);
    ASSERT(!amoebaTorsionTorsionForce->usesPeriodicBoundaryConditions());
    ASSERT(!system.usesPeriodicBoundaryConditions());
    Context context(system, integrator, Platform::getPlatformByName("Reference"));

    context.setPositions(positions);
    State state                      = context.getState(State::Forces | State::Energy);
    std::vector<Vec3> forces         = state.getForces();
    const double conversion          = -1.0;

    for (unsigned int ii = 0; ii < forces.size(); ii++) {
        forces[ii][0] *= conversion;
        forces[ii][1] *= conversion;
        forces[ii][2] *= conversion;
    }

    double tolerance = 1.0e-03;
    for (unsigned int ii = 0; ii < forces.size(); ii++) {
        ASSERT_EQUAL_VEC(expectedForces[ii], forces[ii], tolerance);
    }
    ASSERT_EQUAL_TOL(expectedEnergy, state.getPotentialEnergy(), tolerance);
}

void testPeriodic() {
    // Create a force that uses periodic boundary conditions.

    System system;
    system.setDefaultPeriodicBoxVectors(Vec3(3, 0, 0), Vec3(0, 3, 0), Vec3(0, 0, 3));
    int numberOfParticles = 6;
    for (int ii = 0; ii < numberOfParticles; ii++)
        system.addParticle(1.0);
    LangevinIntegrator integrator(0.0, 0.1, 0.01);
    AmoebaTorsionTorsionForce* amoebaTorsionTorsionForce = new AmoebaTorsionTorsionForce();
    int chiralCheckAtomIndex;
    int gridIndex;
    chiralCheckAtomIndex  = 5;
    gridIndex             = 2;
    amoebaTorsionTorsionForce->addTorsionTorsion(0, 1, 2, 3, 4, chiralCheckAtomIndex, 0);
    amoebaTorsionTorsionForce->setTorsionTorsionGrid(0, getTorsionGrid(gridIndex, false));
    amoebaTorsionTorsionForce->setUsesPeriodicBoundaryConditions(true);
    system.addForce(amoebaTorsionTorsionForce);
    Context context(system, integrator, Platform::getPlatformByName("Reference"));
    std::vector<Vec3> positions(numberOfParticles);
    positions[0] = Vec3(0, 1, 0);
    positions[1] = Vec3(0, 0, 0);
    positions[2] = Vec3(0, 0, 0.5);
    positions[3] = Vec3(0.4, 0.4, 0.4);
    positions[4] = Vec3(1, 0, 1);
    positions[5] = Vec3(1, 1, 0);
    context.setPositions(positions);
    State s1 = context.getState(State::Forces | State::Energy);
    
    // Move one atom to a position that should give identical results.

    positions[0] = Vec3(0, -2, 0);
    context.setPositions(positions);
    State s2 = context.getState(State::Forces | State::Energy);
    ASSERT_EQUAL_TOL(s1.getPotentialEnergy(), s2.getPotentialEnergy(), 1e-5);
    for (int i = 0; i < numberOfParticles; i++)
        ASSERT_EQUAL_VEC(s1.getForces()[i], s2.getForces()[i], 1e-5);
}

int main(int numberOfArguments, char* argv[]) {

    try {
        std::cout << "TestReferenceAmoebaTorsionTorsionForce running test..." << std::endl;
        registerAmoebaReferenceKernelFactories();
        testTorsionTorsion(1, true);
        testTorsionTorsion(1, false);
        testPeriodic();
    }
    catch(const std::exception& e) {
        std::cout << "exception: " << e.what() << std::endl;
        std::cout << "FAIL - ERROR.  Test failed." << std::endl;
        return 1;
    }
    std::cout << "Done" << std::endl;
    return 0;
}



