/*
 * Copyright (c) 2002 by Louis Zechtzer
 *
 * Permission to use, copy and distribute this software is hereby granted
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/* 
 * Authors: Louis Zechtzer (lou@clarity.net)
 */
/* Updated to OpenMosix 2.4.17 and afterwards by David Santo Orcero
 * irbis@orcero.org http://www.orcero.org/irbis */

#ifndef __OPENMOSIX_H
#define __OPENMOSIX_H

#if defined(TESTING) || defined(ALPHA)
#define OPENMOSIX_PROC_CONFIG "/tmp/om_config"
#define OPENMOSIX_PROC_MOSPE "/tmp/om_mospe"
#else
#define OPENMOSIX_PROC_CONFIG "/proc/hpc/admin/config"
#define OPENMOSIX_PROC_MOSPE "/proc/hpc/admin/mospe"
#endif

#define OPENMOSIX_SUCCESS 0
#define OPENMOSIX_FAIL 1

#include <sys/socket.h>
#include <netinet/in.h>
#include <stdint.h>

/* XXX - from linux/mosixnet.h (include the file here instead) */
typedef struct mosixnet
{
        int base;
        struct sockaddr saddr;
        int cnt;
} mosixnet_t;
#define MAX_MOSNET_ENTS 256
#define MOSIX_MAX 65536

#ifdef TESTING
extern int test_openmosix();
#endif

#define OPENMOSIX_ALIAS 0
#define OPENMOSIX_NOT_ALIAS 1

extern int openmosix_initialize(const struct in_addr *, int);
extern int openmosix_finalize();
extern int openmosix_add_node(const struct in_addr *, const struct in_addr *, 
	int);

#endif /* __OPENMOSIX_H */
