/*  Author(s): Ariel Rosenblatt for Mosix                               */
/*  Adapted to OpenMosix from Mosix and bugfixing by David Santo Orcero */
/*  irbis@orcero.org  http://www.orcero.org/irbis                       */
/* Mosix is (c) of prof. Amnon Barak http://www.mosix.org               */
/* Original code is (c) of prof. Amnon Barak http://www.mosix.org       */
/* OpenMosix is (c) of Moshe Bar http://www.openmosix.com               */
/* Each respective trademark is of its own owner                        */
/* All rights reserved.                                                 */
/* This software is distributed under GPL 2                             */

/* THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTY IS ASSUMED.               */
/* NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING            */
/* FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED. IT CAN BURN              */
/* YOUR HARD DISK, ERASE ALL YOUR DATA AND BROKE DOWN YOUR                  */
/* MICROWAVE OVEN. YOU ARE ADVISED.                                         */


/* THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY     */
/* WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING*/
/* FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.                          */





#include "mos.h"

int
msx_is_mosix() 
{
	return(!access("/proc/hpc/", 0));
}

int
msx_is_configured() 
{
	return(msx_read("/proc/hpc/admin/mospe") == -1 ? 0: 1);
}
 
int
msx_readval(const char *fn, int64_t *val)
{
	int fd = open(fn, 0);
	int r;
	char num[30];

	if(fd == -1)
		return(0);
	num[sizeof(num)-1] = '\0';
	r = read(fd, num, sizeof(num)-1);
	close(fd);
	return(r >= 0 && sscanf(num, "%lld", val) == 1);
}

int
msx_readval2(const char *fn, int *val1, int *val2)
{
	int fd = open(fn, 0);
	int r;
	char num[30];

	if(fd == -1)
		return(0);
	num[sizeof(num)-1] = '\0';
	r = read(fd, num, sizeof(num)-1);
	close(fd);
	if(r < 0)
		return(0);
	r = sscanf(num, "%d %d", val1, val2);
	if(r == 1)
		*val2 = 0;
	else if(r != 2)
		return(0);
	return(1);
}

int
msx_write(const char *fn, int val)
{
	int fd = open(fn, 1);
	size_t l, r;
	char num[30];
	if(fd == -1)
		return(0);
	sprintf(num, "%d\n", val);
	r = write(fd, num, l = strlen(num));
	close(fd);
	return(r == l);
}

int
msx_write2(const char *fn, int val1, int val2)
{
	int fd = open(fn, 1);
	size_t l, r;
	char num[30];

	if(fd == -1)
		return(0);
	sprintf(num, "%d %d\n", val1, val2);
	r = write(fd, num, l = strlen(num));
	close(fd);
	return(r == l);
}

int
msx_replace(const char *fn, int val)
{
	int fd = open(fn, 2);
	size_t l, r;
	char num[30];
	int ret;

	if(fd == -1)
		return(0);
	num[sizeof(num)-1] = '\0';
	r = read(fd, num, sizeof(num)-1);
	if(r < 0 || sscanf(num, "%d", &ret) != 1)
		return(-1);
	sprintf(num, "%d\n", val);
	r = write(fd, num, l = strlen(num));
	close(fd);
	return(r == l ? ret : -1);
}

int
msx_read(const char *fn)
{
	int64_t val;

	return(msx_readval(fn, &val) ? (int)val : -1);
}

int64_t
msx_readnode(int node, const char *item)
{
	char fn[40];
	int64_t val;

	if(!node && !(node = msx_read("/proc/hpc/admin/mospe")))
		return(-1);
	sprintf(fn, "/proc/hpc/nodes/%d/%s", node, item);
	if(!msx_readval(fn, &val))
		return(-1);
	if(val >= 0)
		return(val);
	errno = -val;
	return(-1);
}

int
msx_writeproc(int pid, const char *item, int val)
{
	char fn[30];

	sprintf(fn, "/proc/%d/%s", pid, item);
	return(msx_write(fn, val));
}

int
msx_readproc(int pid, const char *item)
{
	char fn[30];

	sprintf(fn, "/proc/%d/%s", pid, item);
	return(msx_read(fn));
}

int
msx_readdata(const char *fn, void *into, int max, int size)
{
	int fd = open(fn, 0);
	size_t r;

	if(fd == -1)
		return(0);
	r = read(fd, into, (size_t) max * size);
	close(fd);
	if(r == -1 || (r % size))
		return(0);
	return(r / size);
}

int
msx_count_ints(const char *fn)
{
	int fd = open(fn, 0);
	int r;
	char buf[4096];
	char *p = buf, *np;
	int n = 0;

	if(fd == -1)
		return(0);
	r = read(fd, buf, sizeof(buf));
	close(fd);
	if(r < 0)
		return(-1);
	if(r == sizeof(buf))
	{
		errno = E2BIG;
		return(-1);
	}
	buf[r] = '\0';
	for(p = buf ; strtol(p, &np, 0) , np != p ; p = np)
		n++;
	return(n);
}

int
msx_fill_ints(const char *fn, int *into, int max)
{
	int fd = open(fn, 0);
	int r;
	char buf[4096];
	char *p = buf, *np;
	int n = 0;

	if(fd == -1)
		return(0);
	r = read(fd, buf, sizeof(buf));
	close(fd);
	if(r < 0)
		return(-1);
	if(r == sizeof(buf))
	{
		errno = E2BIG;
		return(-1);
	}
	buf[r] = '\0';
	for(p = buf ; n < max && (into[n] = strtol(p, &np, 0) , np != p) ; p=np)
		n++;
	return(n);
}
