/*
 * Copyright (c) 2003, Cristiano De Michele <demichel@na.infn.it>. 
 * All rights reserved.
 *
 *	openMosix $Id: moslimit.c,v 1.5 2003/06/22 15:04:14 demichel Exp $
 *
 * Permission to use, copy and distribute this software is hereby granted 
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Cristiano De Michele
 * This utility is based on original code of mosctl openMosix tool
 */

#include <sys/param.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/sysctl.h>
#include <mos.h>

struct coms
{
	const char *com;
	char no;
} coms[] =
{
	{"getloadlocal",  D_GETLOADLOCAL},
        {"getloadremote", D_GETLOADREMOTE},
        {"getcpulocal",   D_GETCPULOCAL},
	{"getcpuremote",  D_GETCPUREMOTE},
	{"getllimitmode", D_GETLLIMITMODE},
	{"getcpulimitmode", D_GETCPULIMITMODE},
	{"getloadlimit",    D_GETLOADLIMIT},
	{"getcpulimit",     D_GETCPULIMIT},
	{"setllimitmode",   D_SETLLIMITMODE},
	{"setcpulimitmode", D_SETCPULIMITMODE},
	{"setloadlimit",    D_SETLOADLIMIT},
	{"setcpulimit",     D_SETCPULIMIT},
	{(char *)0, 0},
};

int main(int na, char **argv)
{
	register struct coms *c;
	int64_t ans;
	register char *x;
	int64_t arg = 0;
	register char *u;
	size_t length = 0;
	void *resp = NULL;

        if (!msx_is_mosix()) {
                fprintf(stderr, "This is NOT a openMosix system!\n");
                exit(1);
        }
	if(na < 2 || na > 3)
	{
		Usage:
		fprintf(stderr, "Usage: %s command\n", argv[0]);
		fprintf(stderr, "Available commands:\n");
		fprintf(stderr, "        setloadlimit [numeric-value], setcpulimit [numeric-value],\n");
		fprintf(stderr, "        setllimitmode [numeric-value], setcpulimitmode [numeric-value],\n");
		fprintf(stderr, "        getloadlimit [node-number], getcpulimit [node-number],\n");
		fprintf(stderr, "        getllimitmode [node-number], getcpulimitmode [node-number],\n");
		fprintf(stderr, "        getloadlocal [node-number], getcpulocal [node-number],\n");
		fprintf(stderr, "        getloadremote [node-number], getcpuremote [node-number]\n");
		exit(1);
	}
	for(x = argv[1] ; *x ; x++)
		if(*x >= 'A' && *x <= 'Z')
			*x += 'a' - 'A';
	for(c = coms ; c->com ; c++)
		if(!strcmp(c->com, argv[1]))
			break;
	if(!c->com) {
		printf("%s: No such option.\n", argv[0]);
		exit(1);
	}
	if(c->no == D_GETLOADLOCAL || c->no == D_GETLOADREMOTE ||
   	   c->no == D_GETCPULOCAL || c->no == D_GETCPUREMOTE ||
	   c->no == D_GETLLIMITMODE || c->no == D_GETLOADLIMIT ||
	   c->no == D_GETCPULIMITMODE || c->no == D_GETCPULIMIT) {
	  if(na > 3)
			goto Usage;
		if(na == 3)
			arg = atoi(argv[2]);
	} else if(c->no == D_SETLOADLIMIT || c->no == D_SETCPULIMIT ||
		  c->no == D_SETLLIMITMODE || c->no == D_SETCPULIMITMODE) {
		if(na != 3)
			goto Usage;
		for(u = argv[2] ; *u ; u++)
			if(*u < '0' || *u > '9')
				goto Usage;
		arg = atoi(argv[2]);
	}
	ans = msxctl(c->no, arg, resp, (int) length);
	if(ans == -1)
	{
		if(c->no == D_GETLOADLIMIT || c->no == D_GETCPULIMIT ||
			c->no == D_GETLOADLOCAL|| c->no == D_GETLOADREMOTE ||
			c->no == D_GETCPULOCAL || c->no == D_GETCPUREMOTE ||
			c->no == D_GETLLIMITMODE || c->no == D_GETCPULIMITMODE)
		switch(errno)
		{
		case EINVAL:
			fprintf(stderr, "Error: Improper node number\n");
			break;
		case EWOULDBLOCK:
		case EHOSTDOWN:
			if(!strcmp(c->com, "isup"))
				fprintf(stderr, "no (it seems)\n");
			else
				fprintf(stderr, "Error: no response\n");
			break;
		case ENOENT:
		        fprintf(stderr,"Node #%s is not configured\n",argv[2]);
			break;
		default:
			perror("Error");
		}
		else if((c->no == D_SETLOADLIMIT || c->no ==  D_SETCPULIMIT
			 || c->no == D_SETLLIMITMODE || 
			 c->no == D_SETCPULIMITMODE)
			&& errno == EINVAL)
			fprintf(stderr, "Error: Improper value\n");
		else
			perror("Error");
	}
	else
	switch(c->no)
	{
		case D_GETLOADLIMIT:
			printf("load limit=%lld\n", ans);
			break;
		case D_GETCPULIMIT:
			printf("cpu limit=%lld\n", ans);
			break;
		case D_GETLLIMITMODE:
			printf("load limit mode=%lld\n", ans);
			break;
		case D_GETCPULIMITMODE:
			printf("cpu limit mode=%lld\n", ans);
			break;
		case D_GETLOADLOCAL:
			printf("local load=%lld\n", ans);
			break;
		case D_GETLOADREMOTE:
			printf("remote load=%lld\n", ans);
			break;
		case D_GETCPULOCAL:
			printf("local cpu usage=%lld\n", ans);
			break;
		case D_GETCPUREMOTE:
			printf("remote cpu usage=%lld\n", ans);
			break;
		case D_SETLOADLIMIT:
			printf("load limit set to %lld\n", arg);
			break;
		case D_SETCPULIMIT:
			printf("cpu limit set to %lld\n", arg);
			break;
		case D_SETLLIMITMODE:
			printf("load limit mode now is %lld\n", arg);
			break;
		case D_SETCPULIMITMODE:
			printf("cpu limit mode now is %lld\n", arg);
			break;
	}
	exit(0);
}
