/*
 * Copyright (c) 2000, Amnon BARAK (amnon@cs.huji.ac.il). All rights reserved.
 *
 *	OpenMosix $Id: mosrun.c,v 1.7 2003/02/26 15:08:24 marhoy Exp $
 *
 * Permission to use, copy and distribute this software is hereby granted 
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh, Ariel Rosenblatt, Moshe Bar
 */



/*  Adapted to OpenMosix from Mosix and bugfixing by David Santo Orcero */
/*  irbis@orcero.org  http://www.orcero.org/irbis                       */
/* Mosix is (c) of prof. Amnon Barak http://www.mosix.org               */
/* Original code is (c) of prof. Amnon Barak http://www.mosix.org       */
/* OpenMosix is (c) of Moshe Bar http://www.openmosix.com               */
/* Each respective trademark is of its own owner                        */
/* All rights reserved.                                                 */
/* This software is distributed under GPL 2                             */


#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/signal.h>
#include <mos.h>
#include <linux/hpcctl.h>

char fok, zeroargv;
int where = D_LEAVE;
int lock = -100;

int main(int na, char *argv[])
{
	int tt = -1, dec = -1, policy = 0;
	int opts = DADV_INHERIT | DADV_EXEC;
	char *prog = (na && strchr(argv[0], '/')) ? strchr(argv[0], '/') + 1 :
							(na ? argv[0] : NULL);
	int tmp[2];
	int randsel(char *str);

	while(na > 1 && argv[1][0] == '-')
	{
		switch(argv[1][1])
		{
			case 'c':
			case 'C':
				if(policy)
					goto Usage;
				policy = DADV_CPU;
				break;
			case 'i':
			case 'I':
				if(policy)
					goto Usage;
				policy = DADV_NOCPU;
				break;
			case 'n':
			case 'N':
				if(policy)
					goto Usage;
				policy = DADV_NODECAY;
				break;
			case 's':
			case 'S':
				if(policy)
					goto Usage;
				policy = DADV_SLOWDECAY;
				break;
			case 'f':
				if(policy)
					goto Usage;
				policy = DADV_FASTDECAY;
				break;
			case 'd':
			case 'D':
				if(argv[1][2])
					argv[1] += 2;
				else if(na <= 1)
					goto Usage;
				else
				{
					na--;
					argv++;
				}
					
				if((policy && policy != DADV_OWNDECAY) ||
					argv[1][0] < '0' || argv[1][0] > '9' ||
					(dec = atoi(argv[1])) < 0 ||
					dec > DECAY_QUOTIENT)
						goto Usage;
				policy = DADV_OWNDECAY;
				break;
			case 't':
			case 'T':
				if(argv[1][2])
					argv[1] += 2;
				else if(na <= 1)
					goto Usage;
				else
				{
					na--;
					argv++;
				}
					
				if((policy && policy != DADV_OWNDECAY) ||
					argv[1][0] < '0' || argv[1][0] >= '9' ||
					(tt = atoi(argv[1])) <= 0 || tt > 65535)
					goto Usage;
				policy = DADV_OWNDECAY;
				break;
			case 'e':
				opts &= ~DADV_EXEC;
				opts |= DADV_NOEXEC | DADV_EXECONCE;
				break;
			case 'E':
				opts &= ~DADV_NOEXEC;
				opts |= DADV_EXEC | DADV_EXECONCE;
				break;
			case 'r':
				opts &= ~DADV_INHERIT;
				opts |= DADV_NOINHERIT | DADV_EXECONCE;
				break;
			case 'R':
				opts &= ~DADV_NOINHERIT;
				opts |= DADV_INHERIT | DADV_EXECONCE;
				break;
			case 'z':
			case 'Z':
				zeroargv = 1;
				break;
			case 'F':
				fok = 1;
				break;
			case 'h':
			case 'H':
				if(where != D_LEAVE)
					goto Usage;
				where = D_GOBACKHOME;
				break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				if(where != D_LEAVE)
					goto Usage;
				where = atoi(&argv[1][1]);
				break;
			case 'j':
				if(where != D_LEAVE)
					goto Usage;
				if(!(where = randsel(&argv[1][2])))
					goto Usage;
				break;
			case 'l':
				lock = D_UNLOCK;
				break;
			case 'L':
				lock = D_LOCK;
				break;
			case 'k':
				lock = D_NOCHANGE;
				break;
			default:
				goto Usage;
		}
		na--;
		argv++;
	}
	if(na < 2 + zeroargv)
	{
		Usage:
		fprintf(stderr, "Usage: %s [-{h|OpenMosix_ID|-jID1-ID2[,ID3-ID4]...} [-F] ] -{l|L|k}\n", prog);
		fprintf(stderr, "              [-{c|i|n|s|f | ([-d dec] [-t tt])} [-{e|E}] [-{r|R}] ]\n");
		fprintf(stderr, "              [-z] prog [args]...\n");
		if (zeroargv)
			fprintf(stderr, "The '-z' option requires at least one argument.\n");
		exit(1);
	}
	if (!msx_is_mosix()) {
		execvp(argv[0] = argv[1], &argv[zeroargv ? 2 : 1]);
		perror("exec");
		exit (1);
	}
	if(policy == DADV_OWNDECAY && (tt == -1 || dec == -1)) {
		msx_get_own(tmp, &tmp[1]);
		if(tmp[1])
		{
			if(dec == -1)
				dec = tmp[0];
			if(tt == -1)
				tt = tmp[1];
		}
		if(tt == -1)
			tt = msx_get_decayinterval();
		if(dec == -1)
		{
			if (msx_get_fast()) 
				dec = msx_get_fastdecay();
			else if (msx_get_slow() || msx_get_cpujob() 
						    || msx_get_iojob()) 
				dec = msx_get_slowdecay();
			else 
				dec = DECAY_QUOTIENT;
		}
	}
	if(policy || (opts & DADV_EXECONCE))
	{
		if(dadvise(policy | opts, tt, dec) == -1)
		{
			perror("dadvise");
			exit(1);
		}
	}
	switch(lock)
	{
		case -100:
			if(where == D_LEAVE &&
				(policy || (opts & DADV_EXECONCE)))
				break;
			/* fall thru: the default is to lock where we are */
		case D_LOCK:
			msx_lock();
			break;
		case D_UNLOCK:
			msx_unlock();
			break;
	}
	if(where != D_LEAVE && !msx_migrate(where) && !fok) {
		perror("Migration Failed");
		exit(1);
	}
	execvp(argv[0] = argv[1], &argv[zeroargv ? 2 : 1]);
	perror("exec");
	exit(1);
}

int
randsel(char *str)
{
	int n = 0, b, e;
	char *s = str;

	while(*s)
	{
		if(*s < '0' || *s > '9')
			return(0);
		b = atoi(s);
		if(b <= 0 || b > MOSIX_MAX)
			return(0);
		while(*s >= '0' && *s <= '9')
			s++;
		if(*s == '-')
		{
			s++;
			if(*s < '0' || *s > '9')
				return(0);
			e = atoi(s);
			if(e < b || e > MOSIX_MAX)
				return(0);
			while(*s >= '0' && *s <= '9')
				s++;
		}
		else
			e = b;
		n += e - b + 1;
		if(*s == ',')
			s++;
		else if(*s)
			return(0);
	}
	if(!n)
		return(0);
	srand((unsigned int) time(0l) ^ getpid());
	n = rand() % n;
	s = str;
	while(n >= 0)
	{
		b = atoi(s);
		if(b <= 0 || b > MOSIX_MAX)
			return(0);
		while(*s >= '0' && *s <= '9')
			s++;
		if(*s == '-')
		{
			s++;
			e = atoi(s);
			while(*s >= '0' && *s <= '9')
				s++;
		}
		else
			e = b;
		if(n < e - b + 1)
			return(b + n);
		else
			n -= (e - b + 1);
		if(*s == ',')
			s++;
	}
	/*NOTREACHED*/
	return(0);
}
