#define PI 3.14159
#include "3dmosmon.h"

// the number for the selected node
int selectednode;


// ####################################### starfield ###########################################

enum {
  NORMAL = 0,
  WEIRD = 1
};

enum {
  STREAK = 0,
  CIRCLE = 1
};

#define MAXSTARS 4000
#define MAXPOS 10000
#define MAXWARP 10
#define MAXANGLES 6000

typedef struct _starRec {
  GLint type;
  float x[2], y[2], z[2];
  float offsetX, offsetY, offsetR, rotation;
} starRec;

GLenum doubleBuffer;
GLint windW = 300, windH = 300;

GLenum flag = NORMAL;
GLint starCount = MAXSTARS / 2;
float speed = 1.0;
GLint nitro = 0;
starRec stars[MAXSTARS];
float sinTable[MAXANGLES];

float
Sin(float angle)
{
  return (sinTable[(GLint) angle]);
}

float
Cos(float angle)
{
  return (sinTable[((GLint) angle + (MAXANGLES / 4)) % MAXANGLES]);
}

void
NewStar(GLint n, GLint d)
{
  stars[n].type = STREAK;

  stars[n].x[0] = (float) (rand() % MAXPOS - MAXPOS / 2);
  stars[n].y[0] = (float) (rand() % MAXPOS - MAXPOS / 2);
  stars[n].z[0] = (float) (rand() % MAXPOS + d);

  stars[n].x[1] = stars[n].x[0];
  stars[n].y[1] = stars[n].y[0];
  stars[n].z[1] = stars[n].z[0];
  stars[n].offsetX = 0.0;
  stars[n].offsetY = 0.0;
  stars[n].offsetR = 0.0;
}

void
RotatePoint(float *x, float *y, float rotation)
{
  float tmpX, tmpY;

  tmpX = *x * Cos(rotation) - *y * Sin(rotation);
  tmpY = *y * Cos(rotation) + *x * Sin(rotation);
  *x = tmpX;
  *y = tmpY;
}

void
MoveStars(void)
{
  float offset;
  GLint n;

  offset = speed * 10.0;

  for (n = 0; n < starCount; n++) {
    stars[n].x[1] = stars[n].x[0];
    stars[n].y[1] = stars[n].y[0];
    stars[n].z[1] = stars[n].z[0];
    stars[n].x[0] += stars[n].offsetX;
    stars[n].y[0] += stars[n].offsetY;
    stars[n].z[0] -= offset;
    stars[n].rotation += stars[n].offsetR;
    if (stars[n].rotation > MAXANGLES) {
      stars[n].rotation = 0.0;
    }
  }
}

GLenum
StarPoint(GLint n)
{
  float x0, y0;

  x0 = stars[n].x[0] * windW / stars[n].z[0];
  y0 = stars[n].y[0] * windH / stars[n].z[0];
  RotatePoint(&x0, &y0, stars[n].rotation);
  x0 += windW / 2.0;
  y0 += windH / 2.0;

  if (x0 >= 0.0 && x0 < windW && y0 >= 0.0 && y0 < windH) {
    return GL_TRUE;
  } else {
    return GL_FALSE;
  }
}

void
ShowStar(GLint n)
{
  float x0, y0, x1, y1, width;
  GLint i;

  x0 = stars[n].x[0] * windW / stars[n].z[0];
  y0 = stars[n].y[0] * windH / stars[n].z[0];
  RotatePoint(&x0, &y0, stars[n].rotation);
  x0 += windW / 2.0;
  y0 += windH / 2.0;

  glEnable(GL_COLOR_MATERIAL);

  if (x0 >= 0.0 && x0 < windW && y0 >= 0.0 && y0 < windH) {
    if (stars[n].type == STREAK) {
      x1 = stars[n].x[1] * windW / stars[n].z[1];
      y1 = stars[n].y[1] * windH / stars[n].z[1];
      RotatePoint(&x1, &y1, stars[n].rotation);
      x1 += windW / 2.0;
      y1 += windH / 2.0;

      glLineWidth(MAXPOS / 100.0 / stars[n].z[0] + 1.0);
      glColor3f(1.0, (MAXWARP - speed) / MAXWARP, (MAXWARP - speed) / MAXWARP);
      if (fabs(x0 - x1) < 1.0 && fabs(y0 - y1) < 1.0) {
        glBegin(GL_POINTS);
	x0=x0-100;
	y0=y0-150;
        glVertex2f(x0, y0);
        glEnd();
      }

// else {
// no stripes
//        glBegin(GL_LINES);
//        glVertex2f(x0, y0);
//        glVertex2f(x1, y1);
//        glEnd();
//      }


    } else {
      width = MAXPOS / 10.0 / stars[n].z[0] + 1.0;
      glColor3f(1.0, 0.0, 0.0);
      glBegin(GL_POLYGON);
      for (i = 0; i < 8; i++) {
        float x = x0 + width * Cos((float) i * MAXANGLES / 8.0);
        float y = y0 + width * Sin((float) i * MAXANGLES / 8.0);
        glVertex2f(x, y);
      };
      glEnd();
    }
  }
  glDisable(GL_COLOR_MATERIAL);
}

void
UpdateStars(void)
{
  GLint n;

  glClear(GL_COLOR_BUFFER_BIT);

  for (n = 0; n < starCount; n++) {
    if (stars[n].z[0] > speed || (stars[n].z[0] > 0.0 && speed < MAXWARP)) {
      if (StarPoint(n) == GL_FALSE) {
        NewStar(n, MAXPOS);
      }
    } else {
      NewStar(n, MAXPOS);
    }
  }
}

void
ShowStars(void)
{
  GLint n;

  glClear(GL_COLOR_BUFFER_BIT);

  for (n = 0; n < starCount; n++) {
    if (stars[n].z[0] > speed || (stars[n].z[0] > 0.0 && speed < MAXWARP)) {
      ShowStar(n);
    }
  }
}




void
Idle(void)
{
  MoveStars();
  UpdateStars();
  if (nitro > 0) {
    speed = (float) (nitro / 10) + 1.0;
    if (speed > MAXWARP) {
      speed = MAXWARP;
    }
    if (++nitro > MAXWARP * 10) {
      nitro = -nitro;
    }
  } else if (nitro < 0) {
    nitro++;
    speed = (float) (-nitro / 10) + 1.0;
    if (speed > MAXWARP) {
      speed = MAXWARP;
    }
  }
  glutPostRedisplay();
}



void
Visible(int state)
{
  if (state == GLUT_VISIBLE) {
    glutIdleFunc(Idle);
  } else {
    glutIdleFunc(NULL);
  }
}







// ############################################ now the real work ###############################

void handler(int x)
{
    //printf("handler!\n");
    Barmanager.GetMosixData(x);

}

void RaiseSigUser()
{
    int ppid;
	
    ppid = getppid();
    
    while (1)
    {
	usleep(read_delay);
	kill(ppid, SIGUSR1);
    }
}

void init(void)
{ 
  float angle;
  GLint n;


   signal (SIGUSR1, handler); // this is used to check for data..   
   glClearColor(0.0, 0.0, 0.0, 0.0);
   glShadeModel(GL_FLAT);
	
    Barmanager.SetXsquares(10);
    Barmanager.SetYsquares(0); // not used
    Barmanager.SetZsquares(10);
    Barmanager.SetGridSize(2);
    Barmanager.GenerateGrid();
    DISPLAYMODE = LOAD;
    
    camx = Barmanager.GetXsquares()/2 *Barmanager.GetGridSize();
    camy = 5;
    camz = Barmanager.GetZsquares()/2*Barmanager.GetGridSize();
    
    anglex= 30;
    angley= -20;
    anglez=0;
    
    glEnable(GL_LIGHTING);
    glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_TRUE);
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE);
    glLightModelfv(GL_LIGHT_MODEL_AMBIENT,global_ambient);

    SPEED_MODIFIER = DEFAULTSPEED;
    Barmanager.ToggleSpin();
    if ( (kpid =  fork()) == 0)
	RaiseSigUser();

	printf("kpid %d\n", kpid);
	//getchar();     



	// init for the starfield
	srand((unsigned int) time(NULL));
	  for (n = 0; n < MAXSTARS; n++) {
 	   NewStar(n, 100);
	  }
	  angle = 0.0;
	  for (n = 0; n <= MAXANGLES; n++) {
	    sinTable[n] = sin(angle);
	    angle += PI / (MAXANGLES / 2.0);
	  }
	  glClearColor(0.0, 0.0, 0.0, 0.0);
	  glDisable(GL_DITHER);

}



float cleanAngleY(float a)
{
	float ret;
	
    angley = a;

	if (angley > 2*PI)
	 angley = 0;
    else if (angley < -2*PI)
		angley = 0;


    if (angley > PI/2-PI/128)
	angley = PI/2-PI/128;
    else if (angley < -PI/2+PI/128)
       angley = -PI/2+PI/128;

	return angley;
}


float cleanAngleX(float x)
{
	float anglex;
	anglex = x;

    if (anglex > 2*PI)
	  anglex = 0;
    else if (anglex < -2*PI)
	  anglex = 0;

	return anglex;
}
void display(void)
{  
	float xsquares, zsquares, gridsize;
		     
	glClear(GL_COLOR_BUFFER_BIT);
	glColor3f(1.0f,1.0f,1.0f);

	glLoadIdentity();
	
	angley = cleanAngleY(angley);
	anglex = cleanAngleX(anglex);
		
	lookxrl =  2*cos(angley)*sin(anglex);
	lookzrl =  2*cos(angley)*cos(anglex);
	lookyud =  2*sin(angley);
	//VIEWPORT CODE
	glViewport(0, HEIGHT/5, WIDTH, 9*HEIGHT/10-HEIGHT/7);
	fAspect = (GLfloat)WIDTH/(GLfloat)(9*HEIGHT/10-HEIGHT/5);
	// Reset coordinate system
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	// Produce the perspective projection
	gluPerspective(50.0f, fAspect, 1.0, 1000.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	// Clear the window with current clearing color
	// Save the matrix state and do the rotations
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	if (!Barmanager.GetSpin())
		gluLookAt(camx,                  camy,           camz+2,
			  camx + lookxrl,camy  + lookyud, camz + lookzrl, 
			  0.0 ,                  1.0 ,            0.0);
	else
	{
	    camy = 5;
	
	    if (Barmanager.GetSpin() == CIRCLESPIN)
		{
		gridsize = Barmanager.GetGridSize();
		xsquares = Barmanager.GetXsquares();
		zsquares = Barmanager.GetZsquares();
		
		camx = sin(slowcounter*SPEED_MODIFIER)*xsquares*gridsize;
		camz = cos(slowcounter*SPEED_MODIFIER)*zsquares*gridsize;
		//camx and camz now make a circle centered at the origin 
		// but we only have quad 1, so offset accordingly
		camx += xsquares/2 *gridsize;
		camz += zsquares/2 * gridsize;
    //    printf("should be spinning..\n");	
		gluLookAt(camx, camy, camz+2,
		 xsquares/2*gridsize,5,zsquares/2*gridsize,
		    0,100,0);

	
//                glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		}
	
	} 
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	// showstars
	ShowStars();

	Barmanager.Show();
	glutSwapBuffers();

}



void reshape(int w, int h)
{
	glViewport(0,0,(GLsizei) w, (GLsizei) h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60.0, (GLfloat) w/(GLfloat)h, 1.0, 200.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0, 0.0, 5.0,
		  0.0, 0.0, 0.0, 
		  0.0, 1.0, 0.0);
	WIDTH = w;
	HEIGHT = h;

}



void keyboard(unsigned char key, int x, int y)
{       static bool animate = false;

	switch (key)
	{ 
	case 'q': kill(kpid, SIGKILL); Barmanager.quit(); break;
    
	case 'r': Barmanager.ToggleSpin(); break;
	
	case 'w':
		camx +=  .25*cos(angley)*sin(anglex);
		camz +=  .25*cos(angley)*cos(anglex);
		camy +=  .25*sin(angley);
		break;

	case 's':
		camx -=  .25*cos(angley)*sin(anglex);
		camz -=  .25*cos(angley)*cos(anglex);
		camy -=  .25*sin(angley);
		break;
	case 'a':
		camx += 0.125*sin(anglex+PI/2);
		camz += 0.125*cos(anglex+PI/2);
		break;
	case 'd':
		camx -= 0.125*sin(anglex+PI/2);
		camz -= 0.125*cos(anglex+PI/2);
		break;

	case 'l':
		if (glutGetModifiers() != GLUT_ACTIVE_CTRL)
		    {
		    DISPLAYMODE = LOAD;
		    printf("mode set to load\n");
		    }
		else
		{
		    if(LIGHTS_ON)
		    {
			LIGHTS_ON = 0;
			glDisable(GL_LIGHTING);
		    }
		    else
			{
			    LIGHTS_ON = 1;
			    glEnable(GL_LIGHTING);
			}
		}
		break;
	case 'm':
		    printf("mode set to memory\n");
		    DISPLAYMODE = MEM;
		    break;
	case 'u':
		    printf("mode set to util\n");
		    DISPLAYMODE = UTIL;
		    break;

	// speed up stars
	case 't':
		    nitro = 1;
		    break;

	default:
	break;
	}
}

void MainLoop()
{
	slowcounter += 0.00125;
	medcounter += 0.0125;
	fastcounter +=0.05;
	glutPostRedisplay();
}

void mouse(int btn, int state, int x, int y)
{
 // right button clicked -> togglespin ( same as 'r'
 if ((btn==2) && (state==1)) {
  Barmanager.ToggleSpin();
 }

 // fly ahead / left mouse button
 if (btn==0)  {
  camx +=  .5*cos(angley)*sin(anglex);
  camz +=  .5*cos(angley)*cos(anglex);
  camy +=  .5*sin(angley);
 }


 // switch the selectednode with the mouse
 if ((btn==0) && (state==1)) {
  selectednode++;
 }
 if ((btn==1) && (state==1)) {
  selectednode--;
 }


 // fly back / middle mouse button
 if (btn==1)  {
  camx -=  .5*cos(angley)*sin(anglex);
  camz -=  .5*cos(angley)*cos(anglex);
  camy -=  .5*sin(angley);
 }

 
}



void passive_mouse(int x,int y)
{
    if ( Barmanager.GetSpin() == 0)
   {
   angley += (mousepos[1] - (float)y)/100;
    anglex += (mousepos[0] - (float)x)/100;

    mousepos[0] = x;
    mousepos[1] = y;
	}
}

void handleSpecialKey(int k, int x, int y)
{
	switch (k)
	{
	case GLUT_KEY_UP:
		if ( glutGetModifiers() != GLUT_ACTIVE_CTRL)
		{
			angley += PI/128;
		 }
				
		else
		    camy += 1;
		break;

	case GLUT_KEY_DOWN:

		if ( glutGetModifiers() != GLUT_ACTIVE_CTRL)
		{
			angley -= PI/128;
		  }
		else
		    camy -= 1;
		break;

	case GLUT_KEY_LEFT:
    // here i do not want to move the camera but
    // change the selected node e.g. nodenumber -1
    if(selectednode>1) {
      selectednode--;
    }

		break;
	case GLUT_KEY_RIGHT:
    // here i do not want to move the camera but
    // change the selected node e.g. nodenumber +1
    selectednode++;


		break;
	case GLUT_KEY_HOME:
		camx = Barmanager.GetXsquares()/2*Barmanager.GetGridSize();
		camy = 5;
		camz = 0;
		anglex=0;
		angley=0;
		anglez=0;
	break;
	case GLUT_KEY_PAGE_UP:
	    SPEED_MODIFIER += 0.1;
	    break;
	case GLUT_KEY_PAGE_DOWN:
	    SPEED_MODIFIER -= 0.1;
	    break;
	}

}

void ParseArguments(int argc, char **argv)
{
	/* incredibly un-robust command line parsing by jon. */
     if (argc == 2)
	Barmanager.init(argv[1], DEFAULT_PORT);
	 else if (argc == 3)
	Barmanager.init(argv[1], argv[2]);
	    else
	 {
	     usage();
	     exit(0);
	}                                     
}

void usage()
{
    printf("3dmosmon by johnny cache\n");
    printf("(enhanced for openMosix by Matt)\n");
    printf("./3dmosmon server [port]\n");
    
}

	
int main(int argc, char** argv)
{

	ParseArguments(argc, argv);
	glutInit(&argc, argv);
	
	glutInitDisplayMode(GLUT_DEPTH|GLUT_DOUBLE | GLUT_RGB);
	
	glutInitWindowSize(500, 300);
	glutInitWindowPosition(100,100);
	glutCreateWindow("Cluster Status");
	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutSpecialFunc(handleSpecialKey);
	glutMouseFunc(mouse);
	glutPassiveMotionFunc(passive_mouse);    
	
	glutVisibilityFunc(Visible);

	glutKeyboardFunc(keyboard);
	glutIdleFunc(MainLoop);
	
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	init();


	glutMainLoop();
  return 0;
}


void  print_CObject_struct(CObject_struct &s)
{
	printf(" type :%d\n id: %d\n   \npos(%f, %f, %f)\n dir(%f, %f %f)\n angle(%f, %f, %f)\n color(%f, %f, %f, %f)\n solid: %d\n\n",          
	s.type, s.id,  s.posX, s.posY, s.posZ, s.dirX, s.dirY, s.dirZ, s.angleX, s.angleY, s.angleZ, s.color_r, s.color_g, s.color_b, s.color_a /*, s.solid */);


}



