#ifndef _MATERIALSH
#define _MATERIALSH


/*
const GLfloat Color[11][4] =
{ 0.0f,0.0f,0.0f,1.0f,
  1.0f,0.0f,0.0f,1.0f, // red
  0.0f,1.0f,0.0f,1.0f, // green
  0.0f,0.0f,1.0f,1.0f, // blue
  1.0f,1.0f,0.0f,1.0f, // cyan
  1.0f,0.0f,1.0f,1.0f, // magenta
  1.0f,1.0f,0.0f,1.0f, // yellow
  1.0f,1.0f,1.0f,1.0f, // white
  0.0f,0.0f,0.0f,1.0f,  // black
  0.75f,0.75f,0.75f,1.0f,//brown
  0.0,  0.61f, 0.035     //dark green   
};

*/
struct material_struct
{
	float ambient[4];
	float diffuse[4];
	float specular[4];
	float shininess;
};


static material_struct whiteMaterials = {
	{1.0, 1.0, 1.0, 1.0},
	{0.0, 0.0, 0.0, 1.0},   
	{1.0, 1.0, 1.0, 1.0},
	{20.0}
};
 
static material_struct lensMaterials = {
	{0.1, 0.1, 0.1, 1.0},
	{0.1, 0.1, 0.1, 1.0},   
	{1.0, 1.0, 1.0, 1.0},
	{20.0}
};
static material_struct redMaterials = {
	{1.0, 0.0, 0.0, 0.4},
	{0.0, 0.0, 0.0, 0.4},
	{0.0, 0.0, 0.0, 0.4},
	{20.0}
};


static material_struct greenMaterials = {
	{0.0, 0.6, 0.2, 0.4},
	{0.0, 0.0, 0.0, 0.4},
	{0.3, 0.3, 0.3, 0.4},
	{20.0}
};

static material_struct blueMaterials = {
	{0.0, 0.0, 1.0, 0.4},
	{0.0, 0.0, 0.0, 0.4},
	{0.6, 0.6, 0.8, 0.4},
	{20.0}
};


static material_struct yellowMaterials = {
	{1.0, 1.0, 0.0, 1.0},
	{0.0, 0.0, 0.0, 1.0},
	{0.8, 0.8, 0.6, 1.0},
	{25.0}

};


static material_struct orangeMaterials = {
	{1.0, 0.75, 0.5, 1.0},
	{0.0, 0.0, 0.0, 1.0},
	{0.8, 0.8, 0.6, 1.0},
	{25.0}

};


static material_struct dgreenMaterials = {
	{0.0, 0.3, 0.0, 0.3},
	{1.0, 1.0, 1.0, 0.3},
	{0.2, 0.2, 0.2, 0.3},
	{30.0}
};

static material_struct groundMaterials = {
	{0.0, 0.3, 0.0, 1.0},
	{0.0, 0.0, 0.0, 1.0},
	{0.6, 0.8, 0.6, 1.0},
	{0.0}
};

static material_struct brownMaterials = {
	{0.4, 0.24, 0.11, 1.0},
	{0.0, 0.0, 0.0, 1.0},
	{0.3, 0.3, 0.3, 1.0},
	{35.0}
};

static material_struct moonMaterials = {
	{0.5, 0.5, 0.6, 1.0},
	{0.0, 0.0, 0.0, 1.0},
	{0.6, 0.6, 0.8, 1.0},
	{20.0}
};

static material_struct sunMaterials = {
	{0.75, 0.5, 0.0,1.0},
	{0.0, 0.0, 0.0, 1.0},
	{0.6, 0.6, 0.8, 1.0},
	{20.0}
};



#endif

