#ifndef _OBJECTSH
#define _OBJECTSH
#define PI 3.14159
#include <stdio.h>
#include <list>
#include <string>
#include "colors.h"
#include "materials.h"
#include <GL/glut.h>

using namespace std;

#define CONE 301
#define SPHERE 302
#define CYLINDER 303
#define DISK 305

#define TWODRECT 309
#define BAR 401 //            

struct CObject_struct {
   int type;                   // object type, 0=bird, 1=flower, 2=tree, 3=teapot, ?
   unsigned long id;           //used for something? maybe?
   float posX, posY, posZ;     // location in the world
   float dirX, dirY, dirZ;     // orientation direction vector
   float angleX, angleY, angleZ; //360 degrees of orientations. Whee!
   float color_r, color_g, color_b, color_a;
   material_struct obj_materials;
   int drawstyle;

};


class CObject

{       
	protected:
	CObject_struct base_data;
	public:
	
		CObject() {  base_data.type = -1; }
	CObject(int t) { base_data.type = t;     }
	CObject(CObject_struct &base) : base_data(base) {; }
	   
	CObject(float fposx, float fposy,float fposz) { 
		   base_data.posX = fposx; base_data.posY = fposy; base_data.posZ = fposz; 
		   
	   }
       CObject(int t, float fposx, float fposy, float fposz) { 
		   base_data.type = t; base_data.posX = fposx; base_data.posY = fposy; base_data.posZ = fposz; 
		   
	   }
       CObject(int t, float fposx, float fposy, float fposz, float fdirx, float fdiry, float fdirz) { base_data.type = t; base_data.posX = fposx; base_data.posY = fposy; base_data.posZ = fposz; base_data.dirX = fdirx; base_data.dirY = fdiry; base_data.dirZ = fdirz; 
	  
	   }      
       
       virtual void draw()=0; // draws the object at the current location & orientation
       virtual void dealloc()= 0;
       void setId(unsigned long x) { base_data.id = x; }
       void setPos( float x, float y, float z) { base_data.posX = x; base_data.posY = y; base_data.posZ = z;}
       void getPos(float &x, float &y, float &z) { x = base_data.posX, y = base_data.posY, z = base_data.posZ; }
       void setDir( float x, float y, float z) { base_data.dirX = x; base_data.dirY = y; base_data.dirZ = z;}
       void getDir( float &x, float &y, float &z) { x = base_data.dirX ; y = base_data.dirY = y;  z = base_data.dirZ;}
       
	   void setAngle( float x, float y=0.0, float z=0.0) { base_data.angleX = x; base_data.angleY = y; base_data.angleZ = z; }
	   void getAngle( float &x, float &y, float &z) { x = base_data.angleX;  y = base_data.angleY;  z= base_data.angleZ; }
		
	void setColor( float r, float g, float b, float a=1.0) { base_data.color_r = r; base_data.color_g = g; base_data.color_b = a; base_data.color_a = a;}
	void getColor(float &r, float &g, float &b, float &a ){ r = base_data.color_r; g = base_data.color_g; b = base_data.color_b; a = base_data.color_a;}
	
       void setColor4v(const float colorv[4] ) { base_data.color_r = colorv[0]; base_data.color_g = colorv[1]; base_data.color_b = colorv[2]; base_data.color_a = colorv[3];}
       void getColor4v(float colorv[4]) { colorv[0] = base_data.color_r; colorv[1] = base_data.color_g; colorv[2] = base_data.color_b; colorv[3] = base_data.color_a; }
	
	// other public interface members
	 
	   void loadMaterials(material_struct m) { base_data.obj_materials = m; }
//       void recvMaterial(material_struct m) { m = base_data.obj_materials; }

	   void setMaterials();
	   unsigned long getId() { return base_data.id; }
	   int getType() { return base_data.type; }
	   void setBase(struct CObject_struct & base) { base_data = base; }
	   CObject_struct getBase() { return base_data; }
	   int WriteBase(FILE *f) { int ret;  ret = fwrite((void *) & base_data, sizeof(base_data), 1, f); printf("CObject :: Writebase, sizeof(base_data is %d) ret: %d\n", sizeof(base_data), ret);   return ret; }
	   int WriteYourself(FILE *f) { printf("dont be here\n"); return -1;} // make this virtual in the end.
};


struct CDisk_struct
{
    float inner_r;
    float outter_r;
    float slices;
    float stacks;
    GLUquadricObj *disk;
};

class CDisk : public CObject
{
	CDisk_struct disk_data;

    public:
    CDisk(struct CObject_struct &base, CDisk_struct &disk); 
    CDisk(float inner_r = 0.25, float outter_r = 0.5, float x=0.0, float y=0.0, float z=0.0, float slices = 20, float stacks = 20); 
    int WriteYourself(FILE *fp) { printf("sizeof(disk_data) %d\n", sizeof(disk_data)); return( WriteBase(fp) + fwrite((void *) &disk_data, sizeof(disk_data), 1, fp)); }

	void draw();
    void dealloc();
    ~CDisk();
};

struct CSphere_struct
{
    float radius;
    float slices;
    float stacks;
    GLUquadricObj * sphere;
};

class CSphere : public CObject
{

	CSphere_struct sphere_data; 
   public:
	CSphere(struct  CObject_struct &base, CSphere_struct &sphere); 
	CSphere( float radius=1.0, float x=0.0, float y=0.0, float z=0.0, float slices =10.0, float stacks=10.0);
    int WriteYourself(FILE *fp) { printf("sizeof(sphere_data) %d\n", sizeof(sphere_data)); return( WriteBase(fp) + fwrite((void *) &sphere_data, sizeof(sphere_data), 1, fp)); }

	void draw();
    void dealloc();
    ~CSphere();
};


    
struct CCylinder_struct 
{
    GLdouble base;
    GLdouble top;
    float height;
    float slices;
    float stacks;
  
    GLUquadricObj * obj;


};

class CCylinder : public CObject
{
   CCylinder_struct cyl_data;

	 public:    
	 CCylinder(struct CObject_struct &base, CCylinder_struct &cyl); 
     CCylinder(float x = 0.0, float y=0.0, float z=0.0, double  dbase =2.0, double dtop=2.0, float fheight = 2.0, float fslices = 10, float fstacks=10);
    void draw(); 
    void dealloc();
    int WriteYourself(FILE *fp) { int ret;  printf("sizeof(cyl_data) %d\n", sizeof(cyl_data));   WriteBase(fp); printf("supposedly just called writeBase crom CCylinder..\n");   fwrite((void *) &cyl_data, sizeof(cyl_data), 1, fp);   return 1; }
    
	
	~CCylinder();
};

struct TwoDRect_struct
{
    float width;
    float depth;
};

class TwoDRect : public CObject
{
    TwoDRect_struct rect_data;
    public:
    TwoDRect(float x = 0.0, float y = 0.0, float z=0.0, float width=1.0, float depth= 1.0) : CObject(TWODRECT, x ,y, z)
    {
	rect_data.width = width;
	rect_data.depth = depth;
	loadMaterials(whiteMaterials);
	
    }

    TwoDRect(CObject_struct &base, TwoDRect_struct &rect) : CObject(base), rect_data(rect) 
    { 
    // printf("2drect struct ctor\n");
    }

    void draw();
    ~TwoDRect() {
    //  printf("2drect dtor\n");
    }
    void dealloc() {
    //  printf("2drect dealloc\n");
    }
};


struct CBar_struct
{
    float height;
    float width;
    int fill_style;
    // more to come later
    
};

class CBar : public CObject
{
    CBar_struct bar_data;
    
    public: 
    CBar :: CBar(struct CObject_struct &base, CBar_struct &data) : CObject(base) 
	    { bar_data = data; } 
    CBar(float x=0.0, float y=0.0, float z=0.0, float height=2, float width=2, int style=0) : CObject(BAR,x,y,z)
    { bar_data.height = height;
      bar_data.width = width;
      bar_data.fill_style=style;
    }    
    int setData(struct CBar_struct d) { bar_data = d; }
    struct CBar_struct getData() { return bar_data; }
    void SetHeight(float h) { bar_data.height = h;}
    float GetHeight() { return bar_data.height;}
    void SetWidth(float h){ bar_data.width= h;}
    float GetWidth() { return bar_data.width;}
    void setStyle(int s) { if (s < 3) bar_data.fill_style=s;}
    int getStyle() { return bar_data.fill_style;}
    
    void init();
    void draw();
    void dealloc() {;}
};

struct CCone_struct
{
    GLdouble base;
    GLdouble height;
    float slices;
    float stacks;
};    


class CCone : public CObject
{
	CCone_struct cone_data;
	
    public:
		CCone(float x = 0.0, float y=0.0, float z=0.0, double  dbase =2.0,  double dheight = 2.0, float fslices = 10, float fstacks=10) : CObject(CONE, x, y, z) {   
		setAngle(270.0, 0.0, 0.0); setDir(1.0 ,1.0 ,1.0); 
		cone_data.base = dbase; cone_data.height = dheight; cone_data.slices = fslices; cone_data.stacks = fstacks; 
		loadMaterials(whiteMaterials); 
		}
		CCone( CObject_struct &base, CCone_struct &cone) : CObject(base), cone_data(cone) { printf("special cone ctor\n"); }
    void draw();
	int WriteYourself(FILE *fp) {  printf("sizeof(cone_data) %d\n", sizeof(cone_data)); return( WriteBase(fp) + fwrite((void *) &cone_data, sizeof(cone_data), 1, fp)); }
     ~CCone() { printf(" CCone :: ~CCone\n"); } 
    void dealloc(){ /* printf("CCone :: dealloc()\n"); CCone:: ~CCone() ; */ ; }

};


#endif
