/***************************************************************************
                          clusterinfo.cpp  -  description
                             -------------------
    begin                : Wed Jul 31 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "clusterinfo.h"
#include "ende.xpm"
#include "white.xpm"


clusterinfo::clusterinfo(QWidget *parent, const char *name ) : QWidget(parent,name) {

	QPixmap end;
	end = QPixmap(ende);

	title_cluster_info= new QLabel(this,"title");
	title_cluster_info->setGeometry(0,0,180,20);
	title_cluster_info->setMinimumSize(0,0);
	title_cluster_info->setText("Informations about the cluster");
	title_cluster_info->setMargin(0);
	title_cluster_info->setAlignment( AlignVCenter | AlignCenter );

	close= new QPushButton(end, "close", this);
	close->setGeometry(420,140,60,20);
	close->setMinimumSize(0,0);
	close->setText("quit");
	QObject::connect(close, SIGNAL(clicked()), this, SLOT(close()) );
}


clusterinfo::~clusterinfo(){
}



// helping functions

inline int min(int eins, int zwei) {
	if(eins>zwei) {
		return zwei;
		} else {
		return eins;
	}
}

inline int max(int eins, int zwei) {
 	if(eins<zwei) {
		return zwei;
		} else {
		return eins;
	}
}



// #########################

void clusterinfo::paintEvent(QPaintEvent *) {

	int oload, obalance, oallmem, ousedmem, cpus;
	FILE *readfile;
	char *when;
	when = new char[50];
	int j=0;
	QPainter p(this);
	const char *nodefilename;
	nodefilename = this->name();

	string startdate;
	string enddate;
	int allload = 0;
	int allmem = 0;
	int allusedmem = 0;
	int maxload = 0;
	int minload = 200;
	int maxmem = 0;
	int minmem = 1000000;
	int maxusedmem = 0;
	int minusedmem = 1000000;
	int allcpus = 0;
	int maxcpus = 0;
	int mincpus = 1000000;
	int allbalance = 0;
	int minbalance = 100;
	int maxbalance = 0;

	QPixmap white_pix;
	white_pix= QPixmap(white_xpm);

	startdate.erase();
	enddate.erase();

	p.setWindow(0, 20, 485, 116);
	p.setPen(Qt::black);

	p.moveTo(0, 50);
	for(int i=0;i<=485; i++) {
		p.lineTo(i, 50);
	}
	p.moveTo(0, 69);
	for(int i=0;i<=290; i++) {
		p.lineTo(i, 69);
	}
	p.moveTo(0, 115);
	for(int i=0;i<=485; i++) {
		p.lineTo(i, 115);
	}

	if((readfile=fopen(nodefilename, "r")) == NULL) {
		cout << "could not open openMosix data information file" << nodefilename << endl;
		} else {

		while  ((!feof(readfile))&&(j<4320)) {
			fscanf(readfile, "%s %d %d %d %d %d", when, &oload, &obalance, &oallmem, &ousedmem, &cpus);
			if(oload==-999) {
				// it is a checkpoint or we are reading the last end of the logfile
				} else {
				// calculate the values

				// date
				if (j==0) {
            	startdate = startdate + when;
				}
				enddate.erase();
				enddate = enddate + when;
			
				// load
				oload = (oload *45)/100;
				allload = allload + oload;
				minload = min(minload, oload);
				maxload = max(maxload, oload);

				// balancing
				obalance = (obalance *45)/200;
				allbalance = allbalance + obalance;
				minbalance = min(minbalance, obalance);
				maxbalance = max(maxbalance, obalance);

				// memory
				ousedmem = (ousedmem * 45)/100;
				allmem = allmem + oallmem;
				allusedmem = allusedmem + ousedmem;
				minmem = min(minmem, oallmem);
				maxmem = max(maxmem, oallmem);
				minusedmem = min(minusedmem, ousedmem);
				maxusedmem = max(maxusedmem, ousedmem);


				// cpus
				allcpus = allcpus + cpus;
				mincpus = min(mincpus, cpus);
				maxcpus = max(maxcpus, cpus);

				j++;

				// check if we are really reading from file
				oload = -999;

			}
		}
		fclose(readfile);

		// calculate all values

		if (j>0) {
			allload = allload/j;
			allmem = allmem/j;
			allusedmem = allusedmem/j;
			allcpus = allcpus/j;
			allbalance = allbalance/j;
			} else {
      	allload = 0;
			maxload = 0;
			minload = 0;
			allmem = 0;
			maxmem = 0;
			minmem = 0;
			allusedmem = 0;
			maxusedmem = 0;
			minusedmem = 0;
			allcpus = 0;
			maxcpus = 0;
			mincpus = 0;
			allbalance = 0;
			maxbalance = 0;
			minbalance = 0;
		}

		// draw the widgets
		QLabel_startdate1= new QLabel(this,"startdate");
		QLabel_startdate1->setGeometry(0,20,60,20);
		QLabel_startdate1->setMinimumSize(0,0);
		QLabel_startdate1->setText("from	:");
		QLabel_startdate1->setMargin(0);
		QLabel_startdate1->setAlignment( AlignVCenter | AlignCenter );
		QWhatsThis::add(QLabel_startdate1 ,"This is the date/time when the openMosixcollector started gathering the cluster informations.");
		QLabel_startdate1->show();

		// startdate
		QLabel_startdate2= new QLabel(this,"start-date");
		QLabel_startdate2->setGeometry(60,20,120,20);
		QLabel_startdate2->setMinimumSize(0,0);
		QLabel_startdate2->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_startdate2->setText(startdate.c_str());
		QLabel_startdate2->setMargin(0);
		QLabel_startdate2->setAlignment( AlignVCenter | AlignCenter );
		QLabel_startdate2->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_startdate2 ,"This is the date/time when the openMosixcollector started gathering the cluster informations.");
		QLabel_startdate2->show();

		// endate
		QLabel_enddate1= new QLabel(this,"enddate");
		QLabel_enddate1->setGeometry(180,20,60,20);
		QLabel_enddate1->setMinimumSize(0,0);
		QLabel_enddate1->setText("to	:");
		QLabel_enddate1->setMargin(0);
		QLabel_enddate1->setAlignment( AlignVCenter | AlignCenter );
		QWhatsThis::add(QLabel_enddate1 ,"This is the date/time when the openMosixcollector finished gathering the cluster informations.");
		QLabel_enddate1->show();

		// endate
		QLabel_enddate2= new QLabel(this,"enddate");
		QLabel_enddate2->setGeometry(240,20,120,20);
		QLabel_enddate2->setMinimumSize(0,0);
		QLabel_enddate2->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_enddate2->setText(enddate.c_str());
		QLabel_enddate2->setMargin(0);
		QLabel_enddate2->setAlignment( AlignVCenter | AlignCenter );
		QLabel_enddate2->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_enddate2 ,"This is the date/time when the openMosixcollector finished gathering the cluster informations.");
		QLabel_enddate2->show();


		// the load diagram
		QLabel_load_top1= new QLabel(this,"Load");
		QLabel_load_top1->setGeometry(35,50,60,20);
		QLabel_load_top1->setMinimumSize(0,0);
		QLabel_load_top1->setMargin(0);
		QLabel_load_top1->setText("Load");
		QLabel_load_top1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_load_top1 ,"The diagram above shows an load-overview of the cluster.");
		QLabel_load_top1->show();

		QBrush brushwhite(white);
		p.setBrush(brushwhite);
		p.drawRect(10, 115-minload, 25, minload);

		QBrush brushblue(blue);
		p.setBrush(brushblue);
		p.drawRect(35, 115-maxload, 25, maxload);

		QBrush brushgreen(green);
		p.setBrush(brushgreen);
		p.drawRect(60, 115-allload, 25, allload);

		// load label
		QLabel_load1= new QLabel(this,"load");
		QLabel_load1->setGeometry(10,140,80,20);
		QLabel_load1->setMinimumSize(0,0);
		QLabel_load1->setText("min/max/mean");
		QLabel_load1->setMargin(0);
		QLabel_load1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_load1 ,"The diagram above shows the min/max/mean balancing values of the cluster.");
		QLabel_load1->show();

		// the balancing diagram
		QLabel_balance_top1= new QLabel(this,"Load-balancing");
		QLabel_balance_top1->setGeometry(110,50,100,20);
		QLabel_balance_top1->setMinimumSize(0,0);
		QLabel_balance_top1->setMargin(0);
		QLabel_balance_top1->setText("Load-balancing");
		QLabel_balance_top1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_balance_top1 ,"The diagram above shows the load-balancing efficiency of the cluster.");
		QLabel_balance_top1->show();

		p.setBrush(brushwhite);
		p.drawRect(110, 115-minbalance, 25, minbalance);

		p.setBrush(brushblue);
		p.drawRect(135, 115-maxbalance, 25, maxbalance);

		p.setBrush(brushgreen);
		p.drawRect(160, 115-allbalance, 25, allbalance);

 		// balancing label
		QLabel_balance1= new QLabel(this,"balancing");
		QLabel_balance1->setGeometry(110,140,80,20);
		QLabel_balance1->setMinimumSize(0,0);
		QLabel_balance1->setText("min/max/mean");
		QLabel_balance1->setMargin(0);
		QLabel_balance1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_balance1 ,"The diagram above shows the min/max/mean balancing values of the cluster.");
		QLabel_balance1->show();

		// the memory diagram
		QLabel_mem_top1= new QLabel(this,"memory");
		QLabel_mem_top1->setGeometry(225,50,100,20);
		QLabel_mem_top1->setMinimumSize(0,0);
		QLabel_mem_top1->setMargin(0);
		QLabel_mem_top1->setText("Memory");
		QLabel_mem_top1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_mem_top1 ,"The diagram above shows the memory overview of the cluster.");
		QLabel_mem_top1->show();

		p.setBrush(brushwhite);
		p.drawRect(210, 115-minusedmem, 25, minusedmem);

		p.setBrush(brushblue);
		p.drawRect(235, 115-maxusedmem, 25, maxusedmem);

		p.setBrush(brushgreen);
		p.drawRect(260, 115-allusedmem, 25, allusedmem);


		// memory label
		QLabel_mem1= new QLabel(this,"memory");
		QLabel_mem1->setGeometry(210,140,80,20);
		QLabel_mem1->setMinimumSize(0,0);
		QLabel_mem1->setText("min/max/mean");
		QLabel_mem1->setMargin(0);
		QLabel_mem1->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_mem1 ,"The diagram above shows the min/max/mean memory values of the cluster.");
		QLabel_mem1->show();


		// top label
		QLabel_header= new QLabel(this,"header");
		QLabel_header->setGeometry(370,50,140,20);
		QLabel_header->setMinimumSize(0,0);
		QLabel_header->setText("avail. MB			CPUs");
		QLabel_header->setMargin(0);
		QLabel_header->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_header ,"The diagram above shows the min/max/mean values of the cluster.");
		QLabel_header->show();

		// mean label
		QLabel_mean= new QLabel(this,"mean");
		QLabel_mean->setGeometry(320,70,40,20);
			QLabel_mean->setMinimumSize(0,0);
		QLabel_mean->setText("mean :");
		QLabel_mean->setMargin(0);
		QLabel_mean->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_mean ,"This row displays the mean values of the cluster.");
		QLabel_mean->show();

		// min label
		QLabel_min= new QLabel(this,"min");
		QLabel_min->setGeometry(320,90,40,20);
		QLabel_min->setMinimumSize(0,0);
		QLabel_min->setText("min    :");
		QLabel_min->setMargin(0);
		QLabel_min->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_min ,"This row displays the min values of the cluster.");
		QLabel_min->show();

		// max label
		QLabel_max= new QLabel(this,"max");
		QLabel_max->setGeometry(320,110,40,20);
		QLabel_max->setMinimumSize(0,0);
		QLabel_max->setText("max   :");
		QLabel_max->setMargin(0);
		QLabel_max->setAlignment( AlignVCenter | AlignLeft );
		QWhatsThis::add(QLabel_max ,"This row displays the max values of the cluster.");
		QLabel_max->show();

	
		// draw the table
		// the first row
		QLabel_table_1_1= new QLabel(this,"table");
		QLabel_table_1_1->setGeometry(360,70,70,20);
		QLabel_table_1_1->setMinimumSize(0,0);
		QLabel_table_1_1->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_1_1->setNum(allmem);
		QLabel_table_1_1->setMargin(0);
		QLabel_table_1_1->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_1_1->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_1_1 ,"This row displays the mean/min/max values of the cluster.");
		QLabel_table_1_1->show();

		QLabel_table_1_2= new QLabel(this,"table");
		QLabel_table_1_2->setGeometry(430,70,50,20);
		QLabel_table_1_2->setMinimumSize(0,0);
		QLabel_table_1_2->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_1_2->setNum(allcpus);
		QLabel_table_1_2->setMargin(0);
		QLabel_table_1_2->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_1_2->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_1_2 ,"This row displays the mean/min/max values of the cluster.");
		QLabel_table_1_2->show();

		// the second row
		QLabel_table_2_1= new QLabel(this,"table");
		QLabel_table_2_1->setGeometry(360,90,70,20);
		QLabel_table_2_1->setMinimumSize(0,0);
		QLabel_table_2_1->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_2_1->setNum(minmem);
		QLabel_table_2_1->setMargin(0);
		QLabel_table_2_1->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_2_1->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_2_1 ,"This row displays the mean/min/max values of the cluster.");
		QLabel_table_2_1->show();

		QLabel_table_2_2= new QLabel(this,"table");
		QLabel_table_2_2->setGeometry(430,90,50,20);
		QLabel_table_2_2->setMinimumSize(0,0);
		QLabel_table_2_2->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_2_2->setNum(mincpus);
		QLabel_table_2_2->setMargin(0);
		QLabel_table_2_2->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_2_2->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_2_2 ,"This row displays the mean/min/max values of the cluster.");
		QLabel_table_2_2->show();

		// the third row
		QLabel_table_3_1= new QLabel(this,"table");
		QLabel_table_3_1->setGeometry(360,110,70,20);
		QLabel_table_3_1->setMinimumSize(0,0);
		QLabel_table_3_1->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_3_1->setNum(maxmem);
		QLabel_table_3_1->setMargin(0);
		QLabel_table_3_1->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_3_1->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_3_1 ,"This row displays the mean/min/max values of the cluster.");
		QLabel_table_3_1->show();

		QLabel_table_3_2= new QLabel(this,"table");
		QLabel_table_3_2->setGeometry(430,110,50,20);
		QLabel_table_3_2->setMinimumSize(0,0);
		QLabel_table_3_2->setBackgroundPixmap(QPixmap(white_pix));
		QLabel_table_3_2->setNum(maxcpus);
		QLabel_table_3_2->setMargin(0);
		QLabel_table_3_2->setAlignment( AlignVCenter | AlignCenter );
		QLabel_table_3_2->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		QWhatsThis::add(QLabel_table_3_2 ,"This row displays the mean/min/max values of the cluster.");
		QLabel_table_3_2->show();
		}
	}







