/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sam Jul 27 14:36:06 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "openmosixcollector.h"


int main(int argc, char *argv[])
{
	if(argc != 2) {
		cout << " -d	//starts the collector as a daemon" << endl;
		cout << " -k //stops the collector daemon" << endl;
		cout << " -r //saves the history to /tmp/openMosixview.[date]/* and starts a new one\nThe collector automatically executes this command once a day to save the history.\nIt restarts automatic, too." << endl;
		cout << " -c //writes a checkpoint to the history-files marked as a vertical blue line in openMosixload" << endl;
		cout << " -help" << endl;
		cout << " --help" << endl;
		cout << " -h" << endl;
	  exit(0);
	}

	int tsecs=0;
	string commandline;
	commandline = commandline + argv[1];

	openmosixcollector *collector = new openmosixcollector();
	collector->updatenodelist();

	if(commandline=="-d") {
		int dofork;
		dofork = collector->daemonize();
	   if(dofork<0) {
	   	exit (-1);
		}
	}

	if(commandline=="-k") {
		collector->kill();
		exit(0);
	}

	if(commandline=="-r") {
		int dofork;
		collector->kill();
		collector->storelogfiles();
		dofork = collector->daemonize();
	   if(dofork<0) {
	   	exit (-1);
		}
	}

	if(commandline=="-c") {
		collector->checkpoint();
		cout << "checkpoint written" << endl;		
		exit(0);
	}

	// the main daemon loop
	while (1) {
		if(!collector->checknodes()) {
			collector->updatenodelist();
			cout << "updating nodelist" << endl;
		}
		collector->lognodes();
		tsecs = collector->incrementcounter();
		if (tsecs>=4320) {
			collector->storelogfiles();
		}
		collector->logprocesshistory(tsecs);
		sleep(10);
	} // end of main loop
}



