/***************************************************************************
                          procwidget.cpp  -  description
                             -------------------
    begin                : Mon Jan 6 2003
    copyright            : (C) 2003 by Matt
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "procwidget.h"

string parsemyname(string firstpart) {
string endstr;
string::iterator p = firstpart.begin();
	for (p=firstpart.begin(); p!=firstpart.end(); p++) {
		string tmpstr;
		tmpstr = *p;
		if(tmpstr==",") {
			return endstr;
		}
		endstr = endstr + tmpstr;
	}
	return endstr;
}


// constructor
procwidget::procwidget(QWidget *parent, const char *name ) : QLabel(parent,name) {

  myname= parsemyname(name);
  this->setGeometry(0,0,6,6);
  this->setMinimumSize(0,0);

  QString proctip;
  proctip.sprintf("PID %s", name);
  QToolTip::add(this, proctip);

  // for drag + drop
  ddButton = LeftButton;
  selButton = RightButton;

  // for selection set unselected;
  selected=0;

}

// destructor
procwidget::~procwidget(){
}



string procwidget::getmyname() {
  return myname;
}


void procwidget::toggle_selected() {

  if (selected==1) {
   selected=0;
   } else {
   selected=1;
  }

//  cout << "selected = " << selected << endl;

}


bool procwidget::is_selected() {

  if (selected==1) {
    return true;
    } else {
    return false;
  }
}



void procwidget::setmiggroup(int pg) {
 processgroup=pg;

 // set the proc dir entry according
 string mypgfile="/proc/";
 string tmpname = this->getmyname();
 mypgfile=mypgfile+tmpname;
 mypgfile=mypgfile+ "/miggroup";
 std::ofstream setpgconf(mypgfile.c_str());
 if (setpgconf) {
  setpgconf << pg;
  setpgconf.close();

  switch (pg) {
    case 0:
      this->setBackgroundColor(Qt::black);
    break;
    case 1:
      this->setBackgroundColor(Qt::white);
    break;
    case 2:
      this->setBackgroundColor(Qt::cyan);
    break;
    case 3:
      this->setBackgroundColor(Qt::blue);
    break;
    case 4:
      this->setBackgroundColor(Qt::yellow);
    break;
    case 5:
      this->setBackgroundColor(Qt::magenta);
    break;
    case 6:
      this->setBackgroundColor(Qt::darkGreen);
    break;
    case 7:
      this->setBackgroundColor(Qt::darkBlue);
    break;
    case 8:
      this->setBackgroundColor(Qt::darkRed);
    break;
    case 9:
      this->setBackgroundColor(Qt::darkMagenta);
    break;
    case 10:
      this->setBackgroundColor(Qt::darkYellow);
    break;
    default:
      this->setBackgroundColor(Qt::white);
  }

  } else {
  cout << "could not set processgroup" << endl;
  }
}




void procwidget::applymiggroup() {

 string miggroup;
 int miggroupnumber=0;
 char zeile[21];
 string mypgfile="/proc/";
 string tmpname = this->getmyname();
 mypgfile=mypgfile+tmpname;
 mypgfile=mypgfile+ "/miggroup";

 std::ifstream getpgconf(mypgfile.c_str());
 if (getpgconf) {
  getpgconf.getline(zeile, 20);
  miggroup.erase();
  miggroup=miggroup+zeile;
  getpgconf.close();

  miggroupnumber=atoi(miggroup.c_str());
  if(miggroupnumber>MAXMIGGROUPS) {
    miggroupnumber=0;
  }
  if(miggroupnumber==0){
    selected=0;
    } else {
    selected=1;
  }

  switch (miggroupnumber) {
    case 0:
      this->setBackgroundColor(Qt::black);
    break;
    case 1:
      this->setBackgroundColor(Qt::white);
    break;
    case 2:
      this->setBackgroundColor(Qt::cyan);
    break;
    case 3:
      this->setBackgroundColor(Qt::blue);
    break;
    case 4:
      this->setBackgroundColor(Qt::yellow);
    break;
    case 5:
      this->setBackgroundColor(Qt::magenta);
    break;
    case 6:
      this->setBackgroundColor(Qt::darkGreen);
    break;
    case 7:
      this->setBackgroundColor(Qt::darkBlue);
    break;
    case 8:
      this->setBackgroundColor(Qt::darkRed);
    break;
    case 9:
      this->setBackgroundColor(Qt::darkMagenta);
    break;
    case 10:
      this->setBackgroundColor(Qt::darkYellow);
    break;
    default:
      this->setBackgroundColor(Qt::white);
  }

  } else {
  cout << "could not get processgroup for " << tmpname << endl;
 }

}



int procwidget::getmiggroup() {
 string miggroup;
 int miggroupnumber=0;
 char zeile[21];
 string mypgfile="/proc/";
 string tmpname = this->getmyname();
 mypgfile=mypgfile+tmpname;
 mypgfile=mypgfile+ "/miggroup";

 std::ifstream getpgconf(mypgfile.c_str());
 if (getpgconf) {
  getpgconf.getline(zeile, 20);
  miggroup.erase();
  miggroup=miggroup+zeile;
  getpgconf.close();
  miggroupnumber=atoi(miggroup.c_str());
  if(miggroupnumber>MAXMIGGROUPS) {
    miggroupnumber=0;
  }
  return miggroupnumber;
  } else {
  cout << "could not get processgroup for " << tmpname << endl;
  return 0;
 }
}

