/***************************************************************************
                          openmosixpidlog.cpp  -  description
                             -------------------
    begin                : Sam Mr 15 14:50:08 CET 2003
    copyright            : (C) 2003 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qaccel.h>
#include "openmosixpidlog.h"

#include "exits.xpm"
#include "white.xpm"

// con- destructors
OpenMosixpidlogApp::OpenMosixpidlogApp(string procid) {

  myPID=procid;
  oldstatus="0";
  oldwhereiam="0";

  QPixmap exits_icon;
  exits_icon= QPixmap(exits);

  QPixmap white_pix;
  white_pix= QPixmap(white_xpm);  
  
  exiticon= new QLabel(this,"exits");
  exiticon->setGeometry(5,5,32,32);
  exiticon->setMinimumSize(0,0);
  exiticon->setPixmap(exits_icon);

  // create the main timer
 internalTimer = new QTimer(this, "intern");

  // zombie movie
  zombieicon= new QLabel(this, MOVIEZOMBIE);
  zombieicon->setGeometry(5,5,32,32);
  zombieicon->setMinimumSize(0,0);
  myzombieicon = new movieplayer(MOVIEZOMBIE, QMovie(MOVIEZOMBIE), zombieicon, 0,Qt::WDestructiveClose);
  myzombieicon->setGeometry(0,0,32,32);
  myzombieicon->stop();


  // remote movie
  remoteicon= new QLabel(this,MOVIEREMOTE);
  remoteicon->setGeometry(5,5,32,32);
  remoteicon->setMinimumSize(0,0);
  myremoteicon = new movieplayer(MOVIEREMOTE, QMovie(MOVIEREMOTE), remoteicon, 0,Qt::WDestructiveClose);
  myremoteicon->setGeometry(0,0,32,32);
  myremoteicon->stop();


  // running movie
  runningicon= new QLabel(this,MOVIERUNNING);
  runningicon->setGeometry(5,5,32,32);
  runningicon->setMinimumSize(0,0);
  myrunningicon = new movieplayer(MOVIERUNNING, QMovie(MOVIERUNNING), runningicon, 0,Qt::WDestructiveClose);
  myrunningicon->setGeometry(0,0,32,32);
  myrunningicon->stop();

  // sleeping movie
  sleepingicon= new QLabel(this,MOVIESLEEP);
  sleepingicon->setGeometry(5,5,32,32);
  sleepingicon->setMinimumSize(0,0);
  mysleepingicon = new movieplayer(MOVIESLEEP, QMovie(MOVIESLEEP), sleepingicon, 0,Qt::WDestructiveClose);
  mysleepingicon->setGeometry(0,0,32,32);
  mysleepingicon->stop();

  // cpuusage
  mycpuusage= new QLabel(this, "cpuusage");
  mycpuusage->setGeometry(37,38,20,10);
  mycpuusage->setMinimumSize(0,0);
  showcpuusage= new cpuUsage(this, "cpuusage");
  showcpuusage->setGeometry(2,48,55,50);
  showcpuusage->setMinimumSize(0,0);


  tabs = new QTabWidget(this, "choose");
  tabs->setGeometry(60, 0, 300, 100);

  // the openMosix information tab
  om = new QLabel(tabs, 0, 0);
  om->setGeometry(0, 0, 240, 100);
  om->setMargin(1);
  om->setFrameStyle(QFrame::Panel | QFrame::Sunken);

  omwhere_label = new QLabel(om, 0, 0);
  omwhere_label->setGeometry(2, 5, 48, 15);
  omwhere_label->setMargin(1);
  omwhere_label->setText("where");
  omwhere = new QLabel(om, 0, 0);
  omwhere->setGeometry(50, 5, 50, 15);
  omwhere->setMargin(1);
  omwhere->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  omwhere->setBackgroundPixmap(QPixmap(white_pix));


  omnmigs_label = new QLabel(om, 0, 0);
  omnmigs_label->setGeometry(2, 20, 48, 15);
  omnmigs_label->setMargin(1);
  omnmigs_label->setText("nmigs");
  omnmigs = new QLabel(om, 0, 0);
  omnmigs->setGeometry(50, 20, 50, 15);
  omnmigs->setMargin(1);
  omnmigs->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  omnmigs->setBackgroundPixmap(QPixmap(white_pix));

  ommiggroup_label = new QLabel(om, 0, 0);
  ommiggroup_label->setGeometry(2, 35, 48, 15);
  ommiggroup_label->setMargin(1);
  ommiggroup_label->setText("miggroup");
  ommiggroup = new QLabel(om, 0, 0);
  ommiggroup->setGeometry(50, 35, 50, 15);
  ommiggroup->setMargin(1);
  ommiggroup->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  ommiggroup->setBackgroundPixmap(QPixmap(white_pix));

  omlock_label = new QLabel(om, 0, 0);
  omlock_label->setGeometry(2, 50, 48, 15);
  omlock_label->setMargin(1);
  omlock_label->setText("lock");
  omlock = new QLabel(om, 0, 0);
  omlock->setGeometry(50, 50, 50, 15);
  omlock->setMargin(1);
  omlock->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  omlock->setBackgroundPixmap(QPixmap(white_pix));

  omcantmove_label = new QLabel(om, 0, 0);
  omcantmove_label->setGeometry(105, 5, 55, 15);
  omcantmove_label->setMargin(1);
  omcantmove_label->setText("cantmove");
  omcantmove = new QLabel(om, 0, 0);
  omcantmove->setGeometry(160, 5, 60, 15);
  omcantmove->setMargin(1);
  omcantmove->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  omcantmove->setBackgroundPixmap(QPixmap(white_pix));

  refresh_label = new QLabel(om, 0, 0);
  refresh_label->setGeometry(105, 40, 55, 15);
  refresh_label->setMargin(1);
  refresh_label->setText("refresh");
  refreshtimeoutbox= new QSpinBox(om, "refresh");
  refreshtimeoutbox->setGeometry(160,40,30,20);
  refreshtimeoutbox->setMinimumSize(0,0);
  refreshtimeoutbox->setValue(1);
  refreshtimeoutbox->setMinValue(1);
  refreshtimeoutbox->setMaxValue(10);
  QObject::connect( refreshtimeoutbox, SIGNAL(valueChanged( int )), this, SLOT(adjusttimer( int )) );


  // the statistic tab
  stats = new QLabel(tabs, 0, 0);
  stats->setGeometry(0, 0, 240, 100);
  stats->setMargin(1);
  stats->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  stats->setText("stats");





  // the memory tab
  memo = new QLabel(tabs, 0, 0);
  memo->setGeometry(0, 0, 240, 100);
  memo->setMargin(1);
  memo->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  memo->setText("memory");

  // the misc tab
  misc = new QLabel(tabs, 0, 0);
  misc->setGeometry(0, 0, 240, 100);
  misc->setMargin(1);
  misc->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  misc->setText("misc");



  tabs->addTab(om, "om");
  tabs->addTab(stats, "stats");
  tabs->addTab(memo, "memory");
  tabs->addTab(misc, "misc");
  tabs->show();


  // construction ready /start logging
  startlogging();


}

// destructor
OpenMosixpidlogApp::~OpenMosixpidlogApp() {
}


// ################################# helping functions ############################

int file_exist(string filename) {
        std::ifstream readfilename(filename.c_str());
        if (readfilename) {
                readfilename.close();
                return 1;
                } else {
                return 0;
        }
}

int string2int(const string s) {
        if (s.length() == 0) {
                return -1;
        } else {
                return(atoi(s.c_str()));
        }
}

string int2string(const int i) {
        char buf[12];
        sprintf(buf,"%d",i);
        return(string(buf));
}



// ############################# methods implementation ###############



void OpenMosixpidlogApp::startlogging() {

 string thecmdline;
 char *cmdtmp;
 cmdtmp = new char[50];
 char *cmdtmp1;
 cmdtmp1 = new char[50];
 FILE *fp;
 thecmdline = thecmdline + "/proc/";
 thecmdline = thecmdline + myPID;
 thecmdline = thecmdline + "/status";
 if ((fp=fopen(thecmdline.c_str(), "r"))!=NULL) {
  fscanf(fp, "%s %s", cmdtmp, cmdtmp1);
  fclose(fp);
 }
 string mytitle="PID ";
 mytitle = mytitle+myPID;
 mytitle = mytitle+" ";
 mytitle = mytitle+cmdtmp1;
 setCaption(mytitle.c_str());

 connect( internalTimer, SIGNAL(timeout()), this, SLOT(refreshlog()) );
 internalTimer->start(1000);

}



void OpenMosixpidlogApp::refreshlog() {

  string tmpvalue;

  refreshstatus();

  // cpu usage
  tmpvalue=getcpuusage();
  mycpuusage->setText(tmpvalue.c_str());
  showcpuusage->updateusage(tmpvalue);


  // where
  omwhere->setText(myWHERE.c_str());

  // nmigs
  tmpvalue=getprocentry("nmigs");
  omnmigs->setText(tmpvalue.c_str());

  // miggroup
  tmpvalue=getprocentry("miggroup");
  if((string2int(tmpvalue)>=0) && (string2int(tmpvalue)<MAXMIGGROUP)) {
    ommiggroup->setText(tmpvalue.c_str());
    } else {
    ommiggroup->setText("0");
  }

  // lock
  tmpvalue=getprocentry("lock");
  omlock->setText(tmpvalue.c_str());

  // cantmove
  tmpvalue=getprocentry("cantmove");
  if(strlen(tmpvalue.c_str())>1) {
    omcantmove->setText(tmpvalue.c_str());
    } else {
    omcantmove->setText("empty");
  }


//  cout << "refresh values" << endl;

}





string OpenMosixpidlogApp::getprocentry(string entry) {

  char *tmpentry;
  tmpentry = new char[101];
  string returnentry;
  string myprocentry="/proc/";
  myprocentry=myprocentry+myPID;
  myprocentry=myprocentry+"/";
  myprocentry=myprocentry+entry;
  std::ifstream readprocentry(myprocentry.c_str());
  if(readprocentry) {
    readprocentry.getline(tmpentry, 100);
    readprocentry.close();
    returnentry.erase();
    returnentry=returnentry+tmpentry;
    if(strlen(returnentry.c_str())>0) {
      return returnentry;
      } else {
      return "0";
    }
    } else {
    return "0";
  }
}






void OpenMosixpidlogApp::refreshstatus() {

  // status
  FILE *fp;
  char *stat;
  stat = new char[50];
  string whereiam;
  string statentry="/proc/";
  statentry=statentry+myPID;
  statentry=statentry+"/stat";
  if(file_exist(statentry)) {
    if ((fp=fopen(statentry.c_str(), "r"))!=NULL) {
      fscanf(fp, "%s", stat);
      fscanf(fp, "%s", stat);
      fscanf(fp, "%s", stat);
      fclose(fp);
    }

    whereiam=getprocentry("where");
    if (!strcmp(whereiam.c_str(), "0")) {

      // if status changed
      if (!strstr(stat, oldstatus.c_str())) {

       if(strstr(stat, "S")) {
           zombieicon->lower();
           myzombieicon->stop();
           runningicon->lower();
           myrunningicon->stop();
           mysleepingicon->run();
           sleepingicon->raise();
           cout << "sleeping" << endl;
       }
       if(strstr(stat, "R")) {
           zombieicon->lower();
           myzombieicon->stop();
           sleepingicon->lower();
           mysleepingicon->stop();
           myrunningicon->run();
           runningicon->raise();
           cout << "running" << endl;
       }
       if(strstr(stat, "Z")) {
           sleepingicon->lower();
           mysleepingicon->stop();
           runningicon->lower();
           myrunningicon->stop();
           myzombieicon->run();
           zombieicon->raise();
         cout << "zombie" << endl;
       }

      } // if status changed

      oldstatus.erase();
      oldstatus=stat;
      oldwhereiam.erase();
      oldwhereiam="0";

      myWHERE="local";


      } else {
      // proc is running remote
      if (oldwhereiam!=whereiam) {
        zombieicon->lower();
        myzombieicon->stop();
        sleepingicon->lower();
        mysleepingicon->stop();
        runningicon->lower();
        myrunningicon->stop();
        myremoteicon->run();
        remoteicon->raise();
      }
      oldwhereiam.erase();
      oldwhereiam=whereiam;
      oldstatus.erase();
      oldstatus="0";
      myWHERE=whereiam;

     }


    } else {
    // process exits
    sleepingicon->lower();
    runningicon->lower();
    exiticon->raise();
  }



}




// this is ugly but i currently found no
// other simple way to get the cpu-usage per process
// if you have a better idea it is more than welcom
string OpenMosixpidlogApp::getcpuusage() {

 char *tmp_usage;
 tmp_usage = new char[11];
 string ret_usage;
 string getusage;
 getusage.erase();
 getusage=getusage+"ps -eo '\%p \%C' | grep ";
 getusage=getusage+myPID;
 getusage=getusage+" | awk {'print $2'}  > /tmp/pcpu.tmp";
 system(getusage.c_str());
 std::ifstream readcpuusage("/tmp/pcpu.tmp");
 if(readcpuusage) {
   readcpuusage.getline(tmp_usage, 10);
   readcpuusage.close();
   unlink("/tmp/pcpu.tmp");
   ret_usage.erase();
   ret_usage=ret_usage+tmp_usage;
   if(strlen(ret_usage.c_str())>1) {
     return ret_usage;
     } else {
     return "0.0";
    }
   } else {
   return "0.0";
 }
}








void OpenMosixpidlogApp::adjusttimer(int val) {
 int secval=val*1000;
 internalTimer->changeInterval(secval);
 cout << "set refresh-timeout to " << val << " seconds" << endl;
}







