/***************************************************************************
                          openmosixpidlog.h  -  description
                             -------------------
    begin                : Sam Mr 15 14:50:08 CET 2003
    copyright            : (C) 2003 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPENMOSIXPIDLOG_H
#define OPENMOSIXPIDLOG_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qtimer.h>
#include <qmovie.h>
#include <qtabwidget.h>
#include <qspinbox.h>

#include <stdlib.h>
#include <string>
#include <iostream>
#include <fstream>
#include <unistd.h>

#include "movieplayer.h"
#include "cpuusage.h"

#define MAXMIGGROUP 1000
#define MOVIEZOMBIE "/usr/share/openmosixview/img/zombie.gif"
#define MOVIEREMOTE "/usr/share/openmosixview/img/remote.gif"
#define MOVIESLEEP "/usr/share/openmosixview/img/schnarch.gif"
#define MOVIERUNNING "/usr/share/openmosixview/img/running.gif"


using namespace std;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class OpenMosixpidlogView is
  * created which creates your view.
  */
class OpenMosixpidlogApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    OpenMosixpidlogApp(string procid);
    /** destructor */
    ~OpenMosixpidlogApp();
    /** initializes all QActions of the application */


  public slots:

    void refreshlog();
    void startlogging();
    void refreshstatus();
    string getprocentry(string entry);
    string getcpuusage();

    void adjusttimer(int val);

  protected:

    string myPID;
    string myWHERE;

    string oldstatus;
    string oldwhereiam;

    movieplayer *myrunningicon;
    movieplayer *mysleepingicon;
    movieplayer *myzombieicon;
    movieplayer *myremoteicon;

    QLabel *runningicon;
    QLabel *sleepingicon;
    QLabel *zombieicon;
    QLabel *exiticon;
    QLabel *remoteicon;
    QLabel *mycpuusage;

    cpuUsage *showcpuusage;

    QTabWidget *tabs;

    QLabel *om;
    QLabel *omwhere_label;
    QLabel *omwhere;
    QLabel *omnmigs_label;
    QLabel *omnmigs;
    QLabel *ommiggroup_label;
    QLabel *ommiggroup;
    QLabel *omlock_label;
    QLabel *omlock;
    QLabel *omcantmove_label;
    QLabel *omcantmove;
    QLabel *refresh_label;

    QLabel *stats;
    QLabel *memo;
    QLabel *misc;

    QTimer *internalTimer;
    QSpinBox *refreshtimeoutbox;

  private:



};
#endif 

