/***************************************************************************
                          openmosixprocs.h  -  description
                             -------------------
    begin                : Don Jul 25 13:55:26 CEST 2002
    copyright            : (C) 2002 by Matt Rechenburg
    email                : mosixview@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPENMOSIXPROCS_H
#define OPENMOSIXPROCS_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qscrollbar.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qslider.h>
#include <qlcdnumber.h>
#include <qprogressbar.h>
#include <qlistbox.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qtabdialog.h>
#include <qmultilineedit.h>
#include <qtimer.h>
#include <qcombobox.h>
#include <qpopupmenu.h>

#include <stdlib.h>
#include <string>
#include <list>
#include <iostream>
#include <fstream>
#include <dirent.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/resource.h>
#include <unistd.h>

#define clustercommand "mosctl"
#define remotedir "/proc/hpc/remote/"
#define clusterdirectory "/proc/hpc/nodes/"
#define migratecommand "migrate"

using namespace std;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class OpenMosixprocsView is
  * created which creates your view.
  */
class OpenMosixprocsApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    OpenMosixprocsApp();
    /** destructor */
    ~OpenMosixprocsApp();
    /** initializes all QActions of the application */
    void initActions();
    /** initMenuBar creates the menu_bar and inserts the menuitems */

    /** setup the statusbar */
    void initStatusBar();
    /** setup the document*/

   // the nodelist
   list<string> nodelist;

	// get nodes hostname by its node id
	string getnodename(string node);



  public slots:

	// for entering what is this mode
	void slot_whatisthis();

	// fills the processbox with data from /proc
	void fill_procbox();

	// syncronize user list box
	void sync_user(int index);

	// open window with information about remote processes
	void remoteproc();

	// open the migrator window
	void migrator( QListViewItem * index);

	// kills a process
	void killproc();

	// migrates a process to a specific node in the cluster
	void migrateto(int index);

	// migrates a process to the best available node
	void migratebest();

	// migrates a process to its home node
	void migratehome();

	// tells a remote process to go home
	void remote_gohome();

	// tells a remote process to the best available node
	void remote_gobest();

	// send SIGSTOP to a process
	void action_sigstop();

	// send SIGCONT to a process
	void action_sigcont();

	// renice processes
	void setprocprio(int prio);

	// locks a process
	void lockproc();

	// unlocks a process
	void unlockproc();

	// starts openMosixpidlog
	void startpidlog(QListViewItem *index, const QPoint &, int);
	void startpidlog();

  private:



	protected:

	QLabel *QLabel_current_proc_label;
	QLabel *QLabel_current_proc;
	QComboBox *userbox;
	QLabel *QLabel_userbox;
	QLabel *user_select_label;
	QListView *processbox;
	QToolButton *what_this_button;
	QPushButton *QPushButton_1;
	QPushButton *QPushButton_refresh;
	QPushButton *QPushButton_rem;

	// for the remote-process window
	QTabDialog *rem;
	QLabel *rem_processbox[500];
	QLabel *rem_from_who[500];
	QLabel *rem_from_ip[500];
	QLabel *rem_from_who_label[500];
	QLabel *rem_from_ip_label[500];
	QPushButton *rem_gohome[500];
	QPushButton *rem_gobest[500];
	QMultiLineEdit* qtchild[500];
	QMultiLineEdit* qtchild_identity[500];
	QLabel *rem_stats[500];
	QLabel *rem_identity[500];
	QLabel *howmanyremote;
	QLabel *howmanyremote_label;

	// widget for the migrator window
	QWidget *hinten;
	QGroupBox *background;
	QGroupBox *miglefttop;
	QGroupBox *migrightbottom;
	QPushButton *QPushButton_best;
	QPushButton *QPushButton_home;
	QPushButton *QPushButton_lock;
	QPushButton *QPushButton_unlock;
	QListBox *hostbox;
	QLabel *QLabel_howmany_procs;
	QLabel *QLabel_howmany_label;
	QLabel *QLabel_22;
	QLabel *QLabel_6;
	QLabel *QLabel_2;
	QLabel *QLabel_52;
	QLabel *QLabel_50;
	QLabel *QLabel_110;
	QLabel *QLabel_111;
	QLabel *home_label;
	QLabel *best_label;
	QLabel *lock_label;
	QLabel *unlock_label;
	QLabel *pidlog_label;
	QLabel *sigstop_label;
	QLabel *sigcont_label;
	QLabel *home_label1;
	QLabel *proc_titel;
	QLabel *pix_titel;
	QLabel *headline_information;
	QLabel *headline_administration;
	QLabel *info_pid;
	QLabel *info_where;
	QLabel *info_lock;
	QLabel *info_mig;
 	QPushButton *QPushButton_71;
	QPushButton *QPushButton_72;
	QMultiLineEdit* procstat;
	QSlider *proc_prio;
	QLabel *prio_label1;
	QLabel *prio_label2;
	QLabel *prio_label3;
	QLabel *prio_label4;
	QPushButton *sigstop_button;
	QPushButton *sigcont_button;
	QPushButton *pidlog_button;


	virtual void resizeEvent(QResizeEvent* ev) {
		processbox->setGeometry(5,30,ev->size().width()-10,ev->size().height()-80);
		QPushButton_1->setGeometry(ev->size().width()-65,ev->size().height()-40,60,20);
		QPushButton_rem->setGeometry(5,ev->size().height()-40,160, 20);

  	QLabel_howmany_procs->setGeometry(ev->size().width()-300,ev->size().height()-40,50,20);
  	QLabel_howmany_label->setGeometry(ev->size().width()-240,ev->size().height()-40,140,20);


	}


};
#endif 

