/*  VideoFileFfmpeg.H
 *
 *  Copyright (C) 2006 Richard Spindler <richard.spindler AT gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _VIDEO_FILE_FFMPEG_H_
#define _VIDEO_FILE_FFMPEG_H_

#ifdef AVCODEC

extern "C" {
#include <ffmpeg/avcodec.h>
#include <ffmpeg/avformat.h>
#ifdef SWSCALE
	#include <ffmpeg/swscale.h>
#endif /* SWSCALE */
}

#include "global_includes.H"
#include "IVideoFile.H"
#include "frame_struct.h"

namespace nle
{

class VideoFileFfmpeg : public IVideoFile
{
	public:
		VideoFileFfmpeg( string filename );
		~VideoFileFfmpeg();
		bool ok();
		int64_t length();
//		double fps();
		frame_struct* read();
		void read( unsigned char** rows, int w, int h );
		void seek( int64_t position );
	protected:
		int64_t ticksPerFrame();
		void seekToFrame( int64_t frame );
	private:
		AVFormatContext* m_formatContext;
		AVCodecContext*  m_codecContext;
		AVCodec*         m_codec;
		AVFrame*         m_avFrame;
		AVFrame*         m_avFrameRGB;
		AVPacket         m_packet;
		frame_struct     m_framestruct;
		unsigned char*   m_frame;
		unsigned char**  m_rows;
		bool             m_ok;
//		double           m_framerate;
		int64_t          m_length;
		int              m_videoStream;
		int64_t          m_ticksPerFrame;
#ifdef SWSCALE
		struct SwsContext *pSWSCtx;
#endif
};
	
} /* namespace nle */

#endif /* AVCODEC */

#endif /* _VIDEO_FILE_FFMPEG_H_ */
