/*
 * kmp_wait_release.cpp -- Wait/Release implementation
 */

/* <copyright>
    Copyright (c) 1997-2015 Intel Corporation.  All Rights Reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
      * Neither the name of Intel Corporation nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
    HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

</copyright> */
#include "kmp_wait_release.h"

void __kmp_wait_32(kmp_info_t *this_thr, kmp_flag_32 *flag, int final_spin
                   USE_ITT_BUILD_ARG(void * itt_sync_obj) )
{
    __kmp_wait_template(this_thr, flag, final_spin
                        USE_ITT_BUILD_ARG(itt_sync_obj) );
}

void __kmp_wait_64(kmp_info_t *this_thr, kmp_flag_64 *flag, int final_spin
                   USE_ITT_BUILD_ARG(void * itt_sync_obj) )
{
    __kmp_wait_template(this_thr, flag, final_spin
                        USE_ITT_BUILD_ARG(itt_sync_obj) );
}

void __kmp_wait_oncore(kmp_info_t *this_thr, kmp_flag_oncore *flag, int final_spin
                       USE_ITT_BUILD_ARG(void * itt_sync_obj) )
{
    __kmp_wait_template(this_thr, flag, final_spin
                        USE_ITT_BUILD_ARG(itt_sync_obj) );
}
void __kmp_release_32(kmp_flag_32 *flag) {
    __kmp_release_template(flag);
}

void __kmp_release_64(kmp_flag_64 *flag) {
    __kmp_release_template(flag);
}

void __kmp_release_oncore(kmp_flag_oncore *flag) {
    __kmp_release_template(flag);
}
