// $Id: MSXException.hh,v 1.11 2005/03/10 20:15:18 m9710797 Exp $

#ifndef MSXEXCEPTION_HH
#define MSXEXCEPTION_HH

#include <string>

namespace openmsx {

class MSXException
{
public:
	MSXException(const std::string& message_)
		: message(message_) { }
	virtual ~MSXException() { }

	const std::string& getMessage() const {
		return message;
	}

private:
	const std::string message;
};

class FatalError
{
public:
	FatalError(const std::string& message_)
		: message(message_) { }
	virtual ~FatalError() { }

	const std::string& getMessage() const {
		return message;
	}

private:
	const std::string message;
};

} // namespace openmsx

#endif
