// $Id: MSXTurboRLeds.hh,v 1.11 2005/03/10 20:15:19 m9710797 Exp $

/*
 * This class implements the 2 Turbo-R specific LEDS:
 *  
 * Bit 0 of IO-port 0xA7 turns the PAUSE led ON (1) or OFF (0) 
 * Bit 7                           TURBO
 * This port can only be written to.
 */

#ifndef TURBORLEDS_HH
#define TURBORLEDS_HH

#include "MSXDevice.hh"

namespace openmsx {

class MSXTurboRLeds : public MSXDevice
{
public:
	MSXTurboRLeds(const XMLElement& config, const EmuTime& time);
	virtual ~MSXTurboRLeds();
	
	virtual void reset(const EmuTime& time);
	virtual void powerDown(const EmuTime& time);
	virtual void writeIO(byte port, byte value, const EmuTime& time);

private:
	byte prev;
};

} // namespace openmsx

#endif
