// $Id: Interpreter.hh,v 1.11 2005/05/04 20:11:40 m9710797 Exp $

#ifndef INTERPRETER_HH
#define INTERPRETER_HH

#include <map>
#include <set>
#include <string>
#include <tcl.h>

namespace openmsx {

class Command;
class Setting;

class Interpreter
{
public:
	static Interpreter& instance();
	
	void init(const char* programName);
	void registerCommand(const std::string& name, Command& command);
	void unregisterCommand(const std::string& name, Command& command);
	void getCommandNames(std::set<std::string>& result);
	bool isComplete(const std::string& command) const;
	std::string execute(const std::string& command);
	std::string executeFile(const std::string& filename);
	
	void setVariable(const std::string& name, const std::string& value);
	void unsetVariable(const std::string& name);
	const char* getVariable(const std::string& name) const;
	void registerSetting(Setting& variable);
	void unregisterSetting(Setting& variable);

	void splitList(const std::string& list,
	               std::vector<std::string>& result);

	void poll();

private:
	Interpreter();
	~Interpreter();
	
	static int outputProc(ClientData clientData, const char* buf,
	        int toWrite, int* errorCodePtr);
	static int commandProc(ClientData clientData, Tcl_Interp* interp,
                               int objc, Tcl_Obj* const objv[]);
	static char* traceProc(ClientData clientData, Tcl_Interp* interp,
                const char* part1, const char* part2, int flags);

	static Tcl_ChannelType channelType;
	Tcl_Interp* interp;
	std::map<std::string, Tcl_Command> commandTokenMap;
};

} // namespace openmsx

#endif
