// $Id: EventListener.hh,v 1.12 2005/03/10 20:15:39 m9710797 Exp $

#ifndef EVENTLISTENER_HH
#define EVENTLISTENER_HH

namespace openmsx {

class Event;

class EventListener
{
public:
	virtual ~EventListener() {}

	/**
	 * This method gets called when an event you are interested in
	 * occurs.
	 * This method should return true when lower priority
	 * EventListener may also receive this event (normally always
	 * the case except for Console)
	 */
	virtual bool signalEvent(const Event& event) = 0;

protected:
	EventListener() {}
};

} // namespace openmsx

#endif
