// $Id: TurboRFDC.hh,v 1.11 2005/03/10 20:15:40 m9710797 Exp $

#ifndef TURBORFDC_HH
#define TURBORFDC_HH

#include "MSXFDC.hh"
#include <memory>

namespace openmsx {

class TC8566AF;

class TurboRFDC : public MSXFDC
{
public:
	TurboRFDC(const XMLElement& config, const EmuTime& time);
	virtual ~TurboRFDC();
	
	virtual void reset(const EmuTime& time);
	
	virtual byte readMem(word address, const EmuTime& time);
	virtual void writeMem(word address, byte value, const EmuTime& time);  
	virtual const byte* getReadCacheLine(word start) const;
	virtual byte* getWriteCacheLine(word address) const;

private:
	const std::auto_ptr<TC8566AF> controller;
	const byte* memory;
	byte blockMask;
};

} // namespace openmsx

#endif
