// $Id: Rom16kBBlocks.hh,v 1.9 2005/03/10 20:15:42 m9710797 Exp $

#ifndef ROM16KBBLOCKS_HH
#define ROM16KBBLOCKS_HH

#include "MSXRom.hh"

namespace openmsx {

class Rom16kBBlocks : public MSXRom
{
public:
	virtual byte readMem(word address, const EmuTime& time);
	virtual const byte* getReadCacheLine(word start) const;

protected:
	Rom16kBBlocks(const XMLElement& config, const EmuTime& time,
	              std::auto_ptr<Rom> rom);
	virtual ~Rom16kBBlocks();

	void setBank(byte region, byte* adr);
	void setRom(byte region, int block);

	byte* bank[4];
};

} // namespace openmsx

#endif
