// $Id: Layer.cc,v 1.1 2005/01/04 10:34:08 m9710797 Exp $

#include "Layer.hh"

namespace openmsx {

Layer::Layer(Coverage coverage_, ZIndex z_)
	: display(NULL), coverage(coverage_), z(z_)
{
}

Layer::~Layer()
{
}

void Layer::setCoverage(Coverage coverage_)
{
	coverage = coverage_;
	if (display) display->updateCoverage(this, coverage);
}

void Layer::setZ(ZIndex z_)
{
	z = z_;
	if (display) display->updateZ(this, z);
}

Layer::ZIndex Layer::getZ() const
{
	return z;
}

} // namespace openmsx

