// $Id: WavImage.hh,v 1.19 2005/11/14 21:52:55 m9710797 Exp $

#ifndef WAVIMAGE_HH
#define WAVIMAGE_HH

#include "CassetteImage.hh"
#include "DynamicClock.hh"
#include "noncopyable.hh"
#include <string>

namespace openmsx {

class WavImage : public CassetteImage, private noncopyable
{
public:
	explicit WavImage(const std::string& fileName);
	virtual ~WavImage();

	virtual short getSampleAt(const EmuTime& time);

private:
	int length;
	byte* buffer;
	DynamicClock clock;
	short average;
};

} // namespace openmsx

#endif
