// $Id: CassetteImage.hh 5920 2006-12-11 19:59:23Z m9710797 $

#ifndef CASSETTEIMAGE_HH
#define CASSETTEIMAGE_HH

#include <string>

namespace openmsx {

class EmuTime;

class CassetteImage
{
public:
	enum FileType { ASCII, BINARY, BASIC, UNKNOWN };

	virtual ~CassetteImage();
	virtual short getSampleAt(const EmuTime& time) = 0;
	virtual EmuTime getEndTime() const = 0;

	FileType getFirstFileType() const;
	std::string getFirstFileTypeAsString() const;

protected:
	CassetteImage();
	void setFirstFileType(FileType type);

private:
	FileType firstFileType;
};

} // namespace openmsx

#endif
