// $Id: MSXWatchIODevice.cc 6593 2007-06-03 23:12:19Z mthuurne $

#include "MSXWatchIODevice.hh"
#include "MSXMotherBoard.hh"
#include "TclObject.hh"
#include <cassert>

namespace openmsx {

MSXWatchIODevice::MSXWatchIODevice(MSXMotherBoard& motherboard,
                                   WatchPoint::Type type,
                                   unsigned beginAddr, unsigned endAddr,
                                   std::auto_ptr<TclObject> command,
                                   std::auto_ptr<TclObject> condition)
	: MSXMultiDevice(motherboard)
	, WatchPoint(motherboard.getMSXCliComm(), command, condition, type,
	             beginAddr, endAddr)
	, device(0)
{
}

MSXWatchIODevice::~MSXWatchIODevice()
{
}

MSXDevice*& MSXWatchIODevice::getDevicePtr()
{
	return device;
}

std::string MSXWatchIODevice::getName() const
{
	assert(device);
	return device->getName();
}

byte MSXWatchIODevice::peekIO(word port, const EmuTime& time) const
{
	assert(device);
	return device->peekIO(port, time);
}

byte MSXWatchIODevice::readIO(word port, const EmuTime& time)
{
	assert(device);
	//std::cout << "Watch readIO " << port << std::endl;
	byte result = device->readIO(port, time);
	checkAndExecute();
	return result;
}

void MSXWatchIODevice::writeIO(word port, byte value, const EmuTime& time)
{
	assert(device);
	//std::cout << "Watch writeIO " << port << " " << value << std::endl;
	device->writeIO(port, value, time);
	checkAndExecute();
}

} // namespace openmsx
