// $Id: ReadDir.cc 5945 2006-12-19 19:20:18Z m9710797 $

#include "ReadDir.hh"

namespace openmsx {

ReadDir::ReadDir(const std::string& directory)
{
	dir = opendir(directory.empty() ? "." : directory.c_str());
}

ReadDir::~ReadDir()
{
	if (dir) {
		closedir(dir);
	}
}

struct dirent* ReadDir::getEntry()
{
	if (!dir) {
		return NULL;
	}
	return readdir(dir);
}

bool ReadDir::isValid() const
{
	return dir;
}

} // namespace openmsx
