// $Id: MSXRam.hh 8352 2008-11-12 18:39:08Z m9710797 $

#ifndef MSXRAM_HH
#define MSXRAM_HH

#include "MSXDevice.hh"
#include <memory>

namespace openmsx {

class CheckedRam;

class MSXRam : public MSXDevice
{
public:
	MSXRam(MSXMotherBoard& motherBoard, const XMLElement& config);

	virtual void powerUp(EmuTime::param time);
	virtual byte readMem(word address, EmuTime::param time);
	virtual void writeMem(word address, byte value, EmuTime::param time);
	virtual const byte* getReadCacheLine(word start) const;
	virtual byte* getWriteCacheLine(word start) const;
	virtual byte peekMem(word address, EmuTime::param time) const;

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

private:
	inline word translate(word address) const;

	const unsigned base;
	const unsigned size;
	const std::auto_ptr<CheckedRam> checkedRam;
};

} // namespace openmsx

#endif
