# $Id: systemfuncs2code.py 9867 2009-05-23 20:32:03Z mthuurne $

from systemfuncs import systemFunctions
from outpututils import rewriteIfChanged

import sys

def iterSystemFuncsHeader(functionResults):
	yield '// Automatically generated by build system.'
	for makeName in sorted(
		func.getMakeName() for func in systemFunctions
		):
		if functionResults[makeName]:
			yield '#define HAVE_%s 1' % makeName
		else:
			yield '// #undef HAVE_%s' % makeName

def getSystemFuncsInfo():
	return dict.fromkeys(
		(func.getMakeName() for func in systemFunctions),
		False
		)

if __name__ == '__main__':
	if len(sys.argv) == 2:
		rewriteIfChanged(
			sys.argv[1],
			iterSystemFuncsHeader(getSystemFuncsInfo())
			)
	else:
		print >> sys.stderr, \
			'Usage: python systemfuncs2code.py CONFIG_HEADER '
		print >> sys.stderr, \
			'Note: Should only be called directly on systems where the probe ' \
			'does not work.'
		sys.exit(2)
