// $Id: RomArc.cc 12528 2012-05-17 17:36:10Z m9710797 $

// Parallax' Arc

#include "RomArc.hh"
#include "MSXCPUInterface.hh"
#include "Rom.hh"
#include "serialize.hh"

namespace openmsx {

RomArc::RomArc(const DeviceConfig& config, std::auto_ptr<Rom> rom)
	: Rom16kBBlocks(config, rom)
{
	setUnmapped(0);
	setRom(1, 0);
	setRom(2, 1);
	setUnmapped(3);

	reset(EmuTime::dummy());

	getCPUInterface().register_IO_Out(0x7f, this);
	getCPUInterface().register_IO_In (0x7f, this);
}

RomArc::~RomArc()
{
	getCPUInterface().unregister_IO_Out(0x7f, this);
	getCPUInterface().unregister_IO_In (0x7f, this);
}

void RomArc::reset(EmuTime::param /*time*/)
{
	offset = 0x00;
}

void RomArc::writeIO(word /*port*/, byte value, EmuTime::param /*time*/)
{
	if (value == 0x35) {
		++offset;
	}
}

byte RomArc::readIO(word port, EmuTime::param time)
{
	return RomArc::peekIO(port, time);
}

byte RomArc::peekIO(word /*port*/, EmuTime::param /*time*/) const
{
	return ((offset & 0x03) == 0x03) ? 0xda : 0xff;
}

template<typename Archive>
void RomArc::serialize(Archive& ar, unsigned /*version*/)
{
	ar.template serializeBase<Rom16kBBlocks>(*this);
	ar.serialize("offset", offset);
}
INSTANTIATE_SERIALIZE_METHODS(RomArc);
REGISTER_MSXDEVICE(RomArc, "RomArc");

} // namespace openmsx
