/* helpDialog.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * Creates a separate, file reading thread, using urlConnect().
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/
import java.awt.*;
import java.net.*;
import java.applet.*;
import java.lang.*;
import java.io.*;

public class helpDialog extends Dialog
{

	TextArea textArea;
	
	helpDialog(String title,String helpText)
	{
		super(new Frame(),false);

		addNotify();
     	
		GridBagLayout gridbag=new GridBagLayout();
       	GridBagConstraints c=new GridBagConstraints();
        	
       	setFont(new Font(gwConst.FONTSTRING,Font.BOLD,gwConst.FONTHEIGHT));
       	setLayout(gridbag);
			
        setBackground(Color.lightGray);

        c.fill=GridBagConstraints.BOTH;
        c.weightx=1.0;c.weighty=1.0;
        c.insets=new Insets(5,5,5,5);
 		c.gridwidth=GridBagConstraints.REMAINDER;
        c.anchor=GridBagConstraints.CENTER;
		textArea=new TextArea(helpText);
       	gridbag.setConstraints(textArea,c);
       	add(textArea);

       	textArea.setEditable(false);
       	textArea.setBackground(Color.white);

       	setTitle(title);

       	       


        Dimension screenSize = getToolkit().getScreenSize();
        resize(textArea.preferredSize().width+15,screenSize.height/2);

        move(Math.max(0,screenSize.width-size().width),0);
	}

	public boolean handleEvent(Event e)
    {
        if (e.id == Event.WINDOW_DESTROY
        		||	(e.id == Event.KEY_PRESS && e.key==27)){
            hide();
            return true;
        }

         return super.handleEvent(e);
    }

    public void show()
    {
        super.show();
        textArea.requestFocus();
    }
        
}
   
		
		
