'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: keyboardaccessibility4.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsi $ $Date: 2006/01/19 11:20:24 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : hercule.li@sun.com
'*
'* short description : Keyboard_Accessibility - 4
'*
'************************************************************************
'*
' #1 tMoveDrawObject1
' #1 tMoveDrawObject2
' #1 tEnteringControl1
' #1 tEnteringControl2
' #1 tCreateDefaultDrawObject1
' #1 tTravelToolBar1
' #1 tTravelToolBar2
' #1 tTravelObject1
' #1 tTravelObject2
' #1 tTravelObject3
' #1 tInsertSpecialCharacter1
' #1 tInsertSpecialCharacter2
' #1 tInsertSpecialCharacter3
'*
'\***********************************************************************

sub C_Keyboard_Accessibility_4

   printLog Chr(13) + "=== Keyboard_Accessibility 4 ==="

   printLog Chr(13) + "-- Test moving draw objects"
      Call tMoveDrawObject1     'Check if the selected object can be moved by the arrow keys
      Call tMoveDrawObject2     'Check if the selected object can be moved in 1 pixel steps using ALT+arrow keys

   printLog Chr(13) + "-- Test entering control"
      Call tEnteringControl1    'Check if SHIFT+CTRL+F2 enters the input line
      Call tEnteringControl2    'Check if SHIFT+CTRL+F5 enters the sheet area control

'   printLog Chr(13) + "-- Test entering control"
'      Call tCreateDefaultDrawObject1     'Check if CTRL+Return can generate a draw object which is in the middle of the view

   printLog Chr(13) + "-- Test travel through toolbars"
      Call tTravelToolBar1       'Check if Arrow Keys travel through the icons of a toolbar
      Call tTravelToolBar2       'Check if TAB Keys travel through the icons of a toolbar

   printLog Chr(13) + "-- Select first draw object and travel through severeal ojbects"
      Call tTravelObject1        'Check if first drawing object is selected ,Check if background objects are reachable as well
      Call tTravelObject2        'Check if TAB travels forward through the drawing objects
      Call tTravelObject3        'Check if Shift + TAB travels backward through the drawing objects

   printLog Chr(13) + "-- Select first draw object and travel through severeal ojbects"
      Call tInsertSpecialCharacter1     'Check if characters from the table can be selected with SPACE
      Call tInsertSpecialCharacter2     'Check if RETURN (OK) puts the correct string into the cell
      Call tInsertSpecialCharacter3     'Check if characters from the table can be selected with SPACE

end sub

'***********************************************************************

testcase tMoveDrawObject1

  printLog "Check if the selected object can be moved by the arrow keys"
  '/// Check if the selected object can be moved by the arrow keys

  Dim sPositionX     , sPositionY     as String
  Dim sPositionXMove , sPositionYMove as String

  sPositionX          = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionY          = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionXMove      = "3" + gSeperator + "20" + gMeasurementUnit
  sPositionYMove      = "3" + gSeperator + "20" + gMeasurementUnit

  call  hNewDocument

  '/// Insert a drawing object (rectangle)
    Call fDrawObjects("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

  '/// Set x position and y position in Format/Position and Size
    Call fPositionAndSize("TabPositionAndSize")
     PositionX.Settext sPositionX
     PositionY.Settext sPositionY
    TabPositionAndSize.OK

  '/// Move the draw object
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Right>" , 2
    DocumentCalc.TypeKeys "<Down>"  , 2

  '/// Check if the draw object's position is correct
    fPositionAndSize("TabPositionAndSize")            
    if fCalculateTolerance(PositionX.GetText , sPositionXMove) > 0.015   then Warnlog "X-Position is wrong: Not -> "+sPositionXMove+"  but -> "+PositionX.GetText
    if fCalculateTolerance(PositionY.GetText , sPositionYMove) > 0.015   then Warnlog "Y-Position is wrong: Not -> "+sPositionYMove+"  but -> "+PositionY.GetText
    TabPositionAndSize.Cancel
    Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tMoveDrawObject2

  Dim sPositionX     , sPositionY     as String
  Dim sPositionXMove , sPositionYMove as String

  sPositionX          = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionY          = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionXMove      = "3" + gSeperator + "02" + gMeasurementUnit
  sPositionYMove      = "3" + gSeperator + "02" + gMeasurementUnit

  printLog "Check if the selected object can be moved in 1 pixel steps using ALT+arrow keys"
  '/// Check if the selected object can be moved in 1 pixel steps using ALT+arrow keys

  call  hNewDocument

  '/// Insert a drawing object (rectangle)
    Call fDrawObjects("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

  '/// Set x position and y position in Format/Position and Size
    Call fPositionAndSize("TabPositionAndSize")
     PositionX.Settext sPositionX
     PositionY.Settext sPositionY
    TabPositionAndSize.OK

  '/// Move the draw object
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD2 Right>"
    Sleep 1
    DocumentCalc.TypeKeys "<MOD2 Down>"
    Sleep 1

  '/// Check if the draw object's position is correct
    fPositionAndSize("TabPositionAndSize")
     if fCalculateTolerance(PositionX.GetText , sPositionXMove) > 0.015 then Warnlog "X-Position is wrong: Not -> "+sPositionXMove+"  but -> "+PositionX.GetText
     if fCalculateTolerance(PositionY.GetText , sPositionYMove) > 0.015 then Warnlog "Y-Position is wrong: Not -> "+sPositionYMove+"  but -> "+PositionY.GetText
    TabPositionAndSize.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tEnteringControl1

  printLog "Check if SHIFT+CTRL+F2 enters the input line"
  '/// Check if SHIFT+CTRL+F2 enters the input line

  call  hNewDocument

   Kontext "RechenleisteCalc"
   try
     if Uebernehmen.IsVisible = TRUE then Warnlog "Uebernehmen Should NOT been seen"
     if Verwerfen.IsVisible   = TRUE then Warnlog "Verwerfen Should NOT been seen"
   catch
   endcatch

   Kontext "DocumentCalc"
  '/// Press Ctrl + Shift + F2
   DocumentCalc.TypeKeys "<MOD1 SHIFT F2>"

   Kontext "RechenleisteCalc"

  '/// Check if the focus is in input line
  '/// Hints : Check if Uebernehmen(58771) and Verwerfen(58770) are Enabled
   try
     if Uebernehmen.IsEnabled = FALSE then Warnlog "Uebernehmen should be Enabled"
     if Verwerfen.IsEnabled   = FALSE then Warnlog "Verwerfen should be Enabled"
   catch
     Warnlog "Something wrong when trying to test entering control"
   endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tEnteringControl2

  printLog "Check if SHIFT+CTRL+F5 enters the sheet area control"
  '/// Check if SHIFT+CTRL+F5 enters the sheet area control
  '/// Hint : In fact, this case can't test focus . Maybe the manual test is still needed.

  Dim sAreaContrl as String

  sAreaContrl = "A1"

  call  hNewDocument

   Kontext "DocumentCalc"

   DocumentCalc.TypeKeys "<SHIFT Right>" , 2
   EditCopy
   if GetClipboardText = sAreaContrl then Warnlog "Something wrong before trying to test area control"
   DocumentCalc.TypeKeys "<Left>" , 2

  '/// Press Ctrl + Shift + F5
   DocumentCalc.TypeKeys "<MOD1 SHIFT F5>"

  '/// Check if the focus is in area control
   Kontext "RechenleisteCalc"
   RechenleisteCalc.TypeKeys "<SHIFT Right>" , 2
   Bereich.TypeKeys "<SHIFT Right>" , 2
   Bereich.TypeKeys "<MOD1 c>" , 2

   if GetClipboardText <> sAreaContrl then Warnlog "Something wrong when trying to test area control"

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tCreateDefaultDrawObject1

  printLog "Check if CTRL+Return can generated a draw object which is in the middle of the view"
  '/// Check if CTRL+Return can generated a draw object which is in the middle of the view
  '/// Hint : In fact, this case can't test if the object is in the middle of the view.
  '/// + Maybe the manual test is still needed.

  Dim aDrawObject()     as String
  Dim i , j , iStep     as Integer
  Dim bAsianLanguage    as Boolean
  Dim aFlag(14)         as Boolean

  aDrawObject = Array( _
                      "Line"              , _
                      "Rectangle"         , _
                      "Ellipse"           , _
                      "Polygon"           , _
                      "Curve"             , _
                      "Freeform Line"     , _
                      "Arc"               , _
                      "Ellipse Pie"       , _
                      "Circle Segment"    , _
                      "Text"              , _
                      "Vertical Text"     , _
                      "Text Animation"    , _
                      "Callouts"          , _
                      "Vertical Callouts" , _
                     )

  'Set 'Asian Language support' ON
   bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

   j = UBound(aDrawObject)

   for i = 0 to j
       aFlag(i) = fActiveObjectInToolbar("Drawing" , aDrawObject(i) , TRUE)
   next i

  '/// The following draw ojbect will be tested.
  '/// 1. line
  '/// 2. rectangle
  '/// 3. ellipse
  '/// 4. textobject
  '/// 5. callouts
  '/// 6. arc
  '/// 7. circle segment
  '/// 8. ellipse pie
  '/// 9. polygon
  '/// 10.curve
  '/// 11.freeform line
  '/// 12.text animation
  '/// 13.text
  '/// 14.veritcal text

   for i = 0 to j
       Select case aDrawObject(i)
           case "Line"               : iStep = 1
           case "Rectangle"          : iStep = 2
           case "Ellipse"            : iStep = 3
           case "Polygon"            : iStep = 4
           case "Curve"              : iStep = 5
           case "Freeform Line"      : iStep = 6
           case "Arc"                : iStep = 7
           case "Ellipse Pie"        : iStep = 8
           case "Circle Segment"     : iStep = 9
           case "Text"               : iStep = 10
           case "Vertical Text"      : iStep = 11
           case "Text Animation"     : iStep = 12
           case "Callouts"           : iStep = 13
           case "Vertical Callouts"  : iStep = 14
       end select

       call  hNewDocument

        Call hToolbarSelect("DRAWING", true)

         Kontext "Drawbar"
         Drawbar.TypeKeys "<Home>"
         Sleep 1
         Drawbar.TypeKeys "<RIGHT>" , iStep , TRUE
         sleep(2)
         Drawbar.TypeKeys "<MOD1 RETURN>"   , TRUE
         sleep(4)

         if aDrawObject(i) = "Text" OR aDrawObject(i) = "Vertical Text" OR aDrawObject(i) = "Callouts" OR aDrawObject(i) = "Text Animation" OR aDrawObject(i) = "Vertical Callouts" then
           Kontext "DocumentCalc"
           DocumentCalc.TypeKeys "<ESCAPE>"
           Sleep 1
           gMouseClick (45,40)
           Sleep 1
         end if

        'Hints : if Format/Position and Size can be executed,
        'that means the object is inserted
         try
             Call fPositionAndSize("TabPositionAndSize")
             TabPositionAndSize.Cancel
         catch
             Warnlog "Something wrong in inserting " + aDrawObject(i)
         endcatch
       Call hCloseDocument
   next i

   for i = 0 to j
       if aFlag(i) = FALSE then
           fActiveObjectInToolbar("Drawing" , aDrawObject(i) , FALSE)
       end if
   next i

  'Set the 'Asian Language support' to default
   if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
   end if

endcase

'-------------------------------------------------------------------------

testcase tTravelToolBar1

  printLog "Check if Arrow Keys travel through the icons of a toolbar"
'/// Check if Arrow Keys travel through the icons of a toolbar

  call  hNewDocument

'/// Check in function Bar
  printLog "In Function bar, move focus right and return "
  printLog "check if open file dlg is opened"

   kontext "Standardbar"
   try
      Standardbar.typekeys "<Home>"   ,  TRUE
      Sleep 1
      Standardbar.typekeys "<Right>"  ,  TRUE
      Sleep 1
      Standardbar.typekeys "<RETURN>" ,  TRUE    ' Open file Dlg
      Sleep 1
      kontext "GeneralFileDialog"
      if GeneralFileDialog.exists (2) then
         GeneralFileDialog.Cancel
      else
         warnlog "File dialog isn't available"
      end if
   catch
       warnlog "Something wrong in testing mail tool bar!"
   endcatch

'/// Check in Object bar
  printLog "In object bar, move focus right 5 times and Down "
  printLog "check if Font color dlg is opened"

   Kontext "FormatObjectbar"
   try
      FormatObjectbar.typekeys "<HOME>"   ,      TRUE
      Sleep 2
      FormatObjectbar.typekeys "<Right>"  , 20 , TRUE
      Sleep 2
      FormatObjectbar.typekeys "<Down>"   ,      TRUE    ' Font colors Dlg
      Sleep 2
      kontext "TB_Farbe"
      if TB_Farbe.exists (2) then
         Sleep 1
         TB_Farbe.Close
         Sleep 1
      else
         warnlog "Font color dialog isn't available"
      end if
   catch
       warnlog "Something wrong in testing object tool bar!"
   endcatch

   Sleep 1

'/// Check in main tool bar
  printLog "In main tool bar, move focus right and return, "
  printLog "check if Functions autopilot dialog  is opened"

   Kontext "RechenleisteCalc"
   try
     RechenleisteCalc.typekeys "<Home>"    , TRUE
     Sleep 1
     RechenleisteCalc.typekeys "<Right>"   , TRUE
     Sleep 1
     RechenleisteCalc.typekeys "<RETURN>"  , TRUE
     kontext "Funktionsautopilot"
     if Funktionsautopilot.exists (2) then
         Sleep 1
         Funktionsautopilot.Cancel
         Sleep 1
     else
         warnlog "Functions autopilot dialog isn't available!"
     end if
   catch
     warnlog "Something wrong in testing main tool bar!"
   endcatch

'/// Check in option bar
  printLog "In option bar, move focus  down 3 times and down , then move focus right "
  printLog "then Ctrl+Return , check if draw object is inserted"
    Call hToolbarSelect("DRAWING", true)
    Kontext "Drawbar"
    Drawbar.TypeKeys "<RIGHT>"       , TRUE
    sleep(2)
    Drawbar.TypeKeys "<MOD1 RETURN>" , TRUE
    sleep(2)

    '/// Hints : if Format/Position and Size can be executed,
    '/// + that means the object is inserted
     try
        Call fPositionAndSize("TabPositionAndSize")
        TabPositionAndSize.Cancel
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<DELETE>"
     catch
        Warnlog "i32287 - Something wrong in operating in option bar!"
     endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTravelToolBar2

  printLog "Check if Tab Key travel through the icons of a toolbar"
'/// Check if Tab Key travel through the icons of a toolbar

  call  hNewDocument

'/// Check in function Bar
  printLog "In Function bar, move focus with TAB and return "
  printLog "check if open file dlg is opened"

   kontext "Standardbar"
   try
      Standardbar.typekeys "<Home>"   ,  TRUE
      Sleep 1
      Standardbar.typekeys "<TAB>"    ,  TRUE
      Sleep 1
      Standardbar.typekeys "<RETURN>" ,  TRUE    ' Open file Dlg
      Sleep 1
      kontext "GeneralFileDialog"
      if GeneralFileDialog.exists (2) then
         GeneralFileDialog.Cancel
      else
         warnlog "File dialog isn't available"
      end if
   catch
       warnlog "Something wrong in testing mail tool bar!"
   endcatch

'/// Check in Object bar
  printLog "In object bar, move focus TAB 20 times and return, "
  printLog "check if Font color dlg is opened"

   Kontext "FormatObjectbar"
   try
      FormatObjectbar.typekeys "<HOME>"  ,      TRUE
      FormatObjectbar.typekeys "<TAB>"   , 20 , TRUE
      FormatObjectbar.typekeys "<Down>"  ,      TRUE    ' Font colors Dlg

      kontext "TB_Farbe"
      if TB_Farbe.exists (2) then
         Sleep 1
         TB_Farbe.Close
         Sleep 1
      else
         warnlog "Font color dialog isn't available"
      end if
   catch
       warnlog "Something wrong in testing object tool bar!"
   endcatch

   Sleep 1

'/// Check in main tool bar
  printLog "In main tool bar, move focus TAB and return, "
  printLog "check if Functions autopilot dialog  is opened"

   Kontext "RechenleisteCalc"
   try
     RechenleisteCalc.typekeys "<Home>"   ,  TRUE
     Sleep 1
     RechenleisteCalc.typekeys "<TAB>"    ,  TRUE
     Sleep 1
     RechenleisteCalc.typekeys "<RETURN>" ,  TRUE
     kontext "Funktionsautopilot"
     if Funktionsautopilot.exists (2) then
         Sleep 1
         Funktionsautopilot.Cancel
         Sleep 1
     else
         warnlog "Functions autopilot dialog isn't available!"
     end if
   catch
     warnlog "Something wrong in testing main tool bar!"
   endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTravelObject1

  printLog "Check if first drawing object is selected , Check if background objects are reachable as well "
  '/// Check if first drawing object is selected , Check if background objects are reachable as well

  Dim testFile      as String
  Dim sObjectName1  as String

  testFile     = "tTravelObject1.sxc"

  sObjectName1 = "Picture1"

 '/// Open test file --  tTravelObject1.sxc which include 3 objects.
 '/// + First one is a picture which is named picture1 and be backgrounded

  Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
  Sleep 1

  Kontext "DocumentCalc"

 '/// Move the focus to the drawing bar , then choose "Arrow"
 '/// Press Ctrl+Return
   Call hToolbarSelect("DRAWING", true)
   Kontext "Drawbar"
   Drawbar.TypeKeys "<Home>"
   Sleep 2
   Drawbar.TypeKeys "<MOD1 RETURN>"
   Sleep 1

 '/// Check if the focus is on the first object -- picture1
   Kontext "DocumentCalc"

 ' ---- try context menu 'Name Object
   try
      DocumentCalc.OpenContextMenu
      Call fMenuSelectNr(10)
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName1 then
        Warnlog "The object name is NOT right , should be " + sObjectName1 + "but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName1
   endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTravelObject2

  printLog "Check if TAB travels forward through the drawing objects "
  '/// Check if TAB travels forward through the drawing objects

  Dim testFile                                   as String
  Dim sObjectName1 , sObjectName2 , sObjectName3 as String

  testFile     = "tTravelObject1.sxc"

  sObjectName1 = "Picture1"
  sObjectName2 = "Chart1"
  sObjectName3 = "Picture2"

 '/// Open test file --  tTravelObject1.sxc which include 3 objects.
 '/// - First one is a picture named picture1 and be backgrounded
 '/// - Second one is a chart  named chart1
 '/// - Third one is a picture named picture2 and be backgrounded

  Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
  Sleep 1

  Kontext "DocumentCalc"

 '/// Move the focus to the drawing bar , then choose "Arrow"
 '/// Press Ctrl+Return
   Call hToolbarSelect("DRAWING", true)
   Kontext "Drawbar"
   Drawbar.TypeKeys "<Home>"
   Sleep 2
   Drawbar.TypeKeys "<MOD1 RETURN>"
   Sleep 1

   Kontext "DocumentCalc"
 '/// Press Tab to check if the focus is on the second object -- chart1
   DocumentCalc.TypeKeys "<TAB>"

   try
      DocumentCalc.OpenContextMenu
      Sleep 1
      Call fMenuSelectNr(5)
      Sleep 1
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName2 then
        Warnlog "The object name is NOT right , should be " + sObjectName2 + "but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName2
   endcatch

 '/// Press Tab again to check if the focus is on the third object -- picture2
   Kontext "DocumentCalc"

   DocumentCalc.TypeKeys "<TAB>"

   try
      DocumentCalc.OpenContextMenu
      Sleep 1
      Call fMenuSelectNr(10)
      Sleep 1
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName3 then
        Warnlog "The object name is NOT right , should be " + sObjectName3 + "but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName3
   endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTravelObject3

  printLog "Check if Shift+TAB travels backward through the drawing objects "
  '/// Check if Shift+TAB travels backward through the drawing objects

  Dim testFile                                   as String
  Dim sObjectName1 , sObjectName2 , sObjectName3 as String

  testFile     = "tTravelObject1.sxc"

  sObjectName1 = "Picture1"
  sObjectName2 = "Chart1"
  sObjectName3 = "Picture2"

 '/// Open test file --  tTravelObject1.sxc which include 3 objects.
 '/// - First one is a picture named picture1 and be backgrounded
 '/// - Second one is a chart  named chart1
 '/// - Third one is a picture named picture2 and be backgrounded

  Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
  Sleep 1

  Kontext "DocumentCalc"

 '/// Move the focus to the drawing bar , then choose "Arrow"
 '/// Press Ctrl+Return
   Call hToolbarSelect("DRAWING", true)
   Kontext "Drawbar"
   Drawbar.TypeKeys "<Home>"
   Sleep 2
   Drawbar.TypeKeys "<MOD1 RETURN>"
   Sleep 1

   Kontext "DocumentCalc"
 '/// Press Shift Tab to check if the focus is on the third object -- Picture2
   DocumentCalc.TypeKeys "<Shift TAB>"

   try
      DocumentCalc.OpenContextMenu
      Sleep 1
      Call fMenuSelectNr(10)
      Sleep 1
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName3 then
        Warnlog "The object name is NOT right , should be " + sObjectName3 + " but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName3
   endcatch

 '/// Press Shift Tab again to check if the focus is on the 2nd object -- Chart1
   Kontext "DocumentCalc"

   DocumentCalc.TypeKeys "<Shift TAB>"

   try
      DocumentCalc.OpenContextMenu
      Sleep 1
      Call fMenuSelectNr(5)
      Sleep 1
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName2 then
        Warnlog "The object name is NOT right , should be " + sObjectName2 + " but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName2
   endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tInsertSpecialCharacter1

 '/// Check if characters from the table can be selected with SPACE
  printLog "Check if characters from the table can be selected with SPACE"

    Dim sTestString as String
    sTestString = "!"

    Call  hNewDocument

    '/// Open insert special characters dialog with Insert/Special Characters
     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"

    '/// Move mouse Right , now the focus is "!"
     SchriftListe.typekeys "<Right>"
     Sleep 1

    '/// Press SPACE
     SchriftListe.typekeys "<SPACE>"
     Sleep 1

     Sonderzeichen.Ok

    '/// Check if character is inserted into the spreadsheet
     Kontext "RechenleisteCalc"
     try
       Uebernehmen.Click
       Sleep 1
     catch
       Warnlog "Something wrong when inserting special characters."
     endcatch

     EditCopy
     if GetClipboardText <> sTestString then Warnlog "The character is NOT inserted correctly. Should be "+sTestString+ " but get "+GetClipboardText

     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"
     Sonderzeichen.OK

    call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tInsertSpecialCharacter2

 '/// Check if RETURN (OK) puts the correct string into the cell
  printLog "Check if RETURN (OK) puts the correct string into the cell"

    Dim sTestString as String
    sTestString = "!"

    Call  hNewDocument

    '/// Open insert special characters dialog with Insert/Special Characters
     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"

    '/// Move mouse Right , now the focus is "!"
     SchriftListe.typekeys "<Right>"
     Sleep 1

    '/// Press SPACE
     SchriftListe.typekeys "<SPACE>"
     Sleep 1

     SchriftListe.typekeys "<RETURN>" ,   TRUE
     Sleep 2

    '/// Check if character is inserted into the spreadsheet
     Kontext "RechenleisteCalc"
     try
       Uebernehmen.Click
       Sleep 1
     catch
       Warnlog "Something wrong when inserting special characters."
     endcatch

     EditCopy
     if GetClipboardText <> sTestString then Warnlog "The character is NOT inserted correctly. Should be "+sTestString+ " but get "+GetClipboardText

     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"
     Sonderzeichen.OK

    call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tInsertSpecialCharacter3

 '/// Check if ALT+D deletes the whole string you assembled
  printLog "Check if ALT+D deletes the whole string you assembled"

    Call  hNewDocument

    '/// Open insert special characters dialog with Insert/Special Characters
     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"

    '/// Move mouse Right , now the focus is "!"
     SchriftListe.typekeys "<Right>"
     Sleep 1

    '/// Press SPACE  ( "!" should be selected)
     SchriftListe.typekeys "<SPACE>"
     Sleep 1

    '/// Press Alt+D  , "!" should be deleted .
    '/// - <<Press Alt+L , German>>
    '/// - <<Press Alt+E , Italian>>
    '/// - ......
     Select case iSprache
         case 01 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case 31 : Sonderzeichen.typekeys "<MOD2 W>" , TRUE
         case 33 : Sonderzeichen.typekeys "<MOD2 S>" , TRUE
         case 34 : Sonderzeichen.typekeys "<MOD2 B>" , TRUE
         case 39 : Sonderzeichen.typekeys "<MOD2 E>" , TRUE
         case 46 : Sonderzeichen.typekeys "<MOD2 R>" , TRUE
         case 49 : Sonderzeichen.typekeys "<MOD2 L>" , TRUE
         case 55 : Sonderzeichen.typekeys "<MOD2 E>" , TRUE
         case 81 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case 82 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case 86 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case 88 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case else : QAErrorLog "The test does not support the language " + iSprache
                     Sonderzeichen.Cancel
                     call hCloseDocument
                     Goto endsub
     end select

     Sleep 2

     try
       Sonderzeichen.Ok
       Warnlog "Should NOT execute OK after deleting all selected characters!"
     catch
       SchriftListe.typekeys "<HOME>"
       Sleep 1
       Sonderzeichen.OK
     endcatch

    call hCloseDocument

endcase
