'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_basicdocuments.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/11 15:29:03 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : BASIC organizers and documents
'*
'*******************************************************************************
'**
' #1 tBasicDocuments ' Documents in BASIC organizers
' #1 hBasicDocuments ' Verify content of the treelist in Basic Organizer
' #1 hTestLibraryListBox ' Listbox should have same content as Basic Organizer treelist
'**
'\******************************************************************************

private const CNAME = "basic"
private const IDOCS = 5
    
testcase tBasicDocuments

    const CFN = "tBasicDocuments::"
    const ISEC = 1 

    '///<H1>Documents in BASIC organizers</H1>
    '///<i>Compare the names of the documents listed in various treelists
    '///+ in Basic Organizer and Basic Object Organizer (Manage...)</i>
    '///<ul>

    dim brc as boolean
    dim sFileWriter as string
    dim sFileCalc as string
    dim iDocumentCount as integer
    dim cNodeListA( 10 ) as string
    dim cNodeListB( 10 ) as string
    dim iSecLevel as integer
    
    '///+<li>Set the Macro Security Level to &quot;Medium&quot;</li>
    printlog( "" )
    iSecLevel = hSetMacroSecurity( ISEC )

    '///+<li>Create a writer document containing a macro, name it basic.odt</li>
    gApplication = "WRITER"
    printlog( "" )
    brc = hCreateBasicWorkFiles()
    sFileWriter = hGetBasicWorkFile( "current" )

    '///+<li>Create a calc document containing a macro, name it basic.ods</li>
    gApplication = "CALC"
    printlog( "" )
    brc = hCreateBasicWorkFiles()
    sFileCalc = hGetBasicWorkFile( "current" )

    '///+<li>Reload the files we just created</li>
    printlog( "" )
    brc = hLoadFile( sFileWriter )
    brc = hHandleSecurityWarning()
    brc = hLoadFile( sFileCalc )
    brc = hHandleSecurityWarning()

    '///+<li>Go to Tools/Macro->Nasic Macros</li>
    printlog( "" )
    brc = hOpenBasicOrganizerFromDoc()

    '///+<li>Verify that the treelist contains five items</li>
    hGetVisibleNodeNames( MakroAus , cNodeListA() )
    
    '///+<li>Verify the names of the docs: Untitled, basic(odt), basic(ods)</li>
    printlog( "" )
    brc = hBasicDocuments( cNodeListA() )
    
    '///+<li>Click the <Manage...> button</li>
    verwalten.click()
    
    '///+<li>Switch to the modules-Tab (should be open by default)</li>
    '///+<li>Verify that the treelist content matches the one from before</li>
    printlog( "" )
    brc = hSelectBasicObjectOrganizerTab( 1 )
    ListAllDelete( cNodeListB() )
    hGetVisibleNodeNames( ModulListe , cNodeListB() )
    brc = hBasicDocuments( cNodeListB() )

    '///+<li>Switch to the Dialogs-Tab (the second one)</li>
    '///+<li>Verify that the treelist content matches the one from before</li>
    printlog( "" )
    brc = hSelectBasicObjectOrganizerTab( 2 )
    ListAllDelete( cNodeListB() )
    hGetVisibleNodeNames( ModuleList , cNodeListB() )
    brc = hBasicDocuments( cNodeListB() )

    '///+<li>Switch to Libraries Tab and look at the entries in the listbox</li>
    '///+<li>Comparision is done against the first list (Macro Organizer)</li>
    printlog( "" )
    brc = hSelectBasicObjectOrganizerTab( 3 )
    brc = hTestLibraryListBox( cNodeListA() )
    
    '///+<li>Close the Basic Object Organizer</li>
    printlog( "" )
    printlog( CFN & "Closing dialogs..." )
    TabBibliotheken.cancel()
    
    '///+<li>Close the Macro Organizer</li>
    Kontext "Makro"
    Makro.cancel()

    '///+<li>Close the two documents we worked with</li>
    brc = hDestroyDocument()
    brc = hDestroyDocument()
    
    '///+<li>Delete the two workfiles</li>
    brc = hDeleteFile( sFileWriter )
    brc = hDeleteFile( sFileCalc )
    
    '///+<li>Reset the Macro security level</li>
    hSetMacroSecurity( iSecLevel )
    
    '///</ul>

endcase

'*******************************************************************************

function hBasicDocuments( cNodeList() as string ) as boolean 

    const CFN = "hBasicDocuments::"
    
    '///<h3>Verify that the documents in the Treelist are the correct ones</h3>
    '///<i>Part of: tBasicDocuments</i><br>
    '///<i>These are the entries from the treelist on the first tab of the 
    '///+ basic object organizer (Libraries/Modules/Dialogs)</i><br>
    
    '///<u>Input</u>:
    '///<ol>
    '///+<li>List containing the names of all nodes from the treelist (string)</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstatus (boolean)</li>
    '///<ul>
    '///+<li>TRUE if all entries are correct</li>
    '///+<li>FALSE on any inconsistency</li>
    '///</ul>
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    
    dim brc as boolean
        brc = true
    dim irc as integer
    dim iDoc as integer

    hBasicDocuments() = true
    
    '///+<li>Count the number of objects in the treelist</li>
    
    if ( listcount( cNodeList() ) <> 5 ) then
        warnlog( CFN & "#i49239# Incorrect object count in treelist" )
        hListPrint( cNodeList() , "List of objects found in treelist" )
        hBasicDocuments() = false
    endif        
    
    '///+<li>Compare the name sof the documents, they should be:</li>
    '///<ul>
    '///+<li>Object 1: My Macros</li>
    '///+<li>Object 2: OpenOffice.org Macros</li>
    '///+<li>Object 3: Untitled document</li>
    iDoc = IDOCS - 2
    irc = hCompareSubStrings( CNAME , cNodeList( iDoc ) ) 
    if ( irc <> 0 ) then
        warnlog( CFN & "String should differ: " & cNodeList( iDoc )
        brc = false
    endif

    '///+<li>Object 4: Document named <basic> (writer document)</li>
    iDoc = IDOCS - 1
    irc = hCompareSubStrings( CNAME , cNodeList( iDoc ) ) 
    if ( irc <> 1 ) then
        warnlog( CFN & "Strings should be identical: " & cNodeList( iDoc )
        brc = false
    endif

    '///+<li>Object 5: Document named <basic> (calc document)</li>
    iDoc = IDOCS
    irc = hCompareSubStrings( CNAME , cNodeList( iDoc ) ) 
    if ( irc <> 1 ) then
        warnlog( CFN & "Strings should be identical: " & cNodeList( iDoc )
        brc = false
    endif
    
    hBasicDocuments() = brc
    '///</ul>
    '///</ul>
end function

'*******************************************************************************

function hTestLibraryListBox( cNodeList() ) as boolean

    const CFN = "hTestLibraryListBox::"

    '///<h3>Compare library-Listbox with Macro-Organizer listbox</h3>
    '///<i>Part of: tBasicDocuments</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>List of items found in Basic Macro Organizer Treelist (MakroAus)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstatus (boolean)</li>
    '///<ul>
    '///+<li>TRUE if all items are identical</li>
    '///+<li>FALSE on any other error</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    dim iEntry as integer
    dim cEntry as string
    dim brc as boolean
    dim irc as integer
    
    brc = true
    
    '///+<li>Check that the number of objects is ok</li>
    if ( bibliothek.getItemCount() <> IDOCS ) then
        warnlog( CFN & "Incorrect number of items in listbox" )
        printlog( CFN & "Expected: " & bibliothek.getItemCount() )
        printlog( CFN & "Found...: " & listcount( cNodeList() ) )
        brc = false
    endif
        
    '///+<li>Compare objects 3 -5 (1+2 always differ)</li>
    for iEntry = 3 to IDOCS
    
        Bibliothek.select( iEntry )
        cEntry = Bibliothek.getSelText()
        
        irc = hCompareSubStrings( cNodeList( iEntry ) , cEntry )
        if ( irc <> 1 ) then
            warnlog( CFN & "Comparision failed" )
            printlog( CFN & "Expected: " & cNodeList( iEntry ) & "<>" & cEntry )
            brc = false
        else
            printlog( CFN & "Comparision succeeded:" & cEntry )
        endif
        
    next iEntry
    
    '///</ul>
    
end function
