'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg1.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:02:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'*******************************************************************************
' **
' #1 tFolder1                           ' create folders with different names ( 'new folder'-button )
' #1 tFolder2                           ' create folders with same names ( 'new folder'-button )
' #1 tFolder3                           ' create folders with lower and upper cases in local-file-system ( 'new folder'-button )
' **
'\******************************************************************************

testcase tFolder1

   '///create new folders
   Dim VerList(50) as String
   dim FULLPATH as string
       FULLPATH = gOfficePath + "user\work\"
       
   printlog " - cleanup the output-dir, kill all directories."
    
   '///kill all directories in [testtool-path]\framework\filedlg\output\*
   GetDirList ( ConvertPath ( FULLPATH ), "*" , VerList() )
   KillDirList ( VerList() )

   '///file/open
   FileOpen
   
   'This is a hack to prevent trouble when opening 'FileOpen' and the path
   'is not accessible. 
   Kontext "Active"
   if Active.Exists( 1 ) then
      Warnlog "The preset path is invalid, a messagebox has been shown."
      Active.OK()
      endif
      
   Kontext "OeffnenDlg"
   Dateiname.SetText( ConvertPath ( FULLPATH ) )
   Oeffnen.Click()
   
   
   '///+click on 'new folder', insert as name 'z' and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with only one character"
   CreateValidDirectory( "z" )


   '///click on 'new folder', insert as name '1234' and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername only with numbers"
   CreateValidDirectory( "1234" )
  

   '///click on 'new folder', insert as name 'xaxaxaxa' ( 8 characters ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with 8 characters"
   CreateValidDirectory( "xaxaxaxa" )

  
   '///click on 'new folder', insert as name 'yxyxyxyx.aaa' ( 8.3 characters ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with 8.3 characters"
   CreateValidDirectory( "yxyxyxyx.aaa" )   

  
   '///click on 'new folder', insert as name 'yxyxyxyxyxyx.aaabbb' ( more than 8.3 characters ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with more than 8.3 characters"
   CreateValidDirectory( "yxyxyxyxyxyx.aaabbb" )

  
   '///click on 'new folder', insert as name 'hälölüle' ( with special characters - umlauts ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with special charaters ( umlauts )"
   CreateValidDirectory( "hälölüle" )
  
   
   '///click on 'new folder', insert as name 'aa bb' ( with spaces in the middle ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with one whitespace in the middle"
   CreateValidDirectory( "aa bb" )
  

   '///click on 'new folder', insert as name ' ccdd' ( with leading spaces ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with leading spaces"
   CreateValidDirectoryCrop( " lead" , "lead" )

   
   '///click on 'new folder', insert as name 'ddee ' ( with spaces at the end ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with trailing spaces"
   CreateValidDirectoryCrop( "trail " , "trail" )
   

   '///click on 'new folder', insert as name 'Here is a dir with spaces' ( with more spaces ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with more spaces"
   CreateValidDirectory( "here is a dir with spaces" )   

   
   '///click on 'new folder', insert as name '??++!!' ( with forbidden signes on windows ) and click OK
   '///+control on system-side if the folder was created ( if yes -> kill it )
   printlog " - foldername with forbidden signes ( ?+! ) - only on windows they are forbidden"
   CreateInvalidDirectory( "??++!!" )   

   Kontext "OeffnenDlg"
   OeffnenDlg.Cancel()
   
endcase

'*******************************************************************************

testcase tFolder2

   '///create new folders with the same name
   '///+in 6.0 it is forbidden to create a new folder with the same name

   dim FULLPATH as string
       FULLPATH = gOfficePath + "user\work\"

   Dim VerList(50) as String

   '///kill all directories in [testtool-path]\framework\filedlg\output\*
   GetDirList ( ConvertPath ( FULLPATH ), "*" , VerList() )
   KillDirList ( VerList() )

   '///Open the File Open dialog
   FileOpen

   Kontext "OeffnenDlg"
   Dateiname.SetText( ConvertPath ( FULLPATH ))
   Oeffnen.Click()

   '///Use 'New Folder' to create a folder twice: "aaa"
   printlog( CHR$(13) + " - Create a folder named 'aaa' twice" )
   CheckDirectoryName( "aaa" ) 

   '///Use 'New Folder' to create a folder twice: "123"
   printlog( CHR$(13) + " - Create a folder named '123' twice" )
   CheckDirectoryName( "123" )     

   '///Use 'New Folder' to create a folder twice: "yayayaya"
   printlog( CHR$(13) + " - Create a folder named 'yayayaya' twice" )
   CheckDirectoryName( "yayayaya" )

   '///Use 'New Folder' to create a folder twice: "ycycycyc.aaa"
   printlog( CHR$(13) + " - Create a folder named 'ycycycyc.aaa' twice" )
   CheckDirectoryName( "ycycycyc.aaa" )
   
   Kontext "NeuerOrdner"
   if NeuerOrdner.Exists() then
      NeuerOrdner.Cancel()
   endif

   '///Close the File Open dialog
   Kontext "OeffnenDlg"
   OeffnenDlg.Cancel()

endcase

'*******************************************************************************

testcase tFolder3

   '///create folders with lower and upper cases in the local file system
   
   dim FULLPATH as string
       FULLPATH = gOfficePath + "user\work\"
       
   dim FOLDERNAME_U as string
       FOLDERNAME_U = "AAABBB"
       
   dim FOLDERNAME_M as string
       FOLDERNAME_M = "AAaabbBB"

   '///file/open
   FileOpen
   
   '///walk to the working directory
   printlog( " - change to working directory" )
   Kontext "OeffnenDlg"
   Dateiname.SetText( ConvertPath ( FULLPATH ))
   Oeffnen.Click()
   
   '///create with 'new folder' a new folder named 'AAABBB' ( only uppercase characters )
   printlog( " - foldername with upper case characters only" )
   call CreateValidDirectory( FOLDERNAME_U )
   
   '///create with 'new folder' a mixed-case named folder
   printlog( " - foldername with mixed case characters" )
   call CreateValidDirectory( FOLDERNAME_M )
   
   '///close FileOpen dialog
   kontext "OeffnenDlg"
   OeffnenDlg.Cancel()
   
endcase


