'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: windows_tools.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:07:47 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description :
'*
'*******************************************************************************
' **
' #0 hGetSysIntegrationPath   ' gets the systemintegration-path
' #0 hGetCurrentUserAppData   ' finds the starmenu/programs-folder
' **
'\******************************************************************************

Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" _
 ( ByVal hKey As Long, _
   ByVal lpSubKey As String, _
   ByVal ulOptions As Long, _
   ByVal samDesired As Long, _
   phkResult As Long) As Long

Declare Function RegQueryValueExString Lib "advapi32.dll" Alias "RegQueryValueExA" _
 ( ByVal hKey As Long, _
   ByVal lpValueName As String, _
   ByVal lpReserved As Long, _
   lpType As Long, _
   lpData As String, _
   lpcbData As Long) As Long

Declare Function RegQueryValueExLong Lib "advapi32.dll" Alias "RegQueryValueExA" _
 ( ByVal hKey As Long, _
   ByVal lpValueName As String, _
   ByVal lpReserved As Long, _
   lpType As Long, _
   lpData As Long, _
   lpcbData As Long) As Long

Declare Function RegQueryValueExNULL Lib "advapi32.dll" Alias "RegQueryValueExA" _
 ( ByVal hKey As Long, _
   ByVal lpValueName As String, _
   ByVal lpReserved As Long, _
   lpType As Long, _
   ByVal lpData As Long, _
   lpcbData As Long) As Long

Declare Function RegCloseKeyA Lib "advapi32.dll" Alias "RegCloseKey" _
 ( ByVal hKey As Long ) As Long


' These constants are required to access the Windows registry
Public Const HKEY_CURRENT_USER = &H80000001
Public Const HKEY_LOCAL_MACHINE = &H80000002
Public Const KEY_ALL_ACCESS = &H3F


function hGetSysIntegrationPath( sLocation as string ) as string

  ' This function queries the windows registry to find the location of the
  ' StartMenu\Programs folder.
  ' It returns a path or in case of an error the string "error".

   dim sKey as string
   dim sVal as string
   dim hKey as long
   dim rc as long
   dim sPath as string
   dim lType as long
   dim dummy as long

   hGetSysIntegrationPath = "error"

   if ( sLocation = "USER" ) then

      ' These are the registry-path and -keys to find the required information
      sKey = "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\"
      sVal = "Programs"

      rc = RegOpenKeyEx( HKEY_CURRENT_USER , sKey , 0 , KEY_ALL_ACCESS , hKey )
      if ( rc <> 0 ) then
         warnlog ( "RegOpenKeyEx returned: " & rc )
         goto endsub
         endif

      rc = RegQueryValueExNULL( hKey , sVal , 0& , lType , 0& , dummy )
      if ( rc <> 0 ) then
         warnlog ( "RegQueryValueExNULL returned: " & rc )
         goto endsub
         endif

      rc = RegQueryValueExString( hKey , sVal , 0& , lType , sPath , dummy )
      if ( rc <> 0 ) then
         warnlog ( "RegQueryValueExString returned: " & rc )
         goto endsub
         endif

      rc = RegCloseKeyA( hKey )
      if ( rc <> 0 ) then
         warnlog ( "RegCloseKeyA returned: " & rc )
         goto endsub
         endif

      hGetSysIntegrationPath() = sPath

   elseif ( sLocation = "ALL_USERS" ) then

      ' These are the registry-path and -keys to find the required information
      sKey = "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\"
      sVal = "Common Programs"

      rc = RegOpenKeyEx( HKEY_LOCAL_MACHINE , sKey , 0 , KEY_ALL_ACCESS , hKey )
      if ( rc <> 0 ) then
         warnlog ( "RegOpenKeyEx returned: " & rc )
         goto endsub
         endif

      rc = RegQueryValueExNULL( hKey , sVal , 0& , lType , 0& , dummy )
      if ( rc <> 0 ) then
         warnlog ( "RegQueryValueExNULL returned: " & rc )
         goto endsub
         endif

      rc = RegQueryValueExString( hKey , sVal , 0& , lType , sPath , dummy )
      if ( rc <> 0 ) then
         warnlog ( "RegQueryValueExString returned: " & rc )
         goto endsub
         endif

      rc = RegCloseKeyA( hKey )
      if ( rc <> 0 ) then
         warnlog ( "RegCloseKeyA returned: " & rc )
         goto endsub
         endif

      hGetSysIntegrationPath() = sPath

   endif

   endsub:

end function

'*******************************************************************************

function hGetCurrentUserAppData( ) as string

  ' This function queries the windows registry to find the location of the
  ' StartMenu\Programs folder.
  ' It returns a path or in case of an error the string "error".

   dim sKey as string
   dim sVal as string
   dim hKey as long
   dim rc as long
   dim sPath as string
   dim lType as long
   dim dummy as long

   hGetCurrentUserAppData = "error"

   ' These are the registry-path and -keys to find the required information
   sKey = "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\"
   sVal = "Local AppData"

   rc = RegOpenKeyEx( HKEY_CURRENT_USER , sKey , 0 , KEY_ALL_ACCESS , hKey )
   if ( rc <> 0 ) then
      warnlog ( "RegOpenKeyEx returned: " & rc )
      goto endsub
      endif

   rc = RegQueryValueExNULL( hKey , sVal , 0& , lType , 0& , dummy )
   if ( rc <> 0 ) then
      warnlog ( "RegQueryValueExNULL returned: " & rc )
      goto endsub
      endif

   rc = RegQueryValueExString( hKey , sVal , 0& , lType , sPath , dummy )
   if ( rc <> 0 ) then
      warnlog ( "RegQueryValueExString returned: " & rc )
      goto endsub
      endif

   rc = RegCloseKeyA( hKey )
   if ( rc <> 0 ) then
      warnlog ( "RegCloseKeyA returned: " & rc )
      goto endsub
      endif

   hGetCurrentUserAppData() = sPath

   endsub:

end function

' ******************************************************************************

Function QueryValueEx(ByVal lhKey, ByVal szValueName As String, vValue As String) As Long
Dim cch As Long
Dim lrc As Long
Dim lType As Long
Dim lValue As Long
Dim sValue As String
Dim Empty

    On Error GoTo QueryValueExError

    lrc = RegQueryValueExNULL(lhKey, szValueName, 0&, lType, 0&, cch)
    If lrc <> ERROR_NONE Then Error 5
    Select Case lType
     Case REG_SZ:
      sValue = String(cch, 0)
      lrc = RegQueryValueExString(lhKey, szValueName, 0&, lType, sValue, cch)
      If lrc = ERROR_NONE Then
          vValue = Left$(sValue, cch)
      Else
          vValue = Empty
      End If
     Case REG_DWORD:
      lrc = RegQueryValueExLong(lhKey, szValueName, 0&, lType, lValue, cch)
      If lrc = ERROR_NONE Then
          vValue = lValue
      End If
     Case Else
      lrc = -1
    End Select
QueryValueExExit:
    QueryValueEx = lrc
    Exit Function
QueryValueExError:
    Resume QueryValueExExit
End Function


Function QueryValue(BaseKey As Long, sKeyName As String, sValueName As String) As Variant
Dim lRetVal As Long      ' Returnvalue API-Call
Dim hKey As Long      ' Onen key handle
Dim vValue As String     ' Key value

    lRetVal = RegOpenKeyEx(BaseKey, sKeyName, 0, KEY_ALL_ACCESS, hKey)
    lRetVal = QueryValueEx(hKey, sValueName, vValue)
    RegCloseKeyA (hKey)
    QueryValue = vValue
End Function
