'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: opt_loadsave_general.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:44 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : thorsten.bosbach@sun.com
'*
'*  short description : Tools->Options Load/Save: General
'*
'*******************************************************************************
'*
' #1 tLoadSaveGeneral
'*
'\******************************************************************************

testcase tLoadSaveGeneral
    Dim lbSave(15) as Boolean
    Dim lsSave(20) as String
    Dim AppCount as Integer
    dim i as Integer

    '///check if all settings are saved in configuration ( Load & Save / General )

    '///+open tools / options / load & save / general
    ToolsOptions
    hToolsOptions("LoadSave","General")
    '///save old settings
    printlog " - save old settings"
    lbSave(13) = BenutzerspezifischeEinstellungen.IsChecked
    lbSave(1)  = DokumenteigenschaftenBearbeiten.IsChecked
    lbSave(2)  = Sicherungskopie.IsChecked
    lbSave(3)  = AutomatischSpeichern.IsChecked

    if AutomatischSpeichern.IsChecked then
        lsSave(1) = Minuten.GetText
    endif

    lbSave(10) = NoPrettyPrinting.IsChecked
    lbSave(11) = URLimDateisystem.IsChecked
    lbSave(12) = URLimInternet.IsChecked

    printlog("Listed Documenttypes are: ")
    AppCount = Dokumenttyp.GetItemCount
    if (AppCount > 7) then
        Warnlog( "Seven applications should be listed, there are " & AppCount )
        for i = 1 to AppCount
            DokumentTyp.select(i)
            printlog( "    -  " & DokumentTyp.getSelText)
        next i
    endif
    for i=1 to AppCount
        Dokumenttyp.Select(i)
        lsSave(2+i)          = Dokumenttyp.GetSelText
        lsSave(2+AppCount+i) = Filter.GetSelText
    next i

    '///+invert and change all settings
    printlog " - invert/change settings"
    if lbSave(13) then BenutzerspezifischeEinstellungen.UnCheck else BenutzerspezifischeEinstellungen.Check
    if lbSave(1) then DokumenteigenschaftenBearbeiten.Uncheck else DokumenteigenschaftenBearbeiten.Check
    if lbSave(2) then Sicherungskopie.Uncheck else Sicherungskopie.Check
    if lbSave(3) then AutomatischSpeichern.Uncheck else AutomatischSpeichern.Check
    if AutomatischSpeichern.IsChecked then
        lsSave(1) = Minuten.GetText
        Minuten.SetText "23"
    endif
    if lbSave(10) then NoPrettyPrinting.Uncheck else NoPrettyPrinting.Check
    if lbSave(11) then URLimDateisystem.Uncheck else URLimDateisystem.Check
    if lbSave(12) then URLimInternet.Uncheck else URLimInternet.Check
    for i=1 to AppCount
        Dokumenttyp.Select(i)
        Filter.Select(3)
    next i

    '///+close options dialog with OK
    printlog " - close options-dlg with OK"
    kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    sleep(3)

    '///exit and restart StarOffice
    printlog " - exit/restart StarOffice"
    ExitRestartTheOffice

    '///check inverting and changes
    printlog " - check inverting/changes"
    '///+open tools / options / load & save / general
    ToolsOptions
    hToolsOptions ( "LoadSave", "General" )

    if BenutzerspezifischeEinstellungen.IsChecked = lbSave ( 13 ) then
        Warnlog "'Load user setting with document' => changes not saved"
    endif
    if DokumenteigenschaftenBearbeiten.IsChecked = lbSave ( 1 ) then
        Warnlog "'Edit document properties before saving' => changes not saved"
    endif
    if Sicherungskopie.IsChecked = lbSave ( 2 ) then
        Warnlog "'Create backup copy' => changes not saved"
    endif
    if AutomatischSpeichern.IsChecked = lbSave ( 3 ) then
        printlog "AutoSave => changes not saved"
    endif
    if AutomatischSpeichern.IsChecked then
        if Minuten.GetText <> "23" then
            Warnlog "Minutes for AutoSave => changes not saved"
        endif
    endif
    if NoPrettyPrinting.IsChecked = lbSave ( 10 ) then
        Warnlog "no pretty printing => changes not saved"
    endif
    if URLimDateisystem.IsChecked = lbSave ( 11 ) then
        Warnlog "URL: File system => changes not saved"
    endif
    if URLimInternet.IsChecked = lbSave ( 12 ) then
        Warnlog "URL: Internet => changes not saved"
    endif
    for i=1 to AppCount
        Dokumenttyp.Select(i)
        if Filter.GetSelIndex <> 3 then
            Warnlog "Document '" + Dokumenttyp.GetSelText + "': changes not saved! => BugID 86605"
        endif
    next i

    '///make other changes
    printlog " - make other changes"
    BenutzerspezifischeEinstellungen.Uncheck
    DokumenteigenschaftenBearbeiten.Check
    Sicherungskopie.Uncheck
    AutomatischSpeichern.Check
    Minuten.SetText "01"
    NoPrettyPrinting.Uncheck
    URLimDateisystem.Uncheck
    URLimInternet.Uncheck
    for i=1 to AppCount
        Dokumenttyp.Select(i)
        Filter.Select(4)
    next i

    printlog " - close options-dlg with OK"
    '///+close options dialog with OK

    kontext "extrasoptionendlg"
    ExtrasOptionenDlg.OK
    Sleep (1)

    '///+you must get for all applications a filter-changes-warning ( perhaps not for all )
    printlog "    - react on messageboxes for loosing settings after changing default-filters"
    kontext "FilterWarning"
    for i=1 to AppCount
        if FilterWarning.Exists(5) then
            FilterWarning.OK
        else
            i = AppCount + 1
        endif
    next i
    Sleep (3)

    '///check second changes
    printlog " - check second changes"
    '///+open tools / options / load & save / general
    ToolsOptions
    hToolsOptions ( "LoadSave", "General" )

    if BenutzerspezifischeEinstellungen.IsChecked <> FALSE then
        Warnlog "'Load user setting with document' => changes not saved"
    endif
    if DokumenteigenschaftenBearbeiten.IsChecked <> TRUE then
        Warnlog "'Edit document properties before saving' => changes not saved"
    endif
    if Sicherungskopie.IsChecked <> FALSE then
        Warnlog "'Create backup copy' => changes not saved"
    endif
    if AutomatischSpeichern.IsChecked <> TRUE then
        Warnlog "AutoSave => changes not saved"
    endif
    if Minuten.GetText <> "1" then
        Warnlog "Minutes for AutoSave => changes not saved"
    endif
    if NoPrettyPrinting.IsChecked <> FALSE then
        Warnlog "no pretty printing => changes not saved"
    endif
    if URLimDateisystem.IsChecked <> FALSE then
        Warnlog "URL: File system => changes not saved"
    endif
    if URLimInternet.IsChecked <> FALSE  then
        Warnlog "URL: Internet => changes not saved"
    endif
    for i=1 to AppCount
        Dokumenttyp.Select(i)
        if Filter.GetSelIndex <> 4 then
            Warnlog "Document '" + Dokumenttyp.GetSelText + "': changes not saved"
        endif
    next i

    '///reset to default settings
    printlog " - reset to saved settings"
    if lbSave ( 13 ) = FALSE then
        BenutzerspezifischeEinstellungen.UnCheck else BenutzerspezifischeEinstellungen.Check
    endif
    if lbSave ( 1  ) = FALSE then
        DokumenteigenschaftenBearbeiten.UnCheck else DokumenteigenschaftenBearbeiten.Check
    endif
    if lbSave ( 2  ) = FALSE then
        Sicherungskopie.Uncheck else Sicherungskopie.Check
    endif
    AutomatischSpeichern.Check
    Minuten.SetText lsSave ( 1 )
    if lbSave ( 3  ) = FALSE then
        AutomatischSpeichern.Uncheck else AutomatischSpeichern.Check
    endif
    if lbSave ( 10 ) = FALSE then
        NoPrettyPrinting.Uncheck else NoPrettyPrinting.Check
    endif
    if lbSave ( 11 ) = FALSE then
        URLimDateisystem.UnCheck else URLimDateisystem.Check
    endif
    if lbSave ( 12 ) = FALSE then
        URLimInternet.UnCheck else URLimInternet.Check
    endif
    for i=1 to AppCount
        Dokumenttyp.Select(i)
        if Dokumenttyp.GetSelText <> lsSave ( 2 + i ) then
            Warnlog "The sorting of the document-listbox has been changed!"
        endif
        Filter.Select(lsSave(2+AppCount+i))
    next i

    '///+close options dialog with OK
    kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    Sleep (3)

    '///check the reset
    printlog " - check settings"
    '///+open tools / options / load & save / general
    ToolsOptions
    hToolsOptions ( "LoadSave", "General" )

    if BenutzerspezifischeEinstellungen.IsChecked <> lbSave ( 13 ) then
        Warnlog "'Load user setting with document' => changes not saved"
    endif
    if DokumenteigenschaftenBearbeiten.IsChecked <> lbSave ( 1 ) then
        Warnlog "'Edit document properties before saving' => changes not saved"
    endif
    if Sicherungskopie.IsChecked <> lbSave ( 2 ) then
        Warnlog "'Create backup copy' => changes not saved"
    endif
    if AutomatischSpeichern.IsChecked <> lbSave ( 3 ) then
        Warnlog "AutoSave => changes not saved"
    endif
    if AutomatischSpeichern.IsChecked then
        if Minuten.GetText <> lsSave( 1 ) then
            Warnlog "Minutes for AutoSave => changes not saved"
        endif
    endif
    if NoPrettyPrinting.IsChecked <> lbSave ( 10 ) then
        Warnlog "no pretty printing => changes not saved"
    endif
    if URLimDateisystem.IsChecked <> lbSave ( 11 ) then
        Warnlog "URL: File system => changes not saved"
    endif
    if URLimInternet.IsChecked <> lbSave ( 12 ) then
        Warnlog "URL: Internet => changes not saved"
    endif
    for i=1 to AppCount
        Dokumenttyp.Select(i)
        if Dokumenttyp.GetSelText <> lsSave ( 2 + i ) then
            Warnlog "The sorting of the document-listbox has been changed!"
        endif
        if Filter.GetSelText <> lsSave ( 2 + AppCount + i ) then
            Warnlog "Document '" + Dokumenttyp.GetSelText + "': changes not saved"
        endif
    next i

    '///+close options dialog with OK
    kontext "extrasoptionendlg"
    ExtrasOptionenDlg.OK
endcase
