'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_sort.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:21:08 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Sort functionality test
'*
'************************************************************************
'*
' #1 tSort_1
' #1 tSort_2
'*
'\***********************************************************************

sub w_sort

   printLog Chr(13) + "- Sort (Tools/Sort)"
      Call tSort_1      'Test Sort in table  -- Ascending mode
      Call tSort_2      'Test Sort in table  -- Descending mode

end sub

'-------------------------------------------------------------------------

testcase tSort_1

  Dim contentInTable()                      as String
  Dim testFile                              as String
  Dim i , j                                 as Integer
  Dim sKeyType01 , sKeyType49 , sKeyType86  as String
  Dim sLanguage01, sLanguage49, sLanguage86 as String

  sKeyType01   = fGetKeyType(01)
  sKeyType49   = fGetKeyType(49)
  sKeyType86   = fGetKeyType(86)
  sLanguage01  = fGetCountryName(01)
  sLanguage49  = fGetCountryName(49)
  sLanguage86  = fGetCountryName(86)

  PrintLog "- Tools / Sorting in table - Ascending mode "

 '---------------------------------------------------------------
 'test for Tools/Sort
 'Language:
 'English            : Alphanumeric
 'German             : Phonebook
 'Simplified Chinese : Pin Yin
 '--------------------------------------------------------------

 '/// Test Sort in table  -- Ascending mode

  PrintLog "- 1.test for Alphanumeric"

  contentInTable = Array( _
           "FIRST NAME", "LAST NAME", "PHONE HOME", "PHONE WORK"     , _
           "Alan"      , "Brown"    , "212121"    , "(407) 555-5454" , _
           "Julie"     , "Clark"    , "321123"    , "(040) 555-007"  , _
           "Patricia"  , "Fisher"   , "121212"    , "(202) 555-4455" , _
           "Peter"     , "Arnold"   , "432104"    , "(212) 555-9876 Ext. 543" , _
          )

  testFile     = "phonelist.sxw"

   '/// 1.test for Alphanumeric
   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + testFile )

   '/// select all table
    Call wDokSchreiben "<Mod1 a>", 2

   '/// Tools/Sort , choose  Ascending mode
   '/// choose English in language and Alphanumeric in keytype
    ToolsSort
     Kontext "Sortieren"
     Sprache.Select  sLanguage01
     Schluessel1.Check
     Spalte1.SetText "1"
     Schluesseltyp1.Select sKeyType01
     Aufsteigend1.Check

     Schluessel2.UnCheck
     Schluessel3.UnCheck
    Sortieren.OK
    Sleep 1

    Call wDokSchreiben "<Mod1 a>" ,2

    j = UBound(contentInTable)

    For i = 0 to j
      Call wDokSchreiben "<Mod1 a>"
      wait 100
      EditCopy

      if GetClipboardText <> contentInTable(i) then
         Warnlog "The content in table is Wrong! We hope to get " + contentInTable(i) + " But get " + GetClipboardText
      endif

      Call wDokSchreiben "<Escape><TAB>"
    next i

    Call hCloseDocument

  PrintLog "- 2.test for Phonebook"
  contentInTable = Array( _
           "FIRST NAME", "LAST NAME", "PHONE HOME", "PHONE WORK"     , _
           "Alan"      , "Brown"    , "212121"    , "(407) 555-5454" , _
           "Julie"     , "Clark"    , "321123"    , "(040) 555-007"  , _
           "Patricia"  , "Fisher"   , "121212"    , "(202) 555-4455" , _
           "Peter"     , "Arnold"   , "432104"    , "(212) 555-9876 Ext. 543" , _
          )

  testFile     = "phonelist.sxw"

   '/// 2.test for Phonebook
   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + testFile )

   '/// select all table
    Call wDokSchreiben "<Mod1 a>", 2

   '/// Tools/Sort , choose  Ascending mode
   '/// choose German in language and phonebook in keytype
    ToolsSort
     Kontext "Sortieren"
     Sprache.Select  sLanguage49
     Schluessel1.Check
     Spalte1.SetText "1"
     Schluesseltyp1.Select sKeyType49
     Aufsteigend1.Check

     Schluessel2.UnCheck
     Schluessel3.UnCheck
    Sortieren.OK
    Sleep 1

    Call wDokSchreiben "<Mod1 a>" ,2

    j = UBound(contentInTable)

    For i = 0 to j
      Call wDokSchreiben "<Mod1 a>"
      wait 100
      EditCopy

      if GetClipboardText <> contentInTable(i) then
         Warnlog "The content in table is Wrong! We hope to get " + contentInTable(i) + " But get " + GetClipboardText
      endif

      Call wDokSchreiben "<Escape><TAB>"
    next i

    Call hCloseDocument

  PrintLog "- 3.test for pinyin"
   contentInTable = Array( _
          "姓名"     , "电话(家)"    ,  "电话(单位)"   ,  _
          "钱二"     , "212121"    , "(407) 555-5454"           , _
          "孙三"     , "432104"    , "(212) 555-9876 Ext. 543"  , _
          "张四"     , "321123"    , "(040) 555-007"            , _
          "赵一"     , "121212"    , "(202) 555-4455"           , _
          )
   testFile     = "phonelist_sc.sxw"

   '/// 3. test for pinyin
   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + testFile )

   '/// select all table
    Call wDokSchreiben "<Mod1 a>", 2

   '/// Tools/Sort , choose  Ascending mode
   '/// choose simplified chinese in language and pinyin in keytype
    ToolsSort
     Kontext "Sortieren"
     Sprache.Select  sLanguage86
     Schluessel1.Check
     Spalte1.SetText "1"
     Schluesseltyp1.Select sKeyType86
     Aufsteigend1.Check

     Schluessel2.UnCheck
     Schluessel3.UnCheck
    Sortieren.OK
    Sleep 1

    Call wDokSchreiben "<Mod1 a>" ,2

    j = UBound(contentInTable)

    For i = 0 to j
      Call wDokSchreiben "<Mod1 a>"
      wait 100
      EditCopy

      if GetClipboardText <> contentInTable(i) then
         Warnlog "The content in table is Wrong! We hope to get " + contentInTable(i) + " But get " + GetClipboardText
      endif

      Call wDokSchreiben "<Escape><TAB>"
    next i

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tSort_2

  Dim contentInTable()                      as String
  Dim testFile                              as String
  Dim i , j                                 as Integer
  Dim sKeyType01 , sKeyType49 , sKeyType86  as String
  Dim sLanguage01, sLanguage49, sLanguage86 as String

  sKeyType01   = fGetKeyType(01)
  sKeyType49   = fGetKeyType(49)
  sKeyType86   = fGetKeyType(86)
  sLanguage01  = fGetCountryName(01)
  sLanguage49  = fGetCountryName(49)
  sLanguage86  = fGetCountryName(86)

  PrintLog "- Tools / Sorting in table - Descending mode "

 '---------------------------------------------------------------
 'test for Tools/Sort
 'Language:
 'English            : Alphanumeric
 'German             : Phonebook
 'Simplified Chinese : Pin Yin
 '--------------------------------------------------------------

 '/// Test Sort in table  -- Descending mode

  PrintLog "- 1.test for Alphanumeric"

  contentInTable = Array( _
         "FIRST NAME", "LAST NAME", "PHONE HOME", "PHONE WORK"     , _
         "Peter"     , "Arnold"   , "432104"    , "(212) 555-9876 Ext. 543" , _
         "Patricia"  , "Fisher"   , "121212"    , "(202) 555-4455" , _
         "Julie"     , "Clark"    , "321123"    , "(040) 555-007"  , _
         "Alan"      , "Brown"    , "212121"    , "(407) 555-5454" , _
        )
  testFile     = "phonelist.sxw"

   '/// 1.test for Alphanumeric
   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + testFile )

   '/// select all table
    Call wDokSchreiben "<Mod1 a>", 2

   '/// Tools/Sort , choose  Descending mode
   '/// choose English in language and Alphanumeric in keytype
    ToolsSort
     Kontext "Sortieren"
     Sprache.Select  sLanguage01
     Schluessel1.Check
     Spalte1.SetText "1"
     Schluesseltyp1.Select sKeyType01
     Absteigend1.Check

     Schluessel2.UnCheck
     Schluessel3.UnCheck
    Sortieren.OK
    Sleep 1

    Call wDokSchreiben "<Mod1 a>" ,2

    j = UBound(contentInTable)

    For i = 0 to j
      Call wDokSchreiben "<Mod1 a>"
      wait 100
      EditCopy

      if GetClipboardText <> contentInTable(i) then
         Warnlog "The content in table is Wrong! We hope to get " + contentInTable(i) + " But get " + GetClipboardText
      endif

      Call wDokSchreiben "<Escape><TAB>"
    next i

    Call hCloseDocument

  PrintLog "- 2.test for Phonebook"

  contentInTable = Array( _
         "FIRST NAME", "LAST NAME", "PHONE HOME", "PHONE WORK"     , _
         "Peter"     , "Arnold"   , "432104"    , "(212) 555-9876 Ext. 543" , _
         "Patricia"  , "Fisher"   , "121212"    , "(202) 555-4455" , _
         "Julie"     , "Clark"    , "321123"    , "(040) 555-007"  , _
         "Alan"      , "Brown"    , "212121"    , "(407) 555-5454" , _
        )
  testFile     = "phonelist.sxw"

   '/// 2.test for Phonebook
   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + testFile )

   '/// select all table
    Call wDokSchreiben "<Mod1 a>", 2

   '/// Tools/Sort , choose  Descending mode
   '/// choose German in language and phonebook in keytype
    ToolsSort
     Kontext "Sortieren"
     Sprache.Select  sLanguage49
     Schluessel1.Check
     Spalte1.SetText "1"
     Schluesseltyp1.Select sKeyType49
     Absteigend1.Check

     Schluessel2.UnCheck
     Schluessel3.UnCheck
    Sortieren.OK
    Sleep 1

    Call wDokSchreiben "<Mod1 a>" ,2

    j = UBound(contentInTable)

    For i = 0 to j
      Call wDokSchreiben "<Mod1 a>"
      wait 100
      EditCopy

      if GetClipboardText <> contentInTable(i) then
         Warnlog "The content in table is Wrong! We hope to get " + contentInTable(i) + " But get " + GetClipboardText
      endif

      Call wDokSchreiben "<Escape><TAB>"
    next i

    Call hCloseDocument

   PrintLog "- 3.test for pinyin"

   contentInTable = Array( _
        "姓名"     , "电话(家)"    ,  "电话(单位)"   ,  _
        "赵一"     , "121212"    , "(202) 555-4455"           , _
        "张四"     , "321123"    , "(040) 555-007"            , _
        "孙三"     , "432104"    , "(212) 555-9876 Ext. 543"  , _
        "钱二"     , "212121"    , "(407) 555-5454"           , _
       )
   testFile     = "phonelist_sc.sxw"

   '/// 3. test for pinyin
   '/// open a test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + testFile )

   '/// select all table
    Call wDokSchreiben "<Mod1 a>", 2

   '/// Tools/Sort , choose  Descending mode
   '/// choose simplified chinese in language and pinyin in keytype
    ToolsSort
     Kontext "Sortieren"
     Sprache.Select  sLanguage86
     Schluessel1.Check
     Spalte1.SetText "1"
     Schluesseltyp1.Select sKeyType86
     Absteigend1.Check

     Schluessel2.UnCheck
     Schluessel3.UnCheck
    Sortieren.OK
    Sleep 1

    Call wDokSchreiben "<Mod1 a>" ,2

    j = UBound(contentInTable)

    For i = 0 to j
      Call wDokSchreiben "<Mod1 a>"
      wait 100
      EditCopy

      if GetClipboardText <> contentInTable(i) then
         Warnlog "The content in table is Wrong! We hope to get " + contentInTable(i) + " But get " + GetClipboardText
      endif

      Call wDokSchreiben "<Escape><TAB>"
    next i

   Call hCloseDocument

endcase

'--------------------------------------------------------------

function fGetCountryName( CountryID as Integer ) as String

  select case iSprache
      case 01   :        ' English (USA)
            select case CountryID
                  case 1:      fGetCountryName = "English (USA)"
                  case 49:     fGetCountryName = "German (Germany)"
                  case 86:     fGetCountryName = "Chinese (simplified)"
                  case else :
                               QAErrorLog "Now, the test does not support for the language " +iSprache
                               fGetCountryName = ""
            end select

        case 31:
            select case CountryID
                case 1:      fGetCountryName = "Engels (VS)"
                case 49:     fGetCountryName = "Duits (Duitsland)"
                case 86:     fGetCountryName = "Chinees (vereenvoudigd)"
                case else :
                QAErrorLog "Now, the test does not support for the language " +iSprache
                fGetCountryName = ""
           end select
           
      case 49   :        ' German
           select case CountryID
                  case 1:      fGetCountryName = "Englisch (USA)"
                  case 49:     fGetCountryName = "Deutsch (Deutschland)"
                  case 86:     fGetCountryName = "Chinesisch (einfach)"
                  case else :
                               QAErrorLog "Now, the test does not support for the language " +iSprache
                               fGetCountryName = ""
           end select
      case 81   :        ' Japanese
           select case CountryID
                  case 1:      fGetCountryName = "英語(米国)"
                  case 49:     fGetCountryName = "ドイツ語(ドイツ)"
                  case 86:     fGetCountryName = "中国語(簡体字)"
                  case else :
                               QAErrorLog "Now, the test does not support for the language " +iSprache
                               fGetCountryName = ""
           end select

      case 86   :        ' Chinese (simplified)
          select case CountryID
                 case 1:      fGetCountryName = "英语(美国)"
                 case 49:     fGetCountryName = "德语(德国)"
                 case 86:     fGetCountryName = "中文(简体字)"
                 case else :
                              QAErrorLog "Now, the test does not support for the language " +iSprache
                              fGetCountryName = ""
          end select

      case 88   :        ' Chinese (traditional)
           select case CountryID
                  case 1:      fGetCountryName = "英語(美國)"
                  case 49:     fGetCountryName = "德語(德國)"
                  case 86:     fGetCountryName = "中文(簡體字)"
                  case else :
                               QAErrorLog "Now, the test does not support for the language " +iSprache
                               fGetCountryName = ""
           end select
      case else :        ' Fallback
                  QAErrorLog "Now, the test does not support for the language " +iSprache
                  fGetCountryName = ""
 end select

end function

'-------------------------------------------------------

function fGetKeyType( KeyType as Integer ) as String

    select case iSprache
        case 01, 31, 49   :
            select case KeyType
                case 1:      fGetKeyType   = "Alphanumeric"
                case 49:     fGetKeyType   = "Phone book"
                case 86:     fGetKeyType   = "Pinyin"
                case else :
                QAErrorLog "Now, the test does not support for the language " +iSprache
                fGetKeyType = ""
            end select
    
        case 81   :' Japanese
            select case KeyType
                case 1:      fGetKeyType   = "英数字"
                case 49:     fGetKeyType   = "電話帳"
                case 86:     fGetKeyType   = "ピンイン(中国語のローマ字表記法)"
                case else :
                QAErrorLog "Now, the test does not support for the language " +iSprache
                fGetKeyType = ""
            end select
        
        case 86   :' Chinese (simplified)
            select case KeyType
                case 1:      fGetKeyType   = "字母数字式"
                case 49:     fGetKeyType   = "电话簿"
                case 86:     fGetKeyType   = "拼音"
                case else :
                QAErrorLog "Now, the test does not support for the language " +iSprache
                fGetKeyType = ""
            end select
        
        case 88   :' Chinese (traditional)
            select case KeyType
                case 1:      fGetKeyType   = "字母數字式"
                case 49:     fGetKeyType   = "電話簿"
                case 86:     fGetKeyType   = "拼音"
                case else :
                QAErrorLog "Now, the test does not support for the language " +iSprache
                fGetKeyType = ""
            end select
        
        case else :' Fallback
            QAErrorLog "The test does not support the language " + iSprache
            fGetKeyType = ""
    end select

end function
