'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: xc_perf1.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/08 08:33:28 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Library for Calc XML Performance Test
'*
'*************************************************************************
' **
' #1 xlog
' #1 xperf
' #1 x92239
' #1 xzahlen100000
' #1 xzahlen1000000
' #1 xcontent_edit
' #1 xcontent_formula
' #1 xcontent_numbers
' #1 xcontent_text
' #1 blog
' #1 bperf
' #1 b92239
' #1 bzahlen100000
' #1 bzahlen1000000
' #1 bcontent_edit
' #1 bcontent_formula
' #1 bcontent_numbers
' #1 bcontent_text
' #1 tinitnormal
' #1 xCreateDocs
' #1 bCreateDocs
' **
'\**************************************************************************************

testcase xlog
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("log_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\log.sxc"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\log" & i & ".sxc"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase
'-------------------------------------------------------------------------

testcase xperf
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("perf_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\perf.sxc"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\perf" & i & ".sxc"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase
'-------------------------------------------------------------------------

testcase x92239
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("92239_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\92239.sxc"))
  sleep(30)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\92239" & i & ".sxc"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xzahlen100000
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("zahlen100000_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\zahlen100000.sxc"))
  sleep(30)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\zahlen100000" & i & ".sxc"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xzahlen1000000
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("zahlen1000000_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\zahlen1000000.sxc"))
  sleep(80)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\zahlen1000000" & i & ".sxc"))
  sleep(80)
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xcontent_edit
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("content_edit_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\content_edit.sxc"))
  sleep(30)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\content_edit" & i & ".sxc"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xcontent_formula
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("content_formula_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\content_formula.sxc"))
  sleep(30)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\content_formula" & i & ".sxc"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xcontent_numbers
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("content_numbers_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\content_numbers.sxc"))
  sleep(30)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\content_numbers" & i & ".sxc"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xcontent_text
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("content_text_sxc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\content_text.sxc"))
  sleep(30)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\content_text" & i & ".sxc"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------
'-------------------------------------------------------------------------

testcase blog
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("log_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\log.sdc"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\log" & i & ".sdc"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase bperf
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("perf_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\perf.sdc"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\perf" & i & ".sdc"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase b92239
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("92239_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\92239.sdc"))
  sleep(30)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\92239" & i & ".sdc"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase bzahlen100000
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("zahlen100000_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\zahlen100000.sdc"))
  sleep(30)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\zahlen100000" & i & ".sdc"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase bzahlen1000000
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("zahlen1000000_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\zahlen1000000.sdc"))
  sleep(80)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\zahlen1000000" & i & ".sdc"))
  sleep(80)
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase bcontent_edit
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("content_edit_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\content_edit.sdc"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\content_edit" & i & ".sdc"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase bcontent_formula
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("content_formula_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\content_formula.sdc"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\content_formula" & i & ".sdc"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase bcontent_numbers
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("content_numbers_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\content_numbers.sdc"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\content_numbers" & i & ".sdc"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase bcontent_text
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("content_text_sdc.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\content_text.sdc"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\content_text" & i & ".sdc"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase tinitnormal
'/// The office will be closed and started <u><b>without</b></u> profiling environment. ///
 call ExitRestartTheOffice
endcase

'-------------------------------------------------------------------------

testcase xCreateDocs
 Dim OfficeBuild as string
 Dim CommandlineString(18) as string
 Dim ShellExec as integer
 Dim i as integer
'/// With the Perl scripts from <a href="mailto:andre.fischer@germany">Andre Fischer</a> ///
'///+ the logfiles in <i>..user/work/xml/profile</i> directory a Calc ///
'///+ document will be created. ///
'/// The filter which is needed for the perl script came from the &acute;xmloff&acute; development team, resp. engineer <a href="mailto:daniel.vogelheim@germany">Daniel Vogelheim</a>. ///
'///+ and are located in <i>...testtool/input/profile/filter</i>. ///
'/// In this round the logs of the XML files will be analyzed.///
  printlog "Build: " & OfficeBuild
  '-------------------
  CommandlineString(1) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\log_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\log_sxc.sxc")
  CommandlineString(2) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\perf_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\perf_sxc.sxc")
  CommandlineString(3) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\92239_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\92239_sxc.sxc")
  CommandlineString(4) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\zahlen100000_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\zahlen100000_sxc.sxc")
  CommandlineString(5) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\zahlen1000000_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\zahlen1000000_sxc.sxc")
  CommandlineString(6) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\content_edit_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\content_edit_sxc.sxc")
  CommandlineString(7) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\content_formula_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\content_formula_sxc.sxc")
  CommandlineString(8) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\content_numbers_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\content_numbers_sxc.sxc")
  CommandlineString(9) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\content_text_sxc.nopid " & gOfficePath & "user\work\xml\profile\results\content_text_sxc.sxc")
  '-------------------
 for i = 1 to 9
  printlog "Command (" & i & "): " & lcase(CommandlineString(i))
  if gPlatGroup = "unx" then
    ShellExec = Shell("perl " & CommandlineString(i) , 1 )
   else
    ShellExec = Shell("perl.exe " & CommandlineString(i) , 1)
  end if
  if ShellExec(i) = 0 then
    printlog "Succesfully executed."
   else
    warnlog "A mistake has been happened."
  end if
 next i
endcase

'-------------------------------------------------------------------------

testcase bCreateDocs
 Dim OfficeBuild as string
 Dim CommandlineString(18) as string
 Dim ShellExec as integer
 Dim i as integer
'/// With the Perl scripts from <a href="mailto:andre.fischer@germany">Andre Fischer</a> ///
'///+ the logfiles in <i>..user/work/xml/profile/</i> directory a Calc ///
'///+ document will be created. ///
'/// The filter which is needed for the perl script came from the &acute;xmloff&acute; development team, resp. engineer <a href="mailto:daniel.vogelheim@germany">Daniel Vogelheim</a>. ///
'///+ and are located in <i>...testtool/input/profile/filter</i>. ///
'/// In this round the logs of the binary files will be analyzed.///
  printlog "Build: " & OfficeBuild
  '-------------------
  CommandlineString(1) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\log_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\log_sdc.sxc")
  CommandlineString(2) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\perf_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\perf_sdc.sxc")
  CommandlineString(3) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\92239_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\92239_sdc.sxc")
  CommandlineString(4) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\zahlen100000_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\zahlen100000_sdc.sxc")
  CommandlineString(5) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\zahlen1000000_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\zahlen1000000_sdc.sxc")
  CommandlineString(6) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\content_edit_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\content_edit_sdc.sxc")
  CommandlineString(7) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\content_formula_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\content_formula_sdc.sxc")
  CommandlineString(8) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\content_numbers_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\content_numbers_sdc.sxc")
  CommandlineString(9) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\content_text_sdc.nopid " & gOfficePath & "user\work\xml\profile\results\content_text_sdc.sxc")
  '-------------------
 for i = 1 to 9
  printlog "Command (" & i & "): " & lcase(CommandlineString(i))
  if gPlatGroup = "unx" then
    ShellExec = Shell("perl " & CommandlineString(i) , 1 )
   else
    ShellExec = Shell("perl.exe " & CommandlineString(i) , 1)
  end if
  if ShellExec(i) = 0 then
    printlog "Succesfully executed."
   else
    warnlog "A mistake has been happened."
  end if
 next i
endcase

'-------------------------------------------------------------------------

